/*----------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 ***************************************************************************
 *
 * File = $Id: $
 *
 *
 * Edit History
 *
 * $Log: /dev_1200/Include/vxWorksBSP.h $
 * 
 * 1     10/20/99 11:59a Jdguilfo
 * Add prototype for sysMemVirtSize
*/
#ifndef VXWORKSBSP_H
#define VXWORKSBSP_H
#if defined(__cplusplus)
extern "C"
{
/*******************************************************************************
*
* sysMemVirtSize - get sizes of virtual memory regions
*
* This routine returns sizes of virtual memory regions.
* 
* void sysMemVirtSize
*     (
*     unsigned int* sys,     /@ Size of memory mapped at zero for VxWorks @/
*     unsigned int* sys_all, /@ Size of memory mapped at zero and usable
*                               by VxWorks @/
*     unsigned int* sdram,   /@ Size of memory mapped at C0000000 and usable 
*                               by HW @/
*     unsigned int* sram,    /@ Size of sram @/
*     unsigned int* flash    /@ Size of Flash @/
*     )
*
* SYS_ALL is the actual amount of memory mapped to virtual address
* zero from the SDRAM. Some amount of the top end of this may be
* reserved by users, so the amount actually available to VxWorks
* is given by SYS. The size SDRAM which is available to the HW and 
* not used by VxWorks (mapped with virt addr == phys addr) is given
* by SDRAM.
*
* RETURNS: N/A
*/
void sysMemVirtSize(unsigned int* sys,
                    unsigned int* sys_all,
                    unsigned int* sdram,
                    unsigned int* sram,
                    unsigned int* flash);

#if defined(__cplusplus)
}
#endif


#endif // ifdef VXWORKSBSP_H
