/* utl_bits.h
 * Bit manipulation utilities
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *  system: SA1200
 *  subsystem: Linker/Loader utility
 *  author: drj Dec 31, 97  Initial version
 *  revisions:
 *  $History: utl_bits.h $
 * 
 * *****************  Version 10  *****************
 * User: Drjohns1     Date: 9/20/99    Time: 3:51p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 9  *****************
 * User: Drjohns1     Date: 8/13/99    Time: 6:23p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 6  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 4:23p
 * Updated in $/development/ucld
 * update COPYRIGHT
 * 
 * *****************  Version 5  *****************
 * User: Drjohns1     Date: 5/21/98    Time: 2:20p
 * Updated in $/base_level2/ucld
 * Updated copyright header
 * 
 * *****************  Version 4  *****************
 * User: Johnsondes   Date: 2/10/98    Time: 4:07p
 * Updated in $/base_level1/ucld
 * Optimized the bit manipulation functions.
 *
 * ---------------------------------------------------------------------
 */
#ifndef __UTL_BITS_H__
#define __UTL_BITS_H__

#include <limits.h>

#ifdef __cplusplus
extern "C"{
#endif

#ifndef WORD_BIT
#define WORD_BIT ((unsigned int)(CHAR_BIT * sizeof(unsigned int)))
#endif

#define ALL_SET_MASK	0xffffffff
#define ALL_CLR_MASK	0x00000000

#define MASK WORD_BIT-1
#define SHIFT ((WORD_BIT==8)?3:(WORDBIT==16)?4:8)

#define TOGGLE_ALL_BITS(word) (~(wrd))
#define CLR_ALL_BITS() (ALL_CLR_MASK)
#define SET_ALL_BITS() (ALL_SET_MASK)
#define CLR_BIT(wrd, bit) ((wrd) & ~(1 << ((bit) & MASK)))
#define SET_BIT(wrd, bit) ((wrd) | (1 << ((bit) & MASK)))
#define TOGGLE_BIT(wrd, bit) ((wrd) ^ (1 << ((bit) & MASK)))
#define IS_BIT_SET(wrd, bit) ((wrd) & (1 << ((bit) & MASK)))


#define isBitSet(wrd, bit) (IS_BIT_SET(wrd, bit))
#define setBit(wrd, bit) (SET_BIT(wrd, bit))
#define clrBit(wrd, bit) (CLR_BIT(wrd, bit))
#define toggleBit(wrd, bit) (TOGGLE_BIT(wrd, bit))
#define toggleAllBits(wrd) (TOGGLE_ALL_BITS(wrd))

void prnByteBin(unsigned char byte);
void prnWordBin(unsigned int word);
unsigned int getField(unsigned int word, int startBit, int fieldLen);
unsigned int setField(unsigned int word, int startBit, int fieldLen,
                      unsigned int value);

int numBitsSet(unsigned int word);
unsigned int bitParity(unsigned int word);
int powOfTwo(unsigned int word);
unsigned int bitSwap(unsigned int word, unsigned int pos1, unsigned int pos2);
unsigned int rightRotate(unsigned int word, unsigned int s);
unsigned int leftRotate(unsigned int word, unsigned int s);

#ifdef __cplusplus
}
#endif

#endif	/* __UTL_BITS_H__ */
