/* ueng.h
 * Ucode Uengine Interface Library
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *
 *  system: SA1200
 *  subsystem: Debug Library
 *  author: drj, June 16,98  Initial version
 *  revisions:
 *  $History: ueng.h $
 * 
 * *****************  Version 29  *****************
 * User: Drjohns1     Date: 2/07/00    Time: 1:34p
 * Updated in $/dev_1200/Include
 * Removed setMasks & clrMasks variables
 * 
 * *****************  Version 27  *****************
 * User: Drjohns1     Date: 9/22/99    Time: 12:55p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 26  *****************
 * User: Drjohns1     Date: 8/06/99    Time: 4:40p
 * Updated in $/dev_1200/Include
 * Added delay param to Sem_Wait
 * 
 * *****************  Version 24  *****************
 * User: Drjohns1     Date: 7/12/99    Time: 5:51p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 23  *****************
 * User: Rdmurato     Date: 6/24/99    Time: 4:06p
 * Updated in $/dev_1200/Include
 * Move constants needed by debug_1200.h into new file, ueng_constants.h
 * 
 * *****************  Version 22  *****************
 * User: Drjohns1     Date: 6/18/99    Time: 3:53p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 21  *****************
 * User: Drjohns1     Date: 6/17/99    Time: 2:46p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 20  *****************
 * User: Drjohns1     Date: 6/16/99    Time: 5:37p
 * Updated in $/dev_1200/Include
 * Changed uEng_reset to uEng_resetUengs
 * 
 * *****************  Version 19  *****************
 * User: Drjohns1     Date: 6/15/99    Time: 6:12p
 * Updated in $/dev_1200/Include
 * Added dump for debugging
 * 
 * *****************  Version 18  *****************
 * User: Drjohns1     Date: 6/14/99    Time: 4:39p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 17  *****************
 * User: Drjohns1     Date: 6/09/99    Time: 4:36p
 * Updated in $/dev_1200/Include
 * Expanded the C API's
 * 
 * *****************  Version 16  *****************
 * User: Qabuild      Date: 6/07/99    Time: 5:33p
 * Updated in $/dev_1200/Include
 * Change // to /* to avoid VxWorks's compile errors
 * 
 * *****************  Version 15  *****************
 * User: Drjohns1     Date: 6/02/99    Time: 1:19p
 * Updated in $/dev_1200/Include
 * Modification per code-review
 * 
 * *****************  Version 13  *****************
 * User: Drjohns1     Date: 4/12/99    Time: 4:26p
 * Updated in $/development/ueng
 * Modified reading/writing of SDRAM xfer registers
 * 
 * *****************  Version 12  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 4:53p
 * Updated in $/development/ueng
 * update COPYRIGHT
 * 
 * *****************  Version 11  *****************
 * User: Qabuild      Date: 3/15/99    Time: 12:25p
 * Updated in $/development/ueng
 * replace // with /*
 * 
 * *****************  Version 10  *****************
 * User: Drjohns1     Date: 3/05/99    Time: 8:54p
 * Updated in $/development/ueng
 * Updated for generic interrupt functions
 * 
 * *****************  Version 9  *****************
 * User: Drjohns1     Date: 3/04/99    Time: 5:44p
 * Updated in $/development/ueng
 * 
 * *****************  Version 8  *****************
 * User: Drjohns1     Date: 3/02/99    Time: 9:40p
 * Updated in $/development/ueng
 * Fixed sdram read/write xfer problems
 * 
 * *****************  Version 7  *****************
 * User: Drjohns1     Date: 2/24/99    Time: 6:37p
 * Updated in $/development/ueng
 * 
 * *****************  Version 6  *****************
 * User: Drjohns1     Date: 2/12/99    Time: 5:53p
 * Updated in $/development/ueng
 * Updated for multi-chip/auto_ambio related changes
 * 
 * *****************  Version 5  *****************
 * User: Drjohns1     Date: 2/09/99    Time: 2:29p
 * Updated in $/development/ueng
 * Updated for breakpoint interupt
 * 
 * *****************  Version 4  *****************
 * User: Qabuild      Date: 2/01/99    Time: 12:05p
 * Updated in $/development/ueng
 * replace // with /* 
 * 
 * *****************  Version 3  *****************
 * User: Drjohns1     Date: 1/29/99    Time: 11:35a
 * Updated in $/development/ueng
 * 
 * *****************  Version 2  *****************
 * User: Drjohns1     Date: 1/26/99    Time: 3:39p
 * Updated in $/development/ueng
 * Partitioned debug library
 * 
 * *****************  Version 1  *****************
 * User: Drjohns1     Date: 1/21/99    Time: 2:27p
 * Created in $/development/ueng
 * Partitioned debug library to create ueng interface library (ueng.lib)
 * 
 * *****************  Version 11  *****************
 * User: Drjohns1     Date: 1/20/99    Time: 5:13p
 * Updated in $/development/udebug
 * Added ueng status and Hop features
 * 
 * *****************  Version 10  *****************
 * User: Drjohns1     Date: 1/18/99    Time: 5:33p
 * Updated in $/development/udebug
 * Added new breakpoint features
 * 
 * *****************  Version 9  *****************
 * User: Drjohns1     Date: 12/11/98   Time: 12:35p
 * Updated in $/development/udebug
 * Completed chnages for reading/writing read & write xfer registers
 * 
 * *****************  Version 8  *****************
 * User: Drjohns1     Date: 12/09/98   Time: 1:01p
 * Updated in $/development/udebug
 * Added APIs for reading and write-xfer reg. and writing read-xfer reg.
 * 
 * *****************  Version 7  *****************
 * User: Drjohns1     Date: 12/07/98   Time: 9:31p
 * Updated in $/development/udebug
 * Initial release
 * 
 * *****************  Version 1  *****************
 * User: Drjohns1     Date: 11/06/98   Time: 11:22a
 * Created in $/users/Johnson/SA1200/udebug
 * 
 * 
 * ---------------------------------------------------------------------
 */
#ifndef __UENG_H
#define __UENG_H

#include "hal_ueng.h"
#include "sem.h"
#include "ueng_constants.h"
#include "core_io.h"

#define ADDR_EN_BITPOS			0xa
#define CTX_ENABLES_BITPOS	    8
#define CTX_ACTIVE_AB_BITPOS	2
#define CTX_ACTIVE_AB_MASK		0x4

#define IS_CTX_RUNNING(activeCtxSts, ctx) ((activeCtxSts & 0x4) & ((activeCtxSts & 0x3) == ctx))
#define CTX_X_STS_PC(csr) (csr & 0x3ff)

#define UENG_MAX_USTORE		1024
#define MAX_EXEC_INST		100
#define MAX_XFER_REG		8
#define MAX_FIFO_QWADDR		160
#define UENG_ALL_CTX		0xf
#define UENG_ALL_UENG		0x3f

#define BR_ADDR_LSB				7
#define BR_ADDR_MASK			0x3ff
#define BR_CTX_LSB				23
#define BR_CTX_MASK				0x3
#define SET_BR_ADDR(brInst, brAddr) brInst | ((brAddr & BR_ADDR_MASK) << BR_ADDR_LSB)
#define SET_BR_CTX(brInst, ctx) brInst | ((ctx & BR_CTX_MASK) << BR_CTX_LSB)

#define VERIFY_UENGMASK(uengMask) if(!uengMask) return(UDBG_BADARG)
#define VERIFY_UENG(ueng) if(ueng < 0 || ueng >= MAX_UENGS) return(UDBG_BADARG)

#define VERIFY_CTXMASK(ctxMask) if(ctxMask == 0) return(UDBG_BADARG)
#define VERIFY_CTX(ctx) if(ctx < 0 || ctx >= MAX_CTX) return(UDBG_BADARG)


typedef enum{
   UENG_MSG_INT,
   UENG_DBG_INT,
   UENG_NUM_INTS			/* number of ueng interrupts defined -- must be the last entry */
}Ueng_ints_T;


#ifdef __cplusplus
class Uengine{
public:
   Uengine(unsigned char uEngNum);
   ~Uengine(){Sem_Destroy(uEngSem);}

   inline void getCtxEnables(unsigned int *ctxEnables){
	   uEngCsr->getCTX_ENABLES(ctxEnables);
	   return;
   }

   inline void getActiveStatus(unsigned int *activeCtxStatus){
	   uEngCsr->getACTIVE_CTX_STS(activeCtxStatus);
	   return;
   }

   inline void getCsrWriteEn(unsigned int *csrWriteEn){
	   uEngCsr->getFBOX_CSR_WRITE_SELF_ENABLE(csrWriteEn);
	   return;
   }
   inline void getSramJouEn(unsigned int *sramJouEn){
	   uEngCsr->getENABLE_SRAM_JOURNALING(sramJouEn);
	   return;
   }
   inline void getCondCodeEn(unsigned int *ccEn){
	   uEngCsr->getCC_ENABLE(ccEn);
	   return;
   }
   inline void setCondCodeEn(unsigned int ccEn){
	   uEngCsr->setCC_ENABLE(ccEn);
	   return;
   }

   inline int getActiveCtx(){
	   unsigned int activeCtxStatus;
	   uEngCsr->getACTIVE_CTX_STS(&activeCtxStatus);
	   if(!(activeCtxStatus & 0x4)) return MAX_CTX;	// invalid context
	   return(activeCtxStatus & 0x3);
   }

   int disableCtx(unsigned int ctxMask);
   int enableCtx(unsigned int ctxMask);

   int getPC(unsigned char ctx, unsigned int *upc);
   int setPC(unsigned int ctxMask, unsigned int upc);
   int getCtxStatus(unsigned char ctx, unsigned int *ctxStatus);
   int setCtxStatus(unsigned int ctxMask, unsigned int ctxStatus);

   int getCtxSigEvents(unsigned char ctx, unsigned int *events);
   int setCtxSigEvents(unsigned int ctxMask, unsigned int events);
   int getCtxWakeupEvents(unsigned char ctx, unsigned int *events);
   int setCtxWakeupEvents(unsigned int ctxMask, unsigned int events);

   int isUengActive();
   int getUword(unsigned int uAddr, unsigned int *uWord);
   int setUword(unsigned int uAddr, unsigned int uWord);
   int start(unsigned char startCtx, unsigned int ctxMask);
   inline int resume(void){return(enableCtx(0xf));}			/* enable all contexts */
   int getCtxArb(int unsigned *ctxArbCtl);
   int setCtxArb(int unsigned ctxArbCtl);
   int getNumUword(unsigned int uAddr, unsigned short numWords, unsigned int *uWord);
   int setNumUword(unsigned int uAddr, unsigned short numWords, unsigned int *uWord);


   void *getHandle(void){return((void *)this); }

   inline int readRelGpr(unsigned int type, unsigned char ctx, unsigned short regNum, unsigned int *data){
	   return(readRelReg(type, ctx, regNum, data));}
   inline int writeRelGpr(unsigned int type, unsigned char ctx, unsigned short regNum, unsigned int data){
	   return(writeRelReg(type, ctx, regNum, data));}

   inline int readRelSramRdXfer(unsigned char ctx, unsigned short regNum, unsigned int *data){
	      return(readRelReg(2, ctx, regNum, data));}
   int readRelSramWrXfer(unsigned char ctx, unsigned short regNum, unsigned int *data);
   int writeRelSramRdXfer(unsigned char ctx, unsigned short regNum, unsigned int data);
   int writeRelSramWrXfer(unsigned char ctx, unsigned short regNum, unsigned int data);

   int writeRelSdramWrXfer(unsigned char ctx, unsigned short regNum, unsigned int *data);
   int writeRelSdramRdXfer(unsigned char ctx, unsigned short regNum, unsigned int *data);
   int readRelSdramWrXfer(unsigned char ctx, unsigned short regNum, unsigned int *data);
   int readRelSdramRdXfer(unsigned char ctx, unsigned short regNum, unsigned int *data);

   int writeTxFifo(unsigned short regNum, unsigned int *data, int setValid);
   int readRxFifo(unsigned short regNum, unsigned int *data);

   int execMicroInst(unsigned char ctx, unsigned int *microInst,
						   unsigned int numInst, int condCodeOff,
						   unsigned int waitForMs = 5);

   int setUstoreFreeMem(unsigned int begFreeAddr, unsigned int size);
   int getUstoreFreeMem(unsigned int *begFreeAddr, unsigned int *size);
   inline void setRst(void){rst = 1; return;}
   inline void clrRst(void){rst = 0; return;}
   void reset(int clrReg=0);
   void clrReset();

   //dj: debug
   void dump(void);

private:
   unsigned int		thisUengNum, rst;
   unsigned int		freeAddr, freeSize;
   UengCSRs			*uEngCsr;
   SramXferReg		*sramXferReg[MAX_CTX];
   sem_T			uEngSem;
   int				semLock;

   enum{LOW=0,HIGH};

   int readRelReg(unsigned int type, unsigned char ctx, unsigned short regNum, unsigned int *data);
   int writeRelReg(unsigned int type, unsigned char ctx, unsigned short regNum, unsigned int data);

   inline int lockAccess(int level){
      if((level == HIGH) || (semLock == LOW)){
	     Sem_Wait(uEngSem, SEM_WAITFOREVER);
	     semLock = level;
		 return(1);
	  }
	  return(0);
   }

   inline void unlockAccess(int key){
	   if(key){
		   semLock = LOW;
		   Sem_Post(uEngSem);
	   }
   }
}; 

Uengine **initUengs();
#endif		/* c++ */


#ifdef __cplusplus
extern "C" {
#endif

int uEng_intConnect(int index, unsigned int intMask, ISR_FUNC isr, int param);
void uEng_clrIregBp();
void uEng_clrIregTh(unsigned int thMask);
void uEng_disableUEFIQ();
void uEng_enableUEFIQ();
void uEng_disableUEIRQ();
void uEng_enableUEIRQ();

int uEng_getCtxEnables(unsigned char uEng, unsigned int *ctxEnables);
int uEng_getActiveStatus(unsigned char uEng, unsigned int *activeCtxStatus);
int uEng_getCsrWriteEn(unsigned char uEng, unsigned int *csrWriteEn);
int uEng_getSramJouEn(unsigned char uEng, unsigned int *sramJouEn);
int uEng_getCondCodeEn(unsigned char uEng, unsigned int *ccEn);
int uEng_setCondCodeEn(unsigned char uEng, unsigned int ccEn);

void uEng_initUengs();
int uEng_getCtxStatus(unsigned char uEng, unsigned char ctx, unsigned int *status);
int uEng_setCtxStatus(unsigned char uEng, unsigned int ctxMask, unsigned int status);
int uEng_getCtxSigEvents(unsigned char uEng, unsigned char ctx, unsigned int *events);
int uEng_setCtxSigEvents(unsigned char uEng, unsigned int ctxMask, unsigned int events);
int uEng_getCtxWakeupEvents(unsigned char uEng, unsigned char ctx, unsigned int *events);
int uEng_setCtxWakeupEvents(unsigned char uEng, unsigned int ctxMask, unsigned int events);

int uEng_setUstoreFreeMem(unsigned char uEng, unsigned int begFreeAddr, unsigned int size);
int uEng_getUstoreFreeMem(unsigned char uEng, unsigned int *begFreeAddr, unsigned int *size);
int uEng_disableCtx(unsigned char uEng, unsigned int ctxMask);
int uEng_getPC(unsigned char uEng, unsigned char ctx, unsigned int *upc);
int uEng_setPC(unsigned char uEng, unsigned int ctxMask, unsigned int upc);
int uEng_isUengActive(unsigned char uEng);
int uEng_start(unsigned char uEng, unsigned char startCtx, unsigned int ctxEnMask);

int uEng_resume(unsigned char uEng);
int uEng_getNumUword(unsigned char uEng, unsigned int uAddr,
					 unsigned short numWords, unsigned int *uWord);
int uEng_setNumUword(unsigned char uEng, unsigned int uAddr,
					 unsigned short numWords, unsigned int *uWord);
int uEng_getUword(unsigned char uEng, unsigned int uAddr, unsigned int *uWord);
int uEng_setUword(unsigned char uEng, unsigned int uAddr, unsigned int uWord);
int uEng_getCtxArb(unsigned char uEng, int unsigned *ctxArbCtl);
int uEng_setCtxArb(unsigned char uEng, int unsigned ctxArbCtl);
int uEng_readRelGpr(unsigned char uEng, unsigned int type, unsigned char ctx, unsigned short regNum, unsigned int *data);
int uEng_writeRelGpr(unsigned char uEng, unsigned int type, unsigned char ctx, unsigned short regNum, unsigned int data);
int uEng_readRelSramRdXfer(unsigned char uEng, unsigned char ctx, unsigned short regNum, unsigned int *data);
int uEng_readRelSramWrXfer(unsigned char uEng, unsigned char ctx, unsigned short regNum, unsigned int *data);
int uEng_writeRelSramRdXfer(unsigned char uEng, unsigned char ctx, unsigned short regNum, unsigned int data);
int uEng_writeRelSramWrXfer(unsigned char uEng, unsigned char ctx, unsigned short regNum, unsigned int data);

int uEng_writeRelSdramWrXfer(unsigned char uEng, unsigned char ctx, unsigned short regNum, unsigned int *data);
int uEng_writeRelSdramRdXfer(unsigned char uEng, unsigned char ctx, unsigned short regNum, unsigned int *data);
int uEng_readRelSdramWrXfer(unsigned char uEng, unsigned char ctx, unsigned short regNum, unsigned int *data);
int uEng_readRelSdramRdXfer(unsigned char uEng, unsigned char ctx, unsigned short regNum, unsigned int *data);

int uEng_writeFIFO_Tx(unsigned char uEng, unsigned int fifoAddr, unsigned int *data64, int setValid);
int uEng_readFIFO_Rx(unsigned char uEng, unsigned int fifoAddr, unsigned int *data64);

int uEng_execMicroInst(unsigned char uEng, unsigned char ctx, unsigned int *microInst,
						   unsigned int numInst, int condCodeOff, unsigned int waitForMs);

void uEng_resetUengs(unsigned int uEngMask, int clrReg);
void uEng_clrResetUengs(unsigned int uEngMask);

#ifdef __cplusplus
}
#endif

#endif			/* __UENG_H */
