/*----------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 ***************************************************************************
 *
 * File = $Id: $
 *
 *
 * Edit History
 *
 * $Log: /development/uca/uca_lib.h $
 * 
 * 5     3/23/99 4:20p C-tclancy
 * update COPYRIGHT
 * 
 * 4     5/20/98 1:59p Jguilford
 * Change copyright notice to Intel
 * 
 * 3     2/23/98 11:54a Rmuratori
 * Add _dll to exported routine names
 * 
 * 2     2/05/98 7:30p Jguilford
 * Integrating preprocessor into UCA & making DLL
 * 
 * 1     1/20/98 3:50p Jguilford
 * Changed to alloc lib form to be built
*/
#ifndef UCA_LIB_H
#define UCA_LIB_H

typedef enum {
    UCA_MSG_COMMENT,
    UCA_MSG_WARNING,
    UCA_MSG_ERROR
} UCA_MSG_SEVERITY;

#if defined(WIN32) && defined(DLL_BUILD) && ! defined(xactor_build)
#define CALL_CONV __cdecl
  #ifdef UCA_EXPORT
  #define DECLSPEC __declspec(dllexport)
  #else
  #define DECLSPEC __declspec(dllexport)
  #endif
#else
#define CALL_CONV
#define DECLSPEC
#endif

typedef void (CALL_CONV *UcaMsgFunc)(char *file,
                                     int   line,
                                     UCA_MSG_SEVERITY severity,
                                     char *text);
/* Application must supply uca_msg callback.
   file:  NULL or filename associated with message
   line:  0 or line number associated with message
   sever: Severity of message
   text:  Text of message
   Note that text points to a static area and the application may not reference
   that pointer after uca_msg returns. I.e. if the application wants to keep
   the message beyond the return, it must first copy it to some other area.
   Note also that the text string will not reference the file/line and it
   will end with a newline.
 */
DECLSPEC UcaMsgFunc CALL_CONV
uca_register_msg_callback_dll(UcaMsgFunc new_callback);
UcaMsgFunc
uca_register_msg_callback(UcaMsgFunc new_callback);

/* Application calls uca_main to invoke the assembler. */
DECLSPEC int CALL_CONV
uca_main_dll(int argc, char *argv[]);
int
uca_main(int argc, char *argv[]);

#endif // ifdef UCA_LIB_H
