/* ------------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *------------------------------------------------------------------------------*/

/* RTM.h
 */ 
#ifndef RTM_H
#define RTM_H

// return codes
#define RTM_SUCCESS          1
#define RTM_FAIL             0
#define RTM_NOT_FOUND       -1
#define RTM_NO_TRIE_FREE    -2
#define RTM_NO_ROUTE_FREE   -3


/* size of route entry in longwords */
#define SIZE_OF_REST_ROUTE_ENTRY   2
#define SIZE_OF_ROUTE              (6 + SIZE_OF_REST_ROUTE_ENTRY)
#define HROUTETABLE void*

typedef unsigned int SRAM_ADDRESS;
typedef unsigned int SDRAM_ADDRESS;
typedef unsigned int PORT_NUMBER;
typedef unsigned short IP_ADDRESS_FIELD;  // Four bits of an IP address often
                                          // used by Tries.
typedef unsigned short NETMASK_FIELD;
typedef struct {
    unsigned int hi32;
    unsigned int lo16;
} MAC_ADDRESS;

int rt_init();
HROUTETABLE rt_create_table();
int rt_delete_table(HROUTETABLE table);

int rt_add_port(HROUTETABLE table, unsigned int port);
int rt_remove_port(HROUTETABLE table, unsigned int port);

int rt_add(char *dest, char *netmask, int itf, HROUTETABLE table);
int rt_add_full(char *dest, 
                char *netmask, 
                char * gateway, 
                int intf, 
                int gateway_da_hi32, 
                int gateway_da_lo16, 
                HROUTETABLE table);
int rt_delete(char *dest, char *netmask, HROUTETABLE table);

int rt_lookup(char *dest, unsigned int inPort);


int  RTM_Init();                     // create data structures       
#ifndef STANDALONE
int RTM_DelayBindSymbols(char *image_name);  // bind symbols at sysConf
#endif
int  RTM_InitULookup(char * filename);       // load microcode from file
int rtm_model_initialize();

int RTM_RtLookup(char *destination, unsigned int inPort);
int RTM_AllocRoute();
int RTM_FreeRoute(unsigned int route_index);

#endif /* RTM_H */
