/* pciCommAPI.h
 *
 *
 *------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *------------------------------------------------------------
 * system: SA1200
 * subsystem: PCI Device Comunication
 * author: Henry Qian 04/27/99
 * revisions:
 *
 *	10/07/99 Dan White	 changed errors to 85xx
 *
 */
#ifndef __PCICOMMAPI_H
#define __PCICOMMAPI_H

/* SHRIMP message */

typedef struct ShrimpMessage {
    unsigned int word_0;
    unsigned int word_1;
    unsigned int word_2;
    unsigned int word_3;
} ShrimpMessage;

typedef struct QueueControlBlock {
    ShrimpMessage* base;
    unsigned int* headPtr;
    unsigned int* tailPtr;
    unsigned int* statusZeroPtr;
    unsigned int* statusOnePtr;
}QueueControlBlock;


/* Total number of devices (include host) in the PCI system
*/
extern unsigned int Pci_NumOfDevices;

/* Current device number (host has Pci_DeviceID 0)
*/
extern unsigned int Pci_DeviceID;


/* -------------------
// function prototypes
// -------------------
*/

#ifdef __cplusplus
extern "C" {
#endif

int Pci_HostConfig(void);
int Pci_DeviceConfig(void);

int Pci_HostSendMail(   unsigned int devHandle,
                        unsigned int command,
                        unsigned int arg2,
                        unsigned int arg3
);

int Pci_HostWaitMail(   unsigned int deviceID,
                        unsigned int command,
                        unsigned int* arg2,
                        unsigned int* arg3
);

void Pci_DeviceSendMail(unsigned int command,
                        unsigned int arg2,
                        unsigned int arg3
);

void Pci_DeviceWaitMail(unsigned int command,
                        unsigned int* arg2,
                        unsigned int* arg3
);

void Pci_ShowSystemConfigTable(void);

void Pci_ShowConfigStatus(unsigned int deviceNo, unsigned int status);

void Pci_ShowQueueCB(QueueControlBlock* msgQueueCB);

int Pci_MsgQInit(   unsigned int Pci_NumOfDevices,
                    QueueControlBlock* Pci_QueueCB
);

unsigned int Pci_CheckSum(  char* data,
                             unsigned int dataLength);

int Pci_ReadMemByte(unsigned int deviceNo,  /* IN: destination device number */
                    char* address,  /* IN: location of device's memory to be read */
                    char* value     /* OUT: content of the memory location */
);

int Pci_WriteMemByte(unsigned int deviceNo, /* IN: destination device number */
                    char* address,  /* IN: location of device's memory to be written */
                    char value      /* IN: value to be written */
);

int Pci_ReadMemWord(unsigned int deviceNo,  /* IN: destination device number */
                    char* address,  /* IN: location of device's memory to be read */
                    short* value    /* OUT: content of the memory location */
);

int Pci_WriteMemWord(unsigned int deviceNo, /* IN: destination device number */
                    char* address,  /* IN: location of device's memory to be written */
                    short value     /* IN: value to be written */
);

int Pci_ReadMemLong(unsigned int deviceNo,  /* IN: destination device number */
                    char* address,  /* IN: location of device's memory to be read */
                    int* value      /* OUT: content of the memory location */
);

int Pci_WriteMemLong(unsigned int deviceNo, /* IN: destination device number */
                    char* address,  /* IN: location of device's memory to be written */
                    int value       /* IN: value to be written */
);

int Pci_ReadMemBlock(unsigned int deviceNo, /* IN: destination device number */
                    char* fromPciAddress,   /* IN: location of device's memory to be read */
                    char* toLocalAddress,   /* OUT: content of the memory location */
                    unsigned int length     /* IN: block length in bytes */
);

int Pci_WriteMemBlock(unsigned int deviceNo,    /* IN: destination device number */
                    char* toPciAddress,     /* IN: location of device's memory to be written */
                    char* fromLocalAddress, /* IN: value to be written */
                    unsigned int length     /* IN: block length in bytes */
);

int Pci_ReadMailBox(unsigned int deviceNo,  /* IN: destination device number */
                    int mailboxNo,  /* IN: mailbox number: {0, 1, 2, 3} */
                    int* value      /* OUT: content of the mailbox */
);

int Pci_WriteMailBox(unsigned int deviceNo, /* IN: destination device number */
                    int mailboxNo,  /* IN: mailbox number: {0, 1, 2, 3} */
                    int value       /* IN: value to be written */
);

int Pci_ReadDoorBellReg(unsigned int deviceNo,  /* IN: destination device number */
                        int* value  /* OUT: content of the doorbell register */
);

int Pci_WriteDoorBellReg(unsigned int deviceNo, /* IN: destination device number */
                        int value   /* IN: value to be written */
);

int Pci_QueueShow(  unsigned int deviceNo,
                    unsigned int queueNo);

int Pci_AllQueueShow(void);

int Pci_GetQueueCB( unsigned int deviceNo,
                    unsigned int queueNo,
                    QueueControlBlock* qcb);

int Pci_QueueEmpty(QueueControlBlock* qcb);

int Pci_QueueFull(QueueControlBlock* qcb);

int Pci_QPutMsg(unsigned int deviceNo,
                unsigned int queueNo,
                ShrimpMessage* message);

int Pci_QGetMsg(unsigned int deviceNo,
                unsigned int queueNo,
                ShrimpMessage* message);

int Pci_QueueReset( unsigned int deviceNo,
                    unsigned int queueNo);

int Pci_AllQueueReset(void);

int Pci_TestQueue(void);

int Pci_Host(void);

int Pci_Init();

void Pci_DoorBell_ISR(void);

void Pci_ToQueue(   QueueControlBlock* qcb,
                    ShrimpMessage* message);

void Pci_FromQueue( QueueControlBlock* qcb,
                    ShrimpMessage* message);

int Pci_Signal( unsigned int deviceNo,
                unsigned int signal);

void Pci_DoorBell_ISR(void);

int Pci_GetMsg( ShrimpMessage* message,
                unsigned int callMode);

int Pci_PutMsg(unsigned int deviceNo,
                ShrimpMessage* message,
                unsigned int callMode);

void Pci_SetQueueStatusZero(    QueueControlBlock* qcb,
                                unsigned int flag);

unsigned int Pci_GetQueueStatusZero(QueueControlBlock* qcb);

void Pci_SetQueueStatusOne(     QueueControlBlock* qcb,
                                unsigned int flag);

unsigned int Pci_GetQueueStatusOne(QueueControlBlock* qcb);

int Pci_AllQueueEmpty(void);


/* ---------------------
// function return codes
// ---------------------
*/

const int PCI_SUCCESS = 0;
const int PCI_ERROR = 0x8501;
const int PCI_MSGQ_EMPTY = 0x8502;
const int PCI_MSGQ_NOT_EMPTY = 0x8503;
const int PCI_MSGQ_FULL = 0x8504;
const int PCI_MSGQ_NOT_FULL = 0x8505;
const int PCI_MSGQ_BUSY = 0x8506;

const int PCI_FALSE = 0;
const int PCI_TRUE = 1;

const int PCI_CALL_UNBLOCK = 0;
const int PCI_CALL_BLOCK = 1;

const int PCI_WAIT_TO_SEND = 1;
const int PCI_WAIT_TO_RECEIVE = 1;

#ifdef __cplusplus
}
#endif


#endif /* __PCICOMMAPI_H */

/* end of file */


