/* core_io.h
 * SA1200 Hardware Absraction Library -- core io
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *
 *  system: SA1200
 *  subsystem: HAL
 *  author: dfh, Feb 24, 99  Initial version
 *  revisions:
 *  $History: core_io.h $
 * 
 * *****************  Version 29  *****************
 * User: Drjohns1     Date: 1/12/00    Time: 8:50p
 * Updated in $/dev_1200/Include
 * Added volatile to WRITE_LWORD and READ_LWORD macros
 * 
 * *****************  Version 27  *****************
 * User: Drjohns1     Date: 10/19/99   Time: 3:02p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 25  *****************
 * User: Drjohns1     Date: 7/15/99    Time: 1:53p
 * Updated in $/dev_1200/Include
 * Corrected mistake in WRITE_LWORD and READ_LWORD macros
 * 
 * *****************  Version 24  *****************
 * User: Drjohns1     Date: 7/14/99    Time: 2:53p
 * Updated in $/dev_1200/Include
 * Fixed WRITE_LWORD/READ_LWORD for Arm compiler/pre-processor
 * 
 * *****************  Version 23  *****************
 * User: Hqianx       Date: 7/09/99    Time: 7:34p
 * Updated in $/dev_1200/Include
 * Use == instead of != for return value.
 * 
 * *****************  Version 22  *****************
 * User: Drjohns1     Date: 6/25/99    Time: 11:46a
 * Updated in $/dev_1200/Include
 * Modified int_Connect for uC/OS -- Henry Qian
 * 
 * *****************  Version 21  *****************
 * User: Lhui         Date: 6/15/99    Time: 11:35a
 * Updated in $/dev_1200/Include
 * Add support for XACTIO
 * 
 * *****************  Version 20  *****************
 * User: Drjohns1     Date: 6/10/99    Time: 4:49p
 * Updated in $/dev_1200/Include
 * Updated for new iostyle -- incomplete
 * 
 * *****************  Version 19  *****************
 * User: Drjohns1     Date: 6/09/99    Time: 7:06p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 18  *****************
 * User: Jdguilfo     Date: 6/09/99    Time: 6:58p
 * Updated in $/dev_1200/Include
 * #define INUM_TO_IVEC
 * 
 * *****************  Version 15  *****************
 * User: Drjohns1     Date: 6/03/99    Time: 12:48p
 * Updated in $/dev_1200/Include
 * Included xact_api.h if IOSTYLE=XACTIO
 * 
 * *****************  Version 14  *****************
 * User: Dhooper      Date: 6/02/99    Time: 2:37p
 * Updated in $/dev_1200/Include
 * comment out #warning
 * 
 * *****************  Version 13  *****************
 * User: Drjohns1     Date: 6/02/99    Time: 1:32p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 12  *****************
 * User: Drjohns1     Date: 6/02/99    Time: 1:18p
 * Updated in $/dev_1200/Include
 * Modification per code-review
 * 
 * *****************  Version 11  *****************
 * User: Dhooper      Date: 5/11/99    Time: 5:25p
 * Updated in $/dev_1200/Include
 * remove volatile qualifier on read/write address
 * 
 * *****************  Version 10  *****************
 * User: Dhooper      Date: 5/11/99    Time: 12:19p
 * Updated in $/dev_1200/Include
 * include iostyle
 * 
 * *****************  Version 9  *****************
 * User: Dhooper      Date: 5/07/99    Time: 1:21p
 * Updated in $/dev_1200/Include
 * IOSTYLE implemented
 * 
 * *****************  Version 7  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 3:41p
 * Updated in $/development/hal_1200
 * update COPYRIGHT
 * 
 * *****************  Version 6  *****************
 * User: Drjohns1     Date: 3/05/99    Time: 8:54p
 * Updated in $/development/hal_1200
 * Updated for generic interrupt functions
 * 
 * *****************  Version 5  *****************
 * User: Hqianx       Date: 3/05/99    Time: 6:54p
 * Updated in $/development/hal_1200
 * Added IRQ_Enable(), IRQ_Disable(), FIQ_Enable(), FIQ_Disable() defines.
 * 
 * *****************  Version 4  *****************
 * User: Hqianx       Date: 3/05/99    Time: 6:12p
 * Updated in $/development/hal_1200
 * Installed generic interrupt handler.
 * 
 * *****************  Version 3  *****************
 * User: Dhooper      Date: 3/04/99    Time: 11:33a
 * Updated in $/development/hal_1200
 * get latest macro from Desmond
 * 
 * *****************  Version 2  *****************
 * User: Dhooper      Date: 3/02/99    Time: 4:20p
 * Updated in $/development/hal_1200
 * ifdef SA1200
 * 
 * *****************  Version 1  *****************
 * User: Dhooper      Date: 2/26/99    Time: 5:46p
 * Created in $/development/hal_1200
 * sdram and sram HAL
 * 
 * 
 * ---------------------------------------------------------------------
 */
#ifndef CORE_IO_H
#define CORE_IO_H

#include "iostyle.h"

typedef enum {
    SAINT_reserved_00   = 0,
    SAINT_SI            = 1,   /* Soft interrupt */
    SAINT_reserved_02   = 2,
    SAINT_reserved_03   = 3,

    SAINT_T1            = 4,   /* Timer 1 */
    SAINT_T2            = 5,   /* Timer 2 */
    SAINT_T3            = 6,   /* Timer 3 */
    SAINT_T4            = 7,   /* Timer 4 */

    SAINT_reserved_08   = 8,
    SAINT_CINT          = 9,   /* CINT pin IRQ */
    SAINT_UENG          = 10,   /* Microengine IRQ */
    SAINT_SRAM          = 11,   /* SRAM unit IRQ */

    SAINT_UART          = 12,   /* UART unit IRQ */
    SAINT_SDRAM         = 13,   /* SDRAM unit IRQ */
    SAINT_RTC           = 14,   /* Real Time Clock */
    SAINT_DFH           = 15,   /* Doorbell from host */

    SAINT_DMA1          = 16,   /* DMA channel 1 */
    SAINT_DMA2          = 17,   /* DMA channel 2 */
    SAINT_PIL           = 18,   /* pci_irq_l */
    SAINT_reserved_19   = 19,

    SAINT_DMA1NB        = 20,   /* DMA1 not busy */
    SAINT_DMA2NB        = 21,   /* DMA2 not busy */
    SAINT_SB            = 22,   /* Start BIST */
    SAINT_RSERR         = 23,   /* Received SERR */

    SAINT_SDPAR         = 24,   /* SDRAM parity */
    SAINT_IIP           = 25,   /* I20 inbound post_list */
    SAINT_reserved_26   = 26,
    SAINT_DTE           = 27,   /* Discard Timer Expired */

    SAINT_DPED          = 28,   /* Data Parity Error Detected */
    SAINT_RMA           = 29,   /* Received Master Abort */
    SAINT_RTA           = 30,   /* Received Target Abort */
    SAINT_DPE           = 31    /* Detect Parity Error */
} SA1200_INTS;

typedef void (*ISR_FUNC)(int);

/*
int int_connect(SA1200_INTS vector, ISR_FUNC isr, int param);
  return 0 on success, !=0 on error

int int_enable(SA1200_INTS vector);
  return 0 on success, !=0 on error

int int_disable(SA1200_INTS vector);
  return 0 on success, !=0 on error

int int_lock();
  Locks out interrupts, returns previous status

void int_unlock(int prev_val);
  Sets interrupt lock status to previous value

 */

#if (IOSTYLE == HARDWARE)
#include "ostype.h"

#define WRITE_LWORD(addr, val) *((volatile unsigned int *)(addr)) = (val)
#define READ_LWORD(addr, val) *((volatile unsigned int *)(val)) = *((unsigned int *)(addr))

#if (OS == VXWORKS)

 /* dj: this need to be cleaned up!!  The next two definitions are
defined in Arm header files (ivArm.h, & excArmLib.h) which should be included */
#define INUM_TO_IVEC(intNum)    ((VOIDFUNCPTR *) (intNum))

#define int_connect(vector, isr, param) \
    intConnect(INUM_TO_IVEC(vector), (isr), (param))

#ifdef __cplusplus
extern "C" {
#endif

int  int_lock(void);
void int_unlock(int prev_val);
void sysMemVirtSize(unsigned int* sys, unsigned int* sys_all, unsigned int* sdram, unsigned int* sram, unsigned int* flash);

#ifdef __cplusplus
}
#endif

#define int_enable(vector)  intEnable(vector)
#define int_disable(vector) intDisable(vector)

#elif (OS == UCOS)
#include "interrupts.h"

#define int_connect(vector, isr, param) \
    (SA_IRQ_Connect((IntSource)(vector), (PFVI)(isr), (int)(param)).func == (PFVI)-1)

#define int_enable(vector)  SA_IRQ_Enable(vector)
#define int_disable(vector) SA_IRQ_Disable(vector)

#define int_lock()           SAr_DisableInt()
#define int_unlock(prev_val) SAr_EnableInt(prev_val)

#endif /* OS type */

#elif (IOSTYLE == AMBAIO)
#include "ambaio.h"

#define CHIPNAME ""
#define WRITE_LWORD(addr, val) printf("ambaIoWrite: addr=0x%x, data=0x%x\n", addr, val); AMBAIO_AutoWrite32("",(unsigned int)addr, (unsigned int)val)
#define READ_LWORD(addr, val) AMBAIO_AutoRead32(CHIPNAME,(unsigned int)addr, (unsigned int *)val); printf("ambaIoRead: addr=0x%x, data=0x%x\n", addr, *val)

#define int_connect(vector, isr, param) AMBAIO_IRQ_Connect(CHIPNAME, (vector), (isr), (param))
#define int_enable(vector) AMBAIO_IRQ_Enable(CHIPNAME, vector)
#define int_disable(vector) AMBAIO_IRQ_Disable(CHIPNAME, vector)
#define int_lock() AMBAIO_intLock(CHIPNAME)
#define int_unlock(prev_val) AMBAIO_intUnlock(CHIPNAME, prev_val)


#elif (IOSTYLE == XACTIO)
#include "Xact_API.h"
#define CHIPNAME ""
#define WRITE_LWORD(addr, val) XACTIO_Write32(CHIPNAME,(unsigned int)addr, (unsigned int)val)
#define READ_LWORD(addr, val) XACTIO_Read32(CHIPNAME,(unsigned int)addr, (unsigned int *)val)

#define int_connect(vector, isr, param) XACTIO_IRQ_Connect(CHIPNAME, (vector), (isr), (param))
#define int_enable(vector) XACTIO_IRQ_Enable(CHIPNAME, vector)
#define int_disable(vector) XACTIO_IRQ_Disable(CHIPNAME, vector)
#define int_lock() XACTIO_intLock(CHIPNAME)
#define int_unlock(prev_val) XACTIO_intUnlock(CHIPNAME, prev_val)

#endif /* IOSTYLE */

#endif		// CORE_IO_H