/* MsgQMGR.h: 
 *      Message Queue Applicaiton interface
 *
 * ------------------------------------------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *------------------------------------------------------------
 *
 * system: SA1200
 * subsystem: Message Queue 
 * author: Lai-Wah Hui 2/12/98
 * revisions:
 * $History: MsgQMgr.h $
 * 
 * *****************  Version 16  *****************
 * User: Lhui         Date: 10/22/99   Time: 10:50a
 * Updated in $/dev_1200/Include
 * Change error code values  from 0x80ff to 0x8000
 * 
 * *****************  Version 15  *****************
 * User: Lhui         Date: 10/06/99   Time: 4:32p
 * Updated in $/dev_1200/Include
 * Change error code values
 * 
 * *****************  Version 12  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 3:42p
 * Updated in $/development/msgq
 * update COPYRIGHT
 * 
 * *****************  Version 9  *****************
 * User: Lhui         Date: 5/20/98    Time: 6:27p
 * Updated in $/base_level2/msgq
 * Replace Digital copyright with Intel copyright
 * 
 * *****************  Version 8  *****************
 * User: Qabuild      Date: 5/05/98    Time: 11:43a
 * Updated in $/base_level2/msgq
 * Change MSGQ_INIT == NULL to MSGQ_INIT == 0 to prevent VxWork compile
 * error
 * 
 * *****************  Version 7  *****************
 * User: Lhui         Date: 4/30/98    Time: 9:38a
 * Updated in $/base_level2/msgq
 * Change INVALID_MSGQ_HANDLE value from -1 to NULL to prevent a compile
 * warning message.
 * 
 * *****************  Version 6  *****************
 * User: Lhui         Date: 4/29/98    Time: 2:46p
 * Updated in $/base_level2/msgq
 * Add MSGQ_EXIST error code
 * 
 * *****************  Version 5  *****************
 * User: C-hqian      Date: 4/21/98    Time: 5:33p
 * Updated in $/base_level2/msgq
 * Modified emun definition so it could be used by C compiler.
 * 
 * *****************  Version 4  *****************
 * User: Lhui         Date: 4/17/98    Time: 5:38p
 * Updated in $/base_level2/msgq
 * Change input type for MsgQ_Create() & MsgQ_Open()
 * 
 * *****************  Version 3  *****************
 * User: Lhui         Date: 4/08/98    Time: 2:28p
 * Updated in $/base_level2/msgq
 * Remove MsgQ.h from MsgQMgr.h
 * 
 * *****************  Version 2  *****************
 * User: Lhui         Date: 3/26/98    Time: 7:08p
 * Updated in $/base_level2/msgq
 * Add AllocMsgBuffer and FreeMsgBuffer functions
 * 
 * *****************  Version 1  *****************
 * User: Lhui         Date: 2/24/98    Time: 12:54p
 * Created in $/base_level2/msgq
 * init. check-in
 * 
 *---------------------------------------------------------------------
 */ 

#if !defined(AFX_MSGQMGR_H__C581CC09_A327_11D1_86AA_0000F80373DD__INCLUDED_)
#define AFX_MSGQMGR_H__C581CC09_A327_11D1_86AA_0000F80373DD__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
#ifdef WIN32
#include <windows.h>
#endif
#define MaxQueue 10
#define MSGQ_ITRUE 1

#define MsgQ_Handle				void *

#define INVALID_MSGQ_HANDLE		NULL

enum Status {MSGQ_SUCCESS =0,
             MSGQ_ERROR = 0x8000,
             MSGQ_FULL,
             MSGQ_EMPTY,
             MSGQ_NOTFOUND,
             MSGQ_EXIST};

enum Wait  {NOWAIT =0,
            WAIT};

typedef enum {
        DownQueue = 1,
        UpQueue,
        FromHostQueue,
        ToHostQueue,
	MaxQueues
} MsgQID;

#if defined(__cplusplus)
extern "C"
{
#endif
int MsgQ_Create(MsgQID msgq_id, size_t elements, size_t BufSize);
MsgQ_Handle MsgQ_Open(MsgQID msgq_id);
int MsgQ_Send(MsgQ_Handle hMsgQ, void *msg, int WaitFlag);
int MsgQ_Receive(MsgQ_Handle hMsgQ, void **msg, int WaitFlag);
int MsgQ_Close(MsgQ_Handle hMsgQ);
void *MsgQ_AllocMsgBuf(MsgQ_Handle hMsgQ, size_t BufSize);
void MsgQ_FreeMsgBuf(MsgQ_Handle hMsgQ, void *buf, size_t BufSize);
int MsgQ_Receive(MsgQ_Handle hMsgQ, void **msg, int WaitFlag);

#if defined(__cplusplus)
}
#endif


#endif // !defined(AFX_MSGQMGR_H__C581CC09_A327_11D1_86AA_0000F80373DD__INCLUDED_)
