/* BigMacAPI.h
 * BigMac API file 
 *
 * ---------------------------------------------------------------------        
 *  Copyright Digital Equipment Corporation 1997-1998. All rights reserved.
 *
 *  Restricted  Rights:  Use,  duplication,  or  disclosure by the U.S.
 *  Government is subject to restrictions  as set forth in subparagraph
 *  (c)(1)(ii) of DFARS 252.227-7013,  or  in FAR 52.227-19,  or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 *  This software  is  proprietary  to  and  embodies  the confidential
 *  technology  of  Digital  Equipment  Corporation.  Possession,  use,
 *  or copying of this software and  media  is authorized only pursuant
 *  to  a  valid  written   license   from  Digital  or  an  authorized
 *  sublicensor.
 * ---------------------------------------------------------------------
 *
 * system: SA1200
 * subsystem: FDriver
 * author: sk, Apr 99 Initial version
 * $History: BigMacAPI.h $
 * 
 * *****************  Version 9  *****************
 * User: Dhooper      Date: 7/23/99    Time: 4:46p
 * Updated in $/dev_1200/SA1_CoreLibs/OctalMAC_21440
 * 
 * *****************  Version 8  *****************
 * User: Skornfel     Date: 7/23/99    Time: 4:19p
 * Updated in $/dev_1200/SA1_CoreLibs/OctalMAC_21440
 * Added OctalMACCofigureEndian(int mac, Endian order); //order=LITTLE 
 * interface 
 * 
 * *****************  Version 7  *****************
 * User: Skornfel     Date: 6/24/99    Time: 3:53p
 * Updated in $/dev_1200/SA1_CoreLibs/OctalMAC_21440
 * 21440 ISV board support removed 
 * 
 * *****************  Version 6  *****************
 * User: Skornfel     Date: 6/09/99    Time: 8:03p
 * Updated in $/dev_1200/SA1_CoreLibs/OctalMAC_21440
 * runs on1200 eval board
 * supports two 21440 macs with 16 ports
 * in both non interrupt and interrupt modes   
 * 
 * *****************  Version 4  *****************
 * User: Skornfel     Date: 5/24/99    Time: 5:27p
 * Updated in $/dev_1200/SA1_CoreLibs/OctalMAC_21440
 * 
 * *****************  Version 3  *****************
 * User: Skornfel     Date: 5/24/99    Time: 4:58p
 * Updated in $/dev_1200/SA1_CoreLibs/OctalMAC_21440
 * 
 * *****************  Version 2  *****************
 * User: Skornfel     Date: 5/24/99    Time: 4:21p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 1  *****************
 * User: Skornfel     Date: 4/26/99    Time: 6:29p
 * Created in $/dev_1200/Include
 * 
  * ---------------------------------------------------------------------
 */
#ifndef BIG_MAC_DRIVER_API_H
#define BIG_MAC_DRIVER_API_H

/* PURPOSE: Fdriver's Extern C API's */

  enum PortRunDirection{
  	RX_AND_TX = 0,
	    RX = 1,
	    TX = 2
  };
  enum BusWidth{
	    BUS_WIDTH_32 = 0,
	    BUS_WIDTH_64 = 1
  };
  enum FIFO_Threshold{
		//THRESHOLD_0 = 0, not allowed
		THRESHOLD_16  = 0x1,
		THRESHOLD_24  = 0x2,
		THRESHOLD_32  = 0x3,
		THRESHOLD_40  = 0x4,
		THRESHOLD_48  = 0x5,
		THRESHOLD_56  = 0x6,
		THRESHOLD_64  = 0x7,
		THRESHOLD_72  = 0x8,
		THRESHOLD_80  = 0x9,
		THRESHOLD_88  = 0xa,
		THRESHOLD_96  = 0xb,
		THRESHOLD_104 = 0xc,
		THRESHOLD_112 = 0xd,
		THRESHOLD_120 = 0xe,
		THRESHOLD_128 = 0xf
  };

  enum Endian{
		LITTLE = 0,
		BIG = 1
  };

#ifdef __cplusplus
extern "C" {
#endif

//externs

void OctalMACCreateDriver (int mac/*=0*/);

int OctalMACStartPort (int port, int mac/*=0*/, int port_run_direction/* = RX_AND_TX*/);

int OctalMACStopPort (int port, int mac/*=0*/, int port_stop_direction/* = RX_AND_TX*/ );

int OctalMACResetPort  (int port, int mac/*=0*/ );

int OctalMACCofigureFifoAndBusWidthOnPort(int port, int mac,				  /*=0*/
												 BusWidth bus_width,		  /*=BUS_WIDTH_64*/
												 FIFO_Threshold rx_threshold, /*=THRESHOLD_128*/ 
												 FIFO_Threshold tx_threshold  /*=THRESHOLD_64*/
												 ); 


int OctalMACCofigureEndian(int mac, Endian order/*LITTLE*/); 

int OctalMACResetAll(int mac/*=0*/);

#ifdef __cplusplus
}
#endif
#endif  /* BIG_MAC_DRIVER_API_H */















