#include <NBaction/NBset.h>
#include <NBaction/NBelement.h>

/*
** This file was automatically generated by nbsetcode.
** If you edit it, your changes will probably be lost
** the next time someone regenerates this file.
*/
/*
** Elt_tcpsset and Set_tcpsset classes used by NCL set 'tcpsset'
** with 4 key(s) size hint= 1000
** hash table size= 1024, with 10 bit wide hash output
*/

class Elt_tcpsset
    : public Element
{
public:
    static int      users_;
    static size_t   esize_;
    static Pool   * epool_;

    void *operator new(size_t esize)
        {
            if (esize_ != esize) {
                /* fails if wrong size for our pool */
                if (epool_ != NULL) {
                    return NULL;
                }
                epool_ = new Pool(esize, Element::align_mod, Element::align_off);
                /* fails if unable to allocate pool */
                if (epool_ == NULL) {
                    return NULL;
                }
                esize_ = esize;
            }
            /* fails if out of memory */
            return epool_->take();
        }

    static void operator delete(void *eptr, size_t esize)
        {
            /* fails if we have no pool */
            if (epool_ == NULL)
                return;
            /* fails if wrong size for pool */
            if (esize_ != esize)
                return;
            epool_->free(eptr);
        }

    inline Elt_tcpsset(nuint32 nk1, nuint32 nk2, nuint32 nk3, nuint32 nk4) {
	key_[0] = nk1;
	key_[1] = nk2;
	key_[2] = nk3;
	key_[3] = nk4;
    }

    nuint32 key_[4];
};

class Set_tcpsset
    : public Set
{
public:

    Set_tcpsset(Ace *iace, char *iname)
        : Set(iace, iname, 10, 4)
        {
            Elt_tcpsset::users_ ++;
        }

    Set_tcpsset(ModuleId id, Ace *iace, char *iname)
        : Set(id, iace, iname, 10, 4)
        {
            Elt_tcpsset::users_ ++;
        }

    ~Set_tcpsset()
        {
            Elt_tcpsset::users_ --;
            if (Elt_tcpsset::users_ < 1) {
                if (Elt_tcpsset::epool_)
                    delete Elt_tcpsset::epool_;
                Elt_tcpsset::epool_ = NULL;
                Elt_tcpsset::esize_ = 0;
                Elt_tcpsset::users_ = 0;
            }
        }

    inline Search locate(nuint32 nk1, nuint32 nk2, nuint32 nk3, nuint32 nk4)
        {
            int                p = table_;
            int                h = 0;

            /*
            ** NOTE: this search code must precisely match the search
            ** algorithm implemented in the Classification Engine.
            */
	    h += (nk1.raw_ & 0xFFFF) + (nk1.raw_ >> 16);
	    h += (nk2.raw_ & 0xFFFF) + (nk2.raw_ >> 16);
	    h += (nk3.raw_ & 0xFFFF) + (nk3.raw_ >> 16);
	    h += (nk4.raw_ & 0xFFFF) + (nk4.raw_ >> 16);
            h ^= h >> 10;
            h &= 0x3ff;
            p += (h<<3) + 4;
            while (true) {
                p = *(int *)p;
                if ((p <= 0) ||
                    (	(nk1.raw_ == ((unsigned *)p)[1]) &&
	(nk2.raw_ == ((unsigned *)p)[2]) &&
	(nk3.raw_ == ((unsigned *)p)[3]) &&
	(nk4.raw_ == ((unsigned *)p)[4])))
                    return Search(p);
            }
        }
};

// Static members for Elt_tcpsset
int                 Elt_tcpsset::users_;
size_t              Elt_tcpsset::esize_;
Pool              * Elt_tcpsset::epool_;

