// ----------------------------------------------------------------------
// cbswitching - cbswitching action code file
//version 1.0
//author: Servio Lima Reina
//Carnegie Mellon University
//Last modified: Feb 17 2001  9:32PM
//Description:
//This program implements an incomplete TCP stack, just for handling 
//three way handshake (SYN) and ACK, RST and DATA packets.
//There is no consideration for packet fragmentation, checksum errors,
//duplicated packets
//In addition, it invokes the LARD algorithm for deciding to which backend
//server send the client's request
//Moreover, the TCP implementation considers only the case when the client
//finishes the connection with a RST packet. Other cases are not taken 
//into account.
//Finally, it establish TCP session with the back ends for sending them 
//the proper client-front end's TCP state information, necesary for the 
//handoff mechanism implemented in the backends.
//The program is expected to run as the CONTROL PLANE in STRONGARM processor
//part of the PA100 Network processor architecture
//PRESENT WORK
//1. Develop of a light TCP layer with support to some TCP states (not all states supported)
//2. ACE search and matching capabilities fully used
//3. Use of hash tables for fast lookup (tcpsessionkey to tcpsession obj mapping and url to backend mapping)
//4. Host stack is not used: all work is done in the STRONGARM  processor
//5. Use of data plane functionality for avoinding to keep TCPSessionHandlers in memory. Basically
// this is a hash table in the ACL associated with a rule in the NCL that does not need to call
//any TCPSessionHandler for handling a packet that belongs to handedoff connection. Therefore less
//memory consumption in the frontend is needed,making it capable of handling a big number of 
//requests/sec
//6. Complete LARD algorithm implementation
//FUTURE WORK
//1. ARP support, ARP table
//2. IP or TCP options support
//3. IP segmentation and reasembly
//4. Remove assumption that the URL (http://*\n\n) fits in a single ethernet frame's payload
//5. All backends have the same thigh and tload because they have the same hardware architecture:
//this assumption should be relief in future versions.
//(1500bytes-54bytes(headers)= 1446bytes payload) which is almost always the case.
//6. Change to variables the values THIGH and TLOW, and allow differences for each different 
//backend server
//7. TCP sliding window mechanism
// ----------------------------------------------------------------------

//LIBRARIES
#include "nbaction/NBaction.h"
#include "nbaction/NBbacklog.h"
#include "nbswap.h"
//#include "nbaction/streamsearch.h"
//#include "Elt_tcpsset.h"
#include <map>
#include "string.h"
#include "defalloc.h"
#include "stdlib.h"


//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
// G L O B A L    V A R I A B L E S
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------

//#define DEBUG
	
//CLOCKING DEFINITIONS for PROFILING
#ifdef DEBUG
#define PA100_TIMESTAMP		0x0c000d00
volatile unsigned *timer = (volatile unsigned*)PA100_TIMESTAMP;
unsigned start,stop;


unsigned clockCycles(void);

unsigned clockCycles(void) {
	return *timer;
}
#endif

//data structures for checksum calculation
//TCP STATES
#define SYN_RCVD		1
#define ACK_RCVD		2
#define ESTABLISHED		3  //client-front end TCP session
#define ESTABLISHED_2	4  //frontend-backend TCP session
#define FIN_RCVD_1		5
#define FIN_RCVD_2		6
#define CLOSING			7
#define DATA_RCVD		8
#define SYN_SEND		9
#define SYNACK_RCVD_0	10
#define SYNACK_RCVD_1	11
#define FIN_FLAG		0x5011

#define TCPSESSION_TIMEOUT		15 //120 //timeout 120 sec - 2 min
#define PKT_SIZE		64 //packet size in bytes
#define PKT_SIZE3		58 //packet size in bytes
#define ETHER_SIZE		14 //ether size in bytes
#define ETHER_FLAG		0x0800
#define MAX_REPORTS		1
//#define FRONTEND_SEQNO	0x3ab50c2a  //fixed seqno shared with the backend
#define FRONTEND_SEQNO	0x11111111  //fixed seqno shared with the backend
//#define FRONTEND_IPADDR 0xa000003
#define FRONTEND_IPADDR 0xa000002
#define IP_TCP_LENGTH	40 //IP+TCP headers without options

//The appropiate setting for TLOW depends on the speed of the backend nodes. 
//In practice, TLOW should be chosen high enough to avoid idel resources on backend nodes,
//which could cause throughput loss. Given TLOW, choosing THIGH involves a tradeoff.
//THIGH-TLOW should be low enough to limit the delay variance among the backends to
//acceptable levels, but high enough to tolerate limited load imbalance and short term
//load fluctuations without destroying locality
//#define TLOW			25	//used in LARD
//#define THIGH			65  //used in LARD
//#define TLOW			10	//used in LARD
//#define THIGH			124  //used in LARD
//#define TLOW			10	//used in LARD
//#define THIGH			1024  //used in LARD
#define NUMBER_BACKENDS 1
#define TLOW			216	//used in LARD
#define THIGH			240  //used in LARD The gap between THIGH and TLOW should not be too high
#define LARD_CAP		(((NUMBER_BACKENDS-1)*THIGH)+TLOW-1)

//Ethernet Port A: 00:90:D7:00:05:12 10 MB/s Half Duplex
//Ethernet Port B: 00:90:D7:00:05:13 10 MB/s Half Duplex
//ROUTER:   ether 00:00:c0:0b:f9:e4
//source
//PORT B
#define FRONTEND_ETHER1	0x0090D700
#define FRONTEND_ETHER2	0x0513
// 00-00-c0-0b-f9-e4 (10.0.0.8)
//destination
//#define ROUTER_ETHER1_SRC	0x0000c00b
//#define ROUTER_ETHER2_SRC	0xf9e4
#define ROUTER_ETHER1_SRC	0x00a0248d
#define ROUTER_ETHER2_SRC	0x4f3c


//client Pentium II 333Mhz 128Mb
//should go away once lard implemented!
//destination (10.0.0.10)IIF
//00-c0-4f-0d-ee-d0
//10.0.0.19
#define BACKEND_ETHER1	0x000000c0       //everglades  Pentium III 600Mhz  256Mb 
#define BACKEND_ETHER2	0x4f0deed0		 //FreeBSD 4.1 REL 0
//10.0.0.20
#define BACKEND_ETHER1_2	0x000000a0  //timberline  Pentium II 266Mhz 64Mb RAM
#define BACKEND_ETHER2_2	0x2412690d	//FreeBSD 4.1 REL 0

//10.0.0.21
#define BACKEND_ETHER1_3	0x000000a0	//dutt  Pentium II 266 Mhz 128 Mb RAM fxp0
#define BACKEND_ETHER2_3	0xc99de40a
//10.0.0.22
#define BACKEND_ETHER1_4	0x00000010	//vail Pentium II 266 Mhz 128 Mb RAM xl0
#define BACKEND_ETHER2_4	0x4b267f13



#define BACKEND_ETHER1_SRC	0x00c04f0d
#define BACKEND_ETHER2_SRC	0xeed0 



//hardcoded list of the ip address of the backends
//would be improved if list is passed through a downcall from the host
uint32 backends[NUMBER_BACKENDS*3]={FRONTEND_IPADDR,BACKEND_ETHER1,BACKEND_ETHER2};
//,
//FRONTEND_IPADDR,BACKEND_ETHER1_2,BACKEND_ETHER2_2};
//									,
//									FRONTEND_IPADDR,BACKEND_ETHER1_3,BACKEND_ETHER2_3};
/*,
									FRONTEND_IPADDR,BACKEND_ETHER1_4,BACKEND_ETHER2_4};
*/									
									
int numbertcpsessions;
		
//Structures used in TCPSessionHandler object
//Partial Ethernet header
typedef struct etherhdr{
		nuint32 etherpart1_dst;
		nuint32 etherpart2_dst;
		nuint32 etherpart1_src;
		nuint32 etherpart2_src;
	}etherhdr;


// complete IP header structure in words of 32 bits
typedef struct iphdr{
	nuint32 vhtl;
	nuint32 srcipaddr;
	nuint32 dstipaddr;
	nuint32 ifo;
	nuint32 tpc;
	}iphdr;

//backend data structure
typedef struct backend{
	nuint16 ether1;
	nuint32 ether2;
	nuint32 ipaddr;
}backend;

//partial tcp header for 
//checksum calculation . struct can not be extended cause it is used as is
//in checksum calculation --it considers struct size
	typedef struct tcphdr{
		nuint32 srcdstport;
		nuint32 seqno;
		nuint32 ackno;
		nuint32 hdrflgwindow;
		nuint32 pseudotcplen;
		nuint32 pseudosrcipaddr;
		nuint32 pseudodstipaddr;
		uint32* payload;
	} tcphdr;

		
//declarations of main classes
	class Ccbswitching;
	class TCPSHashTable;
	class TCPSessionHandler;
	class Packet_template;
	class port_B_target;
	class LARD_table;
	class Backend_server;
	class EventClass;


//declaration of common functions
	/*
int GotString(void* context1, void* context2, Buffer* buf,
			  NBStringID sid, void* stringtag, int endoffset,
			  int matchlen, char* data);
void AfterBuffer(void* context1, void* context2, Buffer* buf,
				 NBStringMatchReport* rep);

void CallbackSearchengine(int returnvalue,void *context);
*/

//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
//				  M A I N      C L A S S E S 
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------


// ----------------------------------------------------------------------
//  Ccbswitching ACE CLASS
//  acts as a multiplexor for incoming packets
//  create TCPSession objects when needed
//  always running
//  TCPSHashTable is a class part of Ccbswitching ACE, because it is
//  also shared by all TCPSessionHandler objects
// ----------------------------------------------------------------------
class Ccbswitching : public Ace {
public:
   Ccbswitching(ModuleId id, char* name, Image* obj);  
   ~Ccbswitching();  
    //void pkthandler(Buffer *b, Search stream,int flag);
	//bool lookupsettable(Buffer *buf, int flag);
	TCPSHashTable *tcpsht;
	Backend_server *beserver[NUMBER_BACKENDS];
	LARD_table *lardht;
//	Set_tcpsset tcpsset_list;
	Target *port_B;
	//NBSearchContext and NBStringSearchEngine objects
	//belong to each particular TCP session
	// String Search Support


	//commented by slima 02/17/01
	//int search_is_set_up; //state variable
	//NBStringSearchEngine urlsearchengine; //engine object
	//void SetupSearch(char* str); //change to search mode
};


// ----------------------------------------------------------------------
//TCPSessionHandler CLASS
//this class represents the session established between client-front end
//and front end-back end
//It handles NBStringSearchEngine because each TCPSessionHandler should
//be related with is respective Search Engine
// ----------------------------------------------------------------------
class TCPSessionHandler{
public:
		int tcpsessionid;
		Buffer *buff;
		int tcpstate;
		//complete http header storage
		uint32 *httpheader; //complete http
		uint32 *url;  //only url
		int tcpsessionkey;
		etherhdr etherheader;
		etherhdr etherheaderorig;
		iphdr	 ipheader;
		iphdr	ipheaderorig;
		tcphdr	 tcpheader;
		tcphdr	tcpheaderorig;
		backend bkendselected;
		
		Backend_server *mybeserver;

		bool flagfin;  //flag for accepting only once the FIN_FLAG packet

		//backlog
		//int bklogranow[10];
		//int bklograest[10];
		int MAX_SIZE;
		//reply packet functions
		void replypkt2(Ccbswitching *Ace, Buffer *buf, int flag);
		//packet template for responding to certain TCP/IP packets
		//each TCPSessionHandlers handles a packet of this kind.
		Packet_template *pktbase_tsh;

		//NBSearchContext and NBStringSearchEngine objects
		//belong to each particular TCP session
		// String Search Support
		//int search_is_set_up; //state variable
		//NBStringSearchEngine urlsearchengine; //engine object

		//commented by slima 02/17/01
		/*NBSearchContext urlsearchcontext; //context object
		//was before static
		NBStringMatchReport rep; //report object
		*/
		//void SetupSearch(char* str, Ccbswitching *ace); //change to search mode
		TCPSessionHandler* TCPSpointer();

		//LARD function: is better to use a function than create a new object (operation 
		// too expensive in terms of memory latency
		bool apply_lard(Ccbswitching *ace);

		//Establish a TCP session with the backend
		void backend_tcpsession(Ccbswitching* ace);

		//checksum calculation
		unsigned long cksum(uint32 *buf,int count);
		long cksum2(uint32 *buf,int count);

		//constructor and destructor
		TCPSessionHandler();
		TCPSessionHandler(int srcipaddr, int dstipaddr, int srcdstport, Ccbswitching *ace);
		~TCPSessionHandler();
		//pkt counter
		int end_pktcounter;

	//event handler
		//EventClass *evt;
		//Backlog bklog;

		//added by slima 02/17/01
		void FoundString(Ccbswitching *ace);
		bool urlfound;


};

// ----------------------------------------------------------------------
//TCPHashTable CLASS
//shared data structure for storing tcpsessionkey to TCPSessionHandler pointer mapping
//This class stores a associative  table (map in C++) that relates
//the hash value of <srcaddr,dstaddr,srcport,dstport> with the pointer
//to the TCPSessionHandler object related to that value.
//A hash function built in the map class used, allows for fast lookup and
//retrieval of the object needed
//This is a shared resource. It should provide an interface for ensure
//atomic transactions over it.
// ----------------------------------------------------------------------
class TCPSHashTable{
	public:
	typedef TCPSessionHandler* tcpsp;
 	//typedef map<int,tcpsp> tcpsessionhashtable;
	typedef map<int,tcpsp> tcpsessionhashtable;
	tcpsessionhashtable::iterator itr;
	tcpsessionhashtable tcpshtable;
	TCPSHashTable();
	~TCPSHashTable();
};



// ----------------------------------------------------------------------
//Packet template class
//Define the content of a base TCP/IP packet
//Buffer will contain  constant TCP/IP packet information
//Modifications to several fields of the packet could be done
//in order to response to several incoming packets
// ----------------------------------------------------------------------
class Packet_template{
public:
	Buffer *buf;
	Packet_template();
	~Packet_template();
	void Packet_initialize3();
};


// ----------------------------------------------------------------------
// Target class for handling packets from/to port B
// ----------------------------------------------------------------------
class port_B_target:public Target{
public:
port_B_target(ModuleId id, Ace* ace, char *name);
~port_B_target();
};


// ----------------------------------------------------------------------
// LARD table
//shared class structure for storing URL to server mapping
// ----------------------------------------------------------------------
class LARD_table{
public:
	LARD_table();
	~LARD_table();
	//To prevent LARD acts as a WRR , we limit the sum total of connections
	//handed to all backend nodes to the value  S= (n-1)*Thigh+Tlow -1
	static int totalsumconnections;

	//map table url to server mapping
	typedef Backend_server* besp;
	//typedef map<uint32*,besp> lardhashtable;
	typedef map<uint32,besp> lardhashtable;
	lardhashtable::iterator itr;
	lardhashtable lardhtable;

	Backend_server* leastloadednode(Ccbswitching *ace);
	bool LARD_checksumallloads(Ccbswitching *ace);
	bool existlessTLOW;
};


class Backend_server{
public:
	Backend_server(nuint32 ipad, int loads, nuint16 eth1, nuint32 eth2);
	~Backend_server();
//data structure for storing backend info
	backend bkend;
//backend constant parameters
	int thigh;
	int tlow;
//backend variable parameters
	int load;
};


//class for keeping track of TCP timeouts and retransmission
class EventClass : public Event{
public:
	TCPSessionHandler *tcpsh;
	Ccbswitching *ace;
	//changed by slima 02/09/01
    //EventClass(TCPSessionHandler *tsh, Ccbswitching *a);
	EventClass();
	~EventClass();
    //void eventAction(Ccbswitching *ace,TCPSessionHandler *tcpsh, Buffer *buff);   //method called after the scheduled time
	void eventAction(void);   //method called after the scheduled time
};



//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
// C O N S T R U C T O R S    A N D   D E S T R U C T O R S
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------


// ----------------------------------------------------------------------
//Ccbswitching CONSTRUCTOR
//creates referenced objects
// ----------------------------------------------------------------------
Ccbswitching::Ccbswitching(
   ModuleId id, 
   char     *name, 
   Image    *obj ):
	Ace( id, name, obj)
		//,
	//tcpsset_list(id,this,"tcpsset")
	//commented by slima 02/17/01
	//,
	//search_is_set_up(0)
{
		numbertcpsessions=0;
	//backend server initialization for LARD hash table use
		for(int i=0;i<NUMBER_BACKENDS;i++){
			if((beserver[i] = new Backend_server(backends[i*3],0,backends[(i*3)+1]&0x0000ffff,backends[(i*3)+2]))==NULL)
			printf("ERROR>>Can not allocate memory for Backend_server[%d]\n",i);
		}

   // TCPSHashTable global is constructed here
	if((lardht = new LARD_table())==NULL)
	   printf("ERROR>>Can not allocate memory for LARD_table\n");

   if((tcpsht = new TCPSHashTable())==NULL)
	   printf("ERROR>>Can not allocate memory for TCPHashTable\n");
	
   //target object created
	port_B =new port_B_target(id, this, "port_B");

	//commented by slima 02/17/01
	//SetupSearch("GET");  //contention for the SEARCH ACE would happen here

	//added by slima 02/09/01
	//new EventClass();

   printf("ACE (1) ");
   printf("cbswitching ");
   printf("has been successfully constructed\r\n" );
   //added by slima 02/09/01
   //start = clock();
} 


// ----------------------------------------------------------------------
//Ccbswitching DESTRUCTOR
//creates referenced objects
// ----------------------------------------------------------------------
Ccbswitching::~Ccbswitching()
{
	int status;
   // TODO:    Add additional destruction code here
   printf("ACE (1) ");
   printf("cbswitching ");
   printf("is destructed\r\n" );

   // tcpsset_list.clear();
/*	for (Elt_tcpsset* p = (Elt_tcpsset*) tcpsset_list.first();
	     p != NULL;
		 p = (Elt_tcpsset*) tcpsset_list.next(p))
	{
		delete p;
	}
*/
		 //commented by slima 02/17/01
/*	if((status=this->urlsearchengine.ChangeOpMode(NBS_MODE_MAINT, NULL, NULL))==NB_SUCCESS)
			printf("STATUS>>NB_SUCCESS of ChangeOpMode MODE_MAINT at END\n");
	else
			printf("STATUS>>%d of ChangeOpMode MODE_MAINT at END\n",status);

	this->urlsearchengine.SchedDelete((NBStrCallback)CallbackSearchengine,NULL);
*/		 

//added by slima 02/08/01
	for(int i=0;i<NUMBER_BACKENDS;i++)
				delete beserver[i];

//delete LARD_table();
	delete this->lardht;
//delete TCPSHashTable();
	delete this->tcpsht;
//delete port_B_target();
	delete this->port_B;
	
} 


// ----------------------------------------------------------------------
//TCPSessionHandler CONSTRUCTOR
//TCPSessionHandler::TCPSessionHandler(nuint32 srcipaddr, nuint32 dstipaddr,
// nuint32 srcdstport){
// ----------------------------------------------------------------------
TCPSessionHandler::TCPSessionHandler(int srcipaddr, int dstipaddr, int srcdstport, Ccbswitching *ace)
:
//search_is_set_up(0),
//commented by slima 02/17/01
//rep(MAX_REPORTS),
MAX_SIZE(10),
end_pktcounter(0)
{
	//src and dst addr,refers to the packet's fields that were sent by the client
	//srcdstport is inverted relative to the packet's field sent by the client
	//httpheader=NULL;
	//url=NULL;
	flagfin=false;
	urlfound=false;
	ipheader.srcipaddr = srcipaddr;
	ipheader.dstipaddr = dstipaddr;
	tcpheader.srcdstport = srcdstport;
	tcpsessionkey = (srcdstport&0xffff0000)>>16;
	//tcpsessionkey = srcipaddr + dstipaddr + (srcdstport&0xffff0000)>>16;

	// set up callbacks
	//commented by slima 02/17/01
	/*this->urlsearchcontext.SetOpt(NBS_OPT_SIMPLE,1);
	this->urlsearchcontext.SetOpt(NBS_OPT_PERSTR,0);
	this->urlsearchcontext.SetPerMatchCallback(
		(NBStrPerMatchCallback) GotString,
		this, ace);
	this->urlsearchcontext.SetPerBufferCallback(
		(NBStrPerBufferCallback) AfterBuffer,
		NULL, NULL);*/

}


// ----------------------------------------------------------------------
//TCPSessionHandler DESTRUCTOR
// ----------------------------------------------------------------------
//TCPSessionHandler::~TCPSessionHandler(int tcpsid){
TCPSessionHandler::~TCPSessionHandler(){
	//commented by slima 02/17/01
//this->urlsearchcontext.SchedDelete();
}


// ----------------------------------------------------------------------
//TCPSHashTable CONSTRUCTOR
// ----------------------------------------------------------------------
TCPSHashTable::TCPSHashTable(){
;
}

// ----------------------------------------------------------------------
//TCPSHashTable DESTRUCTOR
// ----------------------------------------------------------------------
TCPSHashTable::~TCPSHashTable(){
;
}


// ----------------------------------------------------------------------
//Packet_template CONSTRUCTOR
// ----------------------------------------------------------------------
Packet_template::Packet_template(){
}




// ----------------------------------------------------------------------
//Packet_template DESTRUCTOR
// ----------------------------------------------------------------------
Packet_template::~Packet_template(){

}


// ----------------------------------------------------------------------
//port B target CONSTRUCTOR
// ----------------------------------------------------------------------
port_B_target::port_B_target(ModuleId id, Ace *ace, char *name):
Target(id,ace,name)
{

}


// ----------------------------------------------------------------------
//port B target DESTRUCTOR
// ----------------------------------------------------------------------
port_B_target::~port_B_target(){

}




// ----------------------------------------------------------------------
//LARD_table CONSTRUCTOR
// ----------------------------------------------------------------------
LARD_table::LARD_table(){
existlessTLOW=false;
}


// ----------------------------------------------------------------------
//LARD_table DESTRUCTOR
// ----------------------------------------------------------------------
LARD_table::~LARD_table(){

}

// ----------------------------------------------------------------------
//Backend_server CONSTRUCTOR
// ----------------------------------------------------------------------
Backend_server::Backend_server(nuint32 ipad, int loads, nuint16 eth1, nuint32 eth2){
thigh =THIGH;
tlow = TLOW;
load=loads;
bkend.ipaddr = ipad.raw_;
bkend.ether1 = eth1.raw_;
bkend.ether2 = eth2.raw_;

}


// ----------------------------------------------------------------------
//Backend_server DESTRUCTOR
// ----------------------------------------------------------------------
//Backend_server::~Backend_server(nuint32 ipad){
Backend_server::~Backend_server(){
}


// ----------------------------------------------------------------------
//EventClass CONSTRUCTOR
// ----------------------------------------------------------------------
//changed by slima 02/09/01
//EventClass::EventClass(TCPSessionHandler *tsh, Ccbswitching *a):
EventClass::EventClass():
Event(EVENTMFP(eventAction), Time::secs(TCPSESSION_TIMEOUT)){
//changed by slima 02/08/01
//this->tcpsh= tsh;
//this->ace = a;
;
}

// ----------------------------------------------------------------------
//EventClass DESTRUCTOR
// ----------------------------------------------------------------------
EventClass::~EventClass(){
;
}



//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
//M I S C E L A N E O U S      F U N C T I O N S
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------

// ----------------------------------------------------------------------
//TCPSessionHandler pointer function
// ----------------------------------------------------------------------
TCPSessionHandler* TCPSessionHandler::TCPSpointer(){
	return this;
}





// ----------------------------------------------------------------------
//Initialize a packet from Ccbswitching. This template will be copy later
//in each TCPSessionHandler object.
//The initialization occurs only once at the beginning of the program
// ----------------------------------------------------------------------
void Packet_template::Packet_initialize3(){
	unsigned char pktsyn[PKT_SIZE3] = {
			0x00, 0xc0, 0x4f, 0x0d, 0xee, 0xd0, //etherdst
			0x00, 0xb0, 0xd0, 0x22, 0xfc, 0x71, //ethersrc
			0x08,0x00,                                  //type
			0x45, 0x10, 0x00, 0x2c, 0x08, 0x8e,
			0x40, 0x00, 0x40, 0x06, 0x1e, 0x24,
			0x0a, 0x00, 0x00, 0x08, 0x0a, 0x00,
			0x00, 0x03, 0x04, 0x12, 0x00, 0x50,
			0xc9, 0x69, 0x7a, 0x37, 0x00, 0x00,
			0x00, 0x00, 0x60, 0x02, 0x40, 0x00,
			0xfc, 0x18, 0x00, 0x00, 0x02, 0x04, //tcp options
			0x05, 0xb4 
};
		char *ps;
		if((this->buf = new Buffer())!=NULL){
			if ( ((ps=this->buf->prepend(ETHER_SIZE))!=NULL) && ((this->buf->append(PKT_SIZE3-ETHER_SIZE))!=NULL))
				memcpy(ps,pktsyn,PKT_SIZE3);
			else
				printf("STATUS>> Prepend/append problem in allocating buf\n");
		}
			
		//printf("STATUS>>end of packet initialize\n");

}


// ----------------------------------------------------------------------
//fast response to a packet arriving in client-frontend link
// ----------------------------------------------------------------------
void TCPSessionHandler::replypkt2(Ccbswitching *Ace, Buffer *buff, int flag){
		int urlen;
		iphdr oldiphdr;
		iphdr newiphdr;
		tcphdr oldtcphdr;
		tcphdr newtcphdr;

		nuint16 oldiphdr_checksum;
		nuint16 newiphdr_checksum;
		nuint16 oldipchecksum;
		nuint16 newipchecksum;

		nuint16 oldtcphdr_checksum;
		nuint16 newtcphdr_checksum;
		nuint16 oldchecksum;
		nuint16 newchecksum;
		
		//printf("STATUS>>takable set = %d\n",buff->takable());
		//printf("STATUS>>txtime = %d\n",buff->txTime().usec());
		//printf("STATUS>>Backlog est = %d\n",this->bklog.est(bklograest,MAX_SIZE));
	//	//printf("STATUS>>Backlog names = %d\n",this->bklog.names(bklograest,MAX_SIZE));
		//printf("STATUS>>Backlog now = %d\n",this->bklog.now(bklogranow,MAX_SIZE));
		//printf("STATUS>>Backlog size = %d\n",this->bklog.size());


		oldchecksum = (nuint16)( buff->b.pkt_[37]>>16 & 0x0000ffff);
		//printf("STATUS>>original checksum=0x%x\n",oldchecksum.raw_);
		oldtcphdr.srcdstport = buff->b.pkt_[33];
		oldtcphdr.seqno=buff->b.pkt_[34];
		oldtcphdr.ackno=buff->b.pkt_[35];
		oldtcphdr.hdrflgwindow=buff->b.pkt_[36];
	
		//printf("STATUS>>I am HERE -2!!!!\n");

		nuint16 iplength= (nuint16)(buff->b.pkt_[28]&0x0000ffff);
		int payloadlength;
		int trailzeros=0;
		//printf("STATUS>>I am HERE -1!!!!\n");
		if((trailzeros=((iplength.raw_-IP_TCP_LENGTH)%4))==0)
			payloadlength= (iplength.raw_-IP_TCP_LENGTH)/4;  //divided by 4bytes = 32 bits each buff word
		else
			payloadlength= (iplength.raw_-IP_TCP_LENGTH)/4+1;  //divided by 4bytes = 32 bits each buff word

		//printf("STATUS>>I am HERE 0!!!!\n");

		if(flag==ACK_RCVD || flag==SYN_SEND || flag==SYNACK_RCVD_0 || flag==SYNACK_RCVD_1)
		{
		
			
		//oldtcphdr.payload= (uint32*) malloc(payloadlength);
		//if((oldtcphdr.payload= (uint32*) malloc(payloadlength*sizeof(uint32)))==NULL)

		//printf("STATUS>> Before I am HERE...payloadlength:%d\n",payloadlength);

		if(flag!=SYN_SEND){
			//changed by slima 02/08/01
			/*uint32 pld[payloadlength];
			for(int k=0; k<payloadlength;k++)
					pld[k]=0;
			oldtcphdr.payload= pld;
			*/
			//line below commented by slima 02/08/01
			if((oldtcphdr.payload= (uint32*) malloc(payloadlength*sizeof(uint32)))==NULL)
				printf("ERROR>>Could not allocate memory for oldtcphdr.payload\n");
			//else
			//	printf("STATUS>>malloc successful\n");
		} else {
			//printf("STATUS>> I am HERE prev 1\n");
		uint32 arr[1]={0};
		oldtcphdr.payload= arr;
		}
	
	//printf("STATUS>>I am HERE 1!!!!\n");
		oldtcphdr.pseudotcplen=(buff->b.pkt_[28]&0x0000ffff);
	//printf("STATUS>>I am HERE 2!!!!\n");
		if(flag==SYN_SEND){
		oldtcphdr.pseudosrcipaddr=buff->b.pkt_[31];
		oldtcphdr.pseudodstipaddr=buff->b.pkt_[32];
		}
				
		//printf("STATUS>>iplength=%d\n",payloadlength);
		int i=0;

		//changed by slima 02/08/01
		for(i=38;i<38+payloadlength;i++)
			memcpy(oldtcphdr.payload+(i-38),&buff->b.pkt_[i],sizeof(uint32));
		//memcpy(&oldtcphdr.payload[i-38],&buff->b.pkt_[i],sizeof(uint32));

		

		//zero stuffing for cksum calculation
		//trailzeros that should be added when payload is not multiple of 32
		//(3 out of 4 trailzeros may be added as a maximum in a 32 bit word- Buffer structure)
		//printf("STATUS-->Trailzeros value=%d\n",trailzeros);
		if(trailzeros!=0){
		if(trailzeros==1){
			//changed by slima 02/08/01
			*(oldtcphdr.payload+(i-38-1))=(*(oldtcphdr.payload+(i-38-1)))&0xff000000;
			//oldtcphdr.payload[i-38-1]=oldtcphdr.payload[i-38-1]&0xff000000;
			//printf("STATUS>>TRAILZEROS-->0x%x\n",*(oldtcphdr.payload+(i-38-1)));
				}else if(trailzeros==2){
				//changed by slima 02/08/01
				*(oldtcphdr.payload+(i-38-1))=(*(oldtcphdr.payload+(i-38-1)))&0xffff0000;
				//oldtcphdr.payload[i-38-1]=oldtcphdr.payload[i-38-1]&0xffff0000;
					}else if(trailzeros==3){
					//changed by slima 02/08/01
					*(oldtcphdr.payload+(i-38-1))=(*(oldtcphdr.payload+(i-38-1)))&0xffffff00;
					//oldtcphdr.payload[i-38-1]=oldtcphdr.payload[i-38-1]&0xffffff00;
					}
		}
		if(flag==ACK_RCVD) {
			//this->httpheader = (uint32*) malloc(payloadlength);
			if((this->httpheader = (uint32*) malloc(payloadlength*sizeof(uint32)))==NULL)
			//if((this->httpheader = (uint32*) malloc(payloadlength))==NULL)
				printf("ERROR>>Could not allocate memory for httpheader\n");
			memcpy(this->httpheader,oldtcphdr.payload,sizeof(uint32)*payloadlength);
			//	//printf("STATUS>>ACK_RCVD this->httpheader = %s\n",this->httpheader);
		}
	
		if(flag==SYN_SEND){
		unsigned int cko[8];
			cko[0]=(this->cksum(oldtcphdr.payload,payloadlength*4)&0xffff);
			cko[1]=(this->cksum(&oldtcphdr.srcdstport.raw_,4)&0xffff);
			cko[2]=(this->cksum(&oldtcphdr.seqno.raw_,4)&0xffff);
			cko[3]=(this->cksum(&oldtcphdr.ackno.raw_,4)&0xffff);
			cko[4]=(this->cksum(&oldtcphdr.hdrflgwindow.raw_,4)&0xffff);
			cko[5]=(this->cksum(&oldtcphdr.pseudotcplen.raw_,4)&0xffff);
			cko[6]=(this->cksum(&oldtcphdr.pseudosrcipaddr.raw_,4)&0xffff);
			cko[7]=(this->cksum(&oldtcphdr.pseudodstipaddr.raw_,4)&0xffff);
		oldtcphdr_checksum =(nuint16) ~(this->cksum(cko,8*4)&0xffff);

		}
		else{
		unsigned int cko[6];
			cko[0]=(this->cksum(oldtcphdr.payload,payloadlength*4)&0xffff);
			cko[1]=(this->cksum(&oldtcphdr.srcdstport.raw_,4)&0xffff);
			cko[2]=(this->cksum(&oldtcphdr.seqno.raw_,4)&0xffff);
			cko[3]=(this->cksum(&oldtcphdr.ackno.raw_,4)&0xffff);
			cko[4]=(this->cksum(&oldtcphdr.hdrflgwindow.raw_,4)&0xffff);
			cko[5]=(this->cksum(&oldtcphdr.pseudotcplen.raw_,4)&0xffff);
		oldtcphdr_checksum =(nuint16) ~(this->cksum(cko,6*4)&0xffff);
			//printf("STATUS>> R\n");
		}
		//printf("STATUS>>payload=%s, sizeof=%d, checksum=0x%x\n", oldtcphdr.payload, sizeof(oldtcphdr)-4+(sizeof(uint32)*payloadlength),oldtcphdr_checksum.raw_);
		}else {
		//tcp
		oldtcphdr_checksum = Internet::cksum((nuint16*)&oldtcphdr,
			sizeof(oldtcphdr)-16);  //-16 due to the payload and pseudotcplen are not used here
		}


		if(flag==ACK_RCVD || flag==SYN_SEND || flag==SYNACK_RCVD_0 || flag==SYNACK_RCVD_1){
			//calculate IP checksum and get rid of incoming ACK payload
			//printf("STATUS>>Modifying IP header checksum\n");

			//old ip header checksum
			oldipchecksum = (nuint16)( buff->b.pkt_[30] & 0x0000ffff);
			if(flag!=SYN_SEND && flag!=SYNACK_RCVD_0){  //changed by slima 02/02/2001
			oldiphdr.vhtl=buff->b.pkt_[28];

			//ip
			oldiphdr_checksum = Internet::cksum((nuint16*)&oldiphdr.vhtl,
			sizeof(oldiphdr.vhtl));
			}
			else {
				oldiphdr.vhtl=buff->b.pkt_[28];
				oldiphdr.srcipaddr=buff->b.pkt_[31];
				oldiphdr.dstipaddr=buff->b.pkt_[32];
				//ip
				oldiphdr_checksum = Internet::cksum((nuint16*)&oldiphdr,
				sizeof(oldiphdr)-8);
				
			}

			if(flag==ACK_RCVD){
				//added by slima 02/16/01
			#ifdef DEBUG
			start = clockCycles();
			#endif

				if(ntohl(buff->b.pkt_[38])==0x47455420)   //if payload is = "GET "
					this->urlfound=true;

#ifdef DEBUG
	stop = clockCycles();
	printf("%d cycl after url searching\n",(stop-start)>>3);
	//start = clockCycles();
#endif

//					this->FoundString(Ace);

				//commented by slima 02/17/01
			/*if (Ace->search_is_set_up) {
			int val=NB_SUCCESS;
			//#ifdef DEBUG
	//		start2 = clockCycles();
			//#endif
			//printf("STATUS>>1c...\n");

			
			if((val =Ace->urlsearchengine.SearchBuffer(Ace, buff, ((char*) buff), 1024,
					&(this->urlsearchcontext), &(this->rep)))!=NB_SUCCESS)
						printf("ERROR>>Search engine cannot accept the request: (NB_FAILURE /NB_BUSY) %d\n",val);
	
			} else {
				printf("ERROR>> Search engine is still not ready to search.\n");
			}*/
			//printf("STATUS>>2c...\n");



			int payload  = (((nuint16)(oldiphdr.vhtl.raw_ & 0x0000ffff)).raw_-0x0028);	
			//printf("STATUS>>payloadlen=%d\n",payload);
			//get rid of payload
			//printf("STATUS>>packetsize before=%d\n",buff->packetSize());

			buff->trim_tail((size_t) (payload-8));
				
			buff->b.pkt_[28]= (buff->b.pkt_[28] & 0xffff0000) |0x00000028;
			
			//frame padding
				buff->b.pkt_[38]=0x00000000;
				buff->b.pkt_[39]=0x00000000;

				newiphdr.vhtl=buff->b.pkt_[28];
			
			//ip
				newiphdr_checksum = Internet::cksum((nuint16*)&newiphdr.vhtl,
			sizeof(newiphdr.vhtl));
			}
			else if(flag==SYNACK_RCVD_1){
				buff->b.pkt_[28]= this->ipheaderorig.vhtl.raw_;
				buff->b.pkt_[31]= this->ipheaderorig.srcipaddr.raw_;//ipsrc of the client
				buff->b.pkt_[32]= this->bkendselected.ipaddr.raw_;//ipdst of the backend
				buff->b.pkt_[33]=this->tcpheaderorig.srcdstport.raw_;  //ports
				newiphdr.vhtl=buff->b.pkt_[28];
			
			//ip
				newiphdr_checksum = Internet::cksum((nuint16*)&newiphdr.vhtl,
			sizeof(newiphdr.vhtl));
			}
			else if(flag==SYNACK_RCVD_0){
				buff->b.pkt_[28]= (buff->b.pkt_[28] & 0xffff0000) |0x00000028;
				buff->b.pkt_[38]=0x00000000;
				buff->b.pkt_[39]=0x00000000;
				buff->b.pkt_[31]= this->ipheaderorig.srcipaddr.raw_;//ipsrc of the client
				buff->b.pkt_[32]= this->bkendselected.ipaddr.raw_;//ipdst of the backend
				buff->b.pkt_[33]=this->tcpheaderorig.srcdstport.raw_;  //ports
				newiphdr.vhtl=buff->b.pkt_[28];
				newiphdr.srcipaddr=buff->b.pkt_[31];//changed by slima 02/02/2001
				newiphdr.dstipaddr=buff->b.pkt_[32];//changed by slima 02/02/2001
			
				/*newiphdr_checksum = Internet::cksum((nuint16*)&newiphdr.vhtl,
			sizeof(newiphdr.vhtl));*/
				newiphdr_checksum = Internet::cksum((nuint16*)&newiphdr, //changed by slima 02/02/2001
				sizeof(newiphdr)-8);
				
			}
			else if(flag==SYN_SEND){
				buff->b.pkt_[28]= (buff->b.pkt_[28] & 0xffff0000) |0x00000030; //48 byte including option field
				//option field
				////printf("this->tcpheaderorig.seqno.raw_ = 0x%x\n",this->tcpheaderorig.seqno.raw_);
				//buff->b.pkt_[38]=0x00000606<<16 | (this->tcpheaderorig.seqno.raw_ & 0xffff0000)>>16; // option type = 6, option len = 4   
				buff->b.pkt_[38]=0x00000606<<16 | (FRONTEND_SEQNO & 0xffff0000)>>16; // option type = 6, option len = 4   
				buff->append(sizeof(uint32));
				//buff->b.pkt_[39]=(this->tcpheaderorig.seqno.raw_ & 0x0000ffff)<<16;
				buff->b.pkt_[39]=(FRONTEND_SEQNO & 0x0000ffff)<<16;
				buff->b.pkt_[31]= this->ipheaderorig.srcipaddr.raw_;//ipsrc of the client
				buff->b.pkt_[32]= this->bkendselected.ipaddr.raw_;//ipdst of the backend
				buff->b.pkt_[33]=this->tcpheaderorig.srcdstport.raw_;  //ports
				newiphdr.vhtl=buff->b.pkt_[28];
				newiphdr.srcipaddr=buff->b.pkt_[31];
				newiphdr.dstipaddr=buff->b.pkt_[32];
				
			//ip
				newiphdr_checksum = Internet::cksum((nuint16*)&newiphdr,
			sizeof(newiphdr)-8);

			}

			
			//printf("STATUS>>packetsize after=%d\n",buff->packetSize());

			//ip
			newipchecksum = Internet::incrcksum(oldipchecksum,
			oldiphdr_checksum, newiphdr_checksum);

			//ip
			buff->b.pkt_[30]=ntohs(newipchecksum) | 
			(buff->b.pkt_[30] &0xffff0000); 

			
		}
		
		
		if(flag!=SYN_SEND && flag!=SYNACK_RCVD_0 && flag!=SYNACK_RCVD_1){
		//ETHERNET MAC SWAPPING
		uint32 etherdstpart1 = buff->b.pkt_[24] & 0x0000ffff;
		//uint32 etherdstpart2 = buff->b.pkt_[25];
		uint32 etherdstpart2 = buff->b.pkt_[25]>>16 & 0x0000ffff;
		uint32 etherdstpart3 = buff->b.pkt_[25] & 0x0000ffff;
		//uint32 ethersrcpart1 = buff->b.pkt_[26];
		uint32 ethersrcpart1 = buff->b.pkt_[26]>>16 & 0x0000ffff ;
		uint32 ethersrcpart2 = buff->b.pkt_[26] & 0x0000ffff;
		uint32 ethersrcpart3 = buff->b.pkt_[27]>>16 & 0x0000ffff;
	
		buff->b.pkt_[24]= ethersrcpart1;
		buff->b.pkt_[25]= ethersrcpart2 <<16 | ethersrcpart3;
		buff->b.pkt_[26] = etherdstpart1 <<16 | etherdstpart2;
		buff->b.pkt_[27]= etherdstpart3 <<16 | ETHER_FLAG;

		uint32 ipsrc = buff->b.pkt_[31];
		uint32 ipdst = buff->b.pkt_[32];
		buff->b.pkt_[31]=ipdst;
		buff->b.pkt_[32]=ipsrc;

		//TCP PORT ADDR SWAPPING
		//srcport & dstport swapping
		buff->b.pkt_[33]= 
((this->tcpheader.srcdstport.raw_ & 0x0000ffff)<<16) |	((this->tcpheader.srcdstport.raw_>>16) & 0x0000ffff);
		
		} //end of SYN_SEND

		
		//ack and seqno swapping, no need of preserving values. They're
		//calculated on the fly
		nuint32 seqno = this->tcpheader.seqno;
		nuint32 ackno = this->tcpheader.ackno;
	

	switch(flag){
		case SYN_RCVD:
		//syn ack flag
		buff->b.pkt_[36]=buff->b.pkt_[36]&0xff00ffff | 0x00120000 ;
		this->tcpheader.seqno.raw_ = FRONTEND_SEQNO; //should be 0 initially
		this->tcpheader.ackno.raw_ = seqno.raw_+1;  //a simple addition of 1 suffice after SYN_RCVD
		//printf("SYN_RCVD case\n");
		break;

		case ACK_RCVD:  //ACK+PUSH flags on 0x18
		//ack flag
		buff->b.pkt_[36]=buff->b.pkt_[36]&0xff00ffff | 0x00100000 ;
		this->tcpheader.seqno.raw_=ackno.raw_;
		this->tcpheader.ackno.raw_=seqno.raw_+((this->ipheader.vhtl.raw_&0x0000ffff)-0x00000028);//plus the length of the data received
		//printf("ACK_RCVD case\n");
		break;
		
		case SYN_SEND:
		//buff->b.pkt_[36]=buff->b.pkt_[36]&0x0f00ffff | 0x60020000 ;
		buff->b.pkt_[36]=buff->b.pkt_[36]&0x0f00ffff | 0x70020000 ;
		//no order change in seqno and ackno
		this->tcpheader.seqno.raw_=this->tcpheaderorig.seqno.raw_;
		//this->tcpheader.seqno.raw_=11111111;
		this->tcpheader.ackno.raw_=this->tcpheaderorig.ackno.raw_;
		//printf("SYN_SEND case\n");
		break;

		case SYNACK_RCVD_0:
		//ack flag
		buff->b.pkt_[36]=buff->b.pkt_[36]&0x0f00ffff | 0x50100000 ;
		this->tcpheader.seqno.raw_=ackno.raw_;
		this->tcpheader.ackno.raw_=seqno.raw_+1;
		//this->tcpheader.ackno.raw_=seqno.raw_+((this->ipheader.vhtl.raw_&0x0000ffff)-0x00000028);//plus the length of the data received
		//printf("SYNACK_RCVD_0 case\n");
		break;
		

		case SYNACK_RCVD_1:
		//ack flag
		buff->b.pkt_[36]=buff->b.pkt_[36]&0x0f00ffff | 0x50180000 ;
		//this->tcpheader.seqno.raw_=ackno.raw_; //plus the datalength to be sent (url)
		//this->tcpheader.ackno.raw_=seqno.raw_+1;
		//this->tcpheader.ackno.raw_=seqno.raw_+((this->ipheaderorig.vhtl.raw_&0x0000ffff)-0x00000028);//plus the length of the data received
		//change data portion of the packet template with the original url 
		//this->tcpheader.ackno.raw_=seqno.raw_+((this->ipheader.vhtl.raw_&0x0000ffff)-0x00000028);//plus the length of the data received
		urlen=(this->ipheaderorig.vhtl.raw_&0x0000ffff) - 0x0028;
		buff->append(urlen);
		if((urlen%4)==0)
			urlen=urlen/4;
		else
			urlen=urlen/4+1;

		for(int i=38;i<38+urlen;i++)
			memcpy(&buff->b.pkt_[i],this->httpheader+(i-38),sizeof(uint32));
	
		//added by slima 02/08/01
		free(this->httpheader);
		//added by slima 02/09/01
		free(this->url);
		//for(int j=38;j<38+urlen;j++)
		//	//printf("buf[%d]=0x%x\n",j,buff->b.pkt_[j]);

		//printf("SYNACK_RCVD_1 case\n");
		//printf("STATUS>>URL sent to backend #%d\n",numbertcpsessions);
		break;

		case FIN_RCVD_1:  //ACK+PUSH flags on 0x18
buff->b.pkt_[36]=buff->b.pkt_[36]&0xff00ffff | 0x00100000 ;
		this->tcpheader.seqno.raw_=ackno.raw_;
		this->tcpheader.ackno.raw_=seqno.raw_+1;
		//printf("FIN_RCVD_1 case\n");
		break;

		case FIN_RCVD_2:  //ACK+PUSH flags on 0x18
		//ack flag
		buff->b.pkt_[36]=buff->b.pkt_[36]&0xff00ffff | 0x00110000 ;
		this->tcpheader.seqno.raw_=ackno.raw_;
		this->tcpheader.ackno.raw_=seqno.raw_;
		//printf("FIN_RCVD_2 case\n");
		break;
		
		default:
		break;
		}
		
		//TCP SEQNO ACK SWAPPING
		buff->b.pkt_[34]=this->tcpheader.seqno.raw_;
		buff->b.pkt_[35]=this->tcpheader.ackno.raw_; 

		newtcphdr.srcdstport = buff->b.pkt_[33];
		newtcphdr.seqno=buff->b.pkt_[34];
		newtcphdr.ackno=buff->b.pkt_[35];
		newtcphdr.hdrflgwindow=buff->b.pkt_[36];
		newtcphdr.pseudotcplen=buff->b.pkt_[28]&0x0000ffff;

		if(flag==SYN_SEND){
			newtcphdr.pseudosrcipaddr=buff->b.pkt_[31];
			newtcphdr.pseudodstipaddr=buff->b.pkt_[32];
		}

		if(flag==ACK_RCVD || flag==SYN_SEND || flag==SYNACK_RCVD_0 || flag==SYNACK_RCVD_1){
			
		//printf("I am HERE 3\n");
			if(flag==ACK_RCVD || flag==SYN_SEND || flag==SYNACK_RCVD_0){
				//printf("I am HERE 33\n");
			//newtcphdr.payload= (uint32*) malloc(2);
						//if((newtcphdr.payload= (uint32*) malloc(2))==NULL)
				//	//printf("ERROR>>Could not allocate memory for newtcphdr.payload\n");
				uint32 newtcphdrpayload[2];
				//printf("I am HERE 333\n");
				for(int j=0;j<2;j++)
					newtcphdrpayload[j]=0;

				newtcphdr.payload = newtcphdrpayload;
				//printf("I am HERE 3333\n");
			//changed by slima 02/08/01
		//	for(int i=38;i<(38+2);i++)
		//		memcpy(((uint32 *)newtcphdr.payload)+(i-38),&buff->b.pkt_[i],sizeof(uint32));

			*newtcphdr.payload=(uint32) buff->b.pkt_[38];
			*(newtcphdr.payload+1) = (uint32)buff->b.pkt_[39];
					//printf("I am HERE 33333\n");
			if(flag==SYN_SEND){
				//printf("I am HERE 4\n");
			unsigned int ck[8];
			ck[0]=(this->cksum(newtcphdr.payload,2*4)&0xffff);
			ck[1]=(this->cksum(&newtcphdr.srcdstport.raw_,4)&0xffff);
			ck[2]=(this->cksum(&newtcphdr.seqno.raw_,4)&0xffff);
			ck[3]=(this->cksum(&newtcphdr.ackno.raw_,4)&0xffff);
			ck[4]=(this->cksum(&newtcphdr.hdrflgwindow.raw_,4)&0xffff);
			ck[5]=(this->cksum(&newtcphdr.pseudotcplen.raw_,4)&0xffff);
			ck[6]=(this->cksum(&newtcphdr.pseudosrcipaddr.raw_,4)&0xffff);
			ck[7]=(this->cksum(&newtcphdr.pseudodstipaddr.raw_,4)&0xffff);
			newtcphdr_checksum =(nuint16) ~(this->cksum(ck,8*4)&0xffff);

			}else{
			unsigned int ck[6];
			ck[0]=(this->cksum(newtcphdr.payload,2*4)&0xffff);
			ck[1]=(this->cksum(&newtcphdr.srcdstport.raw_,4)&0xffff);
			ck[2]=(this->cksum(&newtcphdr.seqno.raw_,4)&0xffff);
			ck[3]=(this->cksum(&newtcphdr.ackno.raw_,4)&0xffff);
			ck[4]=(this->cksum(&newtcphdr.hdrflgwindow.raw_,4)&0xffff);
			ck[5]=(this->cksum(&newtcphdr.pseudotcplen.raw_,4)&0xffff);
			newtcphdr_checksum =(nuint16) ~(this->cksum(ck,6*4)&0xffff);
			}
			}
			else{
				//newtcphdr.payload= (uint32*) malloc(urlen);
			//if((newtcphdr.payload= (uint32*) malloc(urlen*sizeof(uint32)))==NULL)
				//changed by slima 2 lines 02/08/01
				//newtcphdr.payload[urlen];
				//changed by slima 02/08/01
				//if((newtcphdr.payload= (uint32*) malloc(urlen))==NULL)
				if((newtcphdr.payload= (uint32*) malloc(urlen*sizeof(uint32)))==NULL)
					printf("ERROR>>Could not allocate memory for newtcphdr.payload\n");
				//changed by slima 02/08/01
				for(int i=38;i<(38+urlen);i++)
					//memcpy((&newtcphdr.payload[i-38]),&buff->b.pkt_[i],sizeof(uint32));
				memcpy(((uint32 *)newtcphdr.payload)+(i-38),&buff->b.pkt_[i],sizeof(uint32));
			unsigned int ck[6];
			ck[0]=(this->cksum(newtcphdr.payload,urlen*4)&0xffff);
			ck[1]=(this->cksum(&newtcphdr.srcdstport.raw_,4)&0xffff);
			ck[2]=(this->cksum(&newtcphdr.seqno.raw_,4)&0xffff);
			ck[3]=(this->cksum(&newtcphdr.ackno.raw_,4)&0xffff);
			ck[4]=(this->cksum(&newtcphdr.hdrflgwindow.raw_,4)&0xffff);
			ck[5]=(this->cksum(&newtcphdr.pseudotcplen.raw_,4)&0xffff);
			newtcphdr_checksum =(nuint16) ~(this->cksum(ck,6*4)&0xffff);
			}

		//free memory
		//printf("STATUS>>freeing temporal memory\n");
		//changed by slima 02/08/01
		free(oldtcphdr.payload);
		free(newtcphdr.payload);


	}
		else{
			//printf("I am HERE 6\n");
		//NEW TCP CHECKSUM 
		//tcp
		newtcphdr_checksum = Internet::cksum((nuint16*)&newtcphdr,
			sizeof(newtcphdr)-16);  //-16 due to the payload  (4) and pseudotcplen are not used here
		}


		//tcp
		newchecksum = Internet::incrcksum(oldchecksum,
			oldtcphdr_checksum, newtcphdr_checksum);
		//printf("STATUS>>final checksum=0x%x\n",newchecksum.raw_);
		//tcp
		buff->b.pkt_[37]=ntohs(newchecksum)<<16 | 
			(buff->b.pkt_[37] &0x0000ffff); 

		if(flag==SYN_SEND || flag==SYNACK_RCVD_0 || flag==SYNACK_RCVD_1){
			//	//printf("STATUS>>Sending packet through port B\n");
					Ace->port_B->take(buff);
					 if(flag==SYN_SEND || flag==SYNACK_RCVD_0) buff->decref();

		}
			else
					Ace->pass(buff);


			//added by slima 02/09/01
			//if(flag==SYN_RCVD)
			//	new EventClass();

		
}


// ----------------------------------------------------------------------
//Insertion of key values ipsrc, ipdst, srcport, dstport in Set table
// ----------------------------------------------------------------------
/*
bool Ccbswitching::lookupsettable(Buffer *buf, int flag){
	Search tcpssearcher;

	tcpssearcher = tcpsset_list.locate((nuint32)buf->b.pkt_[31],
		(nuint32)buf->b.pkt_[32],
		(nuint32)(buf->b.pkt_[33]>>16 &0x0000ffff),
		(nuint32)(buf->b.pkt_[33]&0x0000ffff)); //Search the list
	
	if(tcpssearcher.hit()){
		//printf("STATUS>>TCP session already in TCPSession list\n");
		return true;
	}
	else{
	
		if(flag==SYN_RCVD){  //only insert if it is SYN_RCVD
			Elt_tcpsset * elt;
		if((elt = new Elt_tcpsset((nuint32)buf->b.pkt_[31],
		(nuint32)buf->b.pkt_[32],
		(nuint32)(buf->b.pkt_[33]>>16 &0x0000ffff),
		(nuint32)(buf->b.pkt_[33]&0x0000ffff)))!=NULL){
		tcpssearcher.insert(elt);
		//printf("STATUS>>TCP session INSERTED in TCPSession list\n");

		 return true;
		}
		else {
			//printf("ERROR>>Cannot allocate memory for Elements\n");
			return false;
		}
			
		}
		else 
			 return false;
	} //else
}
*/

// ----------------------------------------------------------------------
//where everything begins
// ----------------------------------------------------------------------
INITF init_actions(void* id, char* name, Image* obj)
{ 
	printf("init_actions received\n");
    return new Ccbswitching(id, name, obj);  
} 


// ----------------------------------------------------------------------
//action drop: in case packet is of type UNKNOWN
// ----------------------------------------------------------------------
ACTNF action_drop(Buffer* buf, Ccbswitching* ace){
	return ace->drop(buf);
}


// ----------------------------------------------------------------------
// B A C K E N D       A C T I O N S
// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
// Receives SYN+ACK packet from Backend (interface B) and respond with a ACK packet
// ----------------------------------------------------------------------

ACTNF action_exist_tcpsession_synack_backend(Buffer* buf, Ccbswitching* ace)
//, Search stream)
{
#ifdef DEBUG
	start= clockCycles();
#endif
	int tcpsk;
	//if(stream.hit()){
	//TCPSession exist,now determine if ACK belongs to a SYN+ACK or DATA_RCVD	
	//build the tcpsessionkey key
	tcpsk = buf->b.pkt_[33]&0x0000ffff;		
	//lookup the TCPSession object in hash table
	//if found, check if last tcpstate was SYN_SEND
	if((ace->tcpsht->itr = ace->tcpsht->tcpshtable.find(tcpsk))!=ace->tcpsht->tcpshtable.end()){
		if(((*ace->tcpsht->itr).second)->tcpstate ==SYN_SEND){
		//if SYN_SEND, change the state to ESTABLISHED_2 

		((*ace->tcpsht->itr).second)->ipheader.vhtl   = buf->b.pkt_[28];
		((*ace->tcpsht->itr).second)->tcpheader.srcdstport =buf->b.pkt_[33];
		((*ace->tcpsht->itr).second)->tcpheader.seqno = buf->b.pkt_[34];
		((*ace->tcpsht->itr).second)->tcpheader.ackno = buf->b.pkt_[35];
		((*ace->tcpsht->itr).second)->pktbase_tsh->Packet_initialize3();

		((*ace->tcpsht->itr).second)->pktbase_tsh->buf->b.pkt_[24]= ((*ace->tcpsht->itr).second)->bkendselected.ether1.raw_&0x0000ffff;//ether part 1
		((*ace->tcpsht->itr).second)->pktbase_tsh->buf->b.pkt_[25]=	((*ace->tcpsht->itr).second)->bkendselected.ether2.raw_;//ether part 2

		buf->b.pkt_[24] = ((*ace->tcpsht->itr).second)->bkendselected.ether1.raw_&0x0000ffff;//ether part 1
		buf->b.pkt_[25] = ((*ace->tcpsht->itr).second)->bkendselected.ether2.raw_;//ether part 2


		((*ace->tcpsht->itr).second)->pktbase_tsh->buf->b.pkt_[26] = ROUTER_ETHER1_SRC;
		((*ace->tcpsht->itr).second)->pktbase_tsh->buf->b.pkt_[27] = (ROUTER_ETHER2_SRC&0x0000ffff)<<16|ETHER_FLAG;
		buf->b.pkt_[26] = ROUTER_ETHER1_SRC;
		buf->b.pkt_[27] = (ROUTER_ETHER2_SRC&0x0000ffff)<<16|ETHER_FLAG;
		
		((*ace->tcpsht->itr).second)->replypkt2(ace,((*ace->tcpsht->itr).second)->pktbase_tsh->buf,SYNACK_RCVD_0);  //send a 0x10 tcp flag packet (ACK only)
		
		//printf("STATUS>>Before dropping template packet\n");
		ace->drop(((*ace->tcpsht->itr).second)->pktbase_tsh->buf);

		((*ace->tcpsht->itr).second)->tcpstate= ESTABLISHED_2;
		((*ace->tcpsht->itr).second)->replypkt2(ace,buf,SYNACK_RCVD_1);  //send a 0x10 tcp flag packet (ACK only)			
		
		

	}//if SYN_SEND
		//else
		//ace->drop(buf); //in port B

	}//if tcpsht->end()
		//else
		//ace->drop(buf);  //in port B
	//}//elt !=NULL
	//added slima 02/10/01
#ifdef DEBUG
	stop = clockCycles();
	printf("%d cycl after sending URL to be\n",(stop-start)>>3);
#endif
	return RULE_DONE;
}




// ----------------------------------------------------------------------
// F R O N T      E N D       A C T I O N S
// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
//Handler of the initial three way handshake sent by the client (SYN packet)
// ----------------------------------------------------------------------
ACTNF action_new_tcpsession_syn(Buffer* buf, Ccbswitching* ace)
//, Search stream)
{

#ifdef DEBUG
	start= clockCycles();
#endif
	//lookupsettable goes first because it reduces the chance of getting a duplicate
	//SYN_RCVD pkt not detected, then we send a reply
	//ace->lookupsettable(buf,SYN_RCVD);  //insert in stream table
	
	//response a SYN_RCVD pkt, creation of TCPSessionHandler 
	//and insertion in TCPSession HASH table
	//put tcpsessionstate in SYN_RCVD state	
	//creation of TCPSessionHandler object
	//fields in buf has already being modified, therefore switch them in parameters
	//timeout in linux is aprox 3 sec, so it is ok to create
	//first the tcpsession and then response. It takes only ms to do this.
		TCPSessionHandler *tsh;
			
		if((tsh= new TCPSessionHandler((int)buf->b.pkt_[32],
			(int)buf->b.pkt_[31],
			(int)buf->b.pkt_[33], ace))==NULL)
			printf("ERROR>>Can not allocate memory for TCPSessionHandler\n"); //create tcp session object
		
		tsh->tcpsessionid = ++numbertcpsessions;
		//commented by slima 02/25/01
		//if((numbertcpsessions%100)==0)
		//	printf("sess=%d\n",numbertcpsessions);
		//original ethernet header storage
		tsh->etherheaderorig.etherpart1_dst = buf->b.pkt_[24];
		tsh->etherheaderorig.etherpart2_dst = buf->b.pkt_[25];
		tsh->etherheaderorig.etherpart1_src = buf->b.pkt_[26];
		tsh->etherheaderorig.etherpart2_src = buf->b.pkt_[27];

		//original ip header storage
		tsh->ipheaderorig.srcipaddr = buf->b.pkt_[31];
		tsh->ipheaderorig.dstipaddr = buf->b.pkt_[32];
	
		//original tcpheader storage
		tsh->tcpheader.srcdstport =buf->b.pkt_[33];
		tsh->tcpheaderorig.srcdstport =tsh->tcpheader.srcdstport;
		tsh->tcpheader.seqno = buf->b.pkt_[34];
		tsh->tcpheaderorig.seqno = tsh->tcpheader.seqno;
		tsh->tcpheader.ackno = buf->b.pkt_[35];
		tsh->tcpheaderorig.ackno = tsh->tcpheader.ackno;
				
		tsh->replypkt2(ace,buf,SYN_RCVD);  //a response is sent back to the client inmediately
		tsh->tcpstate = SYN_RCVD;
	
		//INSERTION FOR THE FIRST TIME IN TCP SESSION HASH  TABLE
		ace->tcpsht->tcpshtable[tsh->tcpsessionkey]=tsh->TCPSpointer();
#ifdef DEBUG
	stop = clockCycles();
	printf("%d cycl after SYNACK sent\n",(stop-start)>>3);
#endif

	return RULE_DONE;
} 


// ----------------------------------------------------------------------
//receive ACK packets (with 0x08 flag only) sent by the client and forwards them   (ACK packet)
//if previous state was SYN_RCVD , create search for http://*\n\n string traversing
//several packets
// ----------------------------------------------------------------------
ACTNF action_exist_tcpsession_ack(Buffer* buf, Ccbswitching* ace)
//, Search stream)
{

	int tcpsk;
	/*
#ifdef DEBUG
	start= clockCycles();	
#endif
	*/
	//if(stream.hit()){
	//TCPSession exist,now determine if ACK belongs to a SYN+ACK or DATA_RCVD	
	//build the tcpsessionkey key
	tcpsk = (buf->b.pkt_[33]&0xffff0000)>>16;		
	//lookup the TCPSession object in hash table
	//if found, check if last tcpstate was SYN_RCVD
	if((ace->tcpsht->itr = ace->tcpsht->tcpshtable.find(tcpsk))!=ace->tcpsht->tcpshtable.end()){
		if(((*ace->tcpsht->itr).second)->tcpstate ==SYN_RCVD){
		//if SYN_RCVD, change the state to ESTABLISHED and create a new NBStringSearch object associated
		//with this TCPSession. If possible, create a new hashtable for storing :
		//key, NBStringSearch object and another hash table for key, NBSearchReport object
		((*ace->tcpsht->itr).second)->tcpstate= ESTABLISHED;
	
		((*ace->tcpsht->itr).second)->ipheaderorig.vhtl   = buf->b.pkt_[28];
		((*ace->tcpsht->itr).second)->ipheader.vhtl   = buf->b.pkt_[28];
		((*ace->tcpsht->itr).second)->tcpheader.srcdstport =buf->b.pkt_[33];
		((*ace->tcpsht->itr).second)->tcpheader.seqno = buf->b.pkt_[34];
		((*ace->tcpsht->itr).second)->tcpheader.ackno = buf->b.pkt_[35];
		uint32 urlbeginning =ntohl(buf->b.pkt_[38]);
		//changed by slima 02/15/01
#ifdef DEBUG
		start = clockCycles();
#endif
		((*ace->tcpsht->itr).second)->replypkt2(ace,buf,ACK_RCVD);  //send a 0x10 tcp flag packet (ACK only)	

		#ifdef DEBUG
	stop = clockCycles();
	printf("%d cycl after sending ack to url from client\n",(stop-start)>>3);
#endif

		//added by slima 02/18/01
			if(((*ace->tcpsht->itr).second)->urlfound==true)
					((*ace->tcpsht->itr).second)->FoundString(ace);
				

		/*if (ace->search_is_set_up) {
	
	//changed by slima 02/16/01
			
			int val=NB_SUCCESS;
			#ifdef DEBUG
			start2 = clockCycles();
			#endif
if((val =ace->urlsearchengine.SearchBuffer(ace, buf, ((char*) buf), 1024,
			&(((*ace->tcpsht->itr).second)->urlsearchcontext), &(((*ace->tcpsht->itr).second)->rep)))!=NB_SUCCESS)
				printf("ERROR>>Search engine cannot accept the request: (NB_FAILURE /NB_BUSY) %d\n",val);
	

	} else {
		printf("ERROR>> Search engine is still not ready to search.\n");
	}*/
	//printf("STATUS>>after urlsearchengine invocation\n");

	}//if SYN_RCVD
	//else
	//	ace->drop(buf);

	}//if tcpsht->end()
	//else
	//ace->drop(buf);


	//}//elt !=NULL
	//added slima 02/10/01

	return RULE_DONE;
}





ACTNF action_exist_tcpsession_ack10(Buffer* buf, Ccbswitching* ace)
//, Search stream)
{
//just forward ack packets that belong to pre existent TCP sessions
#ifdef DEBUG
	start = clockCycles();
#endif
	int tcpsk;
	//if(stream.hit()){
			//printf("FORWARDING ACK FORM CLIENT TO BACKEND\n");
	//TCPSession exist,now determine if ACK belongs to a SYN+ACK or DATA_RCVD	
	//build the tcpsessionkey key
	tcpsk = (buf->b.pkt_[33]&0xffff0000)>>16;		
		if((ace->tcpsht->itr = ace->tcpsht->tcpshtable.find(tcpsk))!=ace->tcpsht->tcpshtable.end()){
			if(((*ace->tcpsht->itr).second)->tcpstate ==ESTABLISHED_2){
				//decrease load value in lard when FIN packet is seen
				if(((buf->b.pkt_[36]>>16)&FIN_FLAG)==FIN_FLAG && (((*ace->tcpsht->itr).second)->flagfin==false)){
					((*ace->tcpsht->itr).second)->flagfin=true;
					((*ace->tcpsht->itr).second)->mybeserver->load--;

					//added by slima 02/08/01

					//if(((*ace->tcpsht->itr).second)!=NULL)

					//delete NBSearch entry in CE ENGINE
				//	printf("Before Deleting tcpsessionkey-> %d\n",tcpsk);
					//commented by slima 02/19/01
				/*	for (Elt_tcpsset* p = (Elt_tcpsset*) ace->tcpsset_list.first();
						p != NULL;
						p = (Elt_tcpsset*) ace->tcpsset_list.next(p))
					{
							if(ntohl(p->key_[2]) == tcpsk){
							delete p;
							//printf("STATUS>>deleted entry in Elt_tcpsset\n");
							break;
							}
															
					}
					*/
					//commented by slima 02/20/01
					
					ace->tcpsht->tcpshtable.erase(ace->tcpsht->itr);   //erase TCPHashTable entry
					delete ((*ace->tcpsht->itr).second);			//erase TCPSessionHandler obj
					
									
				}
								
				buf->b.pkt_[24] = ((*ace->tcpsht->itr).second)->bkendselected.ether1.raw_&0x0000ffff;//ether part 1
				buf->b.pkt_[25] = ((*ace->tcpsht->itr).second)->bkendselected.ether2.raw_;//ether part 2
				buf->b.pkt_[26] = ROUTER_ETHER1_SRC;
				buf->b.pkt_[27] = (ROUTER_ETHER2_SRC&0x0000ffff)<<16|ETHER_FLAG;

				//ace->pass(buf);
				ace->port_B->take(buf);
#ifdef DEBUG
				stop = clockCycles();
				printf("%d cycl after forwarding ACK packet from client\n",(stop-start)>>3);
#endif
				//printf("STATUS>>After forwarding ACK packet from client\n");
				return RULE_DONE;
			}
			else {
				//added slima 02/08/01
				//at least four pkts has been seen from this session
				//means session is in FIN_WAIT1 state in client
				//	if((++((*ace->tcpsht->itr).second)->end_pktcounter)>=4)
				//		delete ((*ace->tcpsht->itr).second);
		
				ace->drop(buf);
			}
		}
	//}

}

//commented by slima 02/17/01
/*
//-----------------------------------------------------------------------
// CallbackSearchengine(): called when Ccbswitching destructor is invoked
//							frees memory at the end
//-----------------------------------------------------------------------
void CallbackSearchengine(int returnvalue, void* context){

	printf("STATUS>>NBStringSearchEngine : attempt to delete searchengine is %d\n",returnvalue);
	
}

*/

//search URL functions

//commented by slima 02/19/01
/*
//-----------------------------------------------------------------------
// AfterBuffer(): per-buffer callback function called when the search
//				  reaches the end of the packet (regardless of matches found)
//-----------------------------------------------------------------------
void AfterBuffer(void* context1, void* context2, Buffer* buf,
				 NBStringMatchReport* rep)
{
	static int x = 0;
	x++;
}

*/

/*
//-----------------------------------------------------------------------
// GotString(): per-string callback function called when a string 
//				in the packet matches the search string
//-----------------------------------------------------------------------
int GotString(void* context1, void* context2, Buffer* buf,
			  NBStringID sid, void* stringtag, int endoffset,
			  int matchlen, char* data)
{
	int urlen=0;
	//printf("STATUS>>before execution of gotstring\n");
#ifdef DEBUG
	stop = clockCycles();
	printf("%d cycl after url searching\n",(stop-start2)>>3);
	start = clockCycles();
#endif
	TCPSessionHandler* currtcpsh= (TCPSessionHandler*) context1;
	Ccbswitching* ace= (Ccbswitching*)context2;
		
	if((urlen= strcspn((char *)currtcpsh->httpheader,"\n"))!=0){
		if((urlen%sizeof(uint32))==0){
					urlen = urlen/sizeof(uint32);
				if((currtcpsh->url= (uint32*) malloc(urlen*sizeof(uint32)))==NULL)
					printf("ERROR>>Not enough memory for MALLOC\n");
		}
			else{
					urlen = urlen/sizeof(uint32)+1;
					if((currtcpsh->url= (uint32*) malloc(urlen*sizeof(uint32)))==NULL)
					printf("ERROR>>Not enough memory for MALLOC\n");

				}

			memcpy(currtcpsh->url,currtcpsh->httpheader,urlen*sizeof(uint32));
		//	printf("STATUS>>1a...\n");			
			if(currtcpsh->apply_lard(ace))			
				currtcpsh->backend_tcpsession(ace);
			else
				printf("STATUS>>TCP session could not be handled due to excceded S (top) value in LARD\n");
		//	printf("STATUS>>2a...\n");

			//printf("STATUS>>after execution of gotstring,lard, send SYN\n");

			//added by slima 02/15/01
			return NBS_TERM;
	}
	else
		return NBS_TERM;
}
*/

//-----------------------------------------------------------------------
// FoundString(): per-string callback function called when a string 
//				in the packet matches the search string
//-----------------------------------------------------------------------
void TCPSessionHandler::FoundString(Ccbswitching* ace)
{
	int urlen=0;
	//printf("STATUS>>before execution of gotstring\n");
		
	if((urlen= strcspn((char *)this->httpheader,"\n"))!=0){
		if((urlen%sizeof(uint32))==0){
					urlen = urlen/sizeof(uint32);
				if((this->url= (uint32*) malloc(urlen*sizeof(uint32)))==NULL)
					printf("ERROR>>Not enough memory for MALLOC\n");
		}
			else{
					urlen = urlen/sizeof(uint32)+1;
					if((this->url= (uint32*) malloc(urlen*sizeof(uint32)))==NULL)
					printf("ERROR>>Not enough memory for MALLOC\n");

				}

			memcpy(this->url,this->httpheader,urlen*sizeof(uint32));
		//	printf("STATUS>>1a...\n");			
			if(this->apply_lard(ace))			
				this->backend_tcpsession(ace);
			else
				printf("STATUS>>TCP session could not be handled due to excceded S (top) value in LARD\n");
		//	printf("STATUS>>2a...\n");

			//printf("STATUS>>after execution of gotstring,lard, send SYN\n");

			//added by slima 02/15/01
			//return NBS_TERM;
	}
	//else
	//	return NBS_TERM;
}





/*
void Ccbswitching::SetupSearch(char* str)
{
	//static 	NBStringID strid=tcpsessionkey;
	static 	NBStringID strid;
	int returnvalue;
	int status=0;

	//printf("STATUS>> Setting up search for \"%s\"\n", str);

	if (this->search_is_set_up) {
		// delete old string
		if((status=this->urlsearchengine.ChangeOpMode(NBS_MODE_MAINT, NULL, NULL))==NB_SUCCESS)
			printf("STATUS>>NB_SUCCESS of ChangeOpMode MODE_MAINT\n");
		else
			printf("STATUS>>%d of ChangeOpMode MODE_MAINT\n",status);

		if((status=this->urlsearchengine.RemoveString(strid, NULL, NULL))==NB_SUCCESS)
			printf("STATUS>>NB_SUCCESS of RemoveString MODE_MAINT\n");
		else
			printf("STATUS>>%d of RemoveString MODE_MAINT\n",status);
	}
	
	// add new search string
	//	//printf("FAILURE HERE\n");
	if((status=this->urlsearchengine.AddString(str, NULL, &strid, NULL, NULL))==NB_SUCCESS)
		printf("STATUS>>NB_SUCCESS of AddString MODE_SEARCH\n");	
	else
		printf("STATUS>>%d of AddString MODE_SEARCH\n",status);	
	//	//printf("FAILURE HERE 2\n");
	if((status=this->urlsearchengine.ChangeOpMode(NBS_MODE_SEARCH, NULL, NULL))==NB_SUCCESS)
		printf("STATUS>>NB_SUCCESS of ChangeOpMode MODE_SEARCH\n");
	else
		printf("STATUS>>%d of ChangeOpMode MODE_SEARCH\n",status);

	//	//printf("FAILURE HERE 3\n");
	// set up callbacks
	this->search_is_set_up = 1;
	
}
*/

// ----------------------------------------------------------------------
//LARD algorithm implementation
//The goal of LARD is to combine good load balancing and high locality
//This strategy always assigns a single back end node to serve a given target
//thus making the idealized assumption that a single target cannot by itself
//exceed the capacity of one node.
//The front end maintains a one to one mapping of targets to backends nodes in the
//server array. When the first request arrives for a given target, it is assigned a 
//back end node by choosing a lightly loaded backend node. Subsequent requests are
//directed to a target's assigned backend node, unless that node is overloaded.
//In the latter case, the target is assigned a new backend node from the current set
//of lightly loaded nodes.
//while (true) 
//fetch next request r; 
//if server[r.target] = null then 
//n, server[r.target] / fleast loaded nodeg; 
//else 
//n / server[r.target]; 
//if (n.load ? Thigh && 9 node with load ! Tlow ) jj 
//n.load  2 \Lambda Thigh then 
//n, server[r.target] / fleast loaded nodeg; 
//send r to n; 
//The Basic LARD Strategy 
// ----------------------------------------------------------------------
bool TCPSessionHandler::apply_lard(Ccbswitching *ace){

#ifdef DEBUG
	start=clockCycles();
#endif
	/*
static int backend_turn=0;
backend_turn = (++backend_turn)%NUMBER_BACKENDS;
this->mybeserver=ace->beserver[backend_turn];
this->bkendselected.ipaddr=this->mybeserver->bkend.ipaddr.raw_;
this->bkendselected.ether1=this->mybeserver->bkend.ether1.raw_;
this->bkendselected.ether2=this->mybeserver->bkend.ether2.raw_;
this->mybeserver->load++;
return true;
*/

/*
if((ace->lardht->itr = ace->lardht->lardhtable.find(*this->url))!=ace->lardht->lardhtable.end())
		this->mybeserver=(*ace->lardht->itr).second;
else {
		ace->lardht->lardhtable[*this->url]=ace->lardht->leastloadednode(ace);
		this->mybeserver=ace->lardht->lardhtable[*this->url];
}

this->bkendselected.ipaddr=this->mybeserver->bkend.ipaddr.raw_;
this->bkendselected.ether1=this->mybeserver->bkend.ether1.raw_;
this->bkendselected.ether2=this->mybeserver->bkend.ether2.raw_;
this->mybeserver->load++;
return true;
*/

//check if sum of all loads S = (n-1)THIGH +TLOW -1 for avoiding WRR behaviour
	if(ace->lardht->LARD_checksumallloads(ace)){  //if all load is <  S
		if((ace->lardht->itr = ace->lardht->lardhtable.find(*this->url))!=ace->lardht->lardhtable.end()){
			if((((*ace->lardht->itr).second)->load >THIGH && ace->lardht->existlessTLOW) 
					|| (((*ace->lardht->itr).second)->load>=2*THIGH)){
				//USE LEAST LOADED NODE
			//	printf("STATUS>> gt THIGH\n");
				this->mybeserver = ace->lardht->leastloadednode(ace);
			}
			else{ //USE CURRENT NODE
			//	printf("STATUS>> lt THIGH\n");
				this->mybeserver=(*ace->lardht->itr).second;

			}
	
		}
		else { //if url not found?
			//INSERTION IN LARD  HASH  TABLE
			//USE LEAST LOADED NODE
		//	printf("STATUS>> nfound\n");
			ace->lardht->lardhtable[*this->url]=ace->lardht->leastloadednode(ace);
			this->mybeserver=ace->lardht->lardhtable[*this->url];
		}
		this->bkendselected.ipaddr=this->mybeserver->bkend.ipaddr.raw_;
		this->bkendselected.ether1=this->mybeserver->bkend.ether1.raw_;
		this->bkendselected.ether2=this->mybeserver->bkend.ether2.raw_;
		this->mybeserver->load++;
	}
	else 
		return false;

#ifdef DEBUG
	stop = clockCycles();
	printf("%d cycl after LARD & url storage in mem.\n",(stop-start)>>3);
#endif
	return true;


}
		

//TCPSession handler for forwarding TCP state information (client-front end) to the backends
//Send a TCP SYN packet to the backend (initiate a replayed TCP session)

void TCPSessionHandler::backend_tcpsession(Ccbswitching* ace){
//function should know: client seqno, client port, front end seqno (front end port =80)
//start = clockCycles();
//replay packets to backend. Store backend_seqno
//send a TCP SYN packet
#ifdef DEBUG
	start = clockCycles();
#endif
	
	//printf("STATUS>>1...\n");
	if((this->pktbase_tsh= new Packet_template())==NULL)
		printf("ERROR>>Can not allocate memory for Packet_template\n");;
	//printf("STATUS>>2...\n");
	this->pktbase_tsh->Packet_initialize3();

	this->tcpstate= SYN_SEND;
	//printf("STATUS>>3...\n");	
	//orig SYN packet rcvd
		this->pktbase_tsh->buf->b.pkt_[24]= this->bkendselected.ether1.raw_&0x0000ffff;//ether part 1
		this->pktbase_tsh->buf->b.pkt_[25]=	this->bkendselected.ether2.raw_;//ether part 2
	//	this->pktbase_tsh->buf->b.pkt_[26]=	FRONTEND_ETHER1;
	//	this->pktbase_tsh->buf->b.pkt_[27]=	(FRONTEND_ETHER2&0x0000ffff)<<16|ETHER_FLAG;
		this->pktbase_tsh->buf->b.pkt_[26]=	ROUTER_ETHER1_SRC;
		this->pktbase_tsh->buf->b.pkt_[27]=	(ROUTER_ETHER2_SRC&0x0000ffff)<<16|ETHER_FLAG;
	//printf("STATUS>>4...\n");
	//switch some values and send SYN packet
	this->replypkt2(ace,this->pktbase_tsh->buf,SYN_SEND);  //send a 0x10 tcp flag packet (RST only)
	//printf("STATUS>>5...\n");
	ace->drop(this->pktbase_tsh->buf);
	//printf("STATUS>>6...\n");
	//added slima 02/08/01
	delete this->pktbase_tsh;
#ifdef DEBUG
	stop = clockCycles();
	printf("%d cycl after sending SYN to be\n",(stop-start)>>3);
#endif

}


Backend_server* LARD_table::leastloadednode(Ccbswitching *ace){
/*#ifdef DEBUG
start=clockCycles();
#endif
*/
int lessload_index=0;
int lessload = ace->beserver[0]->load;
	for(int i=1; i<NUMBER_BACKENDS; i++){
		if(lessload > ace->beserver[i]->load){
			lessload = ace->beserver[i]->load;
			lessload_index =i;
		}
	}
//if last is less than tlow
if(ace->beserver[lessload_index]->load<TLOW)
	this->existlessTLOW=true;
else
	this->existlessTLOW=false;

//less loaded backend server
/*
#ifdef DEBUG
	stop = clockCycles();
	printf("%d cycl in leastloadednode\n",(stop-start)>>3);
#endif
*/
return ace->beserver[lessload_index];
}



bool LARD_table::LARD_checksumallloads(Ccbswitching *ace){
/*#ifdef DEBUG
	start=clockCycles();
#endif
*/
int acum=0;
ace->lardht->itr = ace->lardht->lardhtable.begin();

	while(ace->lardht->itr!=ace->lardht->lardhtable.end()){	
		acum=acum+((*ace->lardht->itr).second)->load;
		ace->lardht->itr++;
	}

#ifdef DEBUG_2
	if(acum%50==0)
		printf("acum=%d\n",acum);
#endif

	if(acum<= LARD_CAP)   {
	//even if acum =0 (meaning no elements in LARD table, still return true
	//assuming that acum<((NUMBER_BACKENDS-1)*THIGH+TLOW-1 in this case because there is no element or summation is < 
/*#ifdef DEBUG
	stop = clockCycles();
	printf("%d cycl in checksumallloads < S\n",(stop-start)>>3);
#endif*/
	return true;
	}
	else{
#ifdef DEBUG
	stop = clockCycles();
	printf("%d cycl in checksumallloads > S\n",(stop-start)>>3);
#endif
	//	printf("acummulator value=%d\n",acum);
		return false;
	}
}



//adapted checksum function for receiving 32 bit words.
unsigned long TCPSessionHandler::cksum(uint32 *addr, int count)
{
      unsigned long sum = 0;

	
      while( count > 3 )  {
		  sum += (unsigned short)((*addr)>>16);
		  sum += (unsigned short)((*addr)&0x0000ffff);
		  addr++;
          count -= 4;
	  }
 
 
	  if( count > 1 ){
          sum += (unsigned short)((*addr)>>16);
          count -= 2;
		   }
 
 
	  if(count >0)
		  sum += (unsigned char)((*addr)&0x0000ffff);

       while (sum>>16)
           sum = (sum & 0xffff) + (sum >> 16);
 
       return ~sum;
  
}



// Event action method
//  resets the timer, calls retransmit method
void 
//EventClass::eventAction(Ccbswitching *ace,TCPSessionHandler *tcpsh, Buffer *buff)
EventClass::eventAction(void)
{
#ifdef DEBUG
	start=clockCycles();
#endif
	//changed by slima 02/08/01
    //schedule(Time::msec(TCPSESSION_TIMEOUT)); //schedule Action function to be called after TCPSESSION_TIMEOUT msec.
	//delete TCP session 
	//delete tcpsh;	
	//printf("A TCP Session should be deleted here\n");
//	if(this->tcpsh!=NULL)
//		printf("STATUS>>object still has not being deleted\n");
	//	delete this->tcpsh;
#ifdef DEBUG
	stop = clockCycles();
	printf("%d cycl in Event\n",(stop-start)>>3);
#endif
	
   
/*	
	for (Elt_tcpsset* p = (Elt_tcpsset*) this->ace->tcpsset_list.first();
						p != NULL;
						p = (Elt_tcpsset*) this->ace->tcpsset_list.next(p))
					{
						//	if(ntohl(p->key_[2]) == tcpsk){
							delete p;
							printf("STATUS>>deleted entry in Elt_tcpsset\n");
						//	break;
						//	}
															
					}
				//	this->ace->tcpsht->tcpshtable.erase(this->ace->tcpsht->tcpshtable.begin(),this->ace->tcpsht->tcpshtable.end());   //erase TCPHashTable entry
					delete this->tcpsh;
					printf("STATUS>>after deleting\n");
					//delete ((*(this->ace)->tcpsht->itr).second);			//erase TCPSessionHandler obj
*/

}


//IMPLEMENT TIMEOUT AT THE HASH TABLE ELEMENT LEVEL (URL expiration)  TO BE DONE
//AND AT THE TCP HASH TABLE LEVEL


