#include <NBaction/NBset.h>
#include <NBaction/NBelement.h>

/*
** This file was automatically generated by nbsetcode.
** If you edit it, your changes will probably be lost
** the next time someone regenerates this file.
*/
/*
** Elt_ethernetset and Set_ethernetset classes used by NCL set 'ethernetset'
** with 1 key(s) size hint= 900
** hash table size= 1024, with 10 bit wide hash output
*/

class Elt_ethernetset
    : public Element
{
public:
    static int      users_;
    static size_t   esize_;
    static Pool   * epool_;

    void *operator new(size_t esize)
        {
            if (esize_ != esize) {
                /* fails if wrong size for our pool */
                if (epool_ != NULL) {
                    return NULL;
                }
                epool_ = new Pool(esize, Element::align_mod, Element::align_off);
                /* fails if unable to allocate pool */
                if (epool_ == NULL) {
                    return NULL;
                }
                esize_ = esize;
            }
            /* fails if out of memory */
            return epool_->take();
        }

    static void operator delete(void *eptr, size_t esize)
        {
            /* fails if we have no pool */
            if (epool_ == NULL)
                return;
            /* fails if wrong size for pool */
            if (esize_ != esize)
                return;
            epool_->free(eptr);
        }

    inline Elt_ethernetset(nuint32 nk1) {
	key_[0] = nk1;
    }

    nuint32 key_[1];
};

class Set_ethernetset
    : public Set
{
public:

    Set_ethernetset(Ace *iace, char *iname)
        : Set(iace, iname, 10, 1)
        {
            Elt_ethernetset::users_ ++;
        }

    Set_ethernetset(ModuleId id, Ace *iace, char *iname)
        : Set(id, iace, iname, 10, 1)
        {
            Elt_ethernetset::users_ ++;
        }

    ~Set_ethernetset()
        {
            Elt_ethernetset::users_ --;
            if (Elt_ethernetset::users_ < 1) {
                if (Elt_ethernetset::epool_)
                    delete Elt_ethernetset::epool_;
                Elt_ethernetset::epool_ = NULL;
                Elt_ethernetset::esize_ = 0;
                Elt_ethernetset::users_ = 0;
            }
        }

    inline Search locate(nuint32 nk1)
        {
            int                p = table_;
            int                h = 0;

            /*
            ** NOTE: this search code must precisely match the search
            ** algorithm implemented in the Classification Engine.
            */
	    h += (nk1.raw_ & 0xFFFF) + (nk1.raw_ >> 16);
            h ^= h >> 10;
            h &= 0x3ff;
            p += (h<<3) + 4;
            while (true) {
                p = *(int *)p;
                if ((p <= 0) ||
                    (	(nk1.raw_ == ((unsigned *)p)[1])))
                    return Search(p);
            }
        }
};

// Static members for Elt_ethernetset
int                 Elt_ethernetset::users_;
size_t              Elt_ethernetset::esize_;
Pool              * Elt_ethernetset::epool_;

