//
//
//	cbswitching Application
//	Host application file C++ source file
//

#ifdef WIN32
   #include <windows.h>
   #include "nbapi\nbappl.h"
   #define	 IXFUNCPTR(x)	(x)			
#else
   #include "nbapi/nbappl.h"
   #define	 IXFUNCPTR(x)	(&x)
#endif

#include "nbswap.h"
#include "CcbswitchingApp.h"


// /////////////////////////////////////////////////////////////
//  CcbswitchingTargetMgr  ACE Target mgr constructor
//		- creates referenced objects
// /////////////////////////////////////////////////////////////
CcbswitchingTargetMgr::CcbswitchingTargetMgr(NBAppl* appl,
											 AceGroup* acegroup,
											 AceManager* acemgr,
											 char *name):
TargetManager(appl,acegroup,acemgr,name){
;

}

CcbswitchingTargetMgr::~CcbswitchingTargetMgr(){

}

// /////////////////////////////////////////////////////////////
//  CcbswitchingMgr  ACE mgr constructor
//		- creates referenced objects
// /////////////////////////////////////////////////////////////
CcbswitchingMgr::CcbswitchingMgr(
	NBAppl   *appl, 
   AceGroup	*acegroup, 
   char		*name):
	AceManager(
      appl, acegroup, name
      ,ACE_STRINGSEARCH | ACE_PLMODE_MANDATORY | ACE_WRITER
   )
{

	try{
	port_B_manager= new CcbswitchingTargetMgr(appl,acegroup,this,"port_B");
   }
   catch (NBError E) {
      throw NBError(NB_ERROR(3));
   }
  


   // Load NCL and action files into Policy Accelerator
   if (load("Ccbswitchingncl", "CcbswitchingAct") != NB_SUCCESS){
      throw NBError(NB_ERROR(7));
   }
}

//
// CcbswitchingMgr destructor
//
CcbswitchingMgr::~CcbswitchingMgr()
{	
	   delete 	port_B_manager;
}



// /////////////////////////////////////////////////////////////
//  CcbswitchingAceGroup constructor - creates ACE mgr
// /////////////////////////////////////////////////////////////
CcbswitchingAceGroup::CcbswitchingAceGroup(
   NBAppl     *appl, 
   NBFactory  *aceFactory, 
   char       *name):
   AceGroup(appl, aceFactory, name)
{
   // Create cbswitchingMgr
   try{
      pcbswitchingMgr = new CcbswitchingMgr( 
         appl, this, "Ccbswitching");
   }
   catch (NBError E) {
      throw NBError(NB_ERROR(2));
   }

printf("ACE's TAG-->%d\n",pcbswitchingMgr->getTag());
   

}

// /////////////////////////////////////////////////////////////
// CcbswitchingAceGroup destructor 
//    - deletes all ACE manager objects
// /////////////////////////////////////////////////////////////
CcbswitchingAceGroup::~CcbswitchingAceGroup()
{
   delete pcbswitchingMgr;
}


// /////////////////////////////////////////////////////////////
// CcbswitchingAppl constructor - creates ACE group
// /////////////////////////////////////////////////////////////
CcbswitchingAppl::CcbswitchingAppl(void):
#ifdef WIN32
   NBAppl("CcbswitchingAppl", "CcbswitchingApp.exe")
#else
   NBAppl("CcbswitchingAppl", "CcbswitchingApp")
#endif

{
   nRunAppl=1;

	pcbswitchingAceGrp = new CcbswitchingAceGroup(
      this, NULL, "CcbswitchingAceGroup");

    
    DWORD rval;
	
    rval=bind( FROMPASS_Nic1, TO_cbswitching );
    if (rval != NB_SUCCESS) {
    	NB_ABORT(rval);
    }
	   rval=bind( FROMPASS_cbswitching, TO_Nic1 );
    if (rval != NB_SUCCESS) {
    	NB_ABORT(rval);
    }


    rval=bind(FROMPASS_Nic2, TO_cbswitching);
    if (rval != NB_SUCCESS) {
    	NB_ABORT(rval);
    }

//binding target b to nic 2 
   /* rval=bind(FROMPASS_cbswitching ,TO_Nic2  );
    if (rval != NB_SUCCESS) {
    	NB_ABORT(rval);
    }*/

	//binding target b to nic 2 
    rval=bind(TARGETB_cbswitching ,TO_Nic2  );
    if (rval != NB_SUCCESS) {
    	NB_ABORT(rval);
    }
	

		
    /***********************************************************/
}

//
// CcbswitchingAppl destructor - deletes ACE group object
//
CcbswitchingAppl::~CcbswitchingAppl()
{
   delete pcbswitchingAceGrp;
}


// /////////////////////////////////////////////////////////////
//	main() function for application
// /////////////////////////////////////////////////////////////
void main(int argc, char *argv[])
{
   //
   // Construct the cbswitching Application object
   //
   CcbswitchingAppl*	appl;

	   nb_trace_verbose(1);

   try {
      appl = new CcbswitchingAppl();
   }
   catch (NBError E) {
      NB_ABORT(1);
   }

   printf("cbswitching application is running.\r\n");
   // You can set appl->nRunAppl to 0 from within the appl
   // to exit the application.  You must at least sleep 
   // within the while loop, as appl is run in a different
   // thread
    while( appl->nRunAppl ){
#ifdef WIN32
		Sleep( 1000 );
#else
		sched_yield();
#endif
	}

   // Delete the application object when you exit or abort
   // to allow the code on the PA to be unloaded.
   delete appl;
    
}

