//   Copyright (c) 1999 NetBoost Corporation.  All Rights Reserved.  
//   Except as expressly authorized by NetBoost Corporation in writing,
//   reproduction of any portion or element of this computer program, 
//   including without limitation, any portion of any text, sound, image, 
//   data or screen, is strictly prohibited and is a violation of Federal law.
//


#include "NBaction/NBaction.h"


//#define DEBUG
	
//CLOCKING DEFINITIONS for PROFILING
#ifdef DEBUG
#define PA100_TIMESTAMP		0x0c000d00
volatile unsigned *timer = (volatile unsigned*)PA100_TIMESTAMP;
unsigned start,stop;


unsigned clockCycles(void);

unsigned clockCycles(void) {
	return *timer;
}
#endif


class StatsAce : public Ace {
public:
    StatsAce(ModuleId id, char* name, Image* obj);  
	void printinfo(Buffer *buf);
};


StatsAce::StatsAce(ModuleId id, char* name, Image* obj):
    Ace(id, name, obj)
{
  
}


void StatsAce::printinfo(Buffer *buf){
#ifdef DEBUG
	start = clockCycles();
#endif
	int i=0;
	int j=0;
	uint32  val;
	//number of accesses to memory
	for(i=0; i<1;i++)
	//printf("FLAG-->0x%x\n",ntohl(buf->b.pkt_[36]));
		for(j=0; j<1000;j++)
		val = buf->b.pkt_[j];
	
	   
#ifdef DEBUG
	stop = clockCycles();
	printf("%d cycl after %d memory reading\n",(stop-start)>>3,i*j);
#endif

}

//======================================================================		

INITF init_actions(void* id, char* name, Image* obj)
{ 
    return new StatsAce(id, name, obj);  
}

ACTNF action_base(Buffer* buf, StatsAce* ace)
{
//printf("STATUS>>pkt rcvd...0x%x\n",ntohl(buf->b.pkt_[36]));
 //	ace->printinfo(buf);

#ifdef DEBUG
	start = clockCycles();
#endif

    ace->pass(buf);

	
#ifdef DEBUG
	stop = clockCycles();
	printf("%d cycl just forwarding pkts\n",(stop-start)>>3);
#endif

}

