//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  2000 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
// ixplib.uc
//	include ixp common macros files
//
// system: IXP1200
// subsystem: utility microcode
// usage: library macros
// author: dfh	May 1, 2000
//
// revisions:

// standard xfer order
.xfer_order $xfer0 $xfer1 $xfer2 $xfer3 $xfer4 $xfer5 $xfer6 $xfer7
.xfer_order $$xfer0 $$xfer1 $$xfer2 $$xfer3 $$xfer4 $$xfer5 $$xfer6 $$xfer7

// xfer reg shorthand
#define X0 $xfer0
#define X1 $xfer1
#define X2 $xfer2
#define X3 $xfer3
#define X4 $xfer4
#define X5 $xfer5
#define X6 $xfer6
#define X7 $xfer7
#define DX0 $$xfer0
#define DX1 $$xfer1
#define DX2 $$xfer2
#define DX3 $$xfer3
#define DX4 $$xfer4
#define DX5 $$xfer5
#define DX6 $$xfer6
#define DX7 $$xfer7


// macros that access sram, sdram or fbi can specify whether the operation should be
// previously, constants have been used
// 1) SYNC (synchronous). context swap until signal
// 2) ASYNC (asynchronous). request a signal upon completion, not context swap
// 3) NOSYNC. not request a signal, not context swap
//
#define SYNC 0
#define ASYNC 1
#define NOSYNC 2

// alternate method
// 1) pend (synchronous). context swap until signal
// 2) sig (asynchronous). request a signal upon completion, not context swap
// 3) nosig. not request a signal, not context swap
//
#define pend	ctx_swap
#define sig		sig_done
#define nosig	2						// temp to prevent assemble error



// include common libs
#include "constants.uc"		// constants for use instead of magic numbers
#include "stdmac.uc"		// instruction set simplification macros
#include "mem.uc"			// memory allocation macros
#include "msgq.uc"			// message queue macros
#include "sem.uc"			// semaphore macros
#include "critsect.uc"		// critical section macros
#include "tim.uc"			// timer macros
#include "field.uc"			// field extract/compare/branch macros
#include "hashdb.uc"		// hash database macros
#include "ether.uc"			// ethernet protocol macros
#include "ip.uc"			// internet protocol header processing macros
#include "port.uc"			// port receive and transmit macros
#include "rfifo.uc"			// rfifo macros
#include "packetq.uc"		// packet queuing macros
#include "scratch.uc"		// scratch access macros
#include "sdram.uc"			// sdram access macros
#include "sram.uc"			// sram access macros

