//------------------------------------------------------------------------------------
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  1999-2000 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
//-----------------------------------------------------------------------------------
// field.uc
// IXPblock big/little-endian field extract/compare/branch macros
//
//
// system: IXP1200
// subsystem: IO microcode
// usage: library macros
// author: dfh Apr 3, 2000
//
// revisions:


#ifndef FIELD_UC
#define FIELD_UC
#include "endian.uc"

// API:
// field_br_eq							compare byte range to constant and branch if equal
// field_br_gtr							compare byte range to constant and branch if greater
// field_br_less						compare byte range to constant and branch if less
// field_br_gtreq						compare byte range to constant and branch if greater or equal
// field_br_lesseq						compare byte range to constant and branch if less or equal
// field_comp							compare a range of bytes from a register to a constant
// field_dbl_extract					extract a field that spans 2 registers
// field_decr							decrement a range of bytes
// field_extract						extract a range of bytes from a register
// field_incr							increment a range of bytes


// default is BIG-ENDIAN
// by defining LITTLE_ENDIAN, the appropriate underlying swaps will be inserted
// this will allow you to write code that runs big- or little-endian
// for compatibility of new naming conventions with legacy macro names
//
#define field_br_eq br_eq_field
#define field_br_gtr br_gtr_field 
#define field_br_gtreq br_gtreq_field 
#define field_br_less br_less_field
#define field_br_lesseq br_lesseq_field
#define field_comp comp_field
#define field_dbl_extract dbl_extract_field
#define field_decr decr_field
#define field_extract extract_field
#define field_incr incr_field


// field_srbuf_extract
// 		description: Extract a byte field 1-4 bytes from sram read xfer buffer
//					 from source endian format to big-endian. 
//					 Source endian format default in big unless #define LITTLE_ENDIAN
//		outputs:
//			result						GPR with extracted byte field, right justified
//		inputs:
//			const_window_start_byte		starting byte of buffer window, e.g., start of header
//			const_field_start_byte		start of byte field
//			const_field_end_byte		end of byte field
//			
//		size: 1-3 instr
//		see also: endian.uc
//		example usage:
//			field_srbuf_extract[14, 2, 3]		; extract bytes 16-17
//
#macro field_srbuf_extract[result, const_window_start_byte, const_field_start_byte, const_field_end_byte]
#define_eval ABS_SBYTE ((const_window_start_byte + const_field_start_byte) & 0x1f)
#define_eval ABS_EBYTE ((const_window_start_byte + const_field_end_byte) & 0x1f)
#define_eval WORD0 (ABS_SBYTE / 4)
#define_eval WORD1 (ABS_EBYTE / 4)
#define_eval SBYTE_IN_WD (ABS_SBYTE & 0x3)
#define_eval EBYTE_IN_WD (ABS_EBYTE & 0x3)
#if (WORD0 == WORD1)
	field_extract[result, $xfer/**/WORD0/**/, SBYTE_IN_WD, EBYTE_IN_WD]
#elif (((WORD0+1)&0x7) == WORD1)
	field_dbl_extract[result, $xfer/**/WORD0/**/, SBYTE_IN_WD, $xfer/**/WORD1/**/, EBYTE_IN_WD]
#else
#error 2   "Error: extract of byte field greater than 4 bytes. Not supported."
#endif
#endm


#endif // FIELD_UC