//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  2000 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
// critsect.h
// critical section macros 
//
//
// system: IXP1200
// subsystem: OS emulation microcode
// usage: library macros
//
// revisions:
// 		v1.0, May 1, 2000,  jdg, dfh	initial version	


#ifndef CRITSECT_UC
#define CRITSECT_UC


// API:
//	critsect_init[abs_reg]
//	critsect_enter[abs_reg]
//	critsect_exit[abs_reg]


#include "sem.uc"

// critsect_init
//	Initialize critical section absolute register to -1
//
#macro critsect_init[abs_reg]
	sem_init[abs_reg]
#endm


// critsect_enter
//	Enter a critical section
//
#macro critsect_enter[abs_reg]
	sem_wait[abs_reg]
	sem_clr[abs_reg]
#endm


// critsect_exit
//	Exit a critical section
//
#macro critsect_exit[abs_reg]
	sem_set[abs_reg]
#endm	


#endif  //  CRITSECT_UC