// xmit_sched.uc
//		1 transmit scheduler for use with either xmit_8x100.uc or xmit_fast_port.uc
//		used on 2 microengines
//		1 microengine takes even tfifo elements, the other takes odd tfifo elements
//		each element is statically bound to a port. don't need binding to block a port

//		each microengine: define personality  ODD or not ODD
//

#include "stdmac.uc"
#include "mem_map.h"
#include "sem.uc"



.xfer_order $xfer0 $xfer1
.operand_synonym $tfifo_outptr $xfer0
.operand_synonym $pwp $xfer1


	// startup

	br=ctx[1,tx_fill#]				; fill thread
	br=ctx[2,tx_fill#]				; fill thread
	br=ctx[3,tx_fill#]				; fill thread


tx_sched#:
.local pwp_addr filtered_outptr bit31on

.local temp
	alu[temp, --, B, 1, <<31]				; init assignment to no assignment
	move[@assign1, temp]
	move[@assign2, temp]
	move[@assign3, temp]
.endlocal

	
	#ifdef HW_INIT	
		#include "hw_init.uc"				; initializes freelist + hw registers + rdy bus program
	#else
		#ifdef XMIT_INIT
			#include "xmit_init.uc"			; initializes freelist + hw registers
		#endif
	#endif


	#ifdef EVEN
		immed[target_port, 0]
	#else									; not EVEN
		immed[target_port, 1]
		fast_wr[16, inter_thd_sig]			; signal the even scheduler so that it will take the first packet
	#endif 									; EVEN


	// init the xmit scheduler

	#define SKIP_BIT_SET 0x100
	immed[skip_bit_on, SKIP_BIT_SET]


	immed[pwp_addr, XMIT_PWP_VECTOR]		; read pwnp and pweq


//-----------------------------MACRO DEFINITION-----------------------------------------
// tx scheduler assignment routine
//
#macro tx_sched_body[abs_assign, const_to_tid]
.local temp new_target_port
retry#:

	//  poll ports with packets
	//
	scratch[read, $pwp, pwp_addr, 0, 1], ctx_swap

	// If FAST_PORT1 is defined then we are running eval card with 8 10/100 + 1 Gig.  
	// This scheduler is only going to work on the 8 10/100 ports.  The 8 10/100 ports 
	// alternate output FIFO elements with the gig port.
	// To make things easy, this scheduler will process ports 0 through 7, and the ports 
	// will be mapped to output FIFO element = port * 2.  i.e. 10/100 port 6 will always go 
	// out using output FIFO element 12.  If FAST_PORT1 is not defined, then we are running 
	// validation system.  In this configuration there are 16 10/100 ports.  Each of the ports 
	// is mapped directly (1:1) to an output FIFO element.   One scheduler processes all of the 
	// even ports, and the other scheduler processes all of the odd ports.
	#ifdef FAST_PORT1								; if fast_port1 then we are running eval card (8 10/100 + 1 gig)
		alu[new_target_port, target_port, +, 1]     ; indirect.  Also increment for next packet
	#else  											; if running validation system (16 10/100 ports)
		alu[new_target_port, target_port, +, 2]     ; indirect.  Also increment for next packet (this thread does every other port
	#endif
	// if not port with packet, set skip
	alu[--, 1, AND, $pwp, >>indirect]
	br>0[tx_assign#], defer[1], guess_branch
	alu[temp, --, B, target_port, <<4]			; tell fill thread which port to process and it will know how port maps to fifo element
	// optional: put queue select in 3:1
	alu[temp, temp, OR, skip_bit_on]			; tell thread which element to skip
tx_assign#:
	sem_wait[abs_assign]
	move[abs_assign, temp]
	#ifdef FAST_PORT1								; if fast_port1 then we are running eval card (8 10/100 + 1 gig)
		alu[target_port, new_target_port, AND, 0x7] ; only port 0 through 7 are valid ports for this engine
	#else  											; if running validation system (16 10/100 ports)
		alu[target_port, new_target_port, AND, 0xf] ; port 0 through 15 are valid ports for this engine
	#endif
.endlocal

#endm
//------------------------------END MACRO DEFINITION-----------------------------------

#define_eval CTX1_TID (FID*4+1)
#define_eval CTX2_TID (FID*4+2)
#define_eval CTX3_TID (FID*4+3)


tx_sched_loop#:
	tx_sched_body[@assign1, CTX1_TID]
tx_sched_ctx2#:
	tx_sched_body[@assign2, CTX2_TID]
tx_sched_ctx3#:
	tx_sched_body[@assign3, CTX3_TID]
	br[tx_sched_loop#]

.endlocal

// three fill threads
//
#include "xmit_fill_8x100.uc"
		

