//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  1998-99 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
// rec_lmatch.uc
// IPV4 longest specific address match
//
//
// system: SA1200
// subsystem: IP router microcode
// usage: example
// author: dfh 9/28/97
//
// revisions:
//  dfh     Feb 28, 2000    use ip.uc macros, ip_da_extract, ip_trie5_lookup


// ---------------------------SA1200 microcode--------------------------	
//
// Prerequisite Register Usage:
//	symbol
//	 hi64k_base		  - base address of 3 adjacent tables:
//   					1. 64k entry lookup table, each entry 32 bits, total 256KB
//					 	2. 256 entry lookup table, each entry 32 bits, total 1KB 
//						3. many 16 entry trie tables, each entry  32 bits
//   route_table_base -	sdram route entries 128K x 8 longwords (1MB)
//						32 byte stride = offset must be shifted left 5
//	 ip_da			  - 32 bit IP destination address
//
//
// description:
//	Get the route entry whose ip address has the most specific match with ip_da.
//	Also known as longest-prefix match. 
//  lookup result:
//   $$route_entry0-3	- 4 longwords of route entry info,
//					      including the forwarding interface and MAC DA
// Algorithm:
//		please refer to IXP1200 Software Reference Manual (SRM)

#include "ip.uc"

#macro ip_checksum_create_be[accum, const_srbuf_ip_start]
.local temp
#define_eval READ_XFER0 (const_srbuf_ip_start >>2)
#define_eval READ_XFER1 ((READ_XFER0 +1) &0x7)
#define_eval READ_XFER2 ((READ_XFER1 +1) &0x7)
#define_eval READ_XFER3 ((READ_XFER2 +1) &0x7)
#define_eval READ_XFER4 ((READ_XFER3 +1) &0x7)
#define_eval READ_ALIGN (const_srbuf_ip_start & 0x3)
#if (READ_ALIGN == 0)
	alu[accum, --, B, $$xfer/**/READ_XFER0/**/]
	alu[accum, accum, +, $$xfer/**/READ_XFER1/**/]
#elif (READ_ALIGN == 2)
#define_eval READ_XFER5 ((READ_XFER4 +1) &0x7)
	alu[accum, 0, +16, $$xfer/**/READ_XFER0/**/]
	alu[accum, accum, +, $$xfer/**/READ_XFER1/**/]
	alu[accum, accum, +carry, $$xfer/**/READ_XFER5/**/, >>16]
#else
#error 2 	"Error: IP Header non-halfword READ_ALIGN. Not supported."
#endif
	alu[accum, accum, +carry, $$xfer/**/READ_XFER2/**/]
	alu[accum, accum, +carry, $$xfer/**/READ_XFER3/**/]
	alu[accum, accum, +carry, $$xfer/**/READ_XFER4/**/]
	alu[accum, accum, +carry, 0]				; add in previous carry
    ld_field_w_clr[temp, 1100, accum]			; get high 16 of the total
    alu_shf[accum, temp, +, accum, <<16]		; add low 16 bits to upper 16
	alu[accum, 0, +carry, accum, >>16]			; add last carry +1, temp B op=0
	immed[temp, 0xffff]
	alu[accum, temp, -, accum]
//	alu[accum, accum, +, temp, <<16]			; add 1<<16 to 0xffff to get zero result
.endlocal
#endm

#macro get_router_ip[_r_ip, const_sram_addr]
.local r_ip_addr
   immed32[r_ip_addr, const_sram_addr]
   sram[read, $xfer0, r_ip_addr, 0, 1], ctx_swap
   move[_r_ip, $xfer0]
.endlocal
#endm


.xfer_order $$xfer0 $$xfer1 $$xfer2 $$xfer3 $$xfer4 $$xfer5 $$xfer6 $$xfer7
.operand_synonym $$route_entry0 $$xfer0
.operand_synonym $$route_entry1 $$xfer1
.operand_synonym $$route_entry2 $$xfer2
.operand_synonym $$route_entry3 $$xfer3

.import_var hi64k_base route_table_base

// the transfer from rfifo was done at the top of ipverify, in order to free the rfifo element earlier
// we should have the signal back well before now
//
	ctx_arb[sdram]									    ; is transfer from rfifo done?

//	Write thread done as soon as the rfifo element is transferred to sdram
//  By the time it turns around and get sot the Receive Scheduler, this thread will be done
//
#ifndef RECEIVE16						; if no receive scheduler, there are 16 receive threads
			fast_wr[3, THREAD_DONE]		; notify receive scheduler with EOP encode
#endif


// tlaw -- do route_lookup after the whole packet is stored.

/////////////
// route lookup and header processing
//{
//   read ip header from SDRAM
//   lookup route
//   if (OUTBOUND)
//   {
//      write inner ip header
//	    write esp header
//	    write outer ip header
//   }
//   write mac header
//}

// tlaw -- do route_lookup before enqueue


// tlaw - from rec_enqueue.uc
header_stored#:

	.if (bit(rec_state, 1) == 0)							; if not EOP don't enqueue yet
#ifdef FAST_PORT_ENABLED
sop_save#:
		.if (bit(rec_state, 30) ==1)						; if fast port
			alu[tempb, 0xf, AND, rec_state, >>20]			; get SOP seq number
			state_save[$xfer5, output_port, RX_FPORT1_OUTPORT, tempb]	; save output_port for EOP thread to pick up
			br[next_packet#]
		.endif
#endif

#ifdef REC_STATE_SAVE
slow_save1#:
//		Rx_SaveSlowState[buf_handle, rec_state, output_port]
		// tlaw
		Rx_SaveSlowState_w_pkt_label[buf_handle, rec_state, pkt_label]
		br[next_packet#]
#endif
		br[next_mpacket#]
	.endif

// tlaw - Nov 17, 2000
   move[packet_buf_addr_base, packet_buf_addr]			; if both SOP and EOP

/////////////////////////////

got_whole_packet#:

   sdram[read, $$xfer0, packet_buf_addr_base, 1, 3], ctx_swap

// if OUTBOUND, write outer IP header, ESP header, inner IP header

#define ROUTER_IP_ADDR 0x65000

create_tunnel_hdr#:

.local temp accum temp2 r_ip
   // create headers for outbound packets
   .if (pkt_label == PKT_LABEL_OUTBOUND)

        get_router_ip[r_ip, ROUTER_IP_ADDR]

		immed[temp, 29]
        alu_shf[$$xfer0, $$xfer2, +, temp, <<16]		; new ip total length
														; old id keep old one
		ld_field_w_clr[temp, 1110, $$xfer3]		; Flags, Fragment offset, TTL (same as old)
		immed[temp2, 50]							; protocol 50 for ESP
		alu[$$xfer1, temp, +, temp2]
        // checksum first 2 bytes of $xfer2

		ld_field_w_clr[$$xfer2, 0011, r_ip, >>16]			; src ip addr
		alu[temp2, --, B, r_ip, <<16]
		alu[$$xfer3, temp2, +, sa_tunnel_ip, >>16]			; dest ip addr
		alu[temp2, --, B, sa_tunnel_ip, <<16]


		// ESP header
		//	     SPI 32-bit
		//		 seqNo 32-bit
		//		 nextHeader 8-bit (IP 33)
		alu[$$xfer4, temp2, +, sa_spi, >>16]		; sa spi
		alu[temp, --, B, sa_spi, <<16]
		alu[$$xfer5, temp, +, sa_seq, >>16]			; sa seq
		alu[temp, --, B, sa_seq, <<16]
		immed[temp2, 33]						; sa next header
		alu[$$xfer6, temp, +, temp2, <<8]

        move[temp, $$xfer1]
	#ifdef USE_ENDECRYPT
		endecrypt[temp, temp, sa_key]
	#endif
		ld_field_w_clr[$$xfer7, 0011, temp]		; first 2 bytes of inner ip header

		sdram[write, $$xfer0, packet_buf_addr_base, 2, 4], ctx_swap		; write outer ip, esp header

	#ifdef USE_ENDECRYPT
		endecrypt[$$xfer0, $$xfer2, sa_key]
		endecrypt[$$xfer1, $$xfer3, sa_key]
		endecrypt[$$xfer2, $$xfer4, sa_key]
		endecrypt[$$xfer3, $$xfer5, sa_key]
	#else
		move[$$xfer0, $$xfer2]
		move[$$xfer1, $$xfer3]
		move[$$xfer2, $$xfer4]
		move[$$xfer3, $$xfer5]
	#endif

		sdram[write, $$xfer0, packet_buf_addr_base, 6, 2], ctx_swap		; write inner ip header


// tlaw -- load outer ip header and calculate checksum

cal_chksum#:
		sdram[read, $$xfer0, packet_buf_addr_base, 1, 4], ctx_swap
		ip_checksum_create_be[accum, 6]
		ld_field[$$xfer4, 1100, accum, <<16]
		move[$$xfer5, $$xfer5]
		sdram[write, $$xfer4, packet_buf_addr_base, 3, 1], ctx_swap

   .endif
.endlocal



route_lookup_2#:

// different destination

.local temp_da
  .if (pkt_label == PKT_LABEL_NORMAL)
     move[temp_da, ip_da]
  .elif (pkt_label == PKT_LABEL_INBOUND)
     sdram[read, $$xfer6, packet_buf_addr_base, 4, 1], ctx_swap

     alu[temp_da, --, B, $$xfer5, <<16]
     alu[temp_da, temp_da, +, $$xfer6, >>16]
  .else
     move[temp_da, sa_tunnel_ip]
  .endif


	ip_trie5_lookup[route_ent_offset, temp_da, hi64k_base, 0]		; perform longest prefix match
	br!=0[ip_get_route_2#], guess_branch
    immed[exception, IP_NO_ROUTE]
    br[packet_discard#]

.endlocal


ip_get_route_2#:

.local temp_route_base
    immed_w0[temp_route_base, route_table_base]				; load shared address value
    immed_w1[temp_route_base, route_table_base>>16]

// get route entry
	sdram[read, $$route_entry0, temp_route_base, route_ent_offset, 2], optimize_mem, ctx_swap
	alu[output_port, --, b, $$route_entry0]				; save output port for enqueue

.endlocal		// temp_route_base

got_output_port#:
write_layers23#:	
// modify layer 2. insert MAC DA from route entry, write first 32 bytes to sdram  
    sdram[read, $$xfer4, packet_buf_addr_base, 0, 1], ctx_swap

.local temp
	move[$$xfer0, $$route_entry1]							; next hop da bytes 0-3
	ld_field_w_clr[temp, 0011, $$xfer5]
#ifdef LITTLE_ENDIAN
	alu[$$xfer1, $$route_entry2, +, temp, <<16]				; next hop da bytes 4-5: 0 merge with sa bytes 0-1
#else
	alu[$$xfer1, temp, +, $$route_entry2, <<16]				; next hop da bytes 4-5: 0 merge with sa bytes 0-1
#endif
.endlocal
	
//	move[$$xfer2, $$xfer2]
//	move[$$xfer3, $$xfer3]
//	move[$$xfer2, temp_xfer0]									; sa bytes 2-5
//	move[$$xfer3, temp_xfer1]					; mac last 2 bytes, ip fist 2 bytes (version, IHL, ToS)

	sdram[write, $$xfer0, packet_buf_addr_base, 0, 1], ctx_swap		; write mac header

// tlaw
// if NORMAL, done
// if INBOUND, done (not decrypt yet)
/////////////////////////////

.endlocal		// sa01

; rec_enqueue.uc follows

