/* ueng_constants.h
 * 
 * ---------------------------------------------------------------------	
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 * ---------------------------------------------------------------------
 *
 * system: SA1200
 * subsystem: Developer Workbench
 * author: rdm
 * revisions:
 * $History: ueng_constants.h $
 * 
 * *****************  Version 7  *****************
 * User: Dmwhite      Date: 4/05/00    Time: 4:37p
 * Updated in $/dev_1200/Include
 * took out some unwanted comments
 * 
 * *****************  Version 4  *****************
 * User: Drjohns1     Date: 10/27/99   Time: 1:02p
 * Updated in $/dev_1200/Include
 * Changed uengine error/status codes
 * 
 * *****************  Version 3  *****************
 * User: Drjohns1     Date: 10/18/99   Time: 3:47p
 * Updated in $/dev_1200/Include
 * Made UDBG_NOUSTORE not negative
 * 
 * *****************  Version 2  *****************
 * User: Drjohns1     Date: 10/13/99   Time: 3:10p
 * Updated in $/dev_1200/Include
 * Updated error codes
 * 
 * *****************  Version 1  *****************
 * User: Rdmurato     Date: 6/24/99    Time: 4:05p
 * Created in $/dev_1200/Include
 * Initial version
 *
 */

#if !defined(__UENG_CONSTANTS_H)
#define __UENG_CONSTANTS_H

static const char __ueng_constants_H_version__[]= 
        "\nFILEINFO:   $Workfile: ueng_constants.h $ $Date: 4/05/00 4:37p $ $Revision: 7 $\n ";

enum{
   UENG_SUCCESS=0,			/* the operation was successful */
   UENG_FAIL=0x8100,		/* the operation failed */
   UENG_BADARG,				/* bad function argument */
   UENG_DUPBKP,				/* duplicate break point */
   UENG_NOUSTORE,			/* not ustore available */
   UENG_BADADDR,			/* bad address */
   UENG_BADLIB,				/* bad debug library -- wasn't initialized */
   UENG_INACTIVE,			/* micro-engine inactive */
   UENG_ACTIVE,				/* micro-engine active */
   UENG_ATBREAK,			/* micro-engine at breakpoint */
   UENG_RESET,				/* micro-engine is in reset */
   UENG_TIMEOUT 			/* the operation execced th etime limit */
};


#define MAX_UENGS				6
#define MAX_CTX					4
#define MAX_USTORE				1024

#endif      // #if !defined(__UENG_CONSTANTS_H)
