/* rsxact_dll.h
 *
 *
 * ------------------------------------------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *------------------------------------------------------------
 *
 * system: SA1200
 * subsystem: Remote Services
 * author: Lai-Wah Hui 6/22/98
 * revisions:
 * $History: rsxact_dll.h $
 * 
 * *****************  Version 17  *****************
 * User: Bwheeler     Date: 9/21/99    Time: 3:27p
 * Updated in $/dev_1200/Include
 * back out last change (don't know how I made it in the first place!)
 * 
 * *****************  Version 15  *****************
 * User: Qabuild      Date: 9/09/99    Time: 4:18p
 * Updated in $/dev_1200/Include
 * included xact_gui.h
 * 
 * *****************  Version 13  *****************
 * User: Lhui         Date: 7/22/99    Time: 7:44p
 * Updated in $/dev_1200/Include
 * Fix bug #669 -  Remote Simulation doe not make connection
 * 
 * *****************  Version 12  *****************
 * User: Lhui         Date: 5/18/99    Time: 10:24a
 * Updated in $/dev_1200/Include
 * Add support for xact_define_callback_sim_halt()
 * 
 * *****************  Version 12  *****************
 * User: Lhui         Date: 5/14/99    Time: 10:14a
 * Updated in $/dev_1200/Share/RemoteServices
 * Add support for xact_clock_with_remainder(),
 * xact_define_callback_default_go_clock_domain and
 * xact_stop_execution_at_clk 
 * 
 * *****************  Version 10  *****************
 * User: Lhui         Date: 4/13/99    Time: 8:15p
 * Updated in $/development/RemoteServices
 * Add supports for XACT_Define_Automatic_Sim_Halt
 * 
 * *****************  Version 9  *****************
 * User: Lhui         Date: 4/08/99    Time: 5:13p
 * Updated in $/development/RemoteServices
 * Add compile switch for console app supports
 * 
 * *****************  Version 8  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 3:47p
 * Updated in $/development/RemoteServices
 * update COPYRIGHT
 * 
 * *****************  Version 7  *****************
 * User: Lhui         Date: 2/01/99    Time: 7:23p
 * Updated in $/development/RemoteServices
 * Add supports for XACT_get_fifo_handle & XACT_Define_Callback_Ref_Status
 * 
 * *****************  Version 6  *****************
 * User: Lhui         Date: 12/18/98   Time: 4:03p
 * Updated in $/development/RemoteServices
 * Add support for xact_get|set_fifo_state_value
 * 
 * *****************  Version 5  *****************
 * User: Lhui         Date: 12/14/98   Time: 6:20p
 * Updated in $/development/RemoteServices
 * Add support for new transactor functions
 * 
 * *****************  Version 4  *****************
 * User: Lhui         Date: 9/14/98    Time: 5:55p
 * Updated in $/base_level3/RemoteServices
 * Add support for 4 new transactor functions:
 * XACTAPI XACT_find_wildcard_state_name()
 * XACTAPI XACT_Define_Callback_Init_Sim();
 * XACTAPI XACT_Define_Callback_Sim_Reset();
 * XACTAPI XACT_Define_Callback_Restore( );
 * 
 * *****************  Version 3  *****************
 * User: Lhui         Date: 8/19/98    Time: 3:49p
 * Updated in $/base_level3/RemoteServices
 * Include "xact.h"
 * 
 * *****************  Version 2  *****************
 * User: Lhui         Date: 7/27/98    Time: 10:11a
 * Updated in $/base_level3/RemoteServices
 * Add comments
 * 
 * *****************  Version 1  *****************
 * User: Lhui         Date: 7/24/98    Time: 5:29p
 * Created in $/base_level3/RemoteServices
 * Init. check-in
 * 
 */ 
#ifndef RSXACT_DLL_H
#define RSXACT_DLL_H

#include <xact.h>
#include <xact_gui.h>

#define RS_XACT_HANDLE				XACT_HANDLE
#define RS_INVALID_XACT_HANDLE		INVALID_XACT_HANDLE


#ifdef RS_XACT_DLL
#define RS_XACTAPI_NORET __declspec(dllexport)
#define	RS_XACTAPI	__declspec(dllexport) int __cdecl
#else
#ifdef REMOTE_APP
#define RS_XACTAPI_NORET 
#define	RS_XACTAPI	int
#else
#define RS_XACTAPI_NORET __declspec(dllimport)
#define	RS_XACTAPI	__declspec(dllimport) int __cdecl
#endif
#endif

#if defined(__cplusplus)
extern "C"
{
#endif
	/* This routine can be iteratively called to return all state */
	/* names that match the wildcard_name_spec ( "*" is the wildcard */
	/* character that can match 0 or more characters).  A non-NULL */
	/* wildcard_name_spec indicates that a new wildcard name search is */
	/* initiated; a NULL wildcard_name_spec indicates that the next name */
	/* to match the previously initiated wildcard search should be returned. */
	/* Each matching state name is returned in rtn_name_buf provided */
	/* that the specified rtn_name_buf_length indicates that the return */
	/* buffer is large enough to hold the name.  This function returns:    */
	/*     0:   no match found                                             */
	/*     1:   match found                                                */
	/*     -1:  match found but not returned due to size of rtn_name_buf   */
	RS_XACTAPI RS_XACT_find_wildcard_state_name(
        char *wildcard_name_spec, char *rtn_name_buf,
        unsigned int rtn_name_buf_length );

		
	/* The routine is a specific variant of XACT_get_handle, which applies only */
	/* to FIFO states.  Unlike XACT_get_handle, which can address an individual array element */
	/* as the linearly specified element of that array, this routine addresses each fifo element */
	/* relative to its position in the queue.  Thus, fifo_index = 0, addresses the element which */
	/* will be removed during the next remove operation; fifo_index = 1 addresses the element to */
	/* be removed after that, etc.   In all other respects, it operates identically to */
	/* XACT_get_array_state_value.  The routine returns 1 if an valid fifo address is specified; */
	/* 0 indicating an access failure. */
	RS_XACTAPI_NORET RS_XACT_HANDLE RS_XACT_get_fifo_handle( char *state_name, int fifo_array_index );

    /* HANDLE/state_name reference routines */

	/* Return a handle to a transactor state, based on a transactor state name. */
	/* If a handle corresponding to the specified state exists and is currently */
	/* valid, it will be returned; otherwise, a unique handle will be created and */
	/* returned.  Note that the specified state name is case-sensitive.  For non-array */
	/* states, the value of the array_index MUST be -1.  For arrayed states, the array_index */
	/* specifies the particular element in the array that will correspond to the handle. */
	/* If a value of -1 is specified for an array state, a handle is returned corresponding */\
	/* to the array, but which is not associated to a particular array element.  Such a */
	/* handle can be used in calls to XACT_get_array_state_value or XACT_set_array_state_value, */
	/* but cannot be used to specify callbacks on state transitions within the array. */
	/* Returns INVALID_RS_XACT_HANDLE if the function failed */
	RS_XACTAPI_NORET RS_XACT_HANDLE RS_XACT_get_handle( char *state_name, int array_index );



	/* This routine deletes the specified handle.  This deletion operation */
	/* disassociates the handle from the previously specified state and invalidates */
	/* the handle value thereby causing a subsequent reference to that handle to fail.  */
	/* However, once deleted, the value of that handle may be reused when a subsequent */
	/* handle is generated by a call to XACT_get_handle().  This routine */
	/* returns TRUE if successful, or FALSE otherwise. */
	RS_XACTAPI RS_XACT_delete_handle( RS_XACT_HANDLE handle );

	
	
	
	/* Return information about the state referenced by the specified handle:  */
	/*		state_name:    name of state											*/
	/*		width:         width of state (NOTE:  a width of 0 implies that the */
	/*                     state is not directly readable/writeable by the XACT api. */
	/*		array_length:  indicates length of array ranging from 0 to array_length-1. */
	/*                     If this value is -1, the state is a non-array state. */
	/* 
	/* Returning each of the 3 pieces of state information is suppressed when that argument is NULL. */
	/* Note that when using a handle corresponding to an array, the function returns */
	/* information corresponding to the whole array even if the handle corresponds to */
	/* a particular element of an array. */
	/* Return 1 if successful, 0 otherwise */
 
    RS_XACTAPI RS_XACT_get_state_info(RS_XACT_HANDLE handle,char *statename,
                                   int *width, int *array_length);
	/* Get the value of the state corresponding to the transactor handle. */
	/* Note that the "value" pointer is assumed to point to an array of unsigned ints */
	/* large enough to accommodate the value of the state element.  Thus, the array */
	/* length must be = (state_width/32) + ((state_width%32) ? 1 : 0 ) */
    /* If the specified handle corresponds to an element of an array that is currently */
    /* uninitialized, this read of that element will fail.  If a handle to an array */
	/* state is specified that was not associated to a specific array element, this */
	/* function will fail.  If the handle accesses a valid state which contains invalid */
    /* data (e.g. a value of a BUS element caused by no driver actively driving the bus), */
    /* this function will fail. */
    /* Returns 1 if successful, 0 otherwise */
	RS_XACTAPI RS_XACT_get_state_value( RS_XACT_HANDLE s_handle, unsigned int *value ); 

 	/* This routine returns the collection characteristics for the specified statistics simulation state. */
	/* The characteristics are returned in the buffer supplied in the second argument (see definition */
	/* of stat_characteristic above). */
	/* This routine returns TRUE if successful, 0 otherwise. */
	RS_XACTAPI RS_XACT_get_stat_characteristic( RS_XACT_HANDLE stat_handle, Stat_characteristic *stat_char_buf );
	



    /* This routine returns the number of samples (if num_bucket_samples != NULL) and/or the */
	/* title for the specified statistics bucket (if titled_buckets == 1).  The bucket_index argument */
	/* must be between 0 and num_buckets-1 inclusive for the call the succeed, where num_buckets */
	/* was determined from a previous call to XACT_get_stat_characteristic. */
	/* This routine returns TRUE if successful; FALSE otherwise. */
	RS_XACTAPI RS_XACT_get_stat_bucket_data( RS_XACT_HANDLE stat_handle, int bucket_index, int *num_bucket_samples, Stat_str *bucket_title );



	/* Behaves the same as XACT_get_state_value, except that the handle must correspond */
	/* to an array state, and a valid array index must be specified.  If the specified */
	/* handle was associated to a particular element of an array, its predefined array */
	/* index is ignored for the purpose of this call. */ 
	RS_XACTAPI RS_XACT_get_array_state_value(RS_XACT_HANDLE s_handle, int array_index, unsigned int *value ); 


	/* The routine is a specific variant of XACT_get_array_state_value, which applies only */
	/* to FIFO states.  Unlike XACT_get_array_state_value, which addresses each element */
	/* strictly as an array, this routine addresses each fifo element relative to its position */
	/* in the queue.  Thus, fifo_index = 0, addresses the element which will be removed during */
	/* the next remove operation; fifo_index = 1 addresses the element to be removed after that, etc. */
	/* In all other respects, it operates identically to XACT_get_array_state_value. */
	/* The routine returns 1 if valid data is returned, -1 if the addressed entry contains invalid */
	/* data, or 0 indicating an access failure. */
	RS_XACTAPI RS_XACT_get_fifo_state_value( RS_XACT_HANDLE fifo_handle, int fifo_index, unsigned int *value );

	/* Set the value of the state corresponding to the transactor handle. */
	/* Note that the "value" pointer is assumed to point to an array of unsigned ints */
	/* large enough to accommodate the value of the state element.  Thus, the array */
	/* length must be = (state_width/32) + ((state_width%32) ? 1 : 0 ).  If a handle to */
	/* an array state is specified that was not associated to a specific array element, this */
	/* function will fail. */
	/* Returns 1 if successful, 0 otherwise. */
	RS_XACTAPI RS_XACT_set_state_value( RS_XACT_HANDLE s_handle, unsigned int *value ); 



	/* Behaves the same as XACT_set_state_value, except that the handle must correspond */
	/* to an array state, and a valid array index must be specified.  If the specified */
	/* handle was associated to a particular element of an array, its predefined array */
	/* index is ignored for the purpose of this call. */ 
	RS_XACTAPI RS_XACT_set_array_state_value( RS_XACT_HANDLE s_handle, int array_index, unsigned int *value ); 


	/* The routine is a specific variant of XACT_set_array_state_value, which applies only */
	/* to FIFO states.  Unlike XACT_set_array_state_value, which addresses each element */
	/* strictly as an array, this routine addresses each fifo element relative to its position */
	/* in the queue.  Thus, fifo_index = 0, addresses the element which will be removed during */
	/* the next remove operation; fifo_index = 1 addresses the element to be removed after that, etc. */
	/* Note however, that writing to a fifo element does not validate the element.  This can only */
	/* be handled through push/pop operations. */
	/* In all other respects, it operates identically to XACT_set_array_state_value. */
	RS_XACTAPI RS_XACT_set_fifo_state_value( RS_XACT_HANDLE fifo_handle, int fifo_index, unsigned int *value );


    /* The function creates a "bus client" and attaches it to a pre-existing BUS element */
    /* The bus client state is used to drive data onto the BUS or receive data off of the BUS */
    /* By interfacing to the BUS element through a bus client (as opposed to directly reading */
    /* or writing the BUS element directly), assertion checkers will flag instances when */
    /* multiple bus clients are simultaneously driving the BUS, or when a bus client received */
    /* invalid data because no client drove the BUS.  This function can only be called during */
    /* initialization of the simulation; therefore, it must be called only from */
    /* foreign_model_initialize()  (defined below). */
	/* Return 1 if successful, 0 otherwise */
    RS_XACTAPI RS_XACT_add_bus_client( char *bus_name, char *bus_client_name );


    /* This function is used when one wants to check to see if the bus data latched by */
    /* the specified bus_client is valid.  The data is considered valid when exactly one */
    /* bus client source drove the data; otherwise it's considered invalid.  The variable */
    /* *valid returns 1 when valid; 0 otherwise.  This routine returns 1 if successful; */
    /* 0 otherwise. */
    RS_XACTAPI RS_XACT_bus_client_data_validity( RS_XACT_HANDLE bus_client_handle, unsigned int *valid );




    /* This function is analogous to XACT_bus_data_validity except that it applies to the */
    /* actual bus (rather than the bus client).  This routine returns 1 if successful; */
    /* 0 otherwise. */
    RS_XACTAPI RS_XACT_bus_data_validity( RS_XACT_HANDLE bus_handle, unsigned int *valid );




    /* This routine returns TRUE if the current simulation time corresponds to the time when the specified */
    /* clock domain starts a new cycle.  The valid clock domain values are specified in the "enum CLK_TYPE" */
    /* at the top of this file. */
    RS_XACTAPI RS_XACT_start_of_cycle( enum CLK_TYPE clk_type );



    /* This routine returns the clock cycle number (starting at 0) for the specified clock */
    /* It returns -1 if an error occurred during routine execution. */
    RS_XACTAPI RS_XACT_clock_cycle( enum CLK_TYPE );


    /* This routine returns the clock cycle number (starting at 0) for the specified clock */
    /* It returns -1 if an error occurred during routine execution.  If the simulation time */
	/* does not fall on a whole multiple of the specified clock, the percentage of the */
	/* time into the partial clock cycle is returned in percent_remainder; otherwise this */
	/* argument returns 0 */
    RS_XACTAPI RS_XACT_clock_cycle_with_remainder( enum CLK_TYPE, double *percent_remainder );


	/* Callback creation and deletion routines */


	/* call callback when a chip of the specified name has been called */
	RS_XACTAPI RS_XACT_Define_Callback_Create_Chip( void(*fp)( char *chip_name ) );


	/* call callback when the simulation has been instantiated and initialized via the "init" command */
	RS_XACTAPI RS_XACT_Define_Callback_Init_Sim( void(*fp)() );

 	/* call callback when the simulator has prematurely halted model for the reason */
	/* specified by the input argument */
    RS_XACTAPI RS_XACT_Define_Automatic_Sim_Halt(void(*fp)(HALT_STATUS status));

	/* call callback when the simulation has been reset via the "sim_reset" command */
	RS_XACTAPI RS_XACT_Define_Callback_Sim_Reset( void(*fp)() );


	/* call callback when the simulation state has been reloaded via the "restore" command */
	RS_XACTAPI RS_XACT_Define_Callback_Restore( void(*fp)() );




    /* call callback when ucode file has been loaded into specified chip/fbox */
	/* If the ucode_file name is NULL, this means that the associated control */
	/* store has been reset and no longer corresponds to a ucode_file */
	RS_XACTAPI RS_XACT_Define_Callback_Load_Ucode( void(*fp)( char *chip_name,
												   int fbox_num,
												   char *ucode_file ) );



	/* NOTE:  *ContextMask == 0 means that the breakpoint has been cleared */
	RS_XACTAPI RS_XACT_Define_Callback_Breakpoint( void (*fp)( char *chip_name, int fbox_num, int PC, int ContextMask ) ); 


	/* Define callback to invoke whenever a breakpoint has been reached */
	RS_XACTAPI RS_XACT_Define_Callback_Breakpoint_Event(
        void (*fp)( char *chip_name, int fbox_num, int PC, int ContextNum ) ); 

	/* Define callback to be invoked whenever the status of an fbox reference is updated. */ 

	RS_XACTAPI RS_XACT_Define_CallbackRef_Status(void (*fp)(Meta_tag_ref *ref_data));


	/* Define callback to be invoked whenever default clock domain for "go" simulation changes */
	RS_XACTAPI RS_XACT_Define_Callback_Default_Go_Clock_Domain( void (*fp)( enum CLK_TYPE clk_type ) );


	

	/* Define a callback to be invoked when a specified state makes a transition. */
	/* The callback priority allows the user to specify the order in which */
	/* all the defined callbacks are made in; the higher the callback priority, */
	/* the earlier the callback is made.  The user_context argument allows */
	/* the caller of this function to pass contextual information to the */
	/* callback routine if required.  Note that a callback to cancel this */
	/* callback must be defined prior to executing this routine in order for */
	/* this callback definition to be successful (see XACT_Define_Cancel_Callback_State_Transition() */
	/* below).  If the specified handle corresponds to an array state, the handle must */
	/* also specify a particular valid element of the array.  This routine */
	/* returns 1 if successful, 0 otherwise */
	RS_XACTAPI RS_XACT_Define_Callback_State_Transition( 
                   RS_XACT_HANDLE transitioning_state,
                   int callback_priority,
                   int(*fp)( RS_XACT_HANDLE transitioning_state, 
                   void *user_context ),
                   void *user_context );


    /* define the callback to cancel any further state transition callbacks when */
    /* the specified state changes.  NOTE:  this callback must be defined prior to */
    /* calling XACT_Define_Callback_State_Transition() above.  This callback will be called */
    /* if the transactor deletes the state associated with the HANDLE.  State deletion */
    /* can occur if the state element was a user-defined state (e.g. C variable, function, */
    /* watch, etc.).  A predefined hardware state element will never be deleted, but */
    /* for consistency, this cancel callback is still required to be specified prior to */
    /* defining a state transition callback.  This routine returns 1 if successful, 0 otherwise */
    RS_XACTAPI RS_XACT_Define_Cancel_Callback_State_Transition(
               RS_XACT_HANDLE state,
               int (*fp)( RS_XACT_HANDLE handle, void *user_data) );


    /* Calling this routine allows the caller to explicitly cancel the predefined state */
    /* transition callback.  It returns 1 if successful, 0 otherwise */
    RS_XACTAPI RS_XACT_Cancel_State_Transition_Callback( RS_XACT_HANDLE state );


   /* print string to transactor console output */
    RS_XACTAPI RS_XACT_output_to_console( char *output_str );


	/* printf function outputing to transactor console */
	RS_XACTAPI RS_XACT_printf( char *fmt, ... );



	/* printf function outputing to transactor console as a transactor error */
	RS_XACTAPI RS_XACT_printf_error( char *fmt, ... );



	/* routine for registering a foreign function with the transactor's C interpretor */
	/* The argument list of the specified function is assumed to have the following */
	/* characteristics:

		o) only (char *) and (unsigned int) args are allowed
		o) all (char *) args precede all (unsigned int) args.
		o) number of (char *) args is <= 3
		o) number of (int) args is <= 5

	   Returns 1 if successful, 0 otherwise.

	*/
	RS_XACTAPI RS_XACT_register_console_function( char *function_name,
										void *function_ptr,
										int num_char_ptr_args,
										int num_uint_args );




	/* execute the str as a console command */
	RS_XACTAPI RS_XACT_ExecuteCommandStr( char *cmd_str );



	
	/* pass transactor output strings to callback function.  Note that the */
        /* transactor will still print the string to its own console output regardless */
        /* of this callback. */
	RS_XACTAPI RS_XACT_Define_Callback_Output_Message( void(*fp)(const char *message) );



	/* this routine registers the callback to pass the transactor prompt */
	/* to an external command line.  It must be called after the transactor */
	/* has been initialized.  It returns TRUE if successful, and */
	/* FALSE otherwise. */
	RS_XACTAPI RS_XACT_Define_Callback_Set_Prompt( void(*fp)( char *prompt_str ) );



	/* this routine registers the callback necessary for the transactor console */
	/* function to fetch console input from an external source.  This callback */
	/* should be defined prior to invoking XACT_start_console() */
	RS_XACTAPI RS_XACT_Define_Callback_Get_Console_Input( char *(*console_input)() );



        /* this routine registers the 4 callbacks that enable the transactor to */
        /* interact with a foreign model.  For more information on these functions, */
        /* see the descriptions below of the "foreign_model_*" functions. */
    RS_XACTAPI RS_XACT_Define_Callback_Foreign_Model_Calls( int(*for_mod_initialize)(),
                                                      int(*for_mod_pre_sim)(),
                                                      int(*for_mod_post_sim)(),
                                                      int(*for_mod_exit)() );



	/* this routine starts the transactor console.  This function returns only */
	/* when an "exit" command is processed by the console.  When an external program */
	/* is to supply the actual console I/O window, the functions:  */
	/*		XACT_Define_Callback_Output_Message
	/*		XACT_Define_Callback_Set_Prompt
	/*		XACT_Define_Callback_Get_Console_Input
	/*
	/* must be called prior to invoking XACT_start_console().
	/* This function returns TRUE if the console was successfully invoked or FALSE otherwise */	
	RS_XACTAPI RS_XACT_start_console();




	/* this routine initializes the transactor for operation when the */
	/* transactor function is accessed via a library.  This function must */
	/* be the first transactor function called.  Subsequent transactor functions */
	/* should only be called when this function returns with success status. */
	/* It returns TRUE if the initialization was successful or FALSE otherwise. */
	RS_XACTAPI RS_XACT_initialize();


	/* This routine stops simulation at the end of the next simulation cycle */
	/* It also stops script file execution as soon as possible by letting the current */
	/* command complete, and then unwinding the command stack.  This command returns */
	/* TRUE if successful; FALSE otherwise */
	RS_XACTAPI RS_XACT_stop_execution();

	/* This routine stops simulation at the end of the next simulation cycle that */
	/* aligns to the specified clock cycle.  It also stops script file execution as */
	/* soon as possible by letting the current command complete, and then unwinding */
	/* the command stack.  This command returns TRUE if successful; FALSE otherwise */
	RS_XACTAPI RS_XACT_stop_execution_at_clk( enum CLK_TYPE clk_type );


    /* initializes the command line parsing done by XACT_gui_execute_command, i.e., clears outstanding */
    /* line continuation, nested curly braces, nested conditional directives, etc. */
    RS_XACTAPI RS_XACT_init_gui_console();

    /* executes a command line in a gui (e.g., Developer Workbench) environment. Command line status, such */
    /* as line continuation, conditional directives, etc., is maintained between calls. Use XACT_init_gui_console */
    /* to initialize status. */
    RS_XACTAPI RS_XACT_gui_execute_command(char *command_line);

#if defined(__cplusplus)
}
#endif

#endif





