/* memsv.h
 *
 *
 * ------------------------------------------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *------------------------------------------------------------
 *
 * system: SA1200
 * subsystem: memory service library functions
 * author: Henry Qian 4/4/98
 * revisions:
 * $History: memsv.h $
 * 
 * *****************  Version 10  *****************
 * User: Dmwhite      Date: 10/07/99   Time: 9:34a
 * Updated in $/dev_1200/Include
 * changed errors to separate blocks of numbers
 * 
 * *****************  Version 7  *****************
 * User: Hqianx       Date: 4/27/99    Time: 5:36p
 * Updated in $/dev_1200/SA1_CoreLibs/sv_libs
 * Moved libd.h out.
 * 
 * *****************  Version 5  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 4:18p
 * Updated in $/development/sv_libs
 * update COPYRIGHT
 * 
 * *****************  Version 4  *****************
 * User: Lhui         Date: 5/07/98    Time: 11:09a
 * Updated in $/base_level2/sv_libs
 * Add Intel copyright 
 * 
 * *****************  Version 3  *****************
 * User: C-hqian      Date: 5/12/98    Time: 4:11p
 * Updated in $/base_level2/sv_libs
 * Kept LibD handle in order to delete later, when close library.
 * 
 * *****************  Version 2  *****************
 * User: C-hqian      Date: 4/30/98    Time: 3:25p
 * Updated in $/base_level2/sv_libs
 * Code development.
 * 
 * *****************  Version 1  *****************
 * User: C-hqian      Date: 4/28/98    Time: 1:54p
 * Created in $/base_level2/sv_libs
 * Memory service routine library.
 * 
 */ 
#ifndef MEMSV_H
#define MEMSV_H

#include "svlibs.h"

const int MEMSV_SUCCESS = 0x0;
const int MEMSV_BAD_HANDLE = 0x0;
const int MEMSV_FAIL = 0x0408;
const int MEMSV_MAX_THREADS = 24;

extern void *objHandle;

struct msvTASIn {
    int set;        // bits to test
    void* at;       // bit vector location
};

struct msvBuf {
    int len;        // byte count
    void* data;     // buffer location
};

struct msvBCopyIn {
    int len;        // byte count
    void* from;     // from buffer location
    void* to;       // bo buffer location
};

struct msvGatherIn {
    int count;      // number of from msvBufs at *from
    void* from;   // from buffers location, array of msvBufs
    void* to;       // bo buffer location
};

struct msvScatterIn {
    int count;      // number of from msvBufs at *to
    void* from;     // from buffer location
    void* to;     // to buffers location, array of msvBufs
};


#if defined(__cplusplus)
extern "C"
{
#endif

LibHandle* MemSv_Init(
    void* objHandle,    // a handle of uof file
    int appSrcId        // in multi apps, it identifies a specific app
);

int MemSv_TestAndSet(
    LibHandle* libHandle,
    msvTASIn* in,
    int* out
);

int MemSv_BZero(
    LibHandle* libHandle,
    msvBuf* in
);

int MemSv_BCopy(
    LibHandle* libHandle,
    msvBCopyIn* in
);

int MemSv_Gather(
    LibHandle* libHandle,
    msvGatherIn* in
);

int MemSv_scatter(
    LibHandle* libHandle,
    msvScatterIn* in
);

void MemSv_Close(
    LibHandle* libHandle
);

#if defined(__cplusplus)
} // extern "C" {
#endif



#endif /* MEMSV_H */
