/* hal_ueng.h
 * Ucode Uengine Interface Library -- Microengine Registers
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *
 *  system: SA1200
 *  subsystem: Debug Library
 *  author: drj, June 15,98  Initial version
 *  revisions:
 *  $History: hal_ueng.h $
 * 
 * *****************  Version 10  *****************
 * User: Drjohns1     Date: 9/23/99    Time: 9:51p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 8  *****************
 * User: Hqianx       Date: 7/23/99    Time: 8:29p
 * Updated in $/dev_1200/Include
 * Modified inline func to non inline func.
 * 
 * *****************  Version 7  *****************
 * User: Lhui         Date: 6/15/99    Time: 11:35a
 * Updated in $/dev_1200/Include
 * Add support for XACTIO
 * 
 * *****************  Version 6  *****************
 * User: Drjohns1     Date: 6/02/99    Time: 1:20p
 * Updated in $/dev_1200/Include
 * Modification per code-review
 * 
 * *****************  Version 5  *****************
 * User: Dhooper      Date: 5/12/99    Time: 6:18p
 * Updated in $/dev_1200/Include
 * explicit IOSTYLE #if around CSR access
 * 
 * *****************  Version 3  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 3:41p
 * Updated in $/development/hal_1200
 * update COPYRIGHT
 * 
 * *****************  Version 2  *****************
 * User: Drjohns1     Date: 3/05/99    Time: 8:54p
 * Updated in $/development/hal_1200
 * Updated for generic interrupt functions
 * 
 * *****************  Version 1  *****************
 * User: Drjohns1     Date: 3/05/99    Time: 3:38p
 * Created in $/development/hal_1200
 * 
 * *****************  Version 6  *****************
 * User: Drjohns1     Date: 3/04/99    Time: 5:44p
 * Updated in $/development/ueng
 * 
 * *****************  Version 5  *****************
 * User: Drjohns1     Date: 2/24/99    Time: 6:37p
 * Updated in $/development/ueng
 * 
 * *****************  Version 4  *****************
 * User: Drjohns1     Date: 2/12/99    Time: 5:53p
 * Updated in $/development/ueng
 * Updated for multi-chip/auto_ambio related changes
 * 
 * *****************  Version 3  *****************
 * User: Drjohns1     Date: 2/09/99    Time: 2:29p
 * Updated in $/development/ueng
 * Updated for breakpoint interupt
 * 
 * *****************  Version 2  *****************
 * User: Drjohns1     Date: 1/26/99    Time: 3:39p
 * Updated in $/development/ueng
 * Partitioned debug library
 * 
 * *****************  Version 1  *****************
 * User: Drjohns1     Date: 1/21/99    Time: 2:27p
 * Created in $/development/ueng
 * Partitioned debug library to create ueng interface library (ueng.lib)
 * 
 * *****************  Version 6  *****************
 * User: Drjohns1     Date: 12/07/98   Time: 9:31p
 * Updated in $/development/udebug
 * Initial release
 * 
 * *****************  Version 1  *****************
 * User: Drjohns1     Date: 7/01/98    Time: 2:01p
 * Created in $/users/Johnson/SA1200/udebug
 * 
 * ---------------------------------------------------------------------
 */
#ifndef __HAL_UENG_H
#define __HAL_UENG_H

#include <stdio.h>

#ifdef __cplusplus
#include "core_io.h"
#endif


/* Microengine CSR base addresses */
enum{
	UENG0_CSR_BASE_ADDR	= 0xb0000000,
	UENG1_CSR_BASE_ADDR = 0xb0000800,
	UENG2_CSR_BASE_ADDR = 0xb0001000,
	UENG3_CSR_BASE_ADDR	= 0xb0001800,
	UENG4_CSR_BASE_ADDR	= 0xb0002000,
	UENG5_CSR_BASE_ADDR	= 0xb0002800
};


/* Microengine SRAM Read Transfer Registers base addresses */
enum{
	UENG0_CTX0_SRAMXFER_BASE_ADDR = 0xb0004000,
	UENG0_CTX1_SRAMXFER_BASE_ADDR = 0xb0004020,
	UENG0_CTX2_SRAMXFER_BASE_ADDR = 0xb0004040,
	UENG0_CTX3_SRAMXFER_BASE_ADDR =	0xb0004060,

	UENG1_CTX0_SRAMXFER_BASE_ADDR = 0xb0004800,
	UENG1_CTX1_SRAMXFER_BASE_ADDR = 0xb0004820,
	UENG1_CTX2_SRAMXFER_BASE_ADDR =	0xb0004840,
	UENG1_CTX3_SRAMXFER_BASE_ADDR =	0xb0004860,

	UENG2_CTX0_SRAMXFER_BASE_ADDR =	0xb0005000,
	UENG2_CTX1_SRAMXFER_BASE_ADDR =	0xb0005020,
	UENG2_CTX2_SRAMXFER_BASE_ADDR =	0xb0005040,
	UENG2_CTX3_SRAMXFER_BASE_ADDR =	0xb0005060,

	UENG3_CTX0_SRAMXFER_BASE_ADDR =	0xb0005800,
	UENG3_CTX1_SRAMXFER_BASE_ADDR =	0xb0005820,
	UENG3_CTX2_SRAMXFER_BASE_ADDR =	0xb0005840,
	UENG3_CTX3_SRAMXFER_BASE_ADDR =	0xb0005860,

	UENG4_CTX0_SRAMXFER_BASE_ADDR =	0xb0006000,
	UENG4_CTX1_SRAMXFER_BASE_ADDR =	0xb0006020,
	UENG4_CTX2_SRAMXFER_BASE_ADDR =	0xb0006040,
	UENG4_CTX3_SRAMXFER_BASE_ADDR =	0xb0006060,

	UENG5_CTX0_SRAMXFER_BASE_ADDR =	0xb0006800,
	UENG5_CTX1_SRAMXFER_BASE_ADDR =	0xb0006820,
	UENG5_CTX2_SRAMXFER_BASE_ADDR =	0xb0006840,
	UENG5_CTX3_SRAMXFER_BASE_ADDR =	0xb0006860
};


/* Microengine CSR 32-bit word offset */
enum UengCsrByteOffsets{
	CS_ADDR_REG					= 0x0,
	CS_DATA_REG					= 0x4,

	ACTIVE_CTX_REG				= 0x10,
	FBOX_CSR_WRITE_SELF_ENABLE	= 0x14,

	FBOX_JOURNAL_ENABLE			= 0x18,

	CTX_ARB_CNTL				= 0x24,
	CTX_ENABLES					= 0x28,
	CC_ENABLE					= 0x2c,

	CTX_0_STS					= 0x34,
	CTX_1_STS					= 0x38,
	CTX_2_STS					= 0x3C,
	CTX_3_STS					= 0x41,

	CTX_0_SIG_EVENTS			= 0x44,
	CTX_1_SIG_EVENTS			= 0x48,
	CTX_2_SIG_EVENTS			= 0x4C,
	CTX_3_SIG_EVENTS			= 0x50,

	CTX_0_WAKEUP_EVENTS			= 0x54,
	CTX_1_WAKEUP_EVENTS			= 0x58,
	CTX_2_WAKEUP_EVENTS			= 0x5c,
	CTX_3_WAKEUP_EVENTS			= 0x60
};


#ifdef __cplusplus
class UengCSRs{
public:
	UengCSRs(){}
	~UengCSRs(){}



	inline void setUSTORE_ADDRESS(unsigned int val){WRITE_LWORD(&cs_addr_reg, val);}
	inline void getUSTORE_ADDRESS(unsigned int *val){READ_LWORD(&cs_addr_reg, val);}

	inline void setUSTORE_DATA(unsigned int val){WRITE_LWORD(&cs_data_reg, val);}
	inline void getUSTORE_DATA(unsigned int *val){READ_LWORD(&cs_data_reg, val);}

	inline void getALU_OUTPUT(unsigned int *val){READ_LWORD(&alu_out, val);}

	inline void setACTIVE_CTX_STS(unsigned int val){WRITE_LWORD(&active_ctx_sts, val);}
	inline void getACTIVE_CTX_STS(unsigned int *val){READ_LWORD(&active_ctx_sts, val);}

	inline void setFBOX_CSR_WRITE_SELF_ENABLE(unsigned int val){WRITE_LWORD(&fbox_csr_write_self_enable, val);}
	inline void getFBOX_CSR_WRITE_SELF_ENABLE(unsigned int *val){READ_LWORD(&fbox_csr_write_self_enable, val);}

	inline void setENABLE_SRAM_JOURNALING(unsigned int val){WRITE_LWORD(&enable_sram_journaling, val);}
	inline void getENABLE_SRAM_JOURNALING(unsigned int *val){READ_LWORD(&enable_sram_journaling, val);}

	inline void setCTX_ARB_CNTL(unsigned int val){WRITE_LWORD(&ctx_arb_cntl, val);}
	inline void getCTX_ARB_CNTL(unsigned int *val){READ_LWORD(&ctx_arb_cntl, val);}

	inline void setCTX_ENABLES(unsigned int val){WRITE_LWORD(&ctx_enables, val);}
	inline void getCTX_ENABLES(unsigned int *val){READ_LWORD(&ctx_enables, val);}

	inline void setCC_ENABLE(unsigned int val){WRITE_LWORD(&cc_enable, val);}
	inline void getCC_ENABLE(unsigned int *val){READ_LWORD(&cc_enable, val);}

	inline void setCTX_0_STS(unsigned int val){WRITE_LWORD(&ctx_0_sts, val);}
	inline void getCTX_0_STS(unsigned int *val){READ_LWORD(&ctx_0_sts, val);}

	inline void setCTX_1_STS(unsigned int val){WRITE_LWORD(&ctx_1_sts, val);}
	inline void getCTX_1_STS(unsigned int *val){READ_LWORD(&ctx_1_sts, val);}

	inline void setCTX_2_STS(unsigned int val){WRITE_LWORD(&ctx_2_sts, val);}
	inline void getCTX_2_STS(unsigned int *val){READ_LWORD(&ctx_2_sts, val);}

	inline void setCTX_3_STS(unsigned int val){WRITE_LWORD(&ctx_3_sts, val);}
	inline void getCTX_3_STS(unsigned int *val){READ_LWORD(&ctx_3_sts, val);}


	inline void setCTX_0_SIG_EVENTS(unsigned int val){WRITE_LWORD(&ctx_0_sig_events, val);}
	inline void getCTX_0_SIG_EVENTS(unsigned int *val){READ_LWORD(&ctx_0_sig_events, val);}

	inline void setCTX_1_SIG_EVENTS(unsigned int val){WRITE_LWORD(&ctx_1_sig_events, val);}
	inline void getCTX_1_SIG_EVENTS(unsigned int *val){READ_LWORD(&ctx_1_sig_events, val);}

	inline void setCTX_2_SIG_EVENTS(unsigned int val){WRITE_LWORD(&ctx_2_sig_events, val);}
	inline void getCTX_2_SIG_EVENTS(unsigned int *val){READ_LWORD(&ctx_2_sig_events, val);}

	inline void setCTX_3_SIG_EVENTS(unsigned int val){WRITE_LWORD(&ctx_3_sig_events, val);}
	inline void getCTX_3_SIG_EVENTS(unsigned int *val){READ_LWORD(&ctx_3_sig_events, val);}

	inline void setCTX_0_WAKEUP_EVENTS(unsigned int val){WRITE_LWORD(&ctx_0_wakeup_events, val);}
	inline void getCTX_0_WAKEUP_EVENTS(unsigned int *val){READ_LWORD(&ctx_0_wakeup_events, val);}

	inline void setCTX_1_WAKEUP_EVENTS(unsigned int val){WRITE_LWORD(&ctx_1_wakeup_events, val);}
	inline void getCTX_1_WAKEUP_EVENTS(unsigned int *val){READ_LWORD(&ctx_1_wakeup_events, val);}

	inline void setCTX_2_WAKEUP_EVENTS(unsigned int val){WRITE_LWORD(&ctx_2_wakeup_events, val);}
	inline void getCTX_2_WAKEUP_EVENTS(unsigned int *val){READ_LWORD(&ctx_2_wakeup_events, val);}

	inline void setCTX_3_WAKEUP_EVENTS(unsigned int val){WRITE_LWORD(&ctx_3_wakeup_events, val);}
	inline void getCTX_3_WAKEUP_EVENTS(unsigned int *val){READ_LWORD(&ctx_3_wakeup_events, val);}


private:											// word-offset: hex byte offset:
	unsigned int cs_addr_reg;						//		0			0x0
	unsigned int cs_data_reg;						//		1			0x4
	unsigned int alu_out;							//		2			0x8
	unsigned int reserve1;							//		3			0xC
	unsigned int active_ctx_sts;					//		4			0x10
	unsigned int fbox_csr_write_self_enable;		//		5			0x14
	unsigned int enable_sram_journaling;			//		6			0x18
	unsigned int reserve2[2];						//		7 & 8		0x1C-0x20
	unsigned int ctx_arb_cntl;						//		9			0x24
	unsigned int ctx_enables;						//		10			0x28
	unsigned int cc_enable;							//		11			0x2C
	unsigned int reserve3;							//		12			0x30
	unsigned int ctx_0_sts;							//		13			0x34
	unsigned int ctx_1_sts;							//		14			0x38
	unsigned int ctx_2_sts;							//		15			0x3C
	unsigned int ctx_3_sts;							//		16			0x40
	unsigned int ctx_0_sig_events;					//		17			0x44
	unsigned int ctx_1_sig_events;					//		18			0x48
	unsigned int ctx_2_sig_events;					//		19			0x4C
	unsigned int ctx_3_sig_events;					//		20			0x50
	unsigned int ctx_0_wakeup_events;				//		21			0x54
	unsigned int ctx_1_wakeup_events;				//		22			0x58
	unsigned int ctx_2_wakeup_events;				//		23			0x5C
	unsigned int ctx_3_wakeup_events;				//		24			0x60
};

class SramXferReg{
public:
	SramXferReg(){}
	~SramXferReg(){}

	void setSramXferReg(unsigned short regNum, unsigned int val);
	void getSramXferReg(unsigned short regNum, unsigned int *val);

private:										// word-offset:
	unsigned int xfer_reg_0;					//		0
	unsigned int xfer_reg_1;					//		1
	unsigned int xfer_reg_2;					//		2
	unsigned int xfer_reg_3;					//		3
	unsigned int xfer_reg_4;					//		4
	unsigned int xfer_reg_5;					//		5
	unsigned int xfer_reg_6;					//		6
	unsigned int xfer_reg_7;					//		7
};
					// __cplusplus

#endif

#endif			// __HAL_UENG_H
