/* hal_sdram.h
 * SA1200 Hardware Absraction Library -- SDRAM
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *
 *  system: SA1200
 *  subsystem: Debug Library
 *  author: dfh, Feb 24, 99  Initial version
 *  revisions:
 *  $History: hal_sdram.h $
 * 
 * *****************  Version 15  *****************
 * User: Dmwhite      Date: 4/05/00    Time: 4:37p
 * Updated in $/dev_1200/Include
 * took out some unwanted comments
 * 
 * *****************  Version 14  *****************
 * User: Drjohns1     Date: 2/29/00    Time: 1:15p
 * Updated in $/dev_1200/Include
 * Made "C" compatable
 * 
 * *****************  Version 10  *****************
 * User: Dhooper      Date: 5/14/99    Time: 9:26a
 * Updated in $/BL5_Plus/Include
 * change SRAM, SDRAM, FBI_Init to *_Attach
 * 
 * *****************  Version 9  *****************
 * User: Dhooper      Date: 5/12/99    Time: 12:48p
 * Updated in $/dev_1200/Include
 * update to match programmer's ref spec as of 5/10/99
 * 
 * *****************  Version 8  *****************
 * User: Dhooper      Date: 5/11/99    Time: 5:25p
 * Updated in $/dev_1200/Include
 * enforce IOSTYLE FARDWARE or AMBAIO for CSR access
 * 
 * *****************  Version 7  *****************
 * User: Dhooper      Date: 5/10/99    Time: 12:35p
 * Updated in $/dev_1200/Include
 * init function call
 * 
 * *****************  Version 6  *****************
 * User: Dhooper      Date: 5/07/99    Time: 1:21p
 * Updated in $/dev_1200/Include
 * IOSTYLE implemented
 * 
 * *****************  Version 4  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 3:41p
 * Updated in $/development/hal_1200
 * update COPYRIGHT
 * 
 * *****************  Version 3  *****************
 * User: Dhooper      Date: 3/08/99    Time: 6:40p
 * Updated in $/development/hal_1200
 * add console read write functions
 * 
 * *****************  Version 2  *****************
 * User: Dhooper      Date: 3/05/99    Time: 6:05p
 * Updated in $/development/hal_1200
 * read write to sdram non prefetch  and xactio
 * 
 * *****************  Version 1  *****************
 * User: Dhooper      Date: 2/26/99    Time: 5:46p
 * Created in $/development/hal_1200
 * sdram and sram HAL
 * 
 * 
 * ---------------------------------------------------------------------
 */
#ifndef HAL_SDRAM_H
#define HAL_SDRAM_H


#include "core_io.h"
#include "xact_api.h"

#if (IOSTYLE==XACTIO)

#define SDRAM_WRITE(addr, val) XactFastWrite(SDRAM, (unsigned int)val, (int) addr);
#define SDRAM_READ(addr, val) XactFastRead(SDRAM, (int)addr, (unsigned int *)val);

#else

#define SDRAM_WRITE(addr, val) WRITE_LWORD((addr<<2)+SDRAM_NON_PREFETCH_BEGIN, val)
#define SDRAM_READ(addr, val) READ_LWORD((addr<<2)+SDRAM_NON_PREFETCH_BEGIN, val)

#endif

#define HAL_SDRAM_SUCCESS 1

enum SdramAddresses{
	SDRAM_CSR_BASE =			0xFF000000,
	CACHE_FLUSH_AREA_BEGIN =	0xE0000000,
	CACHE_FLUSH_AREA_END =		0xE0FFFFFF,
	SDRAM_PREFETCH_BEGIN =		0xD0000000,
	SDRAM_PREFETCH_END =		0xD1FFFFFF,
	SDRAM_NON_PREFETCH_BEGIN =	0xC0000000,
	SDRAM_NON_PREFETCH_END =	0xC1FFFFFF
};


enum SdramCsrByteOffsets{
	SDRAM_CSR =					0x0,
	SDRAM_MEM_CTL0 =			0x4,
	SDRAM_MEM_CTL1 =			0x8,
	SDRAM_MEM_INIT =			0xC
};


#ifdef __cplusplus

class SdramUnit{
public:
	SdramUnit(){}
	~SdramUnit(){}

#if ((IOSTYLE==HARDWARE)||(IOSTYLE==AMBAIO))

	inline void setSDRAM_CSR(unsigned int val){WRITE_LWORD(&sdram_csr, val);}
	inline void getSDRAM_CSR(unsigned int *val){READ_LWORD(&sdram_csr, val);}

	inline void setSDRAM_MEM_CTL0(unsigned int val){WRITE_LWORD(&sdram_mem_ctl0, val);}
	inline void getSDRAM_MEM_CTL0(unsigned int *val){READ_LWORD(&sdram_mem_ctl0, val);}

	inline void setSDRAM_MEM_CTL1(unsigned int val){WRITE_LWORD(&sdram_mem_ctl1, val);}
	inline void getSDRAM_MEM_CTL1(unsigned int *val){READ_LWORD(&sdram_mem_ctl1, val);}

	inline void setSDRAM_MEM_INIT(unsigned int val){WRITE_LWORD(&sdram_mem_init, val);}
	inline void getSDRAM_MEM_INIT(unsigned int *val){READ_LWORD(&sdram_mem_init, val);}

#endif		//((IOSTYLE==HARDWARE)||(IOSTYLE==AMBAIO))

	inline void write(unsigned int lwaddr, unsigned int val){SDRAM_WRITE(lwaddr, val);}
	inline void read(unsigned int lwaddr, unsigned int *val){SDRAM_READ(lwaddr, val);}

private:											// word offset: hex byte offset:
	unsigned int sdram_csr;							//		0			0x0
	unsigned int sdram_mem_ctl0;					//		1			0x4
	unsigned int sdram_mem_ctl1;					//		2			0x8
	unsigned int sdram_mem_init;					//		3			0xC
};

extern SdramUnit *SDRAM_Attach();


extern "C"
{
#endif		// __cplusplus


extern void SDRAM_Write(unsigned int addr, unsigned int val);
extern unsigned int SDRAM_Read(unsigned int addr);


#if defined(__cplusplus)
}
#endif			// __cplusplus

#endif			// HAL_SDRAM_H // leave extra blank line here

