/* hal_pci.h
 * Hardware Abstraction Layer -- PCI
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *
 *  system: SA1200
 *  subsystem: Debug Library
 *  author: drj, June 15,98  Initial version
 *  revisions:
 *  $History: hal_pci.h $
 * 
 * *****************  Version 6  *****************
 * User: Lhui         Date: 6/15/99    Time: 11:35a
 * Updated in $/dev_1200/Include
 * Add support for XACTIO
 * 
 * *****************  Version 5  *****************
 * User: Dhooper      Date: 5/12/99    Time: 6:18p
 * Updated in $/dev_1200/Include
 * explicit IOSTYLE #if around CSR access
 * 
 * *****************  Version 3  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 3:41p
 * Updated in $/development/hal_1200
 * update COPYRIGHT
 * 
 * *****************  Version 2  *****************
 * User: Drjohns1     Date: 3/05/99    Time: 8:54p
 * Updated in $/development/hal_1200
 * Updated for generic interrupt functions
 * 
 * *****************  Version 1  *****************
 * User: Drjohns1     Date: 3/05/99    Time: 4:06p
 * Created in $/development/hal_1200
 * 
 * *****************  Version 2  *****************
 * User: Qabuild      Date: 2/01/99    Time: 12:05p
 * Updated in $/development/ueng
 * replace // with /* 
 * 
 * *****************  Version 1  *****************
 * User: Drjohns1     Date: 1/21/99    Time: 2:27p
 * Created in $/development/ueng
 * Partitioned debug library to create ueng interface library (ueng.lib)
 * 
 * *****************  Version 6  *****************
 * User: Drjohns1     Date: 12/07/98   Time: 9:31p
 * Updated in $/development/udebug
 * Initial release
 * 
 * *****************  Version 1  *****************
 * User: Drjohns1     Date: 7/01/98    Time: 2:01p
 * Created in $/users/Johnson/SA1200/udebug
 * 
 * ---------------------------------------------------------------------
 */
#ifndef __HAL_PCI_H
#define __HAL_PCI_H


/* PCI CSR core-accessable register base */
enum {PCI_REG_BASE_ADDR	= 0x42000000};

#define RESET_ENABLE_REG	(PCI_REG_BASE_ADDR + 0x7c)


#ifdef __cplusplus
#include "core_io.h"

/* This Class is a partial implementation of the PCI core-accessible registers
/* starting at address 0x42000000 + 0x7c
/* PCI register */
class PciCSRs {
public:
	PciCSRs(){}
	~PciCSRs(){}


	inline void setResetReg(unsigned int val){WRITE_LWORD(&reset_enable_reg, val);}
	inline void getResetReg(unsigned int *val){READ_LWORD(&reset_enable_reg, val);}


private:
	unsigned int reset_enable_reg;
};

#endif					/* __cplusplus */

#endif					/* __HAL_PCI_H */
