//---------------------------------------------------------------------------
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  1998-2000 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
//---------------------------------------------------------------------------
// stdfunc.uc
// standard microcode functions
//
//
// system: IXP1200
// subsystem: microcode common funtions
// usage: common code called as functions
// author: dfh	Apr 5, 1999
// revisions:


#ifndef STDFUNC_UC
#define STDFUNC_UC


// std functions
//		These functions may be used to conserve on microcode, They are entered by
//		setting up the arguments in tempb, tempc, tempd (as necessary),
//		tempa holds the link_pc
//		and then issuing balr[].
//
//		Assumptions: tempa tempb and tempc are available registers
//




#ifdef HASH_FUNC
// hashdb_resolve_func
//		resolve a hashdb conflict to get a pointer to a database entry, or 0 if no entry
//		args:
//		arg_hash_rem		up to 32 bits of hash result remainder
//		arg_lookup_result	return value of previous lookup
//		arg_freelist_id		L2 freelist id	
//		
//		called by: hashdb_resolve in stdmac.uc
//
.subroutine
hashdb_resolve_func#:
.operand_synonym link_pc tempa
.operand_synonym arg_hash_rem tempb
.operand_synonym arg_lookup_result tempc
.operand_synonym arg_L2_base tempd

	hashdb_lookup_L2[arg_hash_rem, arg_lookup_result, arg_L2_base]
	rtn[link_pc]
.endsub
#endif			// HASH_FUNC

#endif // STDFUNC_UC