//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  2000 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
// sram.uc
// macros to access sram 
//
//
// system: IXP1200
// subsystem: utility microcode
// usage: library macros
// author: dfh	May 1, 2000
//
// revisions:


#ifndef SRAM_UC
#define SRAM_UC


// API:
//	sram_read[_xfer, _base_lw_addr, _lw_offset, const_lw_count, sig_spec]
//	sram_write[_xfer, _base_lw_addr, _lw_offset, const_lw_count, sig_spec]


// sram_read
//		description: Read from sram.
//		outputs:
//			_xfer			first sram xfer reg of sequence to read to
//		inputs:
//			_base_lw_addr	base longword address
//			_lw_offset		longword offset
//			const_lw_count	longword count
//			sig_spec		pend:  waiting on signal, context swap
//							sig:   requesting signal, but continuing
//							nosig: not requesting signal, continuing
//
//
#macro	sram_read[_xfer, _base_lw_addr, _lw_offset, const_lw_count, sig_spec]
#if (isnum(sig_spec))
	sram[read, _xfer, _base_lw_addr, _lw_offset, const_lw_count]
#else
	sram[read, _xfer, _base_lw_addr, _lw_offset, const_lw_count], sig_spec
#endif
#endm


// sram_write
//		description: Write to sram.
//		outputs:
//			_xfer			first sram xfer reg of sequence to write from
//		inputs:
//			_base_lw_addr	base longword address
//			_lw_offset		longword offset
//			const_lw_count	longword count
//			sig_spec		pend:  waiting on signal, context swap
//							sig:   requesting signal, but continuing
//							nosig: not requesting signal, continuing
//
#macro	sram_write[_xfer, _base_lw_addr, _lw_offset, const_lw_count, sig_spec]

#if (isnum(sig_spec))
	sram[write, _xfer, _base_lw_addr, _lw_offset, const_lw_count]
#else
	sram[write, _xfer, _base_lw_addr, _lw_offset, const_lw_count], sig_spec
#endif
#endm


#endif // SRAM_UC