//------------------------------------------------------------------------------------
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  1998-2000 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
//-----------------------------------------------------------------------------------
// msgq.uc
// IXPblock message queue macros
//
//
// system: IXP1200
// subsystem: IO microcode
// usage: library macros
// author: dfh Jan 12, 1999	
//
// revisions:	dfh Apr 6, 2000		separated from stdmac.uc


#ifndef MSGQ_UC
#define MSGQ_UC



//------------------------------MESSAGE macros----------------------------
//
// each message is 1 longword, with bit 31 reserved as an invalid bit
// location 0 of the msgq must be initialized to 0x80000000 to make it invalid
// when assembling the message, bit 31=0 indicates the message is valid
//
// 17 locations are used for a messageq 16 deep
// the messageq starts at msg_base_addr, and msg_id index increments by 4
// using +4 nibble add
// this results in circular messageq 0-16, 1-16, 1-16, etc.
//
#define MSGQ_SIZE 16

// msg_send
// send message to mailbox
//
#macro msg_send[xfer_reg, msg_base_addr, msg_id, const_sync]
#ifdef SRAM_MSG

#if (const_sync = SYNC)
	sram[write, xfer_reg, msg_base_addr, msg_id, 1], ctx_swap
#elif (const_sync = ASYNC)
	sram[write, xfer_reg, msg_base_addr, msg_id, 1], sig_done
#else
	sram[write, xfer_reg, msg_base_addr, msg_id, 1]
#endif

#else

#if (const_sync = SYNC)
	scratch[write, xfer_reg, msg_base_addr, msg_id, 1], ctx_swap
#elif (const_sync = ASYNC)
	scratch[write, xfer_reg, msg_base_addr, msg_id, 1], sig_done
#else
	scratch[write, xfer_reg, msg_base_addr, msg_id, 1]
#endif

#endif
#endm

// msgq_send
// send message to next slot on circular message queue
//	this assumes that queue is large enough that receiver takes messages
//	or is blocked so that messages won't overwrite
//  increment circular message queue pointer: msg_id
//
#macro msgq_send[xfer_reg, msg_base_addr, msg_id, const_sync]
	msg_send[xfer_reg, msg_base_addr, msg_id, const_sync]
	alu[msg_id, 1, +4, msg_id]					; 17 addresses then wrap
#endm



// msg_receive
// place message from (offset+msg_base) in xfer_reg
// test_and_set_bits is used to retrieve the message
//
#macro msg_receive[xfer_reg, msg_base_addr, msg_id, const_sync]
#ifdef SRAM_MSG

#if (const_sync = ASYNC)
	sram[bit_wr, xfer_reg, msg_base_addr, msg_id, test_and_set_bits], sig_done
#elif (const_sync = SYNC)
	sram[bit_wr, xfer_reg, msg_base_addr, msg_id, test_and_set_bits], ctx_swap
#else
	sram[bit_wr, xfer_reg, msg_base_addr, msg_id, test_and_set_bits]
#endif

#else

#if (const_sync = ASYNC)
	scratch[bit_wr, xfer_reg, msg_base_addr, msg_id, test_and_set_bits], sig_done
#elif (const_sync = SYNC)
	scratch[bit_wr, xfer_reg, msg_base_addr, msg_id, test_and_set_bits], ctx_swap
#else
	scratch[bit_wr, xfer_reg, msg_base_addr, msg_id, test_and_set_bits]
#endif

#endif
#endm


// msgq_receive
// get message. If invalid. repeat get message
// if valid, increment circular message queue pointer: msg_id
//
#macro msgq_receive[xfer_reg, msg_base_addr, msg_id, const_sync]
do#:
	msg_receive[xfer_reg, msg_base_addr, msg_id, const_sync]
	alu_shf[--, --, B, xfer_reg, >>31]
	br=0[do#]
	alu[msg_id, 1, +4, msg_id]					; 17 addresses then wrap
#endm


// msgq_wait
// for ASYNC messages, wait for completion of the previous send or receive request
//
#macro msgq_wait
#ifdef SRAM_MSG
	ctx_arb[sram]
#else
	ctx_arb[fbi]
#endif
#endm


// msgq_init
//	initialize all mailbox slots in the message queue to invalid
//
#macro msgq_init[write_xfer, msg_base_addr, const_sync]
	immed32[write_xfer, 0x80000000]
.local count
	immed[count, MSGQ_SIZE]
	.while (count > 0)
	msg_send[write_xfer, msg_base_addr, count, SYNC]
	alu[count, count, -, 1]
	.endw
.endlocal
	msg_send[write_xfer, msg_base_addr, count, const_sync]

#endm

#endif // MSGQ_UC