//------------------------------------------------------------------------------------
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  1999-2000 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
//-----------------------------------------------------------------------------------
// hashdb.uc
// IXPblock hash database access macros
//
//
// system: IXP1200
// subsystem: IO microcode
// usage: library macros
// author: dfh Mar 30, 1999	
//
// revisions:	dfh Apr 6, 2000		separated from stdmac.uc


#ifndef HASHDB_UC
#define HASHDB_UC

// API:
//		hashdb_add48		hash database add using 48 bit index
//		hashdb_add64		hash database add using 64 bit index
//		hashdb_lookup48		hash database lookup using 48 bit index
//		hashdb_lookup64		hash database lookup using 64 bit index
//		hashdb_lookup_L2	hash database lookup level 2 tables
//		hashdb_resolve		hash database lookup level 2 tables
//
//
//		FREELIST*_BASE for each freelist associates that freelist with a block of memory
//			note: freelist 0 is an exception in that it associates with 2 blocks, in sram and sdram
//
// (2 freelists are needed per hash database, one for L2 and one for database entries)
//		

// get base address associated with a freelist
//
#macro _get_db_base[db_base_addr, freelist_id]
#define_eval THIS_ID freelist_id

#if (freelist_id == 0)
	immed32[db_base_addr, FREELIST0_BASE]
#elif (freelist_id == 1)
	immed32[db_base_addr, FREELIST1_BASE]
#elif (freelist_id == 2)
	immed32[db_base_addr, FREELIST2_BASE]
#elif (freelist_id == 3)
	immed32[db_base_addr, FREELIST3_BASE]
#elif (freelist_id == 4)
	immed32[db_base_addr, FREELIST4_BASE]
#elif (freelist_id == 5)
	immed32[db_base_addr, FREELIST5_BASE]
#elif (freelist_id == 6)
	immed32[db_base_addr, FREELIST6_BASE]
#elif (freelist_id == 7)
	immed32[db_base_addr, FREELIST7_BASE]
#endif

#endm

// get base address associated with a freelist
//
#macro _get_L2_base[L2_base_addr, freelist_id]

#if (freelist_id == 0)
	immed32[L2_base_addr, FREELIST0_BASE]
#elif (freelist_id == 1)
	immed32[L2_base_addr, FREELIST1_BASE]
#elif (freelist_id == 2)
	immed32[L2_base_addr, FREELIST2_BASE]
#elif (freelist_id == 3)
	immed32[L2_base_addr, FREELIST3_BASE]
#elif (freelist_id == 4)
	immed32[L2_base_addr, FREELIST4_BASE]
#elif (freelist_id == 5)
	immed32[L2_base_addr, FREELIST5_BASE]
#elif (freelist_id == 6)
	immed32[L2_base_addr, FREELIST6_BASE]
#elif (freelist_id == 7)
	immed32[L2_base_addr, FREELIST7_BASE]
#endif

#endm

#define L2_SHIFT_AMOUNT 4
#define L2_SHIFT_MASK 0xf
#define_eval INV_L2_SHIFT_AMOUNT (32 - L2_SHIFT_AMOUNT)

// _hashdb_add_level2
//
//
#macro	_hashdb_add_level2[hash_rem, lookup, L2_freelist, L2_hash_base, db_freelist, xfer0, sd_xfer0, sd_xfer1]

.local tempa tempb table_sel index saved_hash_rem bit_pos

	move[saved_hash_rem, hash_rem]
	immed[bit_pos, 0]

hash_add_loop#:
	alu_shf[index, lookup, +L2_SHIFT_AMOUNT, hash_rem]					; shift table sel and add masked hash_result
   
    sram[read, xfer0, L2_hash_base, index, 1], ctx_swap, optimize_mem	; read L2 table with tableptr+hash_rem
    alu[lookup, 0, b, xfer0]

	br!=0[entry_or_collision#]

// if no entry, add entry
	malloc[lookup, db_freelist,  xfer0]						; get next database index (mem_ptr, freelist, xfer)
	move[xfer0, lookup]
	sram[write, xfer0, L2_hash_base, index, 1], ctx_swap	; write the new entry database index to L2
	br[done#]

// if collision bit set, add the entry to L2
//
entry_or_collision#:
	alu[--, xfer0, AND, 1, <<31]
	br=0[entry_and_no_collision#]

// existing entry and collision
//
	alu[bit_pos, bit_pos, +, L2_SHIFT_AMOUNT]				; increment pointer into hash_rem
	alu[--, bit_pos, -, 1, <<5]								; compare to 32
	br=0[exit#]												; for 64 bit add, exit to caller							

	alu[lookup, --, B, lookup, <<2]
	alu[lookup, --, B, lookup, >>7]							; get just the tableptr
    br[hash_add_loop#], defer[1]
	alu[hash_rem, --, B, hash_rem, >>L2_SHIFT_AMOUNT]

// existing entry and no collision, get existing entry hash_rem and loop
//
entry_and_no_collision#:
	malloc[level2_index, L2_freelist, xfer0]				; get new level2 table index
	alu[level2_index, level2_index, -, L2_hash_base]		; get offset

// insert the original entry in the new L2 table
	_get_db_base[db_hash_base, db_freelist]					; pointer to the db table
	alu[tempa, 1, +, lookup]								; read the second quadword to get hash_rem
	sdram[read, sd_xfer0, db_hash_base, tempa, 1], ctx_swap, defer[1]	; read database (will return 2 longwords)
	alu[bit_pos, bit_pos, +, L2_SHIFT_AMOUNT]
	.if (saved_hash_rem == sd_xfer1)
		br[exit#]											; use existing lookup_result
	.endif
	alu[--, bit_pos, B, 0]									; setup indirect right shift amount
	alu_shf[tempa, L2_SHIFT_MASK, AND, sd_xfer1, >>indirect]; shift to get next bits of hash remainder
	alu_shf[tempb, tempa, +, level2_index]
	move[xfer0, lookup]
    sram[write, xfer0, L2_hash_base, tempb, 1], ctx_swap	; write original entry to new L2 table

// write the L2 collision entry
	alu[lookup, INV_L2_SHIFT_AMOUNT, OR, level2_index, <<5]					; insert L2 index and shift amt
	alu[xfer0, lookup, OR, 1, <<31]							; insert collision
	sram[write, xfer0, L2_hash_base, index, 1], ctx_swap	; write the collision info to L2

// iterate on new entry
	alu[lookup, --, B, level2_index]
    br[hash_add_loop#], defer[1]
	alu[hash_rem, --, B, hash_rem, >>L2_SHIFT_AMOUNT]
	

done#:
	move[sd_xfer0, 0]
	move[sd_xfer1, saved_hash_rem]
	sdram[write, sd_xfer0, 1, lookup, 1], ctx_swap			; write hash_rem to database
exit#:
.endlocal
#endm


// hashdb_add48
//		Add new hash entry using hashed 48 bit value, by creating table lookups
//		lookup_result will point to database entry, so parameters can be inserted there
//		See also: hashdb_lookup48
//
//	parameters:
//		hashr_hi_xfer		hashed_result <47:32>
//		hashr_lo_xfer		hashed_result <31:0>
//		L1_base				level 1 table base constant, 32 bits
//		L2_freelist			id of level 2 freelist (1-7)
//		db_freelist			id of database freelist (1-7)
//		lookup_result		index to database
//
#macro hashdb_add48[hashr_hi_xfer, hashr_lo_xfer, L1_base, L2_freelist, db_freelist, lookup_result, sd_xfer0, sd_xfer1]

.local tempc tempd hash_rem level2_index L2_hash_base db_hash_base L1_addr
.operand_synonym xfer0 hashr_hi_xfer					; note: reusing hashr_hi_xfer
.operand_synonym xfer1 hashr_lo_xfer					; note: reusing hashr_lo_xfer

	_get_db_base[db_hash_base, db_freelist]				; pointer to the db table

    ld_field_w_clr[hash_rem, 0011, hashr_lo_xfer, >>16]
    ld_field[hash_rem, 1100, hashr_hi_xfer, <<16]		; concatenate hash remainder

	immed32[tempd, L1_base]
	ld_field_w_clr[tempc, 0011, hashr_lo_xfer]			; table index = low 16 bits of hash result
	alu[L1_addr, tempd, +, tempc]
    sram[read, xfer0, L1_addr, 0, 1], ctx_swap, optimize_mem ; lookup SRAM_L1 hash

	alu[--, --, B, xfer0]
	br!=0[entry_or_collision#]

// if lookup_xfer is 0, there is no entry, so enter a new one
//
	malloc[lookup_result, db_freelist, xfer1]			; get next database index
	move[xfer1, lookup_result]
	sram[write, xfer1, tempc, tempd, 1], ctx_swap		; write the database index
	br[L1done#]

// if collision bit set, add the entry to L2
//
entry_or_collision#:
	alu[--, xfer0, AND, 1, <<31]
	br=0[entry_and_no_collision#]

// collision and existing entry 
	ld_field_w_clr[level2_index, 0111, xfer0, >>5]
	_get_L2_base[L2_hash_base, L2_freelist]
	br[lookup_L2#]

// no collision and existing entry,
//		get L2 table
//		set collision bit
//		insert pointer to L2
//		shift amount = L2_SHIFT_AMOUNT (4 or 8, level 2 tables are 16 or 256 entries). 
//			insert INV_L2_SHIFT_AMOUNT, 28 or 24 (32-L2_SHIFT_AMOUNT) for faster lookup later
//			add both entries to L2
entry_and_no_collision#:
	_get_L2_base[L2_hash_base, L2_freelist]
	malloc[level2_index, L2_freelist, xfer1]				; get next level2 table index
	alu[level2_index, L2_hash_base, B-A, level2_index]		; get offset

// insert original entry into level2
	alu[tempc, 1, +, xfer0]									; read the second quadword to get hash_rem
	sdram[read, sd_xfer0, db_hash_base, tempc, 1], ctx_swap	; read database
	alu_shf[tempc, L2_SHIFT_MASK, AND, sd_xfer1]			; get lo 4 or 8 bits of hash remainder
	.if (hash_rem == sd_xfer1)
		br[end#]											; use existing lookup_result
	.endif
	alu_shf[tempd, tempc, +, level2_index]
	move[xfer0, xfer0]
    sram[write, xfer0, L2_hash_base, tempd, 1], ctx_swap	; write original entry to new L2 table

// write the collision entry
	alu[lookup_result, INV_L2_SHIFT_AMOUNT, OR, level2_index, <<5]	; insert L2 index and shift amt
	alu[xfer0, lookup_result, OR, 1, <<31]					; insert collision
	sram[write, xfer0, L1_addr, 0, 1], ctx_swap				; write the collision info to L1


// iterate on new entry
lookup_L2#:
	move[lookup_result, level2_index]
	_hashdb_add_level2[hash_rem, lookup_result, L2_freelist, L2_hash_base, db_freelist, xfer0, sd_xfer0, sd_xfer1]
	br[end#]

L1done#:
	move[sd_xfer0, 0]
	move[sd_xfer1, hash_rem]
	alu[tempc, lookup_result, +, 1]
	sdram[write, sd_xfer0, db_hash_base, tempc, 1], ctx_swap	; write hash_rem to database
end#:
.endlocal	
#endm


#macro hashdb_lookup_L2[hash_rem, lookup_result, L2_hash_base]
.local tempa tempb

// solve_hash_conflict
// inputs:
//     lookup_xfer  - value from hash table lookup
//			<30>	- lock bit		entry not valid (update from core in progress)
//          <31>	- collision bit 
//              =0 in this case, means no entry, bail out
//              =1 collision
//          <29>    MBZ
//          <28:5>  L2_table select - 16 bits
//          <4:0>   L2_shift - hash table index shift left amount - 5 bits.  Format is 32-shift left amount
//            
//
//     hash_rem - output of L1 hash, shifted right 16 (32 bits)
//     sram_L2_addr_hash_base
// 
// outputs:
//     if a collision found and resolved:
//			lookup_xfer - forwarding table index
//		if not resolved, no entry
//			lookup_xfer = 0
//
.local table_sel index

hash_lookup_loop#:
	ld_field_w_clr[table_sel, 0111, lookup_result, >>5]		; table_sel in 23:0

// note: table shift value in <5:0> is stored as left shift indirect value (32-n)
	alu[index, --, ~B, 0]									; generate -1
	alu_shf[index, hash_rem, AND, index, >>INV_L2_SHIFT_AMOUNT]	; mask hash result with -1 shifted by lookup_xfer<4;0>

	alu_shf[index, index, +, table_sel]						; add masked hash_result to table sel
   
    sram[read, $xfer7, L2_hash_base, index, 1], defer[1], ctx_swap, optimize_mem
	alu_shf[hash_rem, --, B, hash_rem, >>L2_SHIFT_AMOUNT]	; get new hash_rem
	move[lookup_result, $xfer7]

    br<0[hash_lookup_loop#]			  						; check for empty (=0) or conflict (<31> = 1)
.endlocal

hash_resolved#:
.endlocal
#endm


// hashdb_resolve
//	function call to resolve level 2 conflict
//	calls hash_resolve48_func in stdfunc.uc
//
#macro hashdb_resolve[hashr_hi_xfer, hashr_lo_xfer, lookup_result, const_L2_base]
    ld_field_w_clr[tempb, 0011, hashr_lo_xfer, >>16]
    alu[tempb, tempb, or, hashr_hi_xfer, <<16]				; concatenate hash remainder
	move[tempc, lookup_result]
	immed32[tempd, const_L2_base]
	balr[tempa, hashdb_resolve_func#]

	move[lookup_result, tempc]
#endm


// hashdb_lookup48
//		Resolve 48 bit hash via table lookups to get an index to database.
//	Prerequisites:
//		1. Load 48 bit hash multiplier. This is chosen so as to get high likelyhood
//			of no conflict on low hash argument bits <15:0>
//		2. Add hash entries to table using Bridge Manager spanning tree or other L1/L2 table management
//			This creates the lookups in L1 and L2 tables.
//			The L1 table is an index lookup into a 64K entry table using hash_result<15:0>
//			If collision occurs, do sequence of L2 lookups (see below)
//			L2 consists of many small tables, e.g. 16 or 256 entry
//			For example, if tables are 16 entry, each L2 lookup would take the next 4 bits
//				of hash remainder.
//			If the lookup returns 0, there is no entry in the table.
//			If the lookup has sign bit<31>, there is a collision and 
//				hash_rem (shift_mt) is added to L2 index<<shift_amt, and another L2 lookup is preformed
//			Otherwise the lookup contains an index to the database.
//		3. Perform hardware hash function to get a 48 bit hash result
//				  <47:32> in hashr_hi_xfer, <31:0> in hashr_lo_xfer
//

#macro hashdb_lookup48[hashr_hi_xfer, hashr_lo_xfer, const_L1_base, const_L2_base, lookup_result]
.local tempa tempb hash_rem reg_L2_base 

    ld_field[hash_rem, 0011, hashr_lo_xfer, >>16]
    alu[hash_rem, hash_rem, OR, hashr_hi_xfer, <<16]	; concatenate hash remainder

	immed32[tempb, const_L1_base]
	ld_field_w_clr[tempa, 0011, hashr_lo_xfer]			; table index = low 16 bits of hash result
    sram[read, hashr_lo_xfer, tempa, tempb, 1], ctx_swap, optimize_mem ; lookup SRAM_L1 hash

    move[lookup_result, hashr_lo_xfer]                   ; check results of DA lookup in hash table 1
	br>0[hash_resolved#]

	immed32[reg_L2_base, const_L2_base]
	hashdb_lookup_L2[hash_rem, lookup_result, reg_L2_base]

hash_resolved#:
.endlocal
#endm


// _hashdb_add64_level2
//		add an entry, iterating through hash remainder until there is no collision
//		parameters
//		hi_lo			if 1 iterating on 16 bit hash_rem_hi, if 0, iterating on 48 bit hash_rem_hi and lo
//		hash_rem_hi		bits 47:32 of hash remainder
//		hash_rem_lo		bits 32:0 of hash remainder
//		lookup			previous lookup result, at exit pointer to  database entry
//		L2_freelist		identify of L2 freelist
//		L2_hash_base	base address for L2 tables
//		db_freelist		identify of sdram database freelist
//
#macro	_hashdb_add64_level2[hi_lo, hash_rem_hi, hash_rem, lookup, L2_freelist, L2_hash_base, db_freelist, xfer0, sd_xfer0, sd_xfer1]

.local tempa tempb table_sel index saved_hash_rem bit_pos

	.if (hi_lo == 1)
		move[hash_rem, hash_rem_hi]										; working on hi bits
	.endif
	move[saved_hash_rem, hash_rem]
	immed[bit_pos, 0]

hash_add_loop#:
	alu_shf[index, lookup, +L2_SHIFT_AMOUNT, hash_rem]					; shift table sel and add masked hash_result
   
    sram[read, xfer0, L2_hash_base, index, 1], ctx_swap, optimize_mem	; read L2 table with tableptr+hash_rem
    alu[lookup, 0, b, xfer0]

	br!=0[entry_or_collision#]

// if no entry, add entry
	malloc[lookup, db_freelist,  xfer0]						; get next database index (mem_ptr, freelist, xfer)
	move[xfer0, lookup]
	sram[write, xfer0, L2_hash_base, index, 1], ctx_swap	; write the new entry database index to L2
	br[done#]

// if collision bit set, add the entry to L2
//
entry_or_collision#:
	alu[--, xfer0, AND, 1, <<31]
	br=0[entry_and_no_collision#]

// existing entry and collision
//
	alu[bit_pos, bit_pos, +, L2_SHIFT_AMOUNT]				; increment pointer into hash_rem
	alu[--, bit_pos, -, 1, <<5]								; compare to 32
	br=0[exit#]												; for 64 bit add, exit to caller							

	alu[lookup, --, B, lookup, <<2]
	alu[lookup, --, B, lookup, >>7]							; get just the tableptr
    br[hash_add_loop#], defer[1]
	alu[hash_rem, --, B, hash_rem, >>L2_SHIFT_AMOUNT]

// existing entry and no collision, get existing entry hash_rem and loop
//
entry_and_no_collision#:
	malloc[level2_index, L2_freelist, xfer0]				; get new level2 table index
	alu[level2_index, level2_index, -, L2_hash_base]		; get offset

// insert the original entry in the new L2 table
	_get_db_base[db_hash_base, db_freelist]					; pointer to the db table
	alu[tempa, 1, +, lookup]								; read the second quadword to get hash_rem
	sdram[read, sd_xfer0, db_hash_base, tempa, 1], ctx_swap, defer[1]	; read database (will return 2 longwords)
	alu[bit_pos, bit_pos, +, L2_SHIFT_AMOUNT]
	.if (hi_lo == 0)
		.if (saved_hash_rem == sd_xfer1)
			.if (hash_rem_hi == sd_xfer0)					; if 48 bit hash remainder is same
				br[exit#]									; use existing lookup_result
			.endif
		.endif
	.else
		.if (saved_hash_rem == sd_xfer0)					; if hi hash remainder is same
			br[exit#]										; use existing lookup_result
		.endif
	.endif
	alu[--, bit_pos, B, 0]									; setup indirect right shift amount
	alu_shf[tempa, L2_SHIFT_MASK, AND, sd_xfer1, >>indirect]; shift to get next bits of hash remainder
	alu_shf[tempb, tempa, +, level2_index]
	move[xfer0, lookup]
    sram[write, xfer0, L2_hash_base, tempb, 1], ctx_swap	; write original entry to new L2 table

// write the L2 collision entry
	alu[lookup, INV_L2_SHIFT_AMOUNT, OR, level2_index, <<5]					; insert L2 index and shift amt
	alu[xfer0, lookup, OR, 1, <<31]							; insert collision
	sram[write, xfer0, L2_hash_base, index, 1], ctx_swap	; write the collision info to L2

// iterate on new entry
	alu[lookup, --, B, level2_index]
    br[hash_add_loop#], defer[1]
	alu[hash_rem, --, B, hash_rem, >>L2_SHIFT_AMOUNT]
	

done#:
	move[sd_xfer0, 0]
	move[sd_xfer1, saved_hash_rem]
	sdram[write, sd_xfer0, 1, lookup, 1], ctx_swap			; write hash_rem to database
exit#:
.endlocal
#endm



// hashdb_add64
//		Add new hash entry using hashed 64 bit value, by creating table lookups
//		lookup_result will point to database entry, so parameters can be inserted there
//		See also: hashdb_lookup64
//
//	parameters:
//		hashr_hi_xfer		hashed_result <47:32>
//		hashr_lo_xfer		hashed_result <31:0>
//		L1_base				level 1 table base constant, 32 bits
//		L2_freelist			id of level 2 freelist (1-7)
//		db_freelist			id of database freelist (1-7)
//		lookup_result		index to database
//
#macro hashdb_add64[hashr_hi_xfer, hashr_lo_xfer, L1_base, L2_freelist, db_freelist, lookup_result, sd_xfer0, sd_xfer1]

.local tempc tempd hash_rem hash_rem_hi level2_index L2_hash_base db_hash_base L1_addr
.operand_synonym use_xfer0 hashr_hi_xfer				; note: reusing hashr_hi_xfer
.operand_synonym use_xfer1 hashr_lo_xfer				; note: reusing hashr_lo_xfer

	_get_db_base[db_hash_base, db_freelist]				; pointer to the db table

    ld_field_w_clr[hash_rem, 0011, hashr_lo_xfer, >>16]
    ld_field[hash_rem, 1100, hashr_hi_xfer, <<16]		; concatenate hash remainder
	alu[hash_rem_hi, 0, +16, hashr_hi_xfer, >>16]

	immed32[tempd, L1_base]
	ld_field_w_clr[tempc, 0011, hashr_lo_xfer]			; table index = low 16 bits of hash result
	alu[L1_addr, tempd, +, tempc]
    sram[read, use_xfer0, L1_addr, 0, 1], ctx_swap, optimize_mem ; lookup SRAM_L1 hash

	alu[--, --, B, use_xfer0]
	br!=0[entry_or_collision#]

// if lookup_xfer is 0, there is no entry, so enter a new one
//
	malloc[lookup_result, db_freelist, use_xfer1]			; get next database index
	move[use_xfer1, lookup_result]
	sram[write, use_xfer1, tempc, tempd, 1], ctx_swap		; write the database index
	br[L1done#]

// if collision bit set, add the entry to L2
//
entry_or_collision#:
	alu[--, use_xfer0, AND, 1, <<31]
	br=0[entry_and_no_collision#]

// collision and existing entry 
	ld_field_w_clr[level2_index, 0111, use_xfer0, >>5]
	_get_L2_base[L2_hash_base, L2_freelist]
	br[lookup_L2#]

// no collision and existing entry,
//		get L2 table
//		set collision bit
//		insert pointer to L2
//		shift amount = L2_SHIFT_AMOUNT (4 or 8, level 2 tables are 16 or 256 entries). 
//			insert INV_L2_SHIFT_AMOUNT, 28 or 24 (32-L2_SHIFT_AMOUNT) for faster lookup later
//			add both entries to L2
entry_and_no_collision#:
	_get_L2_base[L2_hash_base, L2_freelist]
	malloc[level2_index, L2_freelist, use_xfer1]				; get next level2 table index
	alu[level2_index, L2_hash_base, B-A, level2_index]			; get offset

// insert original entry into level2
	alu[tempc, 1, +, use_xfer0]									; read the second quadword to get hash_rem
	sdram[read, sd_xfer0, db_hash_base, tempc, 1], ctx_swap		; read database
	alu_shf[tempc, L2_SHIFT_MASK, AND, sd_xfer1]				; get lo 4 or 8 bits of hash remainder
	.if (hash_rem == sd_xfer1)
		alu[tempc, 0, +16, sd_xfer0]
		.if (hash_rem_hi == tempc)								; if hash remainder is same
			br[end#]											; use existing lookup_result
		.endif
	.endif
	alu_shf[tempd, tempc, +, level2_index]
	move[use_xfer0, use_xfer0]
    sram[write, use_xfer0, L2_hash_base, tempd, 1], ctx_swap	; write original entry to new L2 table

// write the collision entry
	alu[lookup_result, INV_L2_SHIFT_AMOUNT, OR, level2_index, <<5]	; insert L2 index and shift amt
	alu[use_xfer0, lookup_result, OR, 1, <<31]					; insert collision
	sram[write, use_xfer0, L1_addr, 0, 1], ctx_swap				; write the collision info to L1


// iterate on new entry
lookup_L2#:
	move[lookup_result, level2_index]
	_hashdb_add64_level2[0, hash_rem_hi, hash_rem, lookup_result, L2_freelist, L2_hash_base, db_freelist, use_xfer0, sd_xfer0, sd_xfer1]
	alu[--, --, B, lookup_result]
	br>=0[end#]
	_hashdb_add64_level2[1, hash_rem_hi, hash_rem, lookup_result, L2_freelist, L2_hash_base, db_freelist, use_xfer0, sd_xfer0, sd_xfer1]
	br[end#]

L1done#:
	move[sd_xfer0, 0]
	move[sd_xfer1, hash_rem]
	alu[tempc, lookup_result, +, 1]
	sdram[write, sd_xfer0, db_hash_base, tempc, 1], ctx_swap	; write hash_rem to database
end#:
.endlocal	
#endm


// lookup 64 bit hash result
//
#macro hashdb_lookup64[hashr_hi_xfer, hashr_lo_xfer, const_L1_base, const_L2_base, lookup_result]
	immed32[tempb, const_L1_base]
	ld_field_w_clr[tempa, 0011, hashr_lo_xfer]					; table index = low 16 bits of hash result
    sram[read, $xfer7, tempa, tempb, 1], ctx_swap, optimize_mem ; lookup SRAM_L1 hash

    move[lookup_result, $xfer7]                   		; check results of DA lookup in hash table 1
	br>0[done#]

	hashdb_resolve[hashr_hi_xfer, hashr_lo_xfer, lookup_result, const_L2_base]
	.if (lookup_result < 0)
		hashdb_resolve[0, hashr_hi_xfer, lookup_result, const_L2_base]
	.endif
done#:
#endm

#endif // HASHDB_UC
