//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  1998-99 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
// rec_nextpac.uc
// get packet from receive FIFO, parse data link, ip version and
// make bridge/route/zero_protocol decision
// this version assumes element rfifo entry = thread id
//
// Version = 1.0.NoBldNum
//
// system: SA1200
// subsystem: receive microcode
// usage: layer 2 header
// author: dfh 11/8/97
// revisions:
//		dfh		7/1/98		support FAST PORT
//		dfh		7/29/98		remove #ifdef REC_SCHEDULER2
//		dfh		7/31/98		test for cancel first, remove message type jump
//		dfh		1/12/99		bi-endian. lower level macros perform swaps if #define LITTLE_ENDIAN

#ifdef RECEIVE16
#macro Rx_CreateIndividualReq[receive_req, tid]
	alu[receive_req, --, B, tid]					; port id
	alu[receive_req, receive_req, OR, tid, <<6]		; wakeup thread id
	alu[receive_req, receive_req, OR, tid, <<18]	; element no.
#endm
#endif

.operand_synonym protocol_len tempb
.operand_synonym exception tempb

.xfer_order $xfer0 $xfer1 $xfer2 $xfer3 $xfer4 $xfer5 $xfer6 $xfer7
.xfer_order $$xfer0 $$xfer1 $$xfer2 $$xfer3 $$xfer4 $$xfer5 $$xfer6 $$xfer7
.operand_synonym $new_descriptor $xfer6
.operand_synonym $sequence_num $xfer5


// setup rfifo_entry and port based on thread_id. each thread works on a fixed element
// thread 0 works on receive fifo element 0
// thread 11 works on receive fifo element 11
	br=ctx[0, context0#]
	br=ctx[1, context1#]
	br=ctx[2, context2#]
	br=ctx[3, context3#]

context0#:
	alu_shf[rfifo_entry, --, B, CONTEXT0_TID, <<3]		; form starting quadword address in rfifo
	#ifdef RECEIVE16
		#ifdef FAST_PORTS_ENABLED
			immed[my_tid, CONTEXT0_TID]
		#endif 
		Rx_CreateIndividualReq[receive_req, CONTEXT0_TID]
		// @req_inflight allows only 1 receive request in flight per box at a time
		// in flight time starts with the receive request and ends with completion of read rec ctl
		sem_flip[@req_inflight]								; from 0 to -1, let first thread go
	#endif
wait_on_scheduler#:
	br_!signal[inter_thread, wait_on_scheduler#]		; wait for freelist_create to complete

	br[begin#]

context1#:
	alu_shf[rfifo_entry, --, B, CONTEXT1_TID, <<3]		; form starting quadword address in rfifo
	#ifdef RECEIVE16
		#ifdef FAST_PORTS_ENABLED
			immed[my_tid, CONTEXT1_TID]
		#endif
		Rx_CreateIndividualReq[receive_req, CONTEXT1_TID]
	#endif
	br[begin#]

context2#:
	alu_shf[rfifo_entry, --, B, CONTEXT2_TID, <<3]		; form starting quadword address in rfifo
	#ifdef RECEIVE16
		#ifdef FAST_PORTS_ENABLED
			immed[my_tid, CONTEXT2_TID]
		#endif
		Rx_CreateIndividualReq[receive_req, CONTEXT2_TID]
	#endif
	br[begin#]

context3#:
	alu_shf[rfifo_entry, --, B, CONTEXT3_TID, <<3]		; form starting quadword address in rfifo
	#ifdef RECEIVE16
		#ifdef FAST_PORTS_ENABLED
			immed[my_tid, CONTEXT3_TID]
		#endif
		Rx_CreateIndividualReq[receive_req, CONTEXT3_TID]
	#endif



begin#:


// load hash multiplier
// for debugging, set to 1
// (alternatively this can be done in core)
#ifdef BRIDGE
	move[$xfer0, 0]
	move[$xfer1, 1]
	csr[write, $xfer0, HASH_MULTIPLIER_48_HI]
	csr[write, $xfer1, HASH_MULTIPLIER_48_LO]
#endif

#ifdef FAST_PORT1
		immed[tempb, SRAM_MPACKET_MAILBOX_1]
#else
#ifdef FAST_PORT2
		immed[tempb, SRAM_MPACKET_MAILBOX_2]
#endif ; FAST_PORT2
#endif ; FAST_PORT1
	alu[$xfer2, --, B, 1, <<31]						; set valid bit
	sram[write, $xfer2, tempb, 2, 1]				; write to validate slot 1 mailbox, since first mseq =1


// first-time startup, write thread done to tell rec_scheduler we are ready for a packet
//
	#ifndef RECEIVE16
		fast_wr[3, THREAD_DONE]							; thread done to receive scheduler
	#endif


next_packet#:
#ifdef RECEIVE16
#macro Rx_Request[xfer_reg, receive_req]
wait_for_rr_in_f#:
	// check to see if read rcv ready already in flight from this uengine
	// if there is, then wait for it to finish before this read.  We can not have every
	// slow port receive thread doing this csr at the same time, or the threads that
	// are processing packets will not get to use the fbi
	alu[--, --, b, @rrr_in_flight]		; check read receive ready flag	
	br=0[check_port#], guess_branch		; if flag is false, then go do our read
	ctx_arb[voluntary]					; if flag is true, hang out here and wait for it to clear
	br[wait_for_rr_in_f#]
check_port#:
	alu[tempa, --, b, 1]
	alu[@rrr_in_flight, --, b, tempa]	; set rcv_rdy request is in flight flag
	csr[read, xfer_reg, RCV_RDY_LO], defer[1], ctx_swap				; get port ready
	alu[tempa, --, B, rfifo_entry, >>3]								; determine if our port has data
	alu[--, tempa, B, 0]
	alu[--, 1, AND, xfer_reg, >>indirect]
	br!=0[send_req1#], defer[2]				; if our port has data then go process it
	alu[tempa, --, b, 0]
	alu[@rrr_in_flight, --, b, tempa]		; clear the read receive ready flag

	ctx_arb[voluntary]						; if our port doesn't have data, stay in this loop waiting for it
	br[wait_for_rr_in_f#]

port_rdy1#:
send_req1#:

	sem_wait[@req_inflight]
	sem_flip[@req_inflight]								; set to block other contexts from sending rec_req

got_rr_avail#:
	move[xfer_reg, receive_req]
	csr[write, xfer_reg, rcv_req],ctx_swap				; send req to FBI
next_packet_data#:
#endm
Rx_Request[$xfer0, receive_req]
#endif


// get a packet descriptor while waiting to start
// tempa is there only to make assembler happy
//
	sram[pop, $new_descriptor, tempa, 0, PACKET_FREELIST], sig_done


next_packet_sop#:
// Load the receive_control_register
//
// format of RCV_CTL is
// +-----+-----+-----+------+----+-----+-----+----+----+-----------+---+---+
// | msg |port |seq# |rxfail|err |elem2|elem1|1or2|seq | validbytes|EOP|SOP|
// |31:30|29:24|23:20|  19  | 18 |17:14|13:10| 9  | 8  |    7:2    | 1 | 0 |
// +-----+-----+-----+------+----+-----+-----+----+----+-----------+---+---+
//
	Rx_Receive[$xfer7, packet_cancel#, packet_fail_discard#]	; read and check receive control
#ifdef RECEIVE16
	sem_flip[@req_inflight]								; clear to allow other context to send rec req
#endif

#ifdef FAST_PORT_ENABLED
	alu[--, FAST_PORT1, -, $xfer7, >>24]
	br=0[fast_port_rec_state#], defer[1]
	alu_shf[rec_state, $xfer7, AND, 0xf, <<20]			; put FAST PORT sequence# in rec_state	23:20
#endif

slow_port_rec_state#:
    br_bclr [$xfer7, 0, slow_not_sop#], defer[2]		; check for continuation packet
	alu[rec_state, $xfer7, AND, 0xf, <<24]				; portnum is used in save slow state
	ld_field[rec_state, 0001, $xfer7]					; byte count, eop, sop from rcv_cntl 7:0 to 7:0


#ifdef REC_STATE_SAVE
	Rx_SOPBlockSlowPort[$xfer7]							; if previous EOP unblocked this port, block port and continue
#endif

#ifdef FAST_PORT_ENABLED
	br[read_rfifo1#]
#endif


// save FAST PORT info
//
#ifdef FAST_PORT_ENABLED
fast_port_rec_state#:
    br_bclr [$xfer7, 0, fast_not_sop#], defer[2]		; check for continuation packet
	ld_field[rec_state, 0001, $xfer7]					; byte count, eop, sop from rcv_cntl 7:0 to 7:0
	alu_shf[rec_state, rec_state, OR, 1, <<30]			; FAST source PORT rec_state 30 = 1

	alu_shf[tempb, 0x1e, AND, $xfer7, >>13]				; get mpacket sequence

	alu[--, $xfer7, AND, 1, <<1]						; test EOP
	br=0[read_rfifo1#]									; if not EOP, state will be saved later
	Rx_ValidateNextFastState[tempb]						; validate the next (this = SOP AND EOP)
#endif


// Load first 4 longwords of packet from the receive fifo 
// packet must be big-endian
// The first 6 bytes are dest address, then 6 bytes of source address.  
// The next 2 bytes are length(802.3) or PID (ethernet).
// If Ethernet/802.3 the next byte is network layer protocol identifier  
//
read_rfifo1#:
#ifdef ALT_BANKS
    r_fifo_rd [$xfer0, rfifo_entry, 0, 2], ctx_swap, defer[1]
	alu[rec_state, rec_state, OR, PACKET_FREELIST, <<29]	; insert freelist id
#else
    r_fifo_rd [$xfer0, rfifo_entry, 0, 2], ctx_swap
#endif
// wait for pop to complete
//
	ctx_arb[sram]										; should have descriptor from rec_nextpac pop by now


802_3_ethernet#:


set_buf_addrs#:
// set packet_buf_addr and buf_handle
//
	Rx_SetBufAddrs[packet_buf_addr, buf_handle, $new_descriptor]


#ifdef FAST_PORT_ENABLED
	alu[--, rec_state, AND, 1, <<30]					; test for fast port source
	br=0[protocol_decode#]
fast_test_for_clear#:

// fast sop save state
fast_save1#:
	alu[--, rec_state, AND, 1, <<1]						; test EOP
	br>0[fast_invalidate_current#]						; if EOP, next was validated earlier
	Rx_SaveFastState[buf_handle, rec_state, tempb]		; non EOP, save state to next mpacket

fast_invalidate_current#:
#ifdef MIN_PACKETS_ONLY
	Rx_InvalidateFastState[tempb]						; invalidate current on SOP, no test and set
#else
	Rx_TestAndInvalidateFastState[tempb]				; invalidate current on SOP, var size packets
#endif
#endif


protocol_decode#:

// extract protocol length field
//
	extract_field[protocol_len, $xfer3, 0, 1]			; get bytes 0-1



// for testing purposes, a 0 in protocol_len indicates that the output port is the following byte
//
#ifdef ZERO_PROTOCOL
	br=0[rec_zeroprotocol#], defer[1]
#endif
 
 
     
// make 802.3/ethernet decision from protocol/len field
//
    immed [tempa, 1500]
    alu [--, protocol_len, -, tempa]					; compare with constant 1500 (RFC 1122, 2.3.3)
    br<=0 [parse_802_3#]								; if protocol_len is gtr than 1500, it is Ethernet




//	register usage at this point
//
//	$xfer0 					MAC DA<31:0>
//	$xfer1					MAC  DA<48:32> and SA<15:0> 
//	$xfer2					MAC  SA<31:0>  
//	$xfer3					MAC length and ip version, IHL, TOS
//	protocol_len			datalink payload length
//	packet_buf_addr			address of buffer in sdram  where packet will be stored
//	buf_handle				address offset of the current descriptor
//	rec_state					<31>fastport flag, <23:20>packet sequence number, <15:8>byte enables, eop, sop



// Ethernet bridge/route decision.
// note: this is simplified so as not to obscure the general control concepts of the ref design
//		
// check pkt word 4 byte 2 (version, IHL). if ip with no options, route, otherwise bridge
//
ethernet#:

#ifdef ROUTE
    br_eq_field[$xfer3, 2, 2, 0x45, ip_verify#]			; bridge/route decision
#endif

#ifdef BRIDGE
	br[rec_bridge#]										; if not IP continue with layer 2 bridge.
#endif

parse_802_3#:
	immed[exception, PROT802_3_NOT_IMPLEMENTED]
	br[packet_early_discard_pop_completed#]

// discard before transfer of packet data to sdram
// caused by rxfail, treated like EOP
//
packet_fail_discard#:
// the packet is dropped, bump a mib counter here
//
	ctx_arb[sram]										; wait for pop to complete

packet_early_discard_pop_completed#:
	immed[tempa, EXCEPTION_COUNTERS]					; 11 contexts, 16 locations each
	alu[tempa, tempa, +, rfifo_entry, <<1]				; add context id * 16
	scratch[incr, --, tempa, exception, 1]

	immed[tempa, TOTAL_DISCARDS]
	scratch[incr, --, tempa, 0, 1]

	#ifndef RECEIVE16
		fast_wr[3, THREAD_DONE]
	#endif

	alu[--, --, b, $new_descriptor]
	br=0[do_not_push#]									; if a zero was poped, don't push it back
		sram[push, --, $new_descriptor, 0, PACKET_FREELIST]				; push buffer back to freelist	

do_not_push#:

#ifdef FAST_PORT_ENABLED
	alu[--, FAST_PORT1, -, $xfer7, >>24]
	br=0[fast_rxfail_discard#]								; if fast port, invalidate mailbox, increment seq num then get next packet
#endif

slow_rxfail_discard#:
//TBD
// if not sop rxfail, we also need to
// 1. restore state
// 2. push the relative buf address  in buf_handle back
	#ifdef RECEIVE16										; flip now that fast state has been updated
		sem_flip[@req_inflight]								; clear to allow other context to send rec req
	#endif
	br[next_packet#]									; if slow port invalidate mailbox then get next packet

#ifdef FAST_PORT_ENABLED
fast_rxfail_discard#:
//TBD
// if not sop rxfail, we also need to
// 1. restore state
// 2. push the relative buf address  in buf_handle back

	alu_shf[tempb, 0x1e, AND, $xfer7, >>13]				; get mpacket sequence, x2
	Rx_InvalidateFastState[tempb]						; $xfer0 contains buf_handle
	alu_shf[tempa, 0xf, AND, $xfer7, >>20]				; extract seq number
	Rx_ValidateNextFastState[tempa]						; validate next fast state

	#ifdef RECEIVE16										; flip now that fast state has been updated
		sem_flip[@req_inflight]								; clear to allow other context to send rec req
	#endif

	// push the buffer that we were using, if any, onto freelist
	alu[tempa, tempa, -, 1]
	alu[tempa, --, b, buf_handle, >>16]					; get offset
	br=0[skip_push#], defer[2]							; if no buffer there, then skip push

	alu[tempa, $xfer0, AND~, 1, <<31]
	immed32[buf_descriptor_base, SRAM_BUFF_DESCRIPTOR_BASE]
	sram[push, --, tempa, buf_descriptor_base, PACKET_FREELIST]

skip_push#:

	#ifdef FAST_PORT1
		FastPort_SeqCheck[ENQUEUE_SEQ1, tempa]				; wait for my seq no. to come up
		fast_wr[3, INCR_ENQ_NUM1]							; increment fast port 1 seq number
	#else
	#ifdef FAST_PORT2
		FastPort_SeqCheck[ENQUEUE_SEQ2, tempa]				; wait for my seq no. to come up
		fast_wr[3, INCR_ENQ_NUM2]							; increment fast port 2 seq number
	#endif ; FAST_PORT2
	#endif ; FAST_PORT1

	br[next_packet#]									; if slow port get next packet

#endif FAST_PORT_ENABLED


// discard after transfer of packet data to sdram and after loading more header into xfer regs
//
packet_discard#:
// the packet is dropped after some data has been transfered to sdram
//
//
	ctx_arb[sdram]										; take the sdram signal
	#ifndef RECEIVE16
		fast_wr[3, THREAD_DONE]											; else write slow port EOP done
	#endif

// discard after sdram signal (from rfifo to sdram) has been consumed and thread_done sent
//
packet_late_discard#:

// increment exception counters
//
	immed[tempa, EXCEPTION_COUNTERS]					; 11 contexts, 16 locations each
	alu[tempa, tempa, +, rfifo_entry, <<1]				; add context id * 16
	scratch[incr, --, tempa, exception, 1]

	immed[tempa, TOTAL_DISCARDS]
	scratch[incr, --, tempa, 0, 1]

// recover full address of buffer descriptor, push back to freelist
//
.local descriptor_addr descriptor_base
	immed[descriptor_base, SRAM_BUFF_DESCRIPTOR_BASE]
	alu[descriptor_addr, descriptor_base, +, buf_handle, >>16]
	alu[descriptor_addr, descriptor_addr, -, 1]
	sram[push, --, descriptor_addr, 0, PACKET_FREELIST]				; push buffer back to freelist	
.endlocal

#ifdef FAST_PORT_ENABLED
// test for fast port
	alu[--, FAST_PORT1, -, rec_state, >>31]
	br=0[fast_discard#]									; if fast port, invalidate mailbox, increment seq num then get next packet
#endif

slow_discard#:
	// set the discard bit
	alu_shf[rec_state, rec_state, OR, 1, <<19]

#ifdef REC_STATE_SAVE
slow_save2#:
	Rx_SaveSlowState[buf_handle, rec_state, output_port]					; save the discard bit with state
	br[next_packet#]
#endif
// otherwise not saving state (as in 12 port version)
	.if (bit(rec_state, 1) == 1)							; if EOP
		br[next_packet#]
	.else
		br[next_mpacket#]
	.endif

#ifdef FAST_PORT_ENABLED
fast_discard#:
	alu_shf[tempa, 0xf, AND, rec_state, >>20]				; extract sop seq number
	#ifdef FAST_PORT1
		FastPort_SeqCheck[ENQUEUE_SEQ1, tempa]				; wait for my seq no. to come up
		fast_wr[3, INCR_ENQ_NUM1]							; increment fast port 1 seq number
	#else
	#ifdef FAST_PORT2
		FastPort_SeqCheck[ENQUEUE_SEQ2, tempa]				; wait for my seq no. to come up
		fast_wr[3, INCR_ENQ_NUM2]							; increment fast port 2 seq number
	#endif ; FAST_PORT2
	#endif ; FAST_PORT1

	.if (bit(rec_state, 1) == 0)							; if not EOP
// fast port non-EOP discard
		alu_shf[rec_state, rec_state, OR, 1, <<19]			; set discard bit
		Rx_SaveFastState[buf_handle, rec_state, tempb]		; save state to next mpacket
	.endif

	br[next_packet#]
#endif

// fast port cancel
// this receive control is skipped, because fbi found fast port not ready
// receive control message = 3
//
packet_cancel#:
#ifdef FAST_PORT_ENABLED
	ctx_arb[sram]										; wait for pop to complete
	alu[--, --, B, $new_descriptor]						; make sure there was a buffer available
	br=0[packet_cancel_no_buf#]							; if no buffer, then don't push a zero
	sram[push, --, $new_descriptor, 0, PACKET_FREELIST]	; push buffer back to freelist	
packet_cancel_no_buf#:
	Rx_RestoreFastState[buf_handle, rec_state]			; get state from previous mpacket
	alu[tempb, 0x1e, AND, $xfer7, >>13]					; get mseq num
	#ifndef RECEIVE16
		fast_wr[2, THREAD_DONE]
	#endif
	Rx_SaveFastState[buf_handle, rec_state, tempb]		; save state to next mpacket
#ifdef RECEIVE16
	sem_flip[@req_inflight]								; clear to allow other context to send rec req
#endif
#endif
	br[next_packet#]




#ifdef ZERO_PROTOCOL
rec_zeroprotocol#:
// for mac protocol/len = 0, output port is the first byte of payload
// store_data# is in rec_enqueue, no lookup just move the data
//
	merge_extract2[rec_state, $xfer3]				; insert byte 2 output port to rec_state byte 3
	alu[output_port, 0, +8, rec_state]				; put output_port in rec_state

#ifdef FAST_PORT_ENABLED
	.if (bit(rec_state, 30) ==1)					; if fast port
sop_save2#:
		alu[tempb, 0xf, AND, rec_state, >>20]		; get SOP seq number
		Rx_SaveOutPort[output_port, tempb]			; save output_port for EOP thread to pick up
	.endif
#endif

	br[store_data#]
#endif


