//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  1998-99 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
// rec_ipverify.uc
// IPV4 verify the ip header prior to routing decision
//
//
// system: SA1200
// subsystem: IP route microcode
// usage: example
// author: dfh 11/8/97
//	
// revisions:
//		dfh		1/12/99		bi-endian. lower level macros perform swaps if #define LITTLE_ENDIAN
//		dfh		3/31/00		use ip.uc macros
//
// ---------------------------SA1200 microcode--------------------------	

 

// Prerequisite: 
//	rec_nextpac.uc   has executed
//	first 4 longwords of the packet has been read in from reveive FIFO
//

//	register usage at this point
//
//	$xfer0 					MAC DA<31:0>
//	$xfer1					MAC  DA<48:32> and SA<15:0> 
//	$xfer2					MAC  SA<31:0>  
//	$xfer3					MAC length and ip version, IHL, TOS
//	protocol_len			datalink payload length
//	packet_buf_addr			address of buffer in sdram where packet will be stored
//	buf_handle				address offset of the current descriptor
//	rec_state				fastport flag, packet sequence number, byte enables, eop, sop

// 
#include "ip.uc"								; ip macros

ip_verify#:

.local sa01

// move second 4 quadwords of receive fifo element to sdram 
//
	sdram_r_fifo_rd[packet_buf_addr, rfifo_entry, 4, 4, ASYNC]		; (see stdmac.uc)


read_rfifo2#:
// get the next 6 longwords of the packet from the receive FIFO
// continuing from where layer 2 left off, and wrapping
//
    r_fifo_rd[$xfer4, rfifo_entry, 2, 2]
#ifdef LITTLE_ENDIAN
	alu[sa01, 0, +16, $xfer1, >>16]
#else
	alu[sa01, 0, +16, $xfer1]										; save sa bytes 0-1 for later merge
#endif
    r_fifo_rd[$xfer0, rfifo_entry, 4, 1], ctx_swap

	ip_verify[exception, 14]					; ip header starts at byte 14
	br>0[packet_discard#]
	ctx_arb[voluntary]
	ip_modify[14, 14]
ip_ok#:

