/* ------------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *------------------------------------------------------------------------------*/

/* rtm_cfg.h
 *
 *
 *
 * system: SA1200
 * subsystem: Route Table Manager
 * author: Don Hooper
 * revisions:
 * $History: rtm_cfg.h $
 * 
 * *****************  Version 7  *****************
 * User: Dhooper      Date: 1/20/00    Time: 11:39a
 * Updated in $/dev_1200/SA1_CoreLibs/rtm
 * clean up the API syntax and comments
 * 
 * *****************  Version 6  *****************
 * User: Dhooper      Date: 1/13/00    Time: 7:48p
 * Updated in $/dev_1200/SA1_CoreLibs/rtm
 * support route_delete
 * 
 * *****************  Version 5  *****************
 * User: Dhooper      Date: 12/01/99   Time: 6:33p
 * Updated in $/dev_1200/SA1_CoreLibs/rtm
 * use 8 bit 256 table for full longest prefix match of 31:24
 * 
 * *****************  Version 3  *****************
 * User: Dhooper      Date: 5/07/99    Time: 10:55a
 * Updated in $/dev_1200/SA1_CoreLibs/rtm
 * use latest IOSTYLE convention
 * 
 * *****************  Version 1  *****************
 * User: Dhooper      Date: 3/26/99    Time: 4:51p
 * Created in $/development/rtm
 * move rtm internal defs here from rtm.h
 * 
 * 
 */ 
#ifndef RTM_CFG_H
#define RTM_CFG_H
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#ifdef STANDALONE
#include "iostyle.h"			// core to rest of chip interface style
#endif

#ifdef WIN32
#include <winsock.h>			// to get inet_addr()
#else
#include <sys/socket.h>
#endif


#define uint    unsigned int
#define uchar   unsigned char

#ifndef WIN32
#define CLEAR "clear"
#else
#define CLEAR "cls"
#endif

#define TRUE	1
#define FALSE	0

#define SIZE_OF_64K 65537
#define SIZE_OF_256 257

#define TRUE    1
#define FALSE   0

/* default number of routes */
#define NUM_ROUTES   512
/* default number of trie entries */
#define NUM_TRIE_SETS    1024
/* Number of entries in trie set = number of long words */
#define SIZE_OF_TRIE_SET 16


#ifdef WIN32
#ifndef bzero
#define bzero(a,b)   memset( (a), 0, (b) )
#endif
#endif

/* DATA STRUCTURES  */


/*
	RTM_lookup_cmds
	This is used to determine the sequence of lookups based on the mask value.
	It is an array of 3 x 8 chars. 8 triplets are for the count of mask least 
	significant nibbles = 0. For example, in a 32 bit address if mask is 
	255.255.255.255, the commands will be in the 0th triplet.Each triplet
	consists of a char to indicate initial lookup START_64K, START_256 or 
	START_TRIE, followed by key start bit and end bit.
 */
#define START_256  0
#define START_64K  1
#define START_TRIE 2
struct RTM_Cmd{
	unsigned char look;
	unsigned char start;
	unsigned char end;
};

// Flink type to support freelists	
struct Flink{
	int next;
	int index;
};


// Trie16Info type to support masks and hidden entries in trie16 blocks 
struct RTM_Trie16Info{
	short population;
	unsigned char  mask[16];			// 4 bit network prefix mask
	unsigned int prefix3[8];			// possible hidden entries
	unsigned int prefix2[4];
	unsigned int prefix1[2];
};			


// Trie256Info type to support masks and hidden entries in trie256 blocks 
struct RTM_Trie256Info{
	unsigned char  mask[256];			// 8 bit network prefix mask
	unsigned int prefix7[128];			// possible hidden entries
	unsigned int prefix6[64];
	unsigned int prefix5[32];
	unsigned int prefix4[16];
	unsigned int prefix3[8];
	unsigned int prefix2[4];
	unsigned int prefix1[2];
};


struct RTM_ConfigInfo{
// trie initial lookup
 	unsigned int hi256_base;			// array lookup indexed by ip 31:24, in shared IO space
	RTM_Trie256Info hi256_info;			// mask and hidden trie info
	unsigned int hi64k_base;			// array lookup indexed by ip 31:16, in shared IO space
// trie blocks
	unsigned int trie_base;				// array of trie blocks. in shared IO space
	RTM_Trie16Info trie_info[NUM_TRIE_SETS];	// mask and hidden trie info
	unsigned int next_free_trie;		// head of freelist
	Flink trie_flinks[NUM_TRIE_SETS];	// static allocation of nodes for freelist
    unsigned int total_trie;			// number of allocated trie sets

// route entries
	unsigned int route_table_base;		// array of route entries. in IO space, shared with microengines
	unsigned int next_free_rt;			// head of freelist
	Flink rt_flinks[NUM_ROUTES];		// static allocation of nodes for freelist
	unsigned int total_rt;				// number of allocated route entry locations
};




extern RTM_ConfigInfo RTM_config;

#endif /* RTM_CFG_H */
