//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  2000 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
// rfifo.uc
// macros to access rfifo 
//
//
// system: IXP1200
// subsystem: utility microcode
// usage: library macros
// author: dfh	May 1, 2000
//
// revisions:


#ifndef RFIFO_UC
#define RFIFO_UC



// rfifo_read
// 		description: Read const_qw_count quadwords from rfifo to sram read xfers.
//		inputs:
//			_rfifo_addr			quadword address
//			const_qw_offset		quadword offset
//			const_qw_count		quadword count
//			sig_spec		pend:  waiting on signal, context swap
//							sig:   requesting signal, but continuing
//							nosig: not allowed. error
//		size: 1-2 instr
//		see also: 
//		example usage:
//			rfifo_read(rfifo_addr, QWOFFSET2, QWCOUNT3, pend);
//
#macro rfifo_read[_rfifo_addr, const_qw_offset, const_qw_count, sig_spec]
#if (isnum (sig_spec))
#error 2  "Error: rfifo_rd. pend or sig is required."
#endif
#define_eval START_XFER ((const_qw_offset << 1) & 0x7)
#define_eval END_XFER ((START_XFER + ((const_qw_count <<1) - 1)) & 0x7)

#if (const_qw_count > 4)
#error 2  "Error: rfifo_rd. More than 4 quadwords."
#elif (END_XFER > START_XFER)
	r_fifo_rd[$xfer/**/START_XFER/**/, _rfifo_addr, const_qw_offset, const_qw_count], sig_spec
#else
// wrap to begining of xfer buffer to avoid writing to other context's xfer regs
#define_eval FIRST_QW_COUNT ((8 - START_XFER) >>1)
#define_eval SECOND_QW_OFFSET (const_qw_offset + FIRST_QW_COUNT)
#define_eval SECOND_QW_COUNT (const_qw_count - FIRST_QW_COUNT)
	r_fifo_rd[$xfer/**/START_XFER/**/, _rfifo_addr, const_qw_offset, FIRST_QW_COUNT]
	r_fifo_rd[$xfer0, _rfifo_addr, SECOND_QW_OFFSET, SECOND_QW_COUNT], sig_spec

#endif
#endm


#endif // RFIFO_UC