// xmit_sched.uc
//		1 transmit scheduler for use with either xmit_8x100.uc or xmit_fast_port.uc
//		used on 2 microengines
//		1 microengine takes even tfifo elements, the other takes odd tfifo elements
//		each element is statically bound to a port. don't need binding to block a port

//		each microengine: define personality  ODD or not ODD
//

#include "stdmac.uc"
#include "mem_map.h"
#include "sem.uc"


.xfer_order $xfer0 $xfer1 
.operand_synonym $xmit_ptr $xfer0
.operand_synonym $gig_ele_count $xfer1

	// startup
	br=ctx[1,tx_fill#]				; fill thread
	br=ctx[2,tx_fill#]				; fill thread
	br=ctx[3,tx_fill#]				; fill thread


tx_sched#:

.local temp
	alu[temp, --, B, 1, <<31]				; init assignment to no assignment
	move[@assign1, temp]
	move[@assign2, temp]
	move[@assign3, temp]
.endlocal


	#ifdef HW_INIT 							; initialize hardware config
		#include "hw_init.uc"
	#endif

.local gig_ele_count last_xmit_ptr local_gig_ele_count mpackets_in_tfifo 

	alu[local_gig_ele_count, --, b, 0]  ; initialize 


	#ifdef EVEN
		immed[@fifo_elem, 0]
	#else								; not EVEN
		immed[@fifo_elem, 1]
	#endif 								; not EVEN


#define SKIP_BIT_SET 0x100

	// init the xmit scheduler
	//
	#ifdef FAST_PORT1
		immed[gig_ele_count_addr, XMIT_FPORT1_ELE_COUNT]	; fast port1 elements queued
	#endif
	#ifdef FAST_PORT2
		immed[gig_ele_count_addr, XMIT_FPORT2_ELE_COUNT]	; fast port2 elements queued
	#endif

	immed[skip_bit_on, SKIP_BIT_SET]


// tx scheduler assignment routine
//
#macro tx_sched_body[abs_assign, const_to_tid]
.local temp 
retry#:

	//  poll xmit_outptr, ports with packets
	//
	scratch[read, $gig_ele_count, gig_ele_count_addr, 0, 1], ctx_swap

	alu[temp, 0, +16, $gig_ele_count]   					; limit variable to 16 bits

	// if not port with packet, set skip
	//
	alu[local_gig_ele_count, 0, +16, local_gig_ele_count]   ; limit to 16 bits
	alu[--, temp, -, local_gig_ele_count]		   			; temp = 16 bit received gig elem count; compare received with processed count

	br!=0[tx_assign#], defer[2]                             ; assign a fill thread if there are mpackets to process
	alu[local_gig_ele_count, 1, +16, local_gig_ele_count]   ; increment processed mpacket count
	alu[temp, --, b, 0]                         			; clear skip bit (temp to be coppied to abs_assign)
    
	alu[local_gig_ele_count, 1, B-A, local_gig_ele_count]   ; no output, so subtract the count that was just added in
	alu[temp, temp, OR, skip_bit_on]		            	; set skip bit

tx_assign#:
	sem_wait[abs_assign]                            ; wait for fill thread to become available
	move[abs_assign, temp]                          ; copy in assignment
.endlocal
#endm

//******************************* END MACROS **************************************


#define_eval CTX1_TID (FID*4+1)
#define_eval CTX2_TID (FID*4+2)
#define_eval CTX3_TID (FID*4+3)

	//signal fill threads indicating initialization is complete
	fast_wr[CTX1_TID, inter_thd_sig]
	fast_wr[CTX2_TID, inter_thd_sig]
	fast_wr[CTX3_TID, inter_thd_sig]

tx_sched_loop#:
	tx_sched_body[@assign1, CTX1_TID]
tx_sched_ctx2#:
	tx_sched_body[@assign2, CTX2_TID]
tx_sched_ctx3#:
	tx_sched_body[@assign3, CTX3_TID]
	br[tx_sched_loop#]

.endlocal

// three fill threads
//
#include "xmit_fill_1gig.uc"
		

