; sv_msg.uc
; microcode service core to uc message transport
;;
; ------------------------------------------------------------------------------------------------------------
;                                                                      
;                  I N T E L   P R O P R I E T A R Y                   
;                                                                      
;     COPYRIGHT (c)  1998 BY  INTEL  CORPORATION.  ALL RIGHTS          
;     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
;     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
;     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
;     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
;     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
;     THE PRIOR WRITTEN PERMISSION OF :                                
;                                                                      
;                        INTEL  CORPORATION                            
;                                                                     
;                     2200 MISSION COLLEGE BLVD                        
;                                                                      
;               SANTA  CLARA,  CALIFORNIA  95052-8119                  
;                                                                      
;------------------------------------------------------------
;
; system: SA1200
; subsystem: Service
; usage: receive and ack messages from core
; author: dfh 2/9/98
; revisions:
;
; Version = 1.0.NoBldNum
;
; ---------------------------SA1200 microcode--------------------------	


; wait for signal from core
Sv_WaitForCall#:
	ctx_arb[inter_thread]

; when we wake, there is a message from core
;
	immed[thread_mb_base, CORE_TO_UTHREAD_MAILBOXES]			; shared constant
	alu_shf[from_core_mb, thread_mb_base, +, my_thread_id, <<2]	; mailbox addr

; issue. do we read 1 then depending on format up to 3 more, or 4 up front
	sram[read, $xfer0, from_core_mb, 0, 4], ctx_swap

; prepare the ack
; swap source and dest, set ack bit
; +------+-----+--------+----+-------+--------+--------+--------+
; | pend | ack | format |fail|  xid  |  src   |  dest  |  func  |
; |  31  | 30  | 29:28  | 27 | 26:24 |  23:16 |  15:8  |  7:0   |
; +------+-----+--------+----+-------+--------+--------+--------+

; keep sync, func and xid
	alu_shf[reply, $xfer0, OR, 1, <<30]		; set ack
	ld_field_w_clr[func, 0001, $xfer0]
	ld_field[reply, 0100, $xfer0, <<8]
	ld_field[reply, 0010, $xfer0, >>8]
	alu_shf[reply, reply, AND~, 3, <<28]	; format 0 = preamble only
	immed[format,0]							; reinitialize reply format to 0

; test if asynchronous
	alu_shf[--, 0, B, reply, >>31]			; bit 31 on means synchronous
	; if synchronous, call function first, ack later
	br>0[Sv_CallFunction#]					; go call the function
	; asynchronous, ack now and do function later
	br[Sv_Ack#]

Sv_CallFunction#:
	jump[func, Sv_Dispatch#]


;----------------------------------------------------------------------
; Sv_Return
;	send preamble only message acknowledgement to core
;	then wait for next call
;
;	input arguments
;		preamble: assembled when the request was received
;----------------------------------------------------------------------
Sv_Ack#:

	immed[thread_mb_base, UTHREAD_TO_CORE_MAILBOXES]			; shared constant
	alu_shf[to_core_mb, thread_mb_base, +, my_thread_id, <<2]	; mailbox addr

; all mem services functions have preamble only reply
	alu_shf[reply, reply, OR, format, <<28]						; insert format
	alu[$xfer0, --, B, reply]
	alu_shf[indirect_wr_len, format, OR, 0x10]		; setup word count
	alu_shf[indirect_wr_len, --, B, indirect_wr_len, <<16]
	sram[write, $xfer0, to_core_mb, 0, 1], indirect_ref, ctx_swap

; write ireg
	fast_wr[1, ireg]

	alu_shf[--, 0, B, reply, >>31]			; bit 31 on means synchronous
	; if synchronous, function done
	br>0[Sv_WaitForCall#]
	; asynchronous, call function
	br[Sv_CallFunction#]					; go call the function


;----------------------------------------------------------------------
; Sv_InvalidFunc
;	function id is not recognized
;
Sv_InvalidFunc#:
;TBD reply with fail code
	nop
	ctx_arb[kill]
