; hashsv.uc
; load hash multipliers and execute hardware hash functions
;;
; ------------------------------------------------------------------------------------------------------------
;                                                                      
;                  I N T E L   P R O P R I E T A R Y                   
;                                                                      
;     COPYRIGHT (c)  1998 BY  INTEL  CORPORATION.  ALL RIGHTS          
;     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
;     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
;     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
;     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
;     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
;     THE PRIOR WRITTEN PERMISSION OF :                                
;                                                                      
;                        INTEL  CORPORATION                            
;                                                                     
;                     2200 MISSION COLLEGE BLVD                        
;                                                                      
;               SANTA  CLARA,  CALIFORNIA  95052-8119                  
;                                                                      
;------------------------------------------------------------
;
; system: SA1200
; subsystem: service microcode
; usage: hardware hash functions
; author: dfh 2/15/98
; Version = 1.0.NoBldNum
; revisions:
;----------------------------------------------------------------------
;#ifdef standalone
.xfer_order $xfer1 $xfer2 
;#endif

;----------------------------------------------------------------------
; HashSv_LdMult48
;	Load 48 bit hardware hash multiplier
;	input registers:
;		$xfer1: 47:32 of multiplier in bits 15:0
;		$xfer2: 31:0 of multiplier
;----------------------------------------------------------------------
HashSv_LdMult48Subr#:
	alu[$xfer1, --, B, $xfer1]			// args coming from core are hi32 in $xfer1, lo32 in $xfer2
	alu[$xfer2, --, B, $xfer2]			// move to write xfer
	csr[write, $xfer1, hash_multiplier_48_hi]
	csr[write, $xfer2, hash_multiplier_48_lo], ctx_swap
	alu_shf[--, 0, B, reply, >>31]	; bit 31 on means synchronous
	; if synchronous, go ack
	br>0[Sv_Ack#]					; go call the function
	; asynchronous, function done
	br[Sv_WaitForCall#]



;----------------------------------------------------------------------
; HashSv_LdMult64
;	Load 48 bit hardware hash multiplier
;	input registers:
;		$xfer1: 63:32 of multiplier
;		$xfer2: 31:0 of multiplier
;----------------------------------------------------------------------
HashSv_LdMult64Subr#:
	alu[$xfer1, --, B, $xfer1]
	alu[$xfer2, --, B, $xfer2]
	csr[write, $xfer1, hash_multiplier_64_hi]
	csr[write, $xfer2, hash_multiplier_64_lo], ctx_swap
	alu_shf[--, 0, B, reply, >>31]	; bit 31 on means synchronous
	; if synchronous, go ack
	br>0[Sv_Ack#]					; go call the function
	; asynchronous, function done
	br[Sv_WaitForCall#]



;----------------------------------------------------------------------
; HashSv_Exec48
;	Execute 48 bit hardware hash function
;	input registers:
;		$xfer1: 48:32 of hash input operand in bits 15:0
;		$xfer2: short 31:0 of hash input operand in upper hword
;			zero in lower halfword
;	output registers:
;		$xfer1: 48:32 of hash result value
;		$xfer2: 31:0 of hash result value in upper hword
;			zero in lower halfword
;----------------------------------------------------------------------
HashSv_Exec48Subr#:
	alu[$xfer1, --, B, $xfer1]
	alu[$xfer2, --, B, $xfer2]
	hash1_48[$xfer1], ctx_swap
	alu[$xfer1, --, B, $xfer1]
	alu[$xfer2, --, B, $xfer2]
	immed[format, 2]
	alu_shf[--, 0, B, reply, >>31]	; bit 31 on means synchronous
	; if synchronous, go ack
	br>0[Sv_Ack#]					; go call the function
	; asynchronous, function done
	br[Sv_WaitForCall#]



;----------------------------------------------------------------------
; HashSv_Exec64
;	Execute 64 bit hardware hash function
;	input registers:
;		$xfer1: 63:32 of hash input operand
;		$xfer2: 31:0 of hash input operand
;	output registers:
;		$xfer1: 63:32 of hash result value
;		$xfer2: 31:0 of hash result_value
;----------------------------------------------------------------------
HashSv_Exec64Subr#:
	alu[$xfer1, --, B, $xfer1]
	alu[$xfer2, --, B, $xfer2]
	hash1_64[$xfer1], ctx_swap
	alu[$xfer1, --, B, $xfer1]
	alu[$xfer2, --, B, $xfer2]
	immed[format, 2]
	alu_shf[--, 0, B, reply, >>31]	; bit 31 on means synchronous
	; if synchronous, go ack
	br>0[Sv_Ack#]					; go call the function
	; asynchronous, function done
	br[Sv_WaitForCall#]



