/* uof.h
 * uCode Object File header file
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *  system: SA1200
 *  subsystem: Linker/Loader
 *  author: drj Dec 31, 97  Initial version
 *  revisions:
 *  $History: uof.h $
 * 
 * *****************  Version 12  *****************
 * User: Drjohns1     Date: 5/06/99    Time: 5:57p
 * Updated in $/dev_1200/Include
 * Fixed fill-pattern being counted as valid uwords
 * 
 * *****************  Version 11  *****************
 * User: Drjohns1     Date: 5/06/99    Time: 4:11p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 9  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 4:23p
 * Updated in $/development/ucld
 * update COPYRIGHT
 * 
 * *****************  Version 8  *****************
 * User: Drjohns1     Date: 5/21/98    Time: 2:20p
 * Updated in $/base_level2/ucld
 * Updated copyright header
 * 
 * *****************  Version 7  *****************
 * User: Johnsondes   Date: 4/29/98    Time: 5:24p
 * Updated in $/base_level2/ucld
 * Added debug information
 * 
 * *****************  Version 6  *****************
 * User: Johnsondes   Date: 4/13/98    Time: 5:26p
 * Updated in $/base_level2/ucld
 * Encapsulated the UOF objects into seperate chunk
 * 
 * *****************  Version 5  *****************
 * User: Johnsondes   Date: 2/20/98    Time: 8:24p
 * Updated in $/base_level1/ucld
 * Added feature for func_table and changed export_label back to
 * export_func
 * 
 * *****************  Version 4  *****************
 * User: Johnsondes   Date: 2/10/98    Time: 4:06p
 * Updated in $/base_level1/ucld
 * Combined the -z functionality with the -f switch.  Also, provision for
 * the making of DLL/lib
 *
 * ---------------------------------------------------------------------
 */
#ifndef __UOF_H__
#define __UOF_H__

#ifdef __cplusplus
extern "C"{
#endif

#define UOF_MAX_FENGINES    6
#define UOF_MAX_THREADS	    4
#define UOF_MAX_PAGES 	    32
#define UOF_MAX_UWORDS	    1024
#define UOF_OBJID_LEN       8
#define UOF_FIELD_POS_SIZE  12

#define UOF_MAXFUNC_ID      255
#define UOF_AUTONOMOUS_TYPE 0
#define UOF_SERVICE_TYPE    1

#define UOF_ONEWAY	    1
#define UOF_TWOWAY	    2

#define UOF_CFID_0	    0xC6C2
#define UOF_CFID_1	    0xC3CB

#define UOF_OBJS	    "UOF_OBJS"

#define UOF_BLNK	    "        "
#define UOF_STRT	    "UOF_STRT"
#define UOF_GTID	    "UOF_GTID"
#define UOF_IMAG	    "UOF_IMAG"

#define UOF_SUCCESS	    0
#define UOF_FAILURE	    1

#define EXPFUNC_TID_MSK     0xff
#define EXPFUNC_TYP_MSK     0xff
#define EXPFUNC_TID_LSB     0
#define EXPFUNC_TYP_LSB     8

#define ADDR_ATTR_UWORD(addrAttr) ((addrAttr & 0x0000ffff))
#define EXP_FUNC_TID(threadId) ((threadId & 0x0000000f))
#define IMAGE_MICRO_ENGINE(imageAttr) ((imageAttr & 0x000000ff))
#define IMAGE_THREAD_TYPE(imageAttr) ((imageAttr & 0x00000f00) >> 8)
#define IMAGE_FILL_PATTERN(imageAttr) ((imageAttr & 0x01) >> 12)

#define SET_EXPFUNC_TID(attr, val) attr &= EXPFUNC_TID_MSK; attr |= (val << EXPFUNC_TID_LSB)
#define SET_EXPFUNC_TYP(attr, val) attr &= EXPFUNC_TYP_MSK; attr |= (val << EXPFUNC_TYP_LSB)
#define GET_EXPFUNC_TID(attr) ((attr >> EXPFUNC_TID_LSB) & EXPFUNC_TID_MSK)
#define GET_EXPFUNC_TYP(attr) ((attr >> EXPFUNC_TYP_LSB) & EXPFUNC_TYP_MSK)


typedef struct uof_fileHdr_S{
   char 		fileId[UOF_OBJID_LEN];	/* chunk file id */
   short 		maxChunks;				/* max chunks in file */
   short 		numChunks;				/* num of actual chunks */
   /* maxChunks of uof_fileChunkHdr_T immediately follows this header */
}uof_fileHdr_T;

typedef struct uof_fileChunkHdr_S{
   char 		chunkId[UOF_OBJID_LEN];	/* chunk identifier */
   unsigned int	checksum;				/* chunk checksum */
   int	 		offset;					/* offset of the chunk in the file */
   int	 		size;					/* size of the chunk */
}uof_fileChunkHdr_T;					/* 20 bytes total */

typedef struct uof_objHdr_S{
   short 		maxChunks;				/* max chunks in chunk obj */
   short 		numChunks;				/* num of actual chunks */
   /* maxChunks of uof_chunkHdr_T immediately follows this header */
}uof_objHdr_T;

typedef struct uof_chunkHdr_S{
   char 		chunkId[UOF_OBJID_LEN];	/* chunk identifier */
   int	 		offset;					/* offset of the chunk in the file */
   int	 		size;					/* size of the chunk */
}uof_chunkHdr_T;						/* 16 bytes total */


typedef struct uof_strTab_S{
   int			tableLen;				/* length of table */
   char			*strings;				/* NULL terminated strings */
}uof_strTab_T;


typedef struct uof_GTID_S{
   char			toolId[UOF_OBJID_LEN];	/* creator tool ID */
   int			toolVersion;			/* creator tool version */
}uof_GTID_T;


typedef struct uof_codePage_S{
   short		impVarTabSize;			/* import var table size */
   short		codeAreaSize;			/* code area size */
   short		expFuncTabSize;			/* export func table size */
   short		dummy1;					/* word alignment padding */
   int			impVarTabOffset;		/* offset to import var table */
   int			codeAreaOffset;			/* offset to code area */
   int			expFuncTabOffset;		/* offset to export func table */
}uof_codePage_T;

typedef struct uof_Image_S{
   int			imageName;				/* image name */
   int			fillPattern;			/* 4-byte fill pattern */
   short		imageAttrib;			/* image attributes */
   short		entryPage;				/* entry point upage num */
   short		entryAddress;			/* entry point uaddress */
   short		numOfPage;				/* number of pages */
   /* numOfPage of uof_codePage follows this header */
}uof_Image_T;


typedef struct uof_importVar_S{
   int			varName;			/* offset to string table */
   int			uwordAddress;			/* micro word address */
   char			fieldAttrs[UOF_FIELD_POS_SIZE];	/* field pos, size, and right shift value */
}uof_importVar_T;


typedef struct uof_impVarTab_S{
   int			numEntries;			/* number of table entries */
   /* numEntries of uof_importVar_T follows */
}uof_impVarTab_T;


typedef struct uof_expFuncTab_S{
   int			numEntries;			/* number of table entries */
   /* numEntries of uof_exportFunc_T follows */
}uof_expFuncTab_T;


typedef struct uof_exportFunc_S{
   int			funcName;		/* func name offset to string table */
   short		funcAddress;	/* func micro word address */
   short		attr;			/* threadID(byte0:<3:0>), funcType(byte1:<1:0>) */
   short		inArgLen;		/* input arg len in long-words */
   short		outArgLen;		/* output arg len in long-words */
}uof_exportFunc_T;


typedef struct uof_codeArea_S{
   int 			numMicroWords;			/* number of micro words */
   /* numMicroWords of microWord follows micro word */
}uof_codeArea_T;



/* The following structures are used to encapsulate the uof image--they will
   be mapped over the uof image in memory */

typedef struct uof_encapUofObj_S{
   char				*begUof;
   uof_objHdr_T 	*objHdr;
   uof_chunkHdr_T	*chunkHdr;
}uof_encapUofObj_T;

typedef struct uof_encapPage_S{
   int				numImpVar;			/* num of import var in array */
   uof_importVar_T	*importVar;			/* array of import variables */
   int				numExpFunc;			/* num of export func in array */
   uof_exportFunc_T	*exportFunc;		/* array of export functions */
   int				numMicroWords;		/* number of micro words in the array */
   int				*microWords;		/* array of uwords */
}uof_encapPage_T;

typedef struct uof_encapFeng_S{
   uof_Image_T		*images;
   uof_encapPage_T	*pages;				/* array of pages */
}uof_encapFeng_T;

#ifdef __cplusplus
}
#endif

#endif	/* __UOF_H__ */
