/* sem.h
 * Semaphore utility
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *  system: SA1200
 *  subsystem: Common
 *  author: sk/drj Feb 27, 98  Initial version
 *  revisions:
 *  $History: sem.h $
 * 
 * *****************  Version 20  *****************
 * User: Drjohns1     Date: 8/06/99    Time: 4:38p
 * Updated in $/dev_1200/Include
 * Updated for delay in Sem_Wait
 * 
 * *****************  Version 18  *****************
 * User: Drjohns1     Date: 6/04/99    Time: 4:22p
 * Updated in $/dev_1200/Include
 * Changed the compiler directive "UCOS" to "U_COS"
 * 
 * *****************  Version 16  *****************
 * User: Drjohns1     Date: 4/07/99    Time: 1:14p
 * Updated in $/development/common
 * 
 * *****************  Version 15  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 3:20p
 * Updated in $/development/common
 * update COPYRIGHT
 * 
 * *****************  Version 14  *****************
 * User: Hqianx       Date: 3/05/99    Time: 1:37p
 * Updated in $/development/common
 * Modified Sem_Wait() and Sem_Destroy().
 * 
 * *****************  Version 13  *****************
 * User: Drjohns1     Date: 3/04/99    Time: 7:53p
 * Updated in $/development/common
 * Aded delayMs for uCOS and uncomment PRIORITY definitions for uCOS
 * 
 * *****************  Version 12  *****************
 * User: Skornfel     Date: 3/03/99    Time: 7:27p
 * Updated in $/development/common
 * fixed WIN /UCOS macros
 * 
 * *****************  Version 11  *****************
 * User: Skornfel     Date: 3/03/99    Time: 2:26p
 * Updated in $/development/common
 * UCOS added and tested
 * 
 * *****************  Version 10  *****************
 * User: Drjohns1     Date: 9/24/98    Time: 12:40p
 * Updated in $/base_level3/common
 * Removed the MUTEX compile option... Linux & Alpha semaphores are
 * implemented using pthread mutex.
 * 
 * *****************  Version 9  *****************
 * User: Jdguilfo     Date: 9/21/98    Time: 12:09p
 * Updated in $/base_level3/common
 * Fix broken lib for linux. It was using an uninitialized pointer.
 * 
 * *****************  Version 8  *****************
 * User: Lhui         Date: 8/25/98    Time: 11:47a
 * Updated in $/base_level3/common
 * Fix  the Vxwork version of Sem_Init and Sem_Destroy
 * 
 * *****************  Version 7  *****************
 * User: Drjohns1     Date: 6/24/98    Time: 3:45p
 * Updated in $/base_level3/common
 * Removed WAIT_FOREVER from Unix sem_wait
 * 
 * *****************  Version 6  *****************
 * User: Drjohns1     Date: 6/18/98    Time: 3:54p
 * Updated in $/base_level3/common
 * Changed __alpha to __DECC and __DECCXX
 * 
 * *****************  Version 5  *****************
 * User: Drjohns1     Date: 5/21/98    Time: 2:06p
 * Updated in $/base_level2/Common
 * Update copyright header
 * 
 * *****************  Version 4  *****************
 * User: Rparent      Date: 5/12/98    Time: 11:15a
 * Updated in $/base_level2/Common
 * 
 * *****************  Version 3  *****************
 * User: Johnsondes   Date: 3/24/98    Time: 6:02p
 * Updated in $/base_level2/Common
 * 
 * *****************  Version 2  *****************
 * User: Johnsondes   Date: 3/04/98    Time: 4:43p
 * Updated in $/base_level1/Common
 * Fixed compile directive 
 * 
 * *****************  Version 1  *****************
 * User: Johnsondes   Date: 3/03/98    Time: 5:38p
 * Created in $/base_level1/Common
 * Initial version
 * 
 * ---------------------------------------------------------------------
 */
#ifndef __SEM_H
#define __SEM_H

enum{SEM_SUCCESS=0, SEM_FAILED, SEM_TIMEDOUT};
typedef void *sem_T;
#define SEM_WAITFOREVER 0xffffffff

#ifdef __cplusplus
extern "C" {
#endif
sem_T Sem_Init(unsigned int initCount);
int Sem_Destroy(sem_T sem);
int Sem_Post(sem_T sem);
int Sem_Wait(sem_T sem, unsigned int timeout);
#ifdef __cplusplus
}
#endif


#endif /* __SEM_H */
