/* rs_connection.h
 *
 *
 * ------------------------------------------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *------------------------------------------------------------
 *
 * system: SA1200
 * subsystem: Remote Services
 * author: Lai-Wah Hui 2/03/99
 * revisions:
 * $History: rs_connection.h $
 * 
 * *****************  Version 21  *****************
 * User: Lhui         Date: 1/06/00    Time: 6:07p
 * Updated in $/dev_1200/Include
 * Add support for VxWorks serial port 
 * 
 * *****************  Version 20  *****************
 * User: Rdmurato     Date: 10/22/99   Time: 10:43a
 * Updated in $/dev_1200/Include
 * Fix start value for return statuses
 * 
 * *****************  Version 19  *****************
 * User: Lhui         Date: 10/06/99   Time: 4:13p
 * Updated in $/dev_1200/Include
 * Change the new error code values
 * 
 * *****************  Version 16  *****************
 * User: Lhui         Date: 4/22/99    Time: 5:41p
 * Updated in $/development/rs_udebug
 * Add a delay parameter to  rs_udebug/control  hop functions. 
 * 
 * *****************  Version 15  *****************
 * User: Lhui         Date: 4/07/99    Time: 5:08p
 * Updated in $/development/rs_udebug
 * Fix bugs in rs_uDbg_GetUengPCs and rs_uDbg_InitLib 
 * 
 * *****************  Version 14  *****************
 * User: Lhui         Date: 3/29/99    Time: 6:04p
 * Updated in $/development/rs_udebug
 * Add supports for debug control functions (start & hop)
 * 
 * *****************  Version 13  *****************
 * User: Lhui         Date: 3/23/99    Time: 6:36p
 * Updated in $/development/rs_udebug
 * Code cleanup and bug fixing
 * 
 * *****************  Version 12  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 3:48p
 * Updated in $/development/rs_udebug
 * update COPYRIGHT
 * 
 * *****************  Version 11  *****************
 * User: Qabuild      Date: 3/19/99    Time: 4:12p
 * Updated in $/development/rs_udebug
 * update makefile dependencies
 * 
 * *****************  Version 10  *****************
 * User: Lhui         Date: 3/19/99    Time: 1:17p
 * Updated in $/development/rs_udebug
 * Add supports for Scomm.lib
 * 
 * *****************  Version 9  *****************
 * User: Lhui         Date: 3/18/99    Time: 5:48p
 * Updated in $/development/rs_udebug
 * Add supports for SA1200 debug control functions
 * 
 * *****************  Version 8  *****************
 * User: Qabuild      Date: 3/16/99    Time: 4:31p
 * Updated in $/development/rs_udebug
 * Add VxWork supports
 * 
 * *****************  Version 7  *****************
 * User: Lhui         Date: 3/15/99    Time: 3:52p
 * Updated in $/development/rs_udebug
 * Increase the timeout value 
 * 
 * *****************  Version 6  *****************
 * User: Lhui         Date: 3/15/99    Time: 12:05p
 * Updated in $/development/rs_udebug
 * Create a DLL version of rs_udbg_client
 * 
 * *****************  Version 5  *****************
 * User: Lhui         Date: 3/12/99    Time: 2:04p
 * Updated in $/development/rs_udebug
 * Create an  include file for external interface
 * 
 * *****************  Version 4  *****************
 * User: Lhui         Date: 3/09/99    Time: 6:23p
 * Updated in $/development/rs_udebug
 * bug fixing
 * 
 * *****************  Version 3  *****************
 * User: Lhui         Date: 3/01/99    Time: 8:42p
 * Updated in $/development/rs_udebug
 * Fix prototypes
 * 
 * *****************  Version 2  *****************
 * User: Lhui         Date: 2/25/99    Time: 8:52p
 * Updated in $/development/rs_udebug
 * Updated for the latest version of udebug related changes
 * 
 * *****************  Version 1  *****************
 * User: Lhui         Date: 2/23/99    Time: 9:26a
 * Created in $/development/rs_udebug
 * Add supports for multiple Core libraries
 */ 
#ifndef RS_CONNECTION_H
#define RS_CONNECTION_H

#ifdef RS_COMMON_DLL
#define RS_API_NORET __declspec(dllexport)
#define	RS_API	__declspec(dllexport) int __cdecl
#else
#ifdef WIN32
#define	RS_API	__declspec(dllimport) int __cdecl
#else
#define	RS_API	int
#endif
#endif



typedef void *hRS_Conn_T;

enum rs_satus {
	RS_SUCCESS=0x0,         /* call succeeded */
	RS_BADPARAM=0x8600,		/* bad parameter */
	RS_VERSMISMATCH,	    /* rpc versions not compatible */
	RS_PROGUNAVAIL,         /* program not available */
	RS_PROGVERSMISMATCH,    /* program version mismatched */
	RS_PROCUNAVAIL,         /* procedure unavailable */
	RS_SYSTEMERROR,         /* generic "other problem" */
    RS_NOMEMORY,            /* memeory not available */
    RS_UDPCANTREGPROG,      /* can't register with UDP */
    RS_TCPCANTREGPROG,      /* can't register with TCP */
	RS_UNKNOWNSERVER,       /* unknown remote name */
	RS_UNKNOWNPROTO,        /* unkown protocol */
	RS_TIMEOUT,				/* time out */
	RS_ERROR};

#if defined(__cplusplus)
extern "C"
{
#endif
RS_API Open_VxWorks_Connection(char *Server,hRS_Conn_T *hTarget);
RS_API Close_VxWorks_Connection(hRS_Conn_T hTarget);
RS_API Open_EtherNet_Connection(char *Server,hRS_Conn_T *hTarget);
RS_API Close_EtherNet_Connection(hRS_Conn_T hTarget);
RS_API Open_Serial_Connection(char *DevName, hRS_Conn_T *hTarget);
RS_API Close_Serial_Connection(hRS_Conn_T hTarget);
#if defined(__cplusplus)
}
#endif

#endif



