/* hashsv.h
 *
 *
 * ------------------------------------------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *------------------------------------------------------------
 *
 * system: SA1200
 * subsystem: hash service library functions
 * author: Henry Qian 4/4/98
 * revisions:
 * $History: hashsv.h $
 * 
 * *****************  Version 11  *****************
 * User: Drjohns1     Date: 2/08/00    Time: 10:31a
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 9  *****************
 * User: Dmwhite      Date: 10/07/99   Time: 9:34a
 * Updated in $/dev_1200/Include
 * changed errors to separate blocks of numbers
 * 
 * *****************  Version 7  *****************
 * User: Dhooper      Date: 6/16/99    Time: 12:22p
 * Updated in $/dev_1200/Include
 * hsv_Data64 and hsv_Data48 are now hsv_Data
 * 
 * *****************  Version 5  *****************
 * User: Hqianx       Date: 4/27/99    Time: 5:26p
 * Updated in $/dev_1200/SA1_CoreLibs/sv_libs
 * Moved libd.h out.
 * 
 * *****************  Version 4  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 4:18p
 * Updated in $/development/sv_libs
 * update COPYRIGHT
 * 
 * *****************  Version 3  *****************
 * User: Lhui         Date: 5/07/98    Time: 11:09a
 * Updated in $/base_level2/sv_libs
 * Add Intel copyright 
 * 
 * *****************  Version 2  *****************
 * User: C-hqian      Date: 5/12/98    Time: 4:22p
 * Updated in $/base_level2/sv_libs
 * Kept LibD handle in order to delete when library is closed.
 * 
 * *****************  Version 1  *****************
 * User: C-hqian      Date: 4/30/98    Time: 3:28p
 * Created in $/base_level2/sv_libs
 * Hash service library routines.
 * 
 * *****************  Version 1  *****************
 * User: C-hqian      Date: 4/28/98    Time: 1:54p
 * Created in $/base_level2/sv_libs
 * Memory service routine library.
 * 
 */ 
#ifndef HASHSV_H
#define HASHSV_H

#include "svlibs.h"

const int HASHSV_SUCCESS = 0x0;
const int HASHSV_BAD_HANDLE = 0x0;
const int HASHSV_FAIL = 0x0408;
const int HASHSV_MAX_THREADS = 24;

extern void *objHandle;


struct hsv_Data {
    unsigned int lo32;
    unsigned int hi32;
};

#if defined(__cplusplus)
extern "C"
{
#endif

LibHandle* HashSv_Init(
    void* objHandle,    // a handle of uof file
    int appSrcId        // in multi apps, it identifies a specific app
);

int HashSv_LdMult48(
    LibHandle* libHandle,
    hsv_Data* inArg
);

int HashSv_LdMult64(
    LibHandle* libHandle,
    hsv_Data* inArg
);

int HashSv_Exec48(
    LibHandle* libHandle,
    hsv_Data* inArg,
    hsv_Data* outArg
);

int HashSv_Exec64(
    LibHandle* libHandle,
    hsv_Data* inArg,
    hsv_Data* outArg
);

void HashSv_Close(
    LibHandle* libHandle
);

#if defined(__cplusplus)
} // extern "C" {
#endif



#endif /* HASHSV_H */
