/* hal_fbi.h
 * SA1200 Hardware Absraction Library -- FBI
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *
 *  system: SA1200
 *  subsystem: Debug Library
 *  author: dfh, Mar 2, 99  Initial version
 *  revisions:
 *  $History: hal_fbi.h $
 * 
 * *****************  Version 12  *****************
 * User: Drjohns1     Date: 2/15/00    Time: 4:04p
 * Updated in $/dev_1200/Include
 * Removed  fbi->getINTER_THD_SIG(..) -- write-only reg.
 * 
 * *****************  Version 9  *****************
 * User: Dhooper      Date: 7/15/99    Time: 4:38p
 * Updated in $/dev_1200/Include
 * FBI reset to enable stop then restart reference design
 * 
 * *****************  Version 8  *****************
 * User: Dhooper      Date: 7/06/99    Time: 5:48p
 * Updated in $/dev_1200/Include
 * complete the set and get functions for thread_done0 and 1 
 * 
 * *****************  Version 7  *****************
 * User: Lhui         Date: 6/15/99    Time: 11:35a
 * Updated in $/dev_1200/Include
 * Add support for XACTIO
 * 
 * *****************  Version 6  *****************
 * User: Dhooper      Date: 6/03/99    Time: 9:14a
 * Updated in $/dev_1200/Include
 * extern Scratch_Write and Read
 * 
 * *****************  Version 5  *****************
 * User: Dhooper      Date: 5/14/99    Time: 9:26a
 * Updated in $/BL5_Plus/Include
 * change SRAM, SDRAM, FBI_Init to *_Attach
 * 
 * *****************  Version 4  *****************
 * User: Dhooper      Date: 5/12/99    Time: 12:48p
 * Updated in $/dev_1200/Include
 * update to match programmer's ref spec as of 5/10/99
 * 
 * *****************  Version 3  *****************
 * User: Dhooper      Date: 5/11/99    Time: 5:25p
 * Updated in $/dev_1200/Include
 * enforce IOSTYLE FARDWARE or AMBAIO for CSR access
 * 
 * *****************  Version 2  *****************
 * User: Dhooper      Date: 5/10/99    Time: 12:42p
 * Updated in $/dev_1200/Include
 * fbi init function
 * 
 * *****************  Version 1  *****************
 * User: Dhooper      Date: 5/07/99    Time: 1:25p
 * Created in $/dev_1200/Include
 *  hal_fbi.h from hal_1200
 * 
 * *****************  Version 2  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 3:41p
 * Updated in $/development/hal_1200
 * update COPYRIGHT
 * 
 * *****************  Version 1  *****************
 * User: Dhooper      Date: 3/02/99    Time: 6:44p
 * Created in $/development/hal_1200
 * fbi hardware abstraction lib
 * 
 * ---------------------------------------------------------------------
 */
#ifndef HAL_FBI_H
#define HAL_FBI_H

#include <stdio.h>

#ifdef __cplusplus
#include "core_io.h"
#endif


enum FbiAddresses{
	FBI_CSR_BASE =			0xB0040000,
	FBI_SCRATCH_PAD_BASE =	0xB0044000
};


enum FbiCsrByteOffsets{
	THREAD_DONE_REG0 =			0x008,
	THREAD_DONE_REG1 =			0x00C,

	RCV_CNTL =					0x018,
	RCV_REQ =					0x01C,
	SOP_SEQ1 =					0x020,
	SOP_SEQ2 =					0x024,
	ENQUEUE_SEQ1 =				0x028,
	ENQUEUE_SEQ2 =				0x02C,
	REC_FASTPORT_CTL =			0x030,

	RCV_RDY_CNT	=				0x0C0,
	RCV_RDY_LO	=				0x0C4,
	RCV_RDY_HI	=				0x0C8,

	XMIT_PTR =					0x0E0,
	XMIT_RDY_LO =				0x0E4,
	XMIT_RDY_HI =				0x0E8,

	RCV_RDY_CTL =				0x0F8,
	XMIT_RDY_CTL =				0x0FC,

	HASH_MULTIPLIER_64_LO =		0x140,
	HASH_MULTIPLIER_64_HI =		0x144,
	HASH_MULTIPLIER_48_LO =		0x148,
	HASH_MULTIPLIER_48_HI =		0x14C,

	RDYBUS_TEMPLATE_CTL =		0x180,
	RDYBUS_TEMPLATE_PROG_1 =	0x184,
	RDYBUS_TEMPLATE_PROG_2 =	0x188,
	RDYBUS_TEMPLATE_PROG_3 =	0x18C,
	RDYBUS_SYNCH_COUNT_DEFAULT =0x190,
	FLOWCTL_MASK =				0x194,
	SEND_CMD =					0x198,
	RFIFO_ADDR =				0x19C,

	FP_READY_WAIT =				0x1A4,

	GET_CMD =					0x1B0,

	INTER_THD_SIG =				0x1C0,

	SELF_DESTRUCT =				0x1D4,

	IREG =						0x1E0
};

#define FBI_RESET_MASK 0x10000

#ifdef __cplusplus

class FbiUnit{
public:
	FbiUnit(){}
	~FbiUnit(){}


// in the order of the programmer's manual:
	inline void setIREG(unsigned int val){WRITE_LWORD(&ireg, val);}
	inline void getIREG(unsigned int *val){READ_LWORD(&ireg, val);}

	inline void getSOP_SEQ1(unsigned int *val){READ_LWORD(&sop_seq1, val);}
	inline void getSOP_SEQ2(unsigned int *val){READ_LWORD(&sop_seq2, val);}

	inline void getENQUEUE_SEQ1(unsigned int *val){READ_LWORD(&enqueue_seq1, val);}
	inline void getENQUEUE_SEQ2(unsigned int *val){READ_LWORD(&enqueue_seq2, val);}

	inline void setINTER_THD_SIG(unsigned int val){WRITE_LWORD(&inter_thd_sig, val);}
//dj: write-only reg:	inline void getINTER_THD_SIG(unsigned int *val){READ_LWORD(&inter_thd_sig, val);}
	
	inline void setTHREAD_DONE_REG0(unsigned int val){WRITE_LWORD(&thread_done_reg0, val);}
	inline void getTHREAD_DONE_REG0(unsigned int *val){READ_LWORD(&thread_done_reg0, val);}

	inline void setTHREAD_DONE_REG1(unsigned int val){WRITE_LWORD(&thread_done_reg1, val);}
	inline void getTHREAD_DONE_REG1(unsigned int *val){READ_LWORD(&thread_done_reg1, val);}

	inline void getRCV_RDY_CNT(unsigned int *val){READ_LWORD(&rcv_rdy_cnt, val);}
	inline void getRCV_RDY_HI(unsigned int *val){READ_LWORD(&rcv_rdy_hi, val);}
	inline void getRCV_RDY_LO(unsigned int *val){READ_LWORD(&rcv_rdy_lo, val);}

	inline void setRCV_RDY_CTL(unsigned int val){WRITE_LWORD(&rcv_rdy_ctl, val);}
	inline void getRCV_RDY_CTL(unsigned int *val){READ_LWORD(&rcv_rdy_ctl, val);}

	inline void setRCV_REQ(unsigned int val){WRITE_LWORD(&rcv_req, val);}
	inline void getRCV_CNTL(unsigned int *val){READ_LWORD(&rcv_cntl, val);}

	inline void getREC_FASTPORT_CTL(unsigned int *val){READ_LWORD(&rec_fastport_ctl, val);}

	inline void setFP_READY_WAIT(unsigned int val){WRITE_LWORD(&fp_ready_wait, val);}

	inline void setRFIFO_ADDR(unsigned int val){WRITE_LWORD(&rfifo_addr, val);}

	inline void setFLOWCTL_MASK(unsigned int val){WRITE_LWORD(&flowctl_mask, val);}
	inline void getFLOWCTL_MASK(unsigned int *val){READ_LWORD(&flowctl_mask, val);}

	inline void setRDYBUS_TEMPLATE_CTL(unsigned int val){WRITE_LWORD(&rdybus_template_ctl, val);}
	inline void setRDYBUS_TEMPLATE_PROG_1(unsigned int val){WRITE_LWORD(&rdybus_template_prog_1, val);}
	inline void setRDYBUS_TEMPLATE_PROG_2(unsigned int val){WRITE_LWORD(&rdybus_template_prog_2, val);}
	inline void setRDYBUS_TEMPLATE_PROG_3(unsigned int val){WRITE_LWORD(&rdybus_template_prog_3, val);}
	inline void setRDYBUS_SYNCH_COUNT_DEFAULT(unsigned int val){WRITE_LWORD(&rdybus_synch_count_default, val);}

	inline void getSELF_DESTRUCT(unsigned int *val){READ_LWORD(&self_destruct, val);}

	inline void setHASH_MULTIPLIER_64_HI(unsigned int val){WRITE_LWORD(&hash_multiplier_64_hi, val);}
	inline void getHASH_MULTIPLIER_64_HI(unsigned int *val){READ_LWORD(&hash_multiplier_64_hi, val);}

	inline void setHASH_MULTIPLIER_64_LO(unsigned int val){WRITE_LWORD(&hash_multiplier_64_lo, val);}
	inline void getHASH_MULTIPLIER_64_LO(unsigned int *val){READ_LWORD(&hash_multiplier_64_lo, val);}

	inline void setHASH_MULTIPLIER_48_HI(unsigned int val){WRITE_LWORD(&hash_multiplier_48_hi, val);}
	inline void getHASH_MULTIPLIER_48_HI(unsigned int *val){READ_LWORD(&hash_multiplier_48_hi, val);}

	inline void setHASH_MULTIPLIER_48_LO(unsigned int val){WRITE_LWORD(&hash_multiplier_48_lo, val);}
	inline void getHASH_MULTIPLIER_48_LO(unsigned int *val){READ_LWORD(&hash_multiplier_48_lo, val);}

	inline void setSEND_CMD(unsigned int val){WRITE_LWORD(&send_cmd, val);}
	inline void getGET_CMD(unsigned int *val){READ_LWORD(&get_cmd, val);}

	inline void getXMIT_RDY_LO(unsigned int *val){READ_LWORD(&xmit_rdy_lo, val);}
	inline void getXMIT_RDY_HI(unsigned int *val){READ_LWORD(&xmit_rdy_hi, val);}

	inline void setXMIT_RDY_CTL(unsigned int val){WRITE_LWORD(&xmit_rdy_ctl, val);}
	inline void getXMIT_RDY_CTL(unsigned int *val){READ_LWORD(&xmit_rdy_ctl, val);}

	inline void getXMIT_PTR(unsigned int *val){READ_LWORD(&xmit_ptr, val);}

	inline void scratch_pad_write(unsigned short regNum, unsigned int val){WRITE_LWORD((regNum<<2)+FBI_SCRATCH_PAD_BASE, val);}
	inline void scratch_pad_read(unsigned short regNum, unsigned int *val){READ_LWORD((regNum<<2)+FBI_SCRATCH_PAD_BASE, val);}



private:									// word offset: hex byte offset:
	unsigned int reserve_0_1[2];			//		0-1			0x0-0x004

	unsigned int thread_done_reg0;			//		2			0x008
	unsigned int thread_done_reg1;			//		3			0x00C
	unsigned int reserve_4_5[2];			//		4-5			0x010-0x014

	unsigned int rcv_cntl;					//		6			0x018
	unsigned int rcv_req;					//		7			0x01C
	unsigned int sop_seq1;					//		8			0x020
	unsigned int sop_seq2;					//		9			0x024
	unsigned int enqueue_seq1;				//		10			0x028
	unsigned int enqueue_seq2;				//		11			0x02C
	unsigned int rec_fastport_ctl;			//		12			0x030
	unsigned int reserve_13_47[35];			//		13-47		0x034-0x0BC

	unsigned int rcv_rdy_cnt;				//		48			0x0C0
	unsigned int rcv_rdy_lo;				//		49			0x0C4
	unsigned int rcv_rdy_hi;				//		50			0x0C8
	unsigned int reserve_51_55[5];			//		51-55		0x0CC-0x0DC
	
	unsigned int xmit_ptr;					//		56			0x0E0
	unsigned int xmit_rdy_lo;				//		57			0x0E4
	unsigned int xmit_rdy_hi;				//		58			0x0E8
	unsigned int reserve_59_61[3];			//		59-61		0x0CC-0x0F4

	unsigned int rcv_rdy_ctl;				//		62			0x0F8
	unsigned int xmit_rdy_ctl;				//		63			0x0FC
	unsigned int reserve_64_79[16];			//		64-79		0x100-0x13C

	unsigned int hash_multiplier_64_lo;		//		80			0x140
	unsigned int hash_multiplier_64_hi;		//		81			0x144
	unsigned int hash_multiplier_48_lo;		//		82			0x148
	unsigned int hash_multiplier_48_hi;		//		83			0x14C
	unsigned int reserve_84_95[12];			//		84-95		0x150-0x17C

	unsigned int rdybus_template_ctl;		//		96			0x180
	unsigned int rdybus_template_prog_1;	//		97			0x184
	unsigned int rdybus_template_prog_2;	//		98			0x188
	unsigned int rdybus_template_prog_3;	//		99			0x18C
	unsigned int rdybus_synch_count_default;//		100			0x190
	unsigned int flowctl_mask;				//		101			0x194
	unsigned int send_cmd;					//		102			0x198
	unsigned int rfifo_addr;				//		103			0x19C
	unsigned int reserve_104;				//		104			0x1A0
	
	unsigned int fp_ready_wait;				//		105			0x1A4
	unsigned int reserve_106_107[2];		//		106-107		0x1A8-0x1AC

	unsigned int get_cmd;					//		108			0x1B0
	unsigned int reserve_109_111[3];		//		109-111		0x1B4-0x1BC

	unsigned int inter_thd_sig;				//		112			0x1C0
	unsigned int reserve_113_116[4];		//		113-116		0x1C4-0x1D0

	unsigned int self_destruct;				//		117			0x1D4
	unsigned int reserve_118_119[2];		//		118-119		0x1D8-0x1DC

	unsigned int ireg;						//		120			0x1E0
};


extern "C"
{
#endif		// __cplusplus


extern FbiUnit	*FBI_Attach();
extern void FBI_Reset();
extern void Scratch_Write(unsigned int addr, unsigned int val);
extern unsigned int Scratch_Read(unsigned int addr);


#if defined(__cplusplus)
}
#endif		// __cplusplus


#endif			// HAL_FBI_H
