/* debug_1200.h
 * Ucode Debug Library Register
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *
 *  system: SA1200
 *  subsystem: Debug Library
 *  author: drj, June 16,98  Initial version
 *  revisions:
 *  $History: debug_1200.h $
 * 
 * *****************  Version 56  *****************
 * User: Dmwhite      Date: 2/29/00    Time: 9:27a
 * Updated in $/dev_1200/Include
 * test
 * 
 * *****************  Version 55  *****************
 * User: Dmwhite      Date: 2/29/00    Time: 7:55a
 * Updated in $/dev_1200/Include
 * psos ARM compile  switch -pedantic wants <CRLF> before<EOF> and no xtra
 * ',' in enums
 * 
 * *****************  Version 53  *****************
 * User: Drjohns1     Date: 10/27/99   Time: 1:02p
 * Updated in $/dev_1200/Include
 * Changed uengine error/status codes
 * 
 * *****************  Version 52  *****************
 * User: Drjohns1     Date: 10/18/99   Time: 3:47p
 * Updated in $/dev_1200/Include
 * Made UDBG_NOUSTORE not negative
 * 
 * *****************  Version 51  *****************
 * User: Drjohns1     Date: 10/18/99   Time: 11:04a
 * Updated in $/dev_1200/Include
 * Added function which returns the virtual memory regions.
 * 
 * *****************  Version 50  *****************
 * User: Drjohns1     Date: 10/13/99   Time: 3:10p
 * Updated in $/dev_1200/Include
 * Updated error codes
 * 
 * *****************  Version 49  *****************
 * User: Drjohns1     Date: 10/04/99   Time: 11:56a
 * Updated in $/dev_1200/Include
 * Changed uDbg_CTXx from enum's to #define's
 * 
 * *****************  Version 48  *****************
 * User: Rdmurato     Date: 9/28/99    Time: 3:45p
 * Updated in $/dev_1200/Include
 * Fix typo, change uDbg_ReadFIFO_Tx to uDbg_ReadFIFO_Rx 
 * 
 * *****************  Version 47  *****************
 * User: Drjohns1     Date: 9/22/99    Time: 12:55p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 1  *****************
 * User: Drjohns1     Date: 7/01/98    Time: 2:01p
 * Created in $/users/Johnson/SA1200/udebug
 * 
 * ---------------------------------------------------------------------
 */
#ifndef __DEBUG_1200_H
#define __DEBUG_1200_H

#include "ueng_constants.h"

enum{
	CNTL_SUCCESS = 0,
	CNTL_FAIL = 0x100,
	CNTL_NOT_RUNNING,
	CNTL_NOT_AT_RESET,
	CNTL_NOT_IN_STOP
};

enum{
	UDBG_UENG_INACTIVE,
	UDBG_UENG_ACTIVE,
	UDBG_UENG_AT_BREAK
};

enum{
   UDBG_SUCCESS		= UENG_SUCCESS,		// the operation was successful
   UDBG_FAIL		= UENG_FAIL,		// the operation failed
   UDBG_BADARG		= UENG_BADARG,		// bad function argument
   UDBG_DUPBKP		= UENG_DUPBKP,		// duplicate break point
   UDBG_BADADDR		= UENG_BADADDR,		// bad address
   UDBG_BADLIB		= UENG_BADLIB,		// bad debug library -- wasn't initialized
   UDBG_TIMEOUT		= UENG_TIMEOUT,		// the operation exceeded the time limit
   UDBG_NOUSTORE	= UENG_NOUSTORE,	// no available space in micro-space
   UDBG_UENGINACT   = UENG_INACTIVE,	// engine inactive
   UDBG_UENGACT	    = UENG_ACTIVE,		// engine active
   UDBG_UENGATBREAK	= UENG_ATBREAK,		// at breakpoint
   UDBG_RESET		= UENG_RESET		// engine in reset
};

#define UDBG_MAX_BREAKPOINTS	64
#define UDEBUG_CTX_ALL			0xf

#define	UDBG_CTX0	1
#define	UDBG_CTX1	2
#define	UDBG_CTX2	4
#define	UDBG_CTX3	8
#define	UDBG_CTXANY 0xf
typedef unsigned int uDbg_CTX_T;

typedef enum{
	UDBG_SDRAM,
	UDBG_SRAM
}uDbg_Storage_T;


typedef struct{
   char  state; 			// active, inactive, break
   char  ctx; 				// contex enable
   char  enables;			// cc<7:6>, csrWrite<5>, sram-journal<4>, ctx<3:0>
   char  breakId;			// breakpint ID
   short pc;				// active PC
}uDbg_uEngStatus_T;


typedef struct uDbg_Bkpt{
   void (*callback)(unsigned short bkptId, unsigned char ueng,
					unsigned char ctx, void *usrData);
   short		  id;				// out: the assigned ID of the breakpoint
   unsigned short ctx;				// out: context at breakpoint
   unsigned short uAddr;			// in: micro-store address
   unsigned char  uEng;				// in: micro-engine at breakpoint
   void			  *usrData;			// in: pointer to user data
   uDbg_CTX_T	  breakIfCtx;		// in: break if equal to ctx
   unsigned int   stpOnBrkUengMask;	// in: micro-engines to stop on break
} uDbg_Bkpt_T;


typedef struct uDbg_BkptArray{
   unsigned short len;				// number of elements in array
   uDbg_Bkpt_T bkpts[UDBG_MAX_BREAKPOINTS];			// array of integers
} uDbg_BkptArray_T;


typedef struct {
	void (*callback)(unsigned short bkptId, unsigned char ueng,
					unsigned char ctx, void *usrData);
    void		   *usrData;			// pointer to user data
    unsigned int   uword;				// the micro-word at the breakpoint
	short		   id;
	unsigned short upc;
	unsigned short ctxBreak;			// the context at the breakpoint
	unsigned short brUpc;
	unsigned char  state;
	unsigned char  ueng;
	uDbg_CTX_T	   breakIfCtx;			// break if equal to ctx
    unsigned int   stpUengMask;			// micro-engines to stop on break
}Breakpoint_T;


typedef struct{
   unsigned short freeUpc[MAX_UENGS];
   unsigned short freeSize[MAX_UENGS];
}uDbg_uStoreFree_T;

typedef enum{UDBG_GPR_A_BANK, UDBG_GPR_B_BANK} uDbg_Bank_T;
typedef void *uDbg_Handle_T;



typedef void* uDbg_Handle_T;

enum ControlType {
    GIVE_CONTROL = 0,
    TAKE_CONTROL,
    INIT_UOF
};

typedef int (*FUNC_CONTROL)(unsigned int, void *);
typedef int (*FUNC_INITUOF)(char*, int, void *);


#ifdef __cplusplus
extern "C" {
#endif

uDbg_Handle_T uDbg_InitLib(uDbg_uStoreFree_T *uStoreFree);
void uDbg_DeleLib(uDbg_Handle_T dbgH);
void uDbg_DefineFreeUstore(uDbg_Handle_T dbgH, unsigned int uEngMask, 
						   unsigned int freeUaddr, unsigned int freeSize);
void uDbg_UpdateFreeUstore(uDbg_Handle_T dbgH, unsigned int uEngMask);

int uDbg_ResetUeng(uDbg_Handle_T dbgH, unsigned int uEngMask, int clrReg);
int uDbg_ClrResetUeng(uDbg_Handle_T dbgH, unsigned int uEngMask);
int uDbg_StartUeng(uDbg_Handle_T dbgH, unsigned int uEngMask);
int uDbg_PauseUeng(uDbg_Handle_T dbgH, unsigned int uEngMask, unsigned int delay);
int uDbg_ResumeUeng(uDbg_Handle_T dbgH, unsigned int uEngMask);
int uDbg_IsUengActive(uDbg_Handle_T dbgH, unsigned int uEngMask);
unsigned int uDbg_GetActiveUengs(uDbg_Handle_T dbgH, unsigned int uEngMask);

int uDbg_SetUthreadsPC(uDbg_Handle_T dbgH, unsigned int uEngMask, unsigned int ctxMask, unsigned int upc);
int uDbg_GetUthreadPC(uDbg_Handle_T dbgH, unsigned char uEng, unsigned char ctx, unsigned int *pc);
int uDbg_SetUengPCs(uDbg_Handle_T dbgH, unsigned char uEng, unsigned int *upc);
int uDbg_GetUengPCs(uDbg_Handle_T dbgH, unsigned char uEng, unsigned int *upc);

int uDbg_SetUword(uDbg_Handle_T dbgH, unsigned int uEngMask, unsigned int uWordAddr, unsigned int uWord);
int uDbg_GetUword(uDbg_Handle_T dbgH, unsigned int uEng, unsigned int uWordAddr, unsigned int *uWord);
int uDbg_SetNumUword(uDbg_Handle_T dbgH, unsigned int uEngMask, unsigned int uWordAddr,
					 unsigned short numWords, unsigned int *uWord);
int uDbg_GetNumUword(uDbg_Handle_T dbgH, unsigned int uEngMask, unsigned int uWordAddr,
					 unsigned short numWords, unsigned int *uWord);

int uDbg_WriteMem32(uDbg_Handle_T dbgH, unsigned int addr, unsigned int *data, unsigned int count);
int uDbg_ReadMem32(uDbg_Handle_T dbgH, unsigned int addr, unsigned int *data, unsigned int count);
int uDbg_WriteMem64(uDbg_Handle_T dbgH, unsigned int addr, unsigned int *data, unsigned int count);
int uDbg_ReadMem64(uDbg_Handle_T dbgH, unsigned int addr, unsigned int *data, unsigned int count);

int uDbg_SetBreakpoint(uDbg_Handle_T dbgH, uDbg_Bkpt_T *breakpoint);
int uDbg_ShowBreakpoints(uDbg_Handle_T dbgH, unsigned int uEng, uDbg_BkptArray_T *breakpoints);
int uDbg_ClearBreakpoint(uDbg_Handle_T dbgH, unsigned int breakpointId);
int uDbg_ClearAllBreakpoints(uDbg_Handle_T dbgH, unsigned int uEngMask);

int uDbg_SetCSR (uDbg_Handle_T dbgH, unsigned int csr, unsigned int data);
int uDbg_GetCSR (uDbg_Handle_T dbgH, unsigned int csr, unsigned int *data);

int uDbg_PutRelGPR(uDbg_Handle_T dbgH, char uEng, unsigned char ctx,
				   uDbg_Bank_T bankType, unsigned int regNum,
				   unsigned int *regData, unsigned int count);

int uDbg_GetRelGPR(uDbg_Handle_T dbgH, char uEng, unsigned char ctx,
				   uDbg_Bank_T bankType, unsigned int regNum,
				   unsigned int *regData, unsigned int count);

int uDbg_PutRelSRAM_WrXfer(uDbg_Handle_T dbgH, char uEng, unsigned char ctx, unsigned int regNum,
						   unsigned int *regData, unsigned int count);

int uDbg_GetRelSRAM_WrXfer(uDbg_Handle_T dbgH, char uEng, unsigned char ctx, unsigned int regNum,
						   unsigned int *regData, unsigned int count);

int uDbg_PutRelSRAM_RdXfer(uDbg_Handle_T dbgH, char uEng, unsigned char ctx, unsigned int regNum,
						   unsigned int *regData, unsigned int count);

int uDbg_GetRelSRAM_RdXfer(uDbg_Handle_T dbgH, char uEng, unsigned char ctx, unsigned int regNum,
						   unsigned int *regData, unsigned int count);

int uDbg_PutRelSDRAM_WrXfer(uDbg_Handle_T dbgH, char uEng, unsigned char ctx, unsigned int regNum,
							unsigned int *regData, unsigned int count);

int uDbg_GetRelSDRAM_WrXfer(uDbg_Handle_T dbgH, char uEng, unsigned char ctx, unsigned int regNum,
							unsigned int *regData, unsigned int count);

int uDbg_PutRelSDRAM_RdXfer(uDbg_Handle_T dbgH, char uEng, unsigned char ctx, unsigned int regNum,
							unsigned int *regData, unsigned int count);

int uDbg_GetRelSDRAM_RdXfer(uDbg_Handle_T dbgH, char uEng, unsigned char ctx, unsigned int regNum,
							unsigned int *regData, unsigned int count);

int uDbg_WriteFIFO_Tx(uDbg_Handle_T dbgH, unsigned char uEng, unsigned int fifoAddr, unsigned int *data64, unsigned int count, int setValid);
int uDbg_ReadFIFO_Rx(uDbg_Handle_T dbgH, unsigned char uEng, unsigned int fifoAddr, unsigned int *data64, unsigned int count);

int uDbg_GetUengStatus(uDbg_Handle_T dhgH, unsigned char uEng, uDbg_uEngStatus_T *uEngStatus);
int uDbg_HopUeng(uDbg_Handle_T dhgH, unsigned int *uEngMask, unsigned int delay);
int uDbg_GetSysMemSize(uDbg_Handle_T dbgH, unsigned int* sys, unsigned int* sys_all, unsigned int* sdram,unsigned int* sram, unsigned int* flash);


int CNTL_InitUof(char* buf, int buflen);

int CNTL_Reset(uDbg_Handle_T uDbg_Handle, unsigned int engineMask, unsigned int portMask, int clrReg);

int CNTL_Start(uDbg_Handle_T uDbg_Handle, unsigned int engineMask,unsigned int portMask);

int CNTL_Pause(uDbg_Handle_T uDbg_Handle, unsigned int engineMask, unsigned int portMask,unsigned int delay);

int CNTL_Resume(uDbg_Handle_T uDbg_Handle, unsigned int engineMask,unsigned int portMask);

int CNTL_Hop(uDbg_Handle_T uDbg_Handle, unsigned int *engineMask, unsigned int portMask, unsigned int delay);


#ifdef __cplusplus
}
#endif


#endif			/* __DEBUG_1200_H  leave next blank line here */
