/* net_app.h
 * SA1200 Network Application
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *
 *  system: SA1200
 *  subsystem: core network application
 *  author: dfh, May 13, 99  Initial version
 *  revisions:
 *  $History: net_app.h $
 * 
 * *****************  Version 19  *****************
 * User: Lhui         Date: 5/05/00    Time: 4:07p
 * Updated in $/dev_1200/SA1_CoreLibs/app_1200
 * Add support for boot application
 * 
 * *****************  Version 16  *****************
 * User: Lhui         Date: 5/02/00    Time: 8:30p
 * Updated in $/dev_1200/SA1_CoreLibs/app_1200
 * Add extern "C" 
 * 
 * *****************  Version 13  *****************
 * User: Drjohns1     Date: 12/17/99   Time: 12:04p
 * Updated in $/dev_1200/SA1_CoreLibs/app_1200
 * Incorporated rtm and brm into netApp
 * 
 * *****************  Version 12  *****************
 * User: Dhooper      Date: 8/18/99    Time: 11:15a
 * Updated in $/dev_1200/SA1_CoreLibs/app_1200
 * put void * arg back in NetAp_Init. call NetApp_Init with NULL for
 * NetApp_GigInit
 * 
 * *****************  Version 11  *****************
 * User: Dhooper      Date: 8/18/99    Time: 11:09a
 * Updated in $/dev_1200/SA1_CoreLibs/app_1200
 * remove void * arg to NetApp_Init
 * 
 * *****************  Version 9  *****************
 * User: Skornfel     Date: 6/21/99    Time: 9:41a
 * Updated in $/dev_1200/SA1_CoreLibs/app_1200
 * 12 port refdes run
 * 
 * *****************  Version 8  *****************
 * User: Dhooper      Date: 6/09/99    Time: 7:08p
 * Updated in $/dev_1200/SA1_CoreLibs/app_1200
 * #ifdef UC_BUFFER around the function NetApp_UCLoadBuffer
 * 
 * *****************  Version 7  *****************
 * User: Jdguilfo     Date: 6/09/99    Time: 7:01p
 * Updated in $/dev_1200/SA1_CoreLibs/app_1200
 * UCLoadBuffer
 * 
 * *****************  Version 6  *****************
 * User: Dhooper      Date: 6/08/99    Time: 10:41a
 * Updated in $/dev_1200/SA1_CoreLibs/app_1200
 * separate NetApp_UCLoadFile
 * 
 * *****************  Version 5  *****************
 * User: Dhooper      Date: 6/03/99    Time: 1:27p
 * Updated in $/dev_1200/SA1_CoreLibs/app_1200
 * add portMask for Start and  Stop, add thread registry
 * 
 * *****************  Version 4  *****************
 * User: Dhooper      Date: 6/02/99    Time: 2:50p
 * Updated in $/dev_1200/SA1_CoreLibs/app_1200
 * move netapp functions to sysconf
 * 
 * *****************  Version 1  *****************
 * User: Dhooper      Date: 5/19/99    Time: 9:59a
 * Created in $/BL5_Plus/SA1_CoreLibs/app_1200
 * app_1200 pre-review
 * 
 * 
 * ---------------------------------------------------------------------
 */


#ifndef __NET_APP_H
#define __NET_APP_H


#if defined(__cplusplus)
extern "C"
{
extern void NetApp_GigInit(void);
}
#endif
extern int NetApp_Init(void);
extern void NetApp_GigInit(void);
extern int NetApp_UCLoadFile(char *filename);
#ifdef UC_BUFFER
extern int NetApp_UCLoadBuffer(void);
#endif
extern int NetApp_LoadSysParam(char * filename);
extern int NetApp_Reset();
extern int NetApp_Run(unsigned int engine_mask, unsigned int port_mask);
extern int NetApp_Stop(unsigned int engine_mask, unsigned int port_mask);
extern int NetApp_Start(unsigned int engine_mask, unsigned int port_mask);
extern int NetApp_LoadRoutes(int port_count);
extern int NetApp_ZeroGPRs();


#endif		// __NET_APP_H
