/* xact_gui.h
 * 
 * ---------------------------------------------------------------------	
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 * ---------------------------------------------------------------------
 *
 * system: IXP1200
 * subsystem: Transactor
 * author: bw
 * revisions:
 * $History: xact_gui.h $
 * 
 * *****************  Version 13  *****************
 * User: Dbernste     Date: 3/23/00    Time: 5:06p
 * Updated in $/dev_1200/Include
 * add changes for receive request metatags
 * 
 * *****************  Version 12  *****************
 * User: Dbernste     Date: 3/02/00    Time: 4:56p
 * Updated in $/dev_1200/Include
 * changes to support inter_thread_signal info the in the meta tag
 * 
 * *****************  Version 11  *****************
 * User: Dbernste     Date: 3/01/00    Time: 4:25p
 * Updated in $/dev_1200/Include
 * add fbi stuff to ref_packet_type and ref_cmd_type
 * 
 * *****************  Version 8  *****************
 * User: Bwheeler     Date: 9/15/99    Time: 12:39p
 * Updated in $/dev_1200/Include
 * add api for rich to get meta tag info from raw ref data
 * 
 * *****************  Version 7  *****************
 * User: Bwheeler     Date: 9/13/99    Time: 11:57a
 * Updated in $/dev_1200/Include
 * fix prototype def for newly added api
 * 
 * *****************  Version 6  *****************
 * User: Bwheeler     Date: 9/13/99    Time: 8:03a
 * Updated in $/dev_1200/Include
 * add api for rich to get data associated with cam
 * 
 * *****************  Version 5  *****************
 * User: Qabuild      Date: 9/10/99    Time: 11:29a
 * Updated in $/dev_1200/Include
 * Updated xact_gui.h file to use C style comments only.
 * 
 * *****************  Version 4  *****************
 * User: Qabuild      Date: 9/09/99    Time: 4:16p
 * Updated in $/dev_1200/Include
 * included xact_gui.h and declared C struct to typedef ref
 * characteristic...
 * 
 * *****************  Version 3  *****************
 * User: Rdmurato     Date: 9/09/99    Time: 11:37a
 * Updated in $/dev_1200/Include
 * Need conditional 'extern C' for function prototypes
 * 
 * *****************  Version 2  *****************
 * User: Bwheeler     Date: 9/07/99    Time: 4:01p
 * Updated in $/dev_1200/Include
 * add reference decomposer for Rich
 * move some APIs from xact.h to xact_gui.h  (gui-specific stuff)
 * 
 * *****************  Version 1  *****************
 * User: Rdmurato     Date: 9/03/99    Time: 12:52p
 * Created in $/dev_1200/Include
 * Initial version
 *
 */

#if !defined(__XACT_GUI_H)
#define __XACT_GUI_H

#include "xact.h"
#include "xact_gui.h"

#define STAT_STR_LEN		STRING_VAR_LEN


typedef struct string_var Stat_str;

struct stat_characteristic
	{
	int min_sample;					/* minimum value sampled */
	int max_sample;					/* maximum value sampled */
	int num_samples;				/* number of samples recorded */
	int sampled_sum;				/* sum of sample values */
	
	int min_bucket_value;			/* value of smallest allocated bucket */
	int max_bucket_value;			/* value of largest allocated bucket */
	int bucket_size;				/* range of contiguous int values per bucket */
	int num_buckets;				/* number of buckets to capture samples */
	int titled_buckets;				/* TRUE if each bucket is given a name */

	Stat_str stat_title;			/* holds title of statistic */
	Stat_str unit_specifier;		/* holds string specifying the units of the samples recorded */
	};
typedef struct stat_characteristic Stat_characteristic;



struct ref_datum
	{
	unsigned int			data;		/* data field */
	int						vb;			/* valid bit (data field is invalid if this bit is clear) */
	};
typedef struct ref_datum Ref_datum;


enum REF_PACKET__TYPE
	{
	REF_PACKET__SRAM,
	REF_PACKET__SDRAM, 
	REF_PACKET__FBI
	};
typedef enum REF_PACKET__TYPE REF_PACKET__TYPE;


enum REF_CMD__TYPE
	{
	REF_CMD__SDRAM_RD,
	REF_CMD__SDRAM_WR,
	REF_CMD__SDRAM_RD_FR_RFIFO,
	REF_CMD__SDRAM_WR_TO_TFIFO,
	REF_CMD__SRAM_RD,
	REF_CMD__SRAM_RD_LK,
	REF_CMD__SRAM_WR,
	REF_CMD__SRAM_WR_UNLK,
	REF_CMD__SRAM_UNLK,
	REF_CMD__SRAM_POP,
	REF_CMD__SRAM_PUSH,
	REF_CMD__SRAM_BIT_WR, 
	REF_CMD__SCRATCH_RD,
	REF_CMD__SCRATCH_WR,
	REF_CMD__SCRATCH_BIT_WR, 
	REF_CMD__SCRATCH_INC,
	REF_CMD__TFIFO_WR,
	REF_CMD__RFIFO_RD,
	REF_CMD__FBI_CSR_RD,
	REF_CMD__FBI_CSR_WR,
	REF_CMD__HASH
	};
typedef enum REF_CMD__TYPE REF_CMD__TYPE;



struct ref_characteristic
	{
	REF_CMD__TYPE			ref_cmd;		/* type of reference */
	unsigned int			ref_addr;		/* address of reference */
	Ref_datum				fifo_addr;		/* address of fifo:  valid only for sdram rfifo/tfifo refs */
	Ref_datum				byte_mask;		/* byte mask corresponding to refs */
	Ref_datum				ref_cnt;		/* num of lws corresponding to ref */
	Ref_datum				xfer_reg;		/* register associated with ref */
	Ref_datum				sig_done;		/* signal when done tag */
	Ref_datum				chained_ref;	/* indicates a chained ref */
	Ref_datum				targ_fbox;		/* fbox targeted by ref (this could be different than the fbox that issued the ref) */ 
	Ref_datum				targ_ctx;		/* thread targeted by ref  (this could be different than the fbox that issued the ref) */
	Ref_datum				fast_write_data;/* data associated with a fast_wr cmd (invalid for non-fast_wr cmds) */
	};
typedef struct ref_characteristic Ref_characteristic;






/* definitions for fbox reference status updates */
enum META_TAG_UNIT_TYPE
	{
	META_TAG_UNIT__SRAM,
	META_TAG_UNIT__SDRAM,
	META_TAG_UNIT__FBI,
	META_TAG_UNIT__PCI
	};
typedef enum META_TAG_UNIT_TYPE META_TAG_UNIT_TYPE;


enum META_TAG_CMD_TYPE
	{
	META_TAG_CMD__NO_CMD,
	META_TAG_CMD__SRAM_READ,
	META_TAG_CMD__SRAM_READ_LOCK,
	META_TAG_CMD__SRAM_WRITE,
	META_TAG_CMD__SRAM_WRITE_UNLOCK,
	META_TAG_CMD__SRAM_UNLOCK,
	META_TAG_CMD__SRAM_BIT_WRITE,
	META_TAG_CMD__SRAM_PUSH,
	META_TAG_CMD__SRAM_POP,
	META_TAG_CMD__SDRAM_READ,
	META_TAG_CMD__SDRAM_RMW,
	META_TAG_CMD__SDRAM_WRITE,
	META_TAG_CMD__SDRAM_RD_TO_TFIFO,
	META_TAG_CMD__SDRAM_WR_FR_RFIFO,
	META_TAG_CMD__FBI_CSR_RD,
	META_TAG_CMD__FBI_TFIFO_WR,
	META_TAG_CMD__FBI_CSR_WR,
	META_TAG_CMD__FBI_RFIFO_RD,
	META_TAG_CMD__FBI_FAST_WR,
	META_TAG_CMD__FBI_SCRATCH_RD,
	META_TAG_CMD__FBI_SCRATCH_WR,
	META_TAG_CMD__FBI_SCRATCH_BIT_WR,
	META_TAG_CMD__FBI_SCRATCH_INC,
	META_TAG_CMD__FBI_HASH,
	META_TAG_CMD__FBI_INTER_THREAD,
	META_TAG_CMD__FBI_RECEIVE
	};
typedef enum META_TAG_CMD_TYPE META_TAG_CMD_TYPE;


enum META_TAG_SIG_TYPE
	{
	META_TAG_SIG__NONE,
	META_TAG_SIG__SRAM,
	META_TAG_SIG__SDRAM,
	META_TAG_SIG__FBI,
	META_TAG_SIG__PCI,
	META_TAG_SIG__INTER_THREAD,
	META_TAG_SIG__AUTOPUSH,
	META_TAG_SIG__SEQ_NUM1,
	META_TAG_SIG__SEQ_NUM2,
	META_TAG_SIG__REC_CTL
	};
typedef enum META_TAG_SIG_TYPE META_TAG_SIG_TYPE;


enum META_TAG_UPDATE_TYPE
	{
	META_TAG_UPDATE__REF_CREATE,
	META_TAG_UPDATE__QIN,
	META_TAG_UPDATE__QOUT,
	META_TAG_UPDATE__PROCESS,
	META_TAG_UPDATE__SET_SIGNAL,
	META_TAG_UPDATE__WAKEUP,
	META_TAG_UPDATE__NO_UPDATE,
	META_TAG_UPDATE__REC_CTL_QIN
	};
typedef enum META_TAG_UPDATE_TYPE META_TAG_UPDATE_TYPE;


struct meta_tag_ref
	{

	char *chip_name;			/* name of chip associated with this ref */
	META_TAG_UNIT_TYPE dest_unit;	/* destination unit that processes the ref */
	META_TAG_CMD_TYPE cmd_type;/* type of ref  */
	META_TAG_SIG_TYPE sig_type; /* type of signal  */
	int fbox_pc;				/* fbox pc at which ref was issued */
	int fbox;					/* fbox corresponding to ref issue */
	int ctx;					/* fbox ctx corresponding to ref issue */
	int fbox_to_be_signaled;	/* fbox corresponding to fbox to be signaled  */
	int ctx_to_be_signaled;		/* fbox ctx corresponding ctx to be signaled  */
	int word_cnt;				/* num of words bursted in ref	 */
	int ending_addr;			/* ending addr of ref  */
	int rmw;					/* indicates that this is a read-mod-write ref */

	unsigned int creation_time;	/* creation time of ref:  NOTE that qin_cycles, qout_cycles, process_cycles,   */
								/* and wakeup_cycles all specify cycle counts relative to the cycle	  */
								/* value specified in creation_time	  */

	META_TAG_UPDATE_TYPE update_type;	/* specifies 1 of 5 values below that has been updated */
	int qin_cycle;				/* core clk cycle when ref was loaded in dest queue (-1 ==> uninitialized) */
	int qout_cycle;				/* core clk cycle when ref was unloaced from dest queue (-1 ==> uninitialized) */
	int process_cycle;			/* core clk cycle when ref was read/written (-1 ==> uninitialized)	*/
	int signal_cycle;			/* core clk cycle when signal was sent to fbox	  */
	int wakeup_cycle;			/* core clk cycle when fbox thread arbitor "consumes" a signal event  */
								/* and thus, wakes up a thread if it was previously swapped out		  */
	int rec_ctl_qin_cycle;		/* cycle at which receive control queued up	 */



	};
typedef struct meta_tag_ref Meta_tag_ref;

#if defined(__cplusplus)
extern "C"
	{
#endif

	/* This routine returns the decomposed reference packet information in the specified ref data. */
	/* It returns TRUE if successful, FALSE otherwise. */
	XACTAPI XACT_decompose_ref_packet( unsigned int *ref_data, Ref_characteristic *ref_char_buf, REF_PACKET__TYPE packet_type );




	/* This routine fills in the Meta_tag_ref structure corresponding to the specified */
	/* reference data.  It returns TRUE if successful, FALSE otherwise. */
	XACTAPI XACT_get_meta_tag( unsigned int *ref_data, Meta_tag_ref *tag_ref );




	/* This routine returns the cam data associated with the address specified by */
	/* cam_index.  It returns TRUE if successful.  It returns FALSE, if the addressed */
	/* entry is invalid, out of bounds, or if the handle does not address a cam object. */
	/* When successful, the routine also returns the bit width of the returned data */
	/* Note that the value array is assumed to be large enough to hold the returned data. */
	XACTAPI XACT_get_cam_data( XACT_HANDLE cam_handle, int cam_index, unsigned int *value, int *data_bit_width );

	
	
	
	
	
	/* This routine returns the collection characteristics for the specified statistics simulation state. */
	/* The characteristics are returned in the buffer supplied in the second argument (see definition */
	/* of stat_characteristic above). */
	/* This routine returns TRUE if successful, 0 otherwise. */
	XACTAPI XACT_get_stat_characteristic( XACT_HANDLE stat_handle, Stat_characteristic *stat_char_buf );
	





    /* This routine returns the number of samples (if num_bucket_samples != NULL) and/or the */
	/* title for the specified statistics bucket (if titled_buckets == 1).  The bucket_index argument */
	/* must be between 0 and num_buckets-1 inclusive for the call the succeed, where num_buckets */
	/* was determined from a previous call to XACT_get_stat_characteristic. */
	/* This routine returns TRUE if successful; FALSE otherwise. */
	XACTAPI XACT_get_stat_bucket_data( XACT_HANDLE stat_handle, int bucket_index, int *num_bucket_samples, Stat_str *bucket_title );



    
	/* Define callback to be invoked whenever the status of an fbox reference is updated. */
	XACTAPI XACT_Define_Callback_Ref_Status( void (*fp)( Meta_tag_ref *ref_data ) );
		


    /* Amba Transactor Interface Routines */

    /* This routines adds a request to the queue within the AMBA Transactor. */
    /* Parameters: */
    /*        chip_name: Name of chip in question */
    /*            write: 1 for write operation, 0 for read operation */
    /*             addr: byte address of operation */
    /*             size: size of transfer, valid values are 1 (byte), 2 (word), and 4 (dword) */
    /*       burst_size: Number of transfers: valid values are 1..8 */
    /* num_prior_blank_cycles: Minimum number of bus cycles of idle before this */
    /*                   operation. */
    /*             data: Pointer to an array of dwords of size "burst_size". */
    /*                   If (size != 4), then the low order bits of each data */
    /*                   item are used. */
    /*            block: If nonzero, then block this thread until the operation */
    /*                   completes. Note that for a write, this means that the */
    /*                   data have left the AMBA bus. This does NOT mean that */
    /*                   the data have reached their final destination, */
    /*                   e.g. SRAM */
    /* Returns: 1 if successful, 0 otherwise. */
    XACTAPI XACT_amba_add_req( char *chip_name,
                               unsigned int write,
                               unsigned int addr,
                               unsigned int size,
                               unsigned int burst_size,
                               unsigned int num_prior_blank_cycles,
                               unsigned int *data,
                               unsigned int block );

    /* This routine returns the most current AMBA read result, if any. */
    /* The return code indicates whether a valid value was returned. */
    /* Parameters: */
    /*    chip_name: Name of chip */
    /*         data: Pointer to location to receive data */
    /* Returns: 1 if valid data returned, 0 if no data available. */
    XACTAPI XACT_amba_get_read_result( char *chip_name, unsigned int *data );


    /* This routine signals the amba transactor that it should perform */
    /* a "return from interrupt" after the specified number of bus cycles */
    /* have elapsed. For more information, see the callback routine: */
    /* XACT_Define_Callback_amba_new_interrupt. */
    /* Parameters: */
    /*     chip_name: Name of chip */
    /*    bus_cycles: Number of cycles to wait before clearing interrupt. */
    XACTAPI XACT_amba_clearing_interrupt( char *chip_name,
                                          unsigned int bus_cycles );


    /* call callback when a new interrupt (FIQ or IRQ) occurs. */
    /* ctx parameter is passed along unchanged. */
    /* After this callback, FIQ and IRQ will not be sampled again */
    /* until XACT_amba_clearing_interrupt is called, and the specified */
    /* number of bus cycles have elapsed. Then, if either FIQ or IRQ */
    /* are asserted, the callback will be called again. */
    /* Thus, the callback should take steps to clear the interrupt */
    /* before returning. */
    XACTAPI XACT_Define_Callback_amba_new_interrupt( char *chip_name,
                                                     void (*fp)(void *ctx,
                                                                unsigned int FIQ,
                                                                unsigned int IRQ),
                                                     void *ctx );

	

#if defined(__cplusplus)
	}
#endif


#endif      /* #if !defined(__XACT_GUI_H) */
