/*------------------------------------------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *
 *------------------------------------------------------------------------------------------------------------*/


/*=================================================================*/

#ifndef __XACT_H
#define __XACT_H

#include <stdio.h>

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif
/* hooks for integration with GUI and external foreign simulation models */

#define STRING_VAR_LEN		300

/* structures for returning statistics collection characteristics */
struct string_var
	{
	char name[STRING_VAR_LEN];
	};
typedef struct string_var String_var;


#define XACT_HANDLE				int
#define INVALID_XACT_HANDLE		-1
#define MODEL_MAGIC_DRIVE		-2
enum CLK_TYPE
	{
	CLK_FBOX,
	CLK_FBUS,
	CLK_PCI
	};

#ifndef	XACT_DLL
#define XACTAPI_NORET 
#define	XACTAPI	int
#endif

enum HALT_STATUS
	{
	HALT_STATUS_USER_STOPPED					= 1,	/* user stopped sim by setting sim.halt */
	HALT_STATUS_BREAK_PT						= 2,	/* sim stopped via user-defined break point */
	HALT_STATUS_ERROR_DURING_SIM				= 3,	/* halting model due to detected error during simulation */
	HALT_STATUS_ERROR_DURING_IND				= 4,	/* halting model due to detected error during .ind file execution */
	HALT_STATUS_ERROR_DURING_SIM_IND			= 5,	/* halting model due to detected error during sim and/or during .ind file execution */
	HALT_STATUS_EXT_MODEL_ERROR					= 6,	/* halting model due to error in external foreign model */
	HALT_STATUS_UNINITIALIZED					= 7,	/* halting model due to reading uninitialized model state */
	HALT_STATUS_PROGRAM_ERROR					= 8,	/* halting model due to internal program error */
	HALT_STATUS_EXIT_ON_ERROR					= 9,	/* exiting model because sim.error_handle_model indicates to do so on an error */
	HALT_STATUS_CTRL_C_ABORT					= 10	/* halting model because user pressed CTRL/C */
	};
typedef enum HALT_STATUS HALT_STATUS;


#if defined(__cplusplus)
extern "C"
	{
#endif
    /* NOTE:  **THESE ARE SINGLE-THREADED API's**  No interlocks have been designed */
    /*          in to allow proper behavior for multiple simultaneous thread execution through */
    /*          this interface.  If multiple threads require access to this API, it is the */
    /*          responsibility of those threads to synchronize their execution so that */
    /*          only 1 thread at a time is executing any of these routines.  Violation */
    /*          of this constraint may cause unpredicatable and/or catastrophic behavior. */


	/* HANDLE/state_name reference routines */


	
	/* This routine can be iteratively called to return all state */
	/* names that match the wildcard_name_spec ( "*" is the wildcard */
	/* character that can match 0 or more characters).  A non-NULL */
	/* wildcard_name_spec indicates that a new wildcard name search is */
	/* initiated; a NULL wildcard_name_spec indicates that the next name */
	/* to match the previously initiated wildcard search should be returned. */
	/* Each matching state name is returned in rtn_name_buf provided */
	/* that the specified rtn_name_buf_length indicates that the return */
	/* buffer is large enough to hold the name.  This function returns:    */
	/*     0:   no match found                                             */
	/*     1:   match found                                                */
	/*     -1:  match found but not returned due to size of rtn_name_buf   */
	XACTAPI XACT_find_wildcard_state_name( char *wildcard_name_spec, char *rtn_name_buf, unsigned int rtn_name_buf_length );

		
		
		
		
	
		
	/* Return a handle to a transactor state, based on a transactor state name. */
	/* If a handle corresponding to the specified state exists and is currently */
	/* valid, it will be returned; otherwise, a unique handle will be created and */
	/* returned.  Note that the specified state name is case-sensitive.  For non-array */
	/* states, the value of the array_index MUST be -1.  For arrayed states, the array_index */
	/* specifies the particular element in the array that will correspond to the handle. */
	/* If a value of -1 is specified for an array state, a handle is returned corresponding */\
	/* to the array, but which is not associated to a particular array element.  Such a */
	/* handle can be used in calls to XACT_get_array_state_value or XACT_set_array_state_value, */
	/* but cannot be used to specify callbacks on state transitions within the array. */
	/* Returns INVALID_XACT_HANDLE if the function failed */
	XACTAPI_NORET XACT_HANDLE XACT_get_handle( char *state_name, int array_index );





	/* The routine is a specific variant of XACT_get_handle, which applies only */
	/* to FIFO states.  Unlike XACT_get_handle, which can address an individual array element */
	/* as the linearly specified element of that array, this routine addresses each fifo element */
	/* relative to its position in the queue.  Thus, fifo_index = 0, addresses the element which */
	/* will be removed during the next remove operation; fifo_index = 1 addresses the element to */
	/* be removed after that, etc.   In all other respects, it operates identically to */
	/* XACT_get_array_state_value.  The routine returns 1 if an valid fifo address is specified; */
	/* 0 indicating an access failure. */
	XACTAPI_NORET XACT_HANDLE XACT_get_fifo_handle( char *state_name, int fifo_array_index );





	/* This routine deletes the specified handle.  This deletion operation */
	/* disassociates the handle from the previously specified state and invalidates */
	/* the handle value thereby causing a subsequent reference to that handle to fail.  */
	/* However, once deleted, the value of that handle may be reused when a subsequent */
	/* handle is generated by a call to XACT_get_handle().  This routine */
	/* returns TRUE if successful, or FALSE otherwise. */
	XACTAPI XACT_delete_handle( XACT_HANDLE handle );

	
	
	
	
	
	/* Return information about the state referenced by the specified handle:  */
	/*		state_name:    name of state											*/
	/*		width:         width of state (NOTE:  a width of 0 implies that the */
	/*                     state is not directly readable/writeable by the XACT api. */
	/*		array_length:  indicates length of array ranging from 0 to array_length-1. */
	/*                     If this array_length is -1, the state is a non-array state. */
	/*                     If the array_length is < -1, it indicates that the state represents */
	/*                     a FIFO object of length -array_length (this precludes FIFOs */
	/*                     from being defined with length 1, but this is a silly case anyway). */
	/* 
	/* Returning each of the 3 pieces of state information is suppressed when that argument is NULL. */
	/* Note that when using a handle corresponding to an array, the function returns */
	/* information corresponding to the whole array even if the handle corresponds to */
	/* a particular element of an array. */
	/* Return 1 if successful, 0 otherwise */
	XACTAPI XACT_get_state_info( XACT_HANDLE state_handle, char *state_name, int *width, int *array_length );


	/* Get the value of the state corresponding to the transactor handle. */
	/* Note that the "value" pointer is assumed to point to an array of unsigned ints */
	/* large enough to accommodate the value of the state element.  Thus, the array */
	/* length must be = (state_width/32) + ((state_width%32) ? 1 : 0 ) */
    /* If the specified handle corresponds to an element of an array that is currently */
    /* uninitialized (e.g. an uninitialized memory location), or is currently invalid */
	/* (e.g. the state of a BUS element that was not driven), the return status is set */
	/* to -1 and the returned value is unpredicatable. */
	/* If a handle to an array state is specified that was not associated to a specific */
	/* array element, this function will fail and will set the return status to 0.  */
    /* This function returns 1 if successful. */
	XACTAPI XACT_get_state_value( XACT_HANDLE state_handle, unsigned int *value ); 



	/* Behaves the same as XACT_get_state_value, except that the handle must correspond */
	/* to an array state, and a valid array index must be specified.  */
    /* If the specified handle corresponds to an element of an array that is currently */
    /* uninitialized (e.g. an uninitialized memory location), the return status is set */
	/* to -1 and the returned value is unpredicatable. */
	/* If the specified handle was associated to a particular element of an array, its predefined array */
	/* index is ignored for the purpose of this call. */ 
	XACTAPI XACT_get_array_state_value( XACT_HANDLE state_handle, int array_index, unsigned int *value ); 



	/* The routine is a specific variant of XACT_get_array_state_value, which applies only */
	/* to FIFO states.  Unlike XACT_get_array_state_value, which addresses each element */
	/* strictly as an array, this routine addresses each fifo element relative to its position */
	/* in the queue.  Thus, fifo_index = 0, addresses the element which will be removed during */
	/* the next remove operation; fifo_index = 1 addresses the element to be removed after that, etc. */
	/* In all other respects, it operates identically to XACT_get_array_state_value. */
	/* The routine returns 1 if valid data is returned, -1 if the addressed entry contains invalid */
	/* data, or 0 indicating an access failure. */
	XACTAPI XACT_get_fifo_state_value( XACT_HANDLE fifo_handle, int fifo_index, unsigned int *value );





	/* This routine returns the number of currently valid FIFO entries, and the total number */
	/* of FIFO entries, given a valid handle to a FIFO state.  It returns 1 if successful; 0 otherwise */
	XACTAPI XACT_get_fifo_fullness( XACT_HANDLE fifo_handle, unsigned int *num_valid_entries, unsigned int *num_total_entries );




	/* Set the value of the state corresponding to the transactor handle. */
	/* Note that the "value" pointer is assumed to point to an array of unsigned ints */
	/* large enough to accommodate the value of the state element.  Thus, the array */
	/* length must be = (state_width/32) + ((state_width%32) ? 1 : 0 ).  If a handle to */
	/* an array state is specified that was not associated to a specific array element, this */
	/* function will fail. */
	/* Returns 1 if successful, 0 otherwise. */
	XACTAPI XACT_set_state_value( XACT_HANDLE state_handle, unsigned int *value ); 



	/* Behaves the same as XACT_set_state_value, except that the handle must correspond */
	/* to an array state, and a valid array index must be specified.  If the specified */
	/* handle was associated to a particular element of an array, its predefined array */
	/* index is ignored for the purpose of this call. */ 
	/* Returns 1 if successful, 0 otherwise. */
	XACTAPI XACT_set_array_state_value( XACT_HANDLE state_handle, int array_index, unsigned int *value ); 




	/* The routine is a specific variant of XACT_set_array_state_value, which applies only */
	/* to FIFO states.  Unlike XACT_set_array_state_value, which addresses each element */
	/* strictly as an array, this routine addresses each fifo element relative to its position */
	/* in the queue.  Thus, fifo_index = 0, addresses the element which will be removed during */
	/* the next remove operation; fifo_index = 1 addresses the element to be removed after that, etc. */
	/* Note however, that writing to a fifo element does not validate the element.  This can only */
	/* be handled through push/pop operations. */
	/* In all other respects, it operates identically to XACT_set_array_state_value. */
	XACTAPI XACT_set_fifo_state_value( XACT_HANDLE fifo_handle, int fifo_index, unsigned int *value );








	/* This function creates a 32-bit integer simulation state.  This state type is */
	/* equivalent to that created by defining a C integer at the transactor command */
	/* line (e.g. "int foo;").  This state is destroyed upon executing a "sim_reset" */
	/* command, unless the "/preserve" qualifier is appended to "sim_reset".  This */
	/* routine returns:  
	/*			1 if the state was created											*/
	/*			0 if the state pre-existed as a non-integer, non-user-defined state */
	/*			-1 if the state pre-existed as a previously defined user-defined integer state */
	XACTAPI XACT_add_sim_state( char *state_name );



	/* this routine registers the external simulation state as */
	/* a transactor state by adding it to the symbol table.  This enables */
	/* the state to be examined, deposited, watched, traced, etc.  The state */
	/* must be of type unsigned int and the specified name must not conflict */
	/* with any previously defined state names.  If the "handle_passively" flag */
	/* is set, then this state will not be reset, saved or restored by the */
	/* transactor because it will assume the external model is handling it */
	/* appropriately.  This function returns 1 if it is successful, 0 otherwise. */
	XACTAPI XACT_import_sim_state( char *state_name, unsigned int *state_ptr, int handle_passively );



    /* The function creates a "bus client" and attaches it to a pre-existing BUS element */
    /* The bus client state is used to drive data onto the BUS or receive data off of the BUS */
    /* By interfacing to the BUS element through a bus client (as opposed to directly reading */
    /* or writing the BUS element directly), assertion checkers will flag instances when */
    /* multiple bus clients are simultaneously driving the BUS, or when a bus client received */
    /* invalid data because no client drove the BUS.  This function can only be called during */
    /* initialization of the simulation; therefore, it must be called only from */
    /* foreign_model_initialize()  (defined below).  Note that, unlike the built-in C function */
	/* "add_bus_client", bus clients defined through this mechanism are permanent states */
	/* which are not deleted during a sim_reset operation. */
	/* Return 1 if successful, 0 otherwise */
    XACTAPI XACT_add_bus_client( char *bus_name, char *bus_client_name );


    /* This function is used when one wants to check to see if the bus data latched by */
    /* the specified bus_client is valid.  The data is considered valid when exactly one */
    /* bus client source drove the data; otherwise it's considered invalid.  The variable */
    /* *valid returns 1 when valid; 0 otherwise.  This routine returns 1 if successful; */
    /* 0 otherwise. */
    XACTAPI XACT_bus_client_data_validity( XACT_HANDLE bus_client_handle, unsigned int *valid );




	/* This function deposits bus data onto the bus specified by the handle. */
	/* Note that data could also be deposited onto the bus by a call to */
	/* XACT_set_state_value.  These two functions differ in that XACT_set_state_value */
	/* will always override the data successfully.  XACT_deposit_bus_data */
	/* performs bus contention checking.  If no other source has driven data */
	/* on the bus, the specified data will be applied to the bus state.  Otherwise */
	/* a bus contention error will be flagged and the deposit will not be made. */
	/* This routine returns TRUE if the data was successfully deposited, or */
	/* FALSE otherwise. */
	XACTAPI XACT_deposit_bus_data( XACT_HANDLE bus_handle, unsigned int data );



    
	/* This function is analogous to XACT_bus_data_validity except that it applies to the */
    /* actual bus (rather than the bus client).  This routine returns 1 if successful; */
    /* 0 otherwise. */
    XACTAPI XACT_bus_data_validity( XACT_HANDLE bus_handle, unsigned int *valid );




	/* This function returns the handle to the bus client that is currently driving data */
	/* on the specified bus.  It returns INVALID_XACT_HANDLE if no client is driving, or if */
	/* more than one client is driving.  It returns MODEL_MAGIC_DRIVE if the bus was driven */
	/* by "model magic" (i.e. an artificial deposit to the bus).  If num_active_drivers is */
	/* non-NULL, it returns the number of clients who drove the bus (note that bus data is */
	/* considered valid only when this value is 1).  If client_name_list is non-NULL, */
	/* this routine will return a string of client names corresponding to those bus client(s) */
	/* who are currently driving the bus.  If more than one client is driving, the names are */
	/* separated by commas.  If the bus is driven by "model magic", this overrides any bus client */
	/* who was driving the bus by conventional means; therefore, the client name list will contain */
	/* simply "model magic" and num_active_drivers will be set to 1. */
	XACTAPI_NORET XACT_HANDLE XACT_client_driving_bus( XACT_HANDLE bus_handle, int *num_active_drivers, char *client_name_list );



    /* This routine returns TRUE if the current simulation time corresponds to the time when the specified */
    /* clock domain starts a new cycle.  The valid clock domain values are specified in the "enum CLK_TYPE" */
    /* at the top of this file. */
    XACTAPI XACT_start_of_cycle( enum CLK_TYPE clk_type );





    /* This routine returns the clock cycle number (starting at 0) for the specified clock */
    /* It returns -1 if an error occurred during routine execution.  If the simulation time */
	/* does not fall on a whole multiple of the specified clock, the remainder is ignored. */
    XACTAPI XACT_clock_cycle( enum CLK_TYPE );




    /* This routine returns the clock cycle number (starting at 0) for the specified clock */
    /* It returns -1 if an error occurred during routine execution.  If the simulation time */
	/* does not fall on a whole multiple of the specified clock, the percentage of the */
	/* time into the partial clock cycle is returned in percent_remainder; otherwise this */
	/* argument returns 0 */
    XACTAPI XACT_clock_cycle_with_remainder( enum CLK_TYPE, double *percent_remainder );





    /* This function sets the validity checks for a pre-existing BUS element */
    /* Sets the validity checks for the named bus state object. The min_dead_cyc 
       threshold is the least number of dead cycles (cycles not being driven)
       that is required between two different sources driving the bus. The
       wrn_thrsh is the threshold for warnings, and the err_thrsh is the threashold
       for errors. The max_dead_cyc threshold is the maximium number of dead
       cycles that can occur in a row. Values of -1 disable the given check.
       Note that each bus client is considered a different source. The verilog
       model and assignments directly from .ind files constitute another, single source. */
    XACTAPI XACT_set_bus_validity_checks( char *bus_name,
                                          int min_wrn_thrsh, int min_err_thrsh,
                                          int max_wrn_thrsh, int max_err_thrsh );




	/* Callback creation and deletion routines */

	/* call callback when a chip of the specified name has been called */
	XACTAPI XACT_Define_Callback_Create_Chip( void(*fp)( char *chip_name ) );


	/* call callback when the simulation has been instantiated and initialized via the "init" command */
	XACTAPI XACT_Define_Callback_Init_Sim( void(*fp)() );


	/* call callback when the simulator has prematurely halted model for the reason */
	/* specified by the input argument */
	XACTAPI XACT_Define_Automatic_Sim_Halt( void(*fp)( HALT_STATUS halt_status ) );


	/* call callback when the simulation has been reset via the "sim_reset" command */
	XACTAPI XACT_Define_Callback_Sim_Reset( void(*fp)() );


	/* call callback when the simulation state has been reloaded via the "restore" command */
	XACTAPI XACT_Define_Callback_Restore( void(*fp)() );


	/* call callback when ucode file has been loaded into specified chip/fbox */
	/* If the ucode_file name is NULL, this means that the associated control */
	/* store has been reset and no longer corresponds to a ucode_file */
	XACTAPI XACT_Define_Callback_Load_Ucode( void(*fp)( char *chip_name,
												   int fbox_num,
												   char *ucode_file ) );



	/* NOTE:  *ContextMask == 0 means that the breakpoint has been cleared */
	XACTAPI XACT_Define_Callback_Breakpoint( void (*fp)( char *chip_name, int fbox_num, int PC, int ContextMask ) ); 


	/* Define callback to invoke whenever a breakpoint has been reached */
	XACTAPI XACT_Define_Callback_Breakpoint_Event( void (*fp)( char *chip_name, int fbox_num, int PC, int ContextNum ) ); 



	/* Define callback to be invoked whenever default clock domain for "go" simulation changes */
	XACTAPI XACT_Define_Callback_Default_Go_Clock_Domain( void (*fp)( enum CLK_TYPE clk_type ) );
		


	/* Define a callback to be invoked when a specified state makes a transition. */
	/* The callback priority allows the user to specify the order in which */
	/* all the defined callbacks are made in; the higher the callback priority, */
	/* the earlier the callback is made.  The user_context argument allows */
	/* the caller of this function to pass contextual information to the */
	/* callback routine if required.  Note that a callback to cancel this */
	/* callback must be defined prior to executing this routine in order for */
	/* this callback definition to be successful (see XACT_Define_Cancel_Callback_State_Transition() */
	/* below).  If the specified handle corresponds to an array state, the handle must */
	/* also specify a particular valid element of the array.  This routine */
	/* returns 1 if successful, 0 otherwise */
	XACTAPI XACT_Define_Callback_State_Transition( XACT_HANDLE transitioning_state, int callback_priority,
												int(*fp)( XACT_HANDLE transitioning_state, void *user_context ),
												void *user_context );


	/* define the callback to cancel any further state transition callbacks when */
	/* the specified state changes.  NOTE:  this callback must be defined prior to */
    /* calling XACT_Define_Callback_State_Transition() above.  This callback will be called */
    /* if the transactor deletes the state associated with the HANDLE.  State deletion */
    /* can occur if the state element was a user-defined state (e.g. C variable, function, */
    /* watch, etc.).  A predefined hardware state element will never be deleted, but */
    /* for consistency, this cancel callback is still required to be specified prior to */
    /* defining a state transition callback.  This routine returns 1 if successful, 0 otherwise */
    XACTAPI XACT_Define_Cancel_Callback_State_Transition( XACT_HANDLE state,
                                                      int (*fp)( XACT_HANDLE handle, void *user_data) );


    /* Calling this routine allows the caller to explicitly cancel the predefined state */
    /* transition callback.  It returns 1 if successful, -1 if no callback was associated */
	/* with this state or 0 otherwise */
    XACTAPI XACT_Cancel_State_Transition_Callback( XACT_HANDLE state );



	/* This routine allows the user to be notified when a handle is about to become */
	/* invalidated.  Handle invalidations can occur when the user has acquired a */
	/* handle to a temporary state (e.g. C variable, function, watch, etc.).  The */
	/* handle is valid when the specified callback is called and becomes invalid */
	/* as soon as execution returns from the callback.  This routine returns 1 */
	/* if successful; 0 otherwise. */
	XACTAPI XACT_Define_Handle_Invalidation_Callback( int (*fp)( XACT_HANDLE handle ) );





	/* print string to transactor console output */
	XACTAPI XACT_output_to_console( char *output_str );


	/* printf function outputing to transactor console */
	XACTAPI XACT_printf( char *fmt, ... );



	/* printf function outputing to transactor console as a transactor error */
	XACTAPI XACT_printf_error( char *fmt, ... );




	/* return the name of the ucode label at the specified control store address */
	/* in the specified fbox.  The argument, label_name, is used to return the string. */
	/* An empty string is returned if no label exists at the specified address. */
	/* This routine returns TRUE if successful; FALSE if the arguments do not address */
	/* a valid fbox/control store location, or if NULL pointers are passed in the 1st or */
	/* 3rd arguments. */
	XACTAPI XACT_get_ucode_label( char *fbox_name, unsigned int ucode_addr, String_var *label_name );




	/* routine for registering a foreign function with the transactor's C interpretor */
	/* The argument list of the specified function is assumed to have the following */
	/* characteristics:

		o) only (char *) and (unsigned int) args are allowed
		o) all (char *) args precede all (unsigned int) args.
		o) number of (char *) args is <= 3
		o) number of (int) args is <= 5

	   Returns 1 if successful, 0 otherwise.

	*/
	XACTAPI XACT_register_console_function( char *function_name,
										void *function_ptr,
										int num_char_ptr_args,
										int num_uint_args );



    /* Define a callback to be called whenever the transactor performs a */
    /* "save" or "restore" operation on the current simulation.  In this way, */
    /* a foreign model can perform an analogous operation on its model state. */
    /* The first parameter of the callback function specifies the name of the */
    /* restore file which the transactor has performed its save or restore */
    /* operation (by supplying this name, the foreign model can generate a different, */
    /* yet similar name to indicate a correspondence between the two restore files). */
    /* The second argument is TRUE for a save operation and FALSE for a restore operation. */
    /* The callback function returns TRUE if successful and FALSE otherwise. */
    /* This routine (which defines the callback) returns TRUE if successfull and */
    /* FALSE otherwise. */
    XACTAPI XACT_Define_Callback_External_Save_Restore( int(*fp)( char *transactor_restore_file_name, int save_operation ) );



	/* execute the str as a console command */
	XACTAPI XACT_ExecuteCommandStr( char *cmd_str );

    /* initializes the command line parsing done by XACT_gui_execute_command, i.e., clears outstanding */
    /* line continuation, nested curly braces, nested conditional directives, etc. */
    XACTAPI XACT_init_gui_console();

    /* executes a command line in a gui (e.g., Developer Workbench) environment. Command line status, such */
    /* as line continuation, conditional directives, etc., is maintained between calls. Use XACT_init_gui_console */
    /* to initialize status. */
    XACTAPI XACT_gui_execute_command(char *command_line);

	
	/* pass transactor output strings to callback function.  Note that the */
    /* transactor will still print the string to its own console output regardless */
    /* of this callback. */
	XACTAPI XACT_Define_Callback_Output_Message( void(*fp)(const char *message) );



	/* this routine registers the callback to pass the transactor prompt */
	/* to an external command line.  It must be called after the transactor */
	/* has been initialized.  It returns TRUE if successful, and */
	/* FALSE otherwise. */
	XACTAPI XACT_Define_Callback_Set_Prompt( void(*fp)( char *prompt_str ) );



	/* this routine registers the callback necessary for the transactor console */
	/* function to fetch console input from an external source.  This callback */
	/* should be defined prior to invoking XACT_start_console() */
	XACTAPI XACT_Define_Callback_Get_Console_Input( char *(*console_input)() );



    /* this routine registers the 4 callbacks that enable the transactor to */
    /* interact with a foreign model.  For more information on these functions, */
    /* see the descriptions below of the "foreign_model_*" functions. */
    XACTAPI XACT_Define_Callback_Foreign_Model_Calls( int(*for_mod_initialize)(),
                                                      int(*for_mod_pre_sim)(),
                                                      int(*for_mod_post_sim)(),
                                                      int(*for_mod_exit)(),
                                                      int(*for_mod_reset)() );



	/* this routine starts the transactor console.  This function returns only */
	/* when an "exit" command is processed by the console.  When an external program */
	/* is to supply the actual console I/O window, the functions:  */
	/*		XACT_Define_Callback_Output_Message
	/*		XACT_Define_Callback_Set_Prompt
	/*		XACT_Define_Callback_Get_Console_Input
	/*
	/* must be called prior to invoking XACT_start_console().
	/* This function returns TRUE if the console was successfully invoked or FALSE otherwise */	
	XACTAPI XACT_start_console();




	/* this routine initializes the transactor for operation when the */
	/* transactor function is accessed via a library.  This function must */
	/* be the first transactor function called.  Subsequent transactor functions */
	/* should only be called when this function returns with success status. */
	/* It returns TRUE if the initialization was successful or FALSE otherwise. */
	XACTAPI XACT_initialize();

	


	/* This function enables or disables the transactor CTRL-C function. */
	/* By default, this function is enabled.  Note that this is a non-blocking */
	/* call (i.e. the simulation is not guaranteed to be stopped when this */
	/* function returns).  This function returns TRUE if successful; FALSE otherwise */
	XACTAPI XACT_CTRL_C_SWITCH( int enable );



    


	/* This routine stops simulation at the end of the next simulation cycle */
	/* It also stops script file execution as soon as possible by letting the current */
	/* command complete, and then unwinding the command stack.  This command returns */
	/* TRUE if successful; FALSE otherwise */
	XACTAPI XACT_stop_execution();

    

	
	/* This routine stops simulation at the end of the next simulation cycle that */
	/* aligns to the specified clock cycle.  It also stops script file execution as */
	/* soon as possible by letting the current command complete, and then unwinding */
	/* the command stack.  This command returns TRUE if successful; FALSE otherwise */
	XACTAPI XACT_stop_execution_at_clk( enum CLK_TYPE clk_type );

    

	
	/* This routine forces termination of the transactor after the next input command */
	/* has been received */
	XACTAPI XACT_exit_transactor();



	
	
	/* this routine returns TRUE if the GUI interface is connected to the transactor; */
    /* otherwise, it returns FALSE */
    XACTAPI XACT_gui_interface();


/*=================================================================*/

#ifdef ext_model_port
	/* functions called by transactor to foreign model */


	/* this routine will be called to initialize the foreign model after */
	/* the transactor "init" command has successfully executed.  Returning 0 */
	/* will result in a transactor error. */
	int foreign_model_initialize();


	/* this routine will be called prior to each transactor simulation event */
	/* It can be used to deposit state values into the transactor model prior */
	/* to simulating the next event.  Returning 0 results in an error. */
	int foreign_model_pre_sim();



	/* this routine will be called subsequent to each transactor simulation event. */
	/* It can be used to query transactor simulation state, in order to copy it */
	/* into the foreign model simulator. */
	int foreign_model_post_sim();

    

	/* this routine will be called just prior to exiting the simulator. */
    /* The routine allows the foreign model to clean up, close files, etc */
    /* before shutting down the program. */
	int foreign_model_exit();



	/* this routine will be called just after reseting the simulator. */
	/* The routine allows the foreign model to reset itself to stay */
	/* in sync with the simulator. */
	int foreign_model_reset();
#endif

	/*=================================================================*/

#if defined(__cplusplus)
	}
#endif

#endif      /* #ifndef __XACT_H */
