/* umsg.h
 * Dispatcher Library
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *
 * ---------------------------------------------------------------------
 */
#ifndef __UMSG_H
#define __UMSG_H

#define ASYNC			0
#define SYNC			1

#define REQ            	0
#define ACK            	1

#define MSG_OK			0
#define MSG_FAIL		1



/* LSB of the field within the preamble word */
#define SYNC_SH			31
#define ACK_REQ_SH	    30
#define FORMAT_SH		28
#define ERROR_SH		27
#define TRANS_ID_SH		24
#define SOURCE_ID_SH	16
#define DEST_ID_SH		8
#define FUNC_ID_SH		0

/* the field mask pattern */ 
#define SYNC_MSK 		0x1
#define ACK_REQ_MSK	0x1
#define FORMAT_MSK		0x3
#define ERROR_MSK		0x1
#define TRANS_ID_MSK	0x7
#define SOURCE_ID_MSK	0xff
#define DEST_ID_MSK		0xff
#define FUNC_ID_MSK		0xff


#define GET_SYNC(hdr) (((hdr) >> SYNC_SH) & SYNC_MSK)
#define GET_ACK_REQ(hdr) (((hdr) >> ACK_REQ_SH) & ACK_REQ_MSK)
#define GET_FORMAT(hdr)	(((hdr) >> FORMAT_SH) & FORMAT_MSK)
#define GET_ERROR(hdr) (((hdr) >> ERROR_SH) & ERROR_MSK)
#define GET_TRANS_ID(hdr) (((hdr) >> TRANS_ID_SH) & TRANS_ID_MSK)
#define GET_SOURCE_ID(hdr) (((hdr) >> SOURCE_ID_SH) & SOURCE_ID_MSK)
#define GET_DEST_ID(hdr) (((hdr) >> DEST_ID_SH) & DEST_ID_MSK)
#define GET_FUNC_ID(hdr) (((hdr) >> FUNC_ID_SH) & FUNC_ID_MSK)


/* 
   These are the optimized mask for setting the fields and are the constant
   value of ~(XXX_MSK << XXX_SH)
*/ 
#define SET_SYN_MSK			0x7fffffff
#define SET_ACK_REQ_MSK	    0xbfffffff
#define SET_FORMAT_MSK		0xcfffffff
#define SET_ERROR_MSK		0xf7ffffff
#define SET_TRANS_ID_MSK	0xf8ffffff
#define SET_SOURCE_ID_MSK	0xff00ffff
#define SET_DEST_ID_MSK		0xffff00ff
#define SET_FUNC_ID_MSK		0xffffff00

#define SET_SYNC(hdr, val) (hdr) &= SET_SYN_MSK;   (hdr) |= ((val) << SYNC_SH)
#define SET_ACK_REQ(hdr, val) (hdr) &= SET_ACK_REQ_MSK;  (hdr) |= ((val) << ACK_REQ_SH)
#define SET_FORMAT(hdr, val) (hdr) &= SET_FORMAT_MSK;  (hdr) |= ((val) << FORMAT_SH)
#define SET_ERROR(hdr, val) (hdr) &= SET_ERROR_MSK;  (hdr) |= ((val) << ERROR_SH)
#define SET_TRANS_ID(hdr, val) (hdr) &= SET_TRANS_ID_MSK; (hdr) |= ((val) << TRANS_ID_SH)
#define SET_SOURCE_ID(hdr, val) (hdr) &= SET_SOURCE_ID_MSK;  (hdr) |= ((val) << SOURCE_ID_SH)
#define SET_DEST_ID(hdr, val) (hdr) &= SET_DEST_ID_MSK; (hdr) |= ((val) << DEST_ID_SH)
#define SET_FUNC_ID(hdr, val) (hdr) &= SET_FUNC_ID_MSK; (hdr) |= ((val) << FUNC_ID_SH)

enum{
	FRMT_ARG_NONE=0,	/* header only */
	FRMT_ARG_1WRD=1,	/* header + 4 bytes */
	FRMT_ARG_2WRD=2,	/* header + 8 bytes */
	FRMT_ARG_DESC=3		/* header + 8 bytes (len, addr) + len * bytes */
};

typedef struct{
	unsigned int len;
	char *addr;
}shrimpArgDesc_T;

#endif			/* __UMSG_H */
