/* scomm.h
 * Serial port communication
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *  system: SA1200
 *  subsystem: Serial Communication Library
 *  author: drj March 1, 99 Initial version
 *  revisions:
 *  $History: scomm.h $
 * 
 * *****************  Version 15  *****************
 * User: Drjohns1     Date: 3/06/00    Time: 11:30a
 * Updated in $/dev_1200/Include
 * Bug fixes
 * 
 * *****************  Version 14  *****************
 * User: Drjohns1     Date: 3/01/00    Time: 5:34p
 * Updated in $/dev_1200/Include
 * Changed SCOMM_PEND to 1 year
 * 
 * *****************  Version 11  *****************
 * User: Drjohns1     Date: 12/03/99   Time: 2:43p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 10  *****************
 * User: Drjohns1     Date: 8/06/99    Time: 5:23p
 * Updated in $/dev_1200/Include
 * Added timout param to scomm_send nd scomm_get
 * 
 * *****************  Version 8  *****************
 * User: Drjohns1     Date: 7/20/99    Time: 3:05p
 * Updated in $/dev_1200/Include
 * Fixed SComm_Print hanging problem
 * 
 * *****************  Version 6  *****************
 * User: Drjohns1     Date: 4/16/99    Time: 6:23p
 * Updated in $/users/Johnson/SA1200/scomm
 * 
 * *****************  Version 5  *****************
 * User: Drjohns1     Date: 3/25/99    Time: 6:10p
 * Updated in $/users/Johnson/SA1200/scomm
 * 
 * *****************  Version 4  *****************
 * User: Drjohns1     Date: 3/25/99    Time: 5:28p
 * Updated in $/users/Johnson/SA1200/scomm
 * Updated... Ongoing development
 * 
 * *****************  Version 3  *****************
 * User: Lhui         Date: 3/24/99    Time: 3:01p
 * Updated in $/development/scomm
 * Add void SComm_InstallDev(char *devName) 
 * 
 * *****************  Version 2  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 4:17p
 * Updated in $/development/scomm
 * update COPYRIGHT
 * 
 * *****************  Version 1  *****************
 * User: Drjohns1     Date: 3/05/99    Time: 9:06p
 * Created in $/users/Johnson/SA1200/scomm
 * 
 * ---------------------------------------------------------------------
 */

#ifndef __SCOMM_H
#define __SCOMM_H

#define SCOMM_PEND 		0x140cd0		/* 1year */

#define SCOMM_XMITFAIL	-8
#define SCOMM_UNAVAIL	-7
#define SCOMM_INVLDPORT	-6
#define SCOMM_DUPLPORT  -5
#define SCOMM_UNCONERR	-4
#define SCOMM_INVLDID 	-3
#define SCOMM_BADPARAM	-2
#define SCOMM_FAIL		-1
#define SCOMM_SUCCESS	0

#define SCOMM_UNCONPORT	-1


#ifdef __cplusplus
extern "C" {
#endif

int SComm_Open(char *devName, int portNum);
int SComm_Close(int sConnId);
int SComm_Recv(int sConnId, void *buffer, unsigned int length, unsigned int timeout);
int SComm_Send(int sConnId, int destPort, void *buffer, unsigned int bufLen, unsigned int timeout);
int SComm_GetError(int sConnId);
int SComm_Reset(int sConnId);
int SComm_DataLen(int sConnId);
int SComm_SendReset(int devNum, int destPort);

void SComm_InstallDev(char *devName);

int SComm_StartPrintSrv(char *deviceName, int portNum);
int SComm_Print(char *format,...);

void initMemLog(char *memBase, int numMsg, int maxMsglen, int circular);
int memLog(char *format,...);

#ifdef WIN32
void SComm_StopPrintSrv(void);
#endif

#if __cplusplus
}
#endif

#endif 		/* __SCOMM_H */
