/* ------------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *------------------------------------------------------------------------------*/

/* RTM.h
 *
 *
 *
 * system: SA1200
 * subsystem: Xact_IO
 * author: Rajendra Shukla 1/19/98
 * revisions:
 * $History: rtm.h $
 * 
 * *****************  Version 18  *****************
 * User: Dhooper      Date: 2/01/00    Time: 9:42a
 * Updated in $/dev_1200/Include
 * #define SIZE_OF_ROUTE 6 + SIZE_OF_REST_ROUTE_ENTRY
 * 
 * needs to be enclosed in parenthesis:
 * 
 * #define SIZE_OF_ROUTE (6 + SIZE_OF_REST_ROUTE_ENTRY)
 * 
 * 
 * *****************  Version 17  *****************
 * User: Dhooper      Date: 1/21/00    Time: 3:12p
 * Updated in $/dev_1200/Include
 * add, lookup, delete now return int
 * 
 * *****************  Version 16  *****************
 * User: Dhooper      Date: 1/21/00    Time: 10:57a
 * Updated in $/dev_1200/Include
 * add rt_add, rt_lookup, rt_delete
 * 
 * *****************  Version 15  *****************
 * User: Dhooper      Date: 1/20/00    Time: 11:39a
 * Updated in $/dev_1200/Include
 * cleanup the API syntax and comments
 * 
 * *****************  Version 13  *****************
 * User: Dhooper      Date: 1/13/00    Time: 7:48p
 * Updated in $/dev_1200/Include
 * support route delete
 * 
 * *****************  Version 10  *****************
 * User: Skornfel     Date: 6/14/99    Time: 9:50a
 * Updated in $/dev_1200/SA1_CoreLibs/rtm
 * extern rt_add
 * 
 * *****************  Version 9  *****************
 * User: Dhooper      Date: 6/02/99    Time: 2:51p
 * Updated in $/dev_1200/SA1_CoreLibs/rtm
 * use 1 uof file for all microcode
 * 
 * *****************  Version 7  *****************
 * User: Dhooper      Date: 3/26/99    Time: 4:51p
 * Updated in $/development/rtm
 * export include file defs only
 * 
 * *****************  Version 5  *****************
 * User: Dhooper      Date: 3/08/99    Time: 7:41p
 * Updated in $/development/rtm
 * use cpp files for rtm, rtm_loader, rtm_console
 * 
 * *****************  Version 4  *****************
 * User: Rparen1x     Date: 2/02/99    Time: 10:42a
 * Updated in $/development/rtm
 * 
 * *****************  Version 3  *****************
 * User: Rshukla1     Date: 5/21/98    Time: 9:54a
 * Updated in $/base_level2/rtm
 * Intel Copyright added and digital copyright deleted
 * 
 * *****************  Version 2  *****************
 * User: Rparent      Date: 3/27/98    Time: 1:47p
 * Updated in $/base_level2/rtm
 * 
 * *****************  Version 3  *****************
 * User: Lhui         Date: 3/19/98    Time: 7:24p
 * Updated in $/base_level1/rtm
 * create rtm libraries
 * 
 * *****************  Version 1  *****************
 * User: Hooper       Date: 2/06/98    Time: 2:56p
 * Created in $/base_level1/rtm
 * route table manager
 * 
 */ 
#ifndef RTM_H
#define RTM_H

// return codes
#define RTM_SUCCESS 1
#define RTM_FAIL 0
#define RTM_NOT_FOUND -1
#define RTM_NO_TRIE_FREE -2
#define RTM_NO_ROUTE_FREE -3


/* size of route entry in longwords */
#define SIZE_OF_REST_ROUTE_ENTRY   2
#define SIZE_OF_ROUTE (6 + SIZE_OF_REST_ROUTE_ENTRY)

struct RTM_AddInfo {
unsigned int itf;										// transmit port
unsigned int gateway_da_hi32;							// hi 32 bits of next hop da
unsigned int gateway_da_lo16;							// lo 16 bits of next hop da
unsigned int destination;								// ip destination
unsigned int netmask;									// ip netmask
unsigned int gateway;									// ip next hop gateway
unsigned int rest[SIZE_OF_REST_ROUTE_ENTRY];			// unspecified rest of route entry
};

struct RTM_DeleteInfo {
unsigned int destination;								// ip destination
unsigned int netmask;									// ip netmask
};


#if defined(__cplusplus)
extern "C"
{
#endif

extern int  RTM_Init();												// create data structures	
#ifndef STANDALONE
extern int RTM_DelayBindSymbols(char *image_name);					// bind symbols at sysConf
#endif
extern int  RTM_InitULookup(char * filename);						// load microcode from file
extern int rtm_model_initialize();

extern int RTM_RtAdd(struct RTM_AddInfo *add_info);		// add a route
extern int RTM_RtDelete(struct RTM_DeleteInfo *del_info);	// delete a route
extern int RTM_RtLookup(char *destination);				// lookup a route
extern int rt_add(char *dest, char *netmask, int intf);
extern int route_add(char *dest, char *netmask, char * gateway, int intf, int gateway_da_hi32, int gateway_da_lo16);
extern int rt_delete(char *dest, char *netmask);
extern int route_delete(char *dest, char *netmask);
extern int rt_lookup(char *dest);
extern int route_lookup(char *dest);

#if defined(__cplusplus)
}
#endif



#endif /* RTM_H */
