/* remote_services.h
 *
 *
 * ------------------------------------------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *------------------------------------------------------------
 *
 * system: SA1200
 * subsystem: Remote Services
 * author: Lai-Wah Hui 6/22/98
 * revisions:
 * $History: remote_services.h $
 * 
 * *****************  Version 12  *****************
 * User: Lhui         Date: 4/13/99    Time: 8:15p
 * Updated in $/development/RemoteServices
 * Add supports for XACT_Define_Automatic_Sim_Halt
 * 
 * *****************  Version 11  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 3:43p
 * Updated in $/development/RemoteServices
 * update COPYRIGHT
 * 
 * *****************  Version 10  *****************
 * User: Lhui         Date: 2/01/99    Time: 7:22p
 * Updated in $/development/RemoteServices
 * Add supports for XACT_get_fifo_handle & XACT_Define_Callback_Ref_Status
 * 
 * *****************  Version 9  *****************
 * User: Lhui         Date: 12/18/98   Time: 4:02p
 * Updated in $/development/RemoteServices
 * Add support for xact_get|set_fifo_state_value
 * 
 * *****************  Version 8  *****************
 * User: Lhui         Date: 12/14/98   Time: 6:20p
 * Updated in $/development/RemoteServices
 * Add support for new transactor functions
 * 
 * *****************  Version 7  *****************
 * User: Qabuild      Date: 9/23/98    Time: 3:28p
 * Updated in $/base_level3/RemoteServices
 * Fix for Vxwork build
 * 
 * *****************  Version 6  *****************
 * User: Lhui         Date: 9/22/98    Time: 5:30p
 * Updated in $/base_level3/RemoteServices
 * Fix bugs
 * 
 * *****************  Version 5  *****************
 * User: Lhui         Date: 9/14/98    Time: 6:01p
 * Updated in $/base_level3/RemoteServices
 * Add support for 4 new transactor functions:
 * XACTAPI XACT_find_wildcard_state_name()
 * XACTAPI XACT_Define_Callback_Init_Sim();
 * XACTAPI XACT_Define_Callback_Sim_Reset();
 * XACTAPI XACT_Define_Callback_Restore( );
 * 
 * *****************  Version 4  *****************
 * User: Lhui         Date: 8/20/98    Time: 3:47p
 * Updated in $/base_level3/RemoteServices
 * Remove u_long to avoid a compile error
 * 
 * *****************  Version 3  *****************
 * User: Lhui         Date: 8/19/98    Time: 3:52p
 * Updated in $/base_level3/RemoteServices
 * Add "close_connection" function
 * 
 * *****************  Version 2  *****************
 * User: Lhui         Date: 7/27/98    Time: 10:11a
 * Updated in $/base_level3/RemoteServices
 * Add comments
 * 
 * *****************  Version 1  *****************
 * User: Lhui         Date: 7/24/98    Time: 5:29p
 * Created in $/base_level3/RemoteServices
 * Init. check-in
 * 
 */ 
#ifndef REMOTE_SERVICE_H
#define REMOTE_SERVICE_H
#ifdef WIN32
#ifdef RS_XACT_DLL
#define	RS_API	__declspec(dllexport) int __cdecl
#else
#define	RS_API	__declspec(dllimport) int __cdecl
#endif
#else
#define RS_API int
#endif

/* remote transactor program name */
#define RS_XACT    (1689)
#ifndef XACT_CALLBK
#define XACT_CALLBK (1690)
#endif
/* remote foreigh extion model sample program name */
#ifndef RsSimExt_Server 
#define RsSimExt_Server (1889)
#endif
#ifndef RsSimExt_Client 
#define RsSimExt_Client (1099)
#endif

enum rs_satus {
	RS_SUCCESS=0,           /* call succeeded */
	RS_VERSMISMATCH,	    /* rpc versions not compatible */
	RS_PROGUNAVAIL,         /* program not available */
	RS_PROGVERSMISMATCH,    /* program version mismatched */
	RS_PROCUNAVAIL,         /* procedure unavailable */
	RS_SYSTEMERROR,         /* generic "other problem" */
    RS_NOMEMORY,             /* memeory not available */
    RS_UDPCANTREGPROG,       /* can't register with UDP */
    RS_TCPCANTREGPROG,       /* can't register with TCP */
	RS_UNKNOWNSERVER,       /* unknown remote name */
	RS_UNKNOWNPROTO,        /* unkown protocol */
	RS_ERROR};

#if defined(__cplusplus)
extern "C"
{
#endif
RS_API Open_Connection(char *Server, unsigned int RemoteProgName);
RS_API Close_Connection(char *Server, unsigned int RemoteProgName);
RS_API CreateXactCallBackServer();
int    CreateClientConnection(char *rs_host, unsigned int Prog);
int    callback_main();
#if defined(__cplusplus)
}
#endif

#endif



