/* config_1200.h
 * SA1200 Network Application Development Board Configuration
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *
 *  system: SA1200
 *  subsystem: core network application
 *  author: dfh, May 13, 99  Initial version
 *  revisions:
 *  $History: config_1200.h $
 * 
 * *****************  Version 29  *****************
 * User: Admin        Date: 5/31/00    Time: 7:50a
 * Updated in $/V1.0/Include
 * Mike change
 * 
 * *****************  Version 28  *****************
 * User: Qabuild      Date: 5/30/00    Time: 4:00p
 * Updated in $/dev_1200/Include
 * Add flw control word of 0x00000000 to be used in place of NOP control
 * word because flow control instructions execute quicker.
 * 
 * MFF
 * 
 * *****************  Version 27  *****************
 * User: Lhui         Date: 4/18/00    Time: 6:08p
 * Updated in $/dev_1200/Include
 * Merge with IAL source 4/12/2000
 * 
 * *****************  Version 1  *****************
 * User: Qabuild      Date: 4/18/00    Time: 5:45p
 * Created in $/Bigpine/SDKChanges/Include
 * added from IAL zip file 4/12/00
 * 
 * *****************  Version 25  *****************
 * User: Mffallon     Date: 1/19/00    Time: 4:19p
 * Updated in $/dev_1200/Include
 * Add defines for SDRAM CSR registers.
 * 
 * *****************  Version 23  *****************
 * User: Drjohns1     Date: 1/10/00    Time: 10:54a
 * Updated in $/dev_1200/Include
 * Included provision for  uofInit event callback
 * 
 * *****************  Version 22  *****************
 * User: Drjohns1     Date: 1/04/00    Time: 2:41p
 * Updated in $/dev_1200/Include
 * Removed external declaration of sysConfig
 * 
 * *****************  Version 21  *****************
 * User: Drjohns1     Date: 12/17/99   Time: 11:53a
 * Updated in $/dev_1200/Include
 * Renamed bridge.h to brm.h
 * 
 * *****************  Version 20  *****************
 * User: Dhooper      Date: 11/02/99   Time: 5:30p
 * Updated in $/dev_1200/Include
 * define CSR_PLL_CFG and enum clock rates
 * 
 * *****************  Version 19  *****************
 * User: Drjohns1     Date: 9/24/99    Time: 9:48p
 * Updated in $/dev_1200/Include
 * Added inControl to SysConf to keep track of whether we are in control
 * 
 * *****************  Version 18  *****************
 * User: Dhooper      Date: 9/16/99    Time: 7:23p
 * Updated in $/dev_1200/Include
 * reset ports then reset fbi in Reset
 * 
 * *****************  Version 17  *****************
 * User: Dhooper      Date: 8/03/99    Time: 6:35p
 * Updated in $/dev_1200/Include
 * DevConf constructor iin class def not cpp
 * 
 * *****************  Version 16  *****************
 * User: Dhooper      Date: 8/03/99    Time: 9:40a
 * Updated in $/dev_1200/Include
 * gigamac support
 * 
 * *****************  Version 15  *****************
 * User: Dhooper      Date: 7/30/99    Time: 4:18p
 * Updated in $/dev_1200/Include
 * call config fbus to set big endian
 * 
 * *****************  Version 14  *****************
 * User: Dhooper      Date: 7/30/99    Time: 3:29p
 * Updated in $/dev_1200/Include
 * default fbi to little endian
 * 
 * *****************  Version 13  *****************
 * User: Dhooper      Date: 7/30/99    Time: 11:17a
 * Updated in $/dev_1200/Include
 * change autopush sync count from 60 to 40
 * 
 * *****************  Version 12  *****************
 * User: Dhooper      Date: 7/30/99    Time: 10:29a
 * Updated in $/dev_1200/Include
 * double the rate of tx autopush
 * 
 * *****************  Version 10  *****************
 * User: Skornfel     Date: 6/11/99    Time: 9:21a
 * Updated in $/dev_1200/Include
 * change rdybus template parameters
 * 
 * *****************  Version 9  *****************
 * User: Jdguilfo     Date: 6/09/99    Time: 6:59p
 * Updated in $/dev_1200/Include
 * #ifdef BRIDGE, #ifdef ROUTE, Octal MAC enums, UCLoadBuffer
 * 
 * *****************  Version 8  *****************
 * User: Dhooper      Date: 6/08/99    Time: 10:40a
 * Updated in $/dev_1200/Include
 * add UCLoadFIle, UCLoadBuffer, UCReloadFile
 * 
 * *****************  Version 7  *****************
 * User: Dhooper      Date: 6/03/99    Time: 9:24p
 * Updated in $/dev_1200/SA1_CoreLibs/app_1200
 * extern sysConf
 * 
 * *****************  Version 6  *****************
 * User: Dhooper      Date: 6/03/99    Time: 8:41p
 * Updated in $/dev_1200/Include
 * don't extern SysConf instance
 * 
 * *****************  Version 5  *****************
 * User: Dhooper      Date: 6/03/99    Time: 1:27p
 * Updated in $/dev_1200/SA1_CoreLibs/app_1200
 * add portMask for Start and  Stop, add thread registry
 * 
 * *****************  Version 4  *****************
 * User: Dhooper      Date: 6/02/99    Time: 2:49p
 * Updated in $/dev_1200/SA1_CoreLibs/app_1200
 * move netapp functions to sysConf
 * 
 * *****************  Version 1  *****************
 * User: Dhooper      Date: 5/19/99    Time: 9:59a
 * Created in $/BL5_Plus/SA1_CoreLibs/app_1200
 * app_1200 pre-review
 * 
 * 
 * ---------------------------------------------------------------------
 * compile time defines			if not defined, get
 *	FBUS_DEV_COUNT				2	
 *  START_THREAD				0
 */

#ifndef CONFIG_1200_H
#define CONFIG_1200_H

#include "sys_param_types.h"
#include "hal_sram.h"
#include "hal_sdram.h"
#include "hal_fbi.h"
#include "uclo.h"
#include "FdriverAPI.h"
#include "BigMacAPI.h"
#ifdef ROUTE
#ifdef RTM_MVR
#include "rtm_mvr.h"
#else
#include "rtm.h"
#endif
#endif
#ifdef BRIDGE
#include "brm.h"
#endif
#include "delay.h"
#include "sem.h"


// clock rate csr
enum ClockRate{ MHZ_162 = 0x10, MHZ_176 = 0x11, MHZ_192 = 0x12 };
#define CSR_PLL_CFG 0x90000c00


// sdram configuration registers
#define SDRAM_MEMCTL0 0xff000004
#define SDRAM_MEMCTL1 0xff000008
#define SDRAM_MEMINIT 0xff00000C



// static fbus configuration settings (validation board)
//
#define FBUS_WIDTH BUS_WIDTH_64			// 64 bit bidirectional
#define FBUS_NO_STATUS 0		// if 1, no status is sent on receive

// fbus device actual (validation board)
#ifndef FBUS_DEVICE_COUNT
#define FBUS_DEVICE_COUNT 2
#endif

// fbus device choices
enum DeviceType{ OCTAL_MAC_21440=0, GIGA_MAC_GC82547EB=1 };

#ifndef FBUS_DEV0_TYPE
#define FBUS_DEV0_TYPE OCTAL_MAC_21440
#endif

#ifndef FBUS_DEV1_TYPE
#define FBUS_DEV1_TYPE OCTAL_MAC_21440
#endif

#ifndef FBUS_DEV2_TYPE
#define FBUS_DEV2_TYPE OCTAL_MAC_21440
#endif

#ifndef FBUS_DEV3_TYPE
#define FBUS_DEV3_TYPE OCTAL_MAC_21440
#endif


#define DEFAULT_RX_RDY_THRESHOLD THRESHOLD_64
#define DEFAULT_TX_RDY_THRESHOLD THRESHOLD_128


enum Endianness{
	LITTLE_E = 0,
	BIG_E = 1
};


#define FBUS_DEVICES_MAX 7
#define FBUS_PORTS_PER_DEVICE_MAX 8



enum SysConf_Returns{
	SYSCONF_THREAD_LIMIT = -2,
	SYSCONF_THREAD_NOT_FOUND = -1,
	SYSCONF_SUCCESS = 0,
	SYSCONF_UNKNOWN_DEVICE = 1,
	SYSCONF_FILE_NOT_FOUND = 2,
	SYSCONF_BOUND_SYMBOLS_LIMIT = 3
};



#ifdef __cplusplus


// information regarding FBus device types
class DevConf{
public:
	DevConf(){}
	~DevConf(){}

	DeviceType type;
	int ports_present;
	unsigned int rx_rdy_threshold;
	unsigned int tx_rdy_threshold;
private:
};

// ConfigureFBusInterface magic numbers 
// ready bus sequencer instructions
// receive ready then transmit ready
enum RdySeqInstrs{
	RDY_SEQ_1MACS = 0x00fb00f7,
	RDY_SEQ_2MACS = 0x00db00d7,
	RDY_SEQ_3MACS = 0x00bb00b7,
	RDY_SEQ_4MACS = 0x009b0097,
	RDY_SEQ_5MACS = 0x007b0077,
	RDY_SEQ_6MACS = 0x005b0057,
	RDY_SEQ_7MACS = 0x003b0037,

	RDY_SEQ_RX_AUTOPUSH =    0x0c000000,
	RDY_SEQ_NO_RX_AUTOPUSH = 0x1f000000,
	RDY_SEQ_TX_AUTOPUSH =    0x00009c00,
	RDY_SEQ_NO_TX_AUTOPUSH = 0x00001f00,
	RDY_SEQ_NOPS = 0x1f1f1f1f,
	RDY_SEQ_FLW_CTLS = 0x00000000,
	RDY_SEQ_PROG_3_TXAP = 0x9c1f1f1f
};

#define DEFAULT_RX_AUTOPUSH 1
#define DEFAULT_TX_AUTOPUSH 1
#define DEFAULT_RDY_SYNCH_COUNT 120

#define MICROENGINES_MAX 6
#define CONTEXT_0_ID 0
#define CONTEXT_1_ID 1
#define CONTEXT_2_ID 2
#define CONTEXT_3_ID 3

enum ControlMask{
	ALL_ENGINES_MASK = 0x3f,
	ALL_CONTEXTS_MASK = 0xf,
	ALL_PORTS_MASK = 0xffffffff
};


// for loading system parameters
#define LINE_LENGTH_MAX 132
#define PARAM_STR_LENGTH_MAX 32
#define BOUND_SYMBOLS_MAX 12

struct ImportedVar{
	char *image_name;
	char *symbol_name;
	int val;
};


typedef char ThreadName[32];
#define COMM_THREADS_MAX 64
#ifndef START_THREAD
#define START_THREAD 0
#endif

// dynamic configuration settings
//
class SysConf{
public:
	SysConf();
	~SysConf(){}

	int nextSymbol;				// index of next delayed bind import_var
	int nextThread;				// index of next threadId

	char uof_file[PARAM_STR_LENGTH_MAX];	// when getting uof from file

	int Reset(unsigned int engine_mask, unsigned int port_mask);
	int Init();
	int BindSymbol(char *image_name, char *symbol_name, int val);
	int UCLoadFile(char *filename);
	int UCReloadFile(){return(UCLoadFile(uof_file));}
	int UCLoadBuffer(unsigned int* buf, unsigned int buflen);
	int Load(char *filename);
	int Configure();
	int Start(unsigned int engine_mask, unsigned int port_mask);
	int Stop(unsigned int engine_mask, unsigned int port_mask);
	int GiveControl();
	int TakeControl();
	int RegisterThread(char *thread_name);
	int ResolveThread(char*thread_name);
	int ResetPorts(unsigned int ports_mask);	
	int StartPorts(unsigned int ports_mask, PortRunDirection direction);
	int StopPorts(unsigned int ports_mask, PortRunDirection direction);
	int byte_order;
	void ConfigureFBusInterface();
	void *getUcloHandle(void){return(uclo_handle);}
	void SetUofCb(int (*uofCb)(void *), void *uofCbArg){pUofCb = uofCb; pUofCbArg = uofCbArg; return;}

private:
	SramUnit *sram;
	SdramUnit *sdram;
	FbiUnit *fbi;

	int (*pUofCb)(void *);		// uof loaded callback
	void *pUofCbArg;			// argument to uof callback function

	void *uclo_handle;			// microcode loader handle
	int inControl;				// to keep track of whether we have control

	bool rx_autopush;			// program receive autopush in ready bus sequencer
	bool tx_autopush;			// program transmit autopush in ready bus sequencer
	int rdy_synch_count;		// fbus cycles for a ready bus sequencer iteration
	DevConf fdev[FBUS_DEVICE_COUNT];
	ImportedVar boundSymbols[BOUND_SYMBOLS_MAX];
	ThreadName commThreads[COMM_THREADS_MAX];

};

extern sem_T SystemControlSem;
extern SysConf *SysConf_Attach();

#endif		// __cplusplus


#endif		// CONFIG_1200_H
